/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.event.event;

import iskallia.vault.world.data.VaultSpectatorData;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpectatorEvents {
    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player;
        Player player2 = event.getPlayer();
        if (!(player2 instanceof ServerPlayer) || (player = (ServerPlayer)player2).m_20194_() == null) {
            return;
        }
        MinecraftServer server = player.m_20194_();
        VaultSpectatorData data = VaultSpectatorData.get(server);
        if (data.isPlayerSpectating(player.m_142081_())) {
            VaultSpectatorData.stopSpectating(player.m_142081_());
        }
        for (UUID watcher : data.getSpectatorsWatchingPlayer(player.m_142081_())) {
            VaultSpectatorData.changeSpectatorTarget(watcher, true);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        Player player2 = event.getPlayer();
        if (!(player2 instanceof ServerPlayer) || (player = (ServerPlayer)player2).m_20194_() == null) {
            return;
        }
        MinecraftServer server = player.m_20194_();
        VaultSpectatorData data = VaultSpectatorData.get(server);
        if (data.isPlayerSpectating(player.m_142081_())) {
            ServerPlayer targetPlayer;
            UUID target = data.getSpectatingTarget(player.m_142081_());
            ServerPlayer serverPlayer = targetPlayer = target != null ? server.m_6846_().m_11259_(target) : null;
            if (targetPlayer == null) {
                VaultSpectatorData.changeSpectatorTarget(player.m_142081_());
            }
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        MinecraftServer server = event.getServer();
        VaultSpectatorData data = VaultSpectatorData.get(server);
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            if (!data.isPlayerSpectating(player.m_142081_())) continue;
            VaultSpectatorData.stopSpectating(player.m_142081_());
        }
        data.forceSave();
    }
}

