/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear;

import iskallia.vault.VaultMod;
import iskallia.vault.config.UniqueGearConfig;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.gear.VaultGearLegendaryHelper;
import iskallia.vault.gear.VaultGearModifierHelper;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.crafting.VaultGearCraftingHelper;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.IdentifiableItem;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.gear.IStaticRarity;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.expertise.type.LegendaryExpertise;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.world.data.DiscoveredModelsData;
import iskallia.vault.world.data.PlayerExpertisesData;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GearRollHelper {
    public static final Random rand = new Random();
    public static final RandomSource randSrc = JavaRandom.ofNanoTime();
    private static final int ROLL_TIME = 120;
    private static final int ENTRIES_PER_ROLL = 50;

    public static void tickGearRoll(ItemStack stack, @Nullable Player player) {
        IStaticRarity rarityitem;
        if (stack.m_41720_() == ModItems.VAULT_GOD_CHARM) {
            return;
        }
        VaultGearData data = VaultGearData.read(stack);
        Object item = VaultGearItem.of(stack);
        VaultGearRarity rarity = data.getRarity();
        if (data.getState() != VaultGearState.IDENTIFIED && !(item instanceof IStaticRarity)) {
            rarity = data.getFirstValue(ModGearAttributes.GEAR_ROLL_TYPE).flatMap(rollTypeStr -> ModConfigs.VAULT_GEAR_TYPE_CONFIG.getRollPool((String)rollTypeStr)).orElse(ModConfigs.VAULT_GEAR_TYPE_CONFIG.getDefaultRoll()).getRandom(rand);
            data.setRarity(rarity);
            data.write(stack);
        } else if (item instanceof IStaticRarity && (rarity = (rarityitem = (IStaticRarity)item).getStaticRarity()) != data.getRarity()) {
            data.setRarity(rarity);
            data.write(stack);
        }
        if (rarity == VaultGearRarity.UNIQUE) {
            if (!data.has(ModGearAttributes.GEAR_UNIQUE_POOL, VaultGearData.Type.ATTRIBUTES)) {
                VaultMod.LOGGER.warn("Unique gear missing 'gear_unique_pool' attribute. Setting to default.");
                data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_UNIQUE_POOL, UniqueGearConfig.DEFAULT_POOL);
            }
            data.getFirstValue(ModGearAttributes.GEAR_UNIQUE_POOL).ifPresent(pool -> {
                UniqueGearConfig.Entry entry = ModConfigs.UNIQUE_GEAR.getRandomEntry((ResourceLocation)pool, randSrc).orElseThrow();
                data.createOrReplaceAttributeValue(ModGearAttributes.UNIQUE_ITEM_KEY, entry.getId());
                if (entry.getModel() != null) {
                    data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_MODEL, entry.getModel());
                }
                data.write(stack);
            });
        } else {
            DiscoveredModelsData modelsData = player == null || player.m_20194_() == null ? null : DiscoveredModelsData.get(player.m_20194_());
            ResourceLocation modelKey = item.getRandomModel(stack, rand, player, modelsData);
            if (modelKey != null) {
                data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_MODEL, modelKey);
                data.write(stack);
            }
        }
    }

    public static void initializeAndDiscoverGear(ItemStack stack, @Nullable Player player) {
        GearRollHelper.initializeGear(stack, player);
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            if (VaultGearData.read(stack).getRarity() != VaultGearRarity.UNIQUE) {
                DiscoveredModelsData worldData = DiscoveredModelsData.get(sPlayer.m_183503_().m_142572_());
                worldData.discoverModelAndBroadcast(stack, (Player)sPlayer);
            }
        }
    }

    public static void initializeGear(ItemStack stack) {
        GearRollHelper.initializeGear(stack, null);
    }

    public static void initializeGear(ItemStack stack, @Nullable Player player) {
        VaultGearItem gearItem;
        if (stack.m_41720_() == ModItems.VAULT_GOD_CHARM) {
            return;
        }
        VaultGearData data = VaultGearData.read(stack);
        data.setState(VaultGearState.IDENTIFIED);
        data.write(stack);
        Item item = stack.m_41720_();
        if (item instanceof IdentifiableItem) {
            IdentifiableItem identItem = (IdentifiableItem)item;
            identItem.onIdentify(stack);
        }
        if ((item = stack.m_41720_()) instanceof VaultGearItem && (gearItem = (VaultGearItem)item).canStoreRepairSlots(stack)) {
            VaultGearModifierHelper.generateRepairSlots(stack, rand);
        }
        if (data.getRarity() == VaultGearRarity.UNIQUE) {
            data = VaultGearData.read(stack);
            GearRollHelper.initializeUniqueGear(data, stack);
            return;
        }
        VaultGearCraftingHelper.generateCraftingPotential(stack);
        VaultGearCraftingHelper.refreshCraftingPotential(stack);
        VaultGearModifierHelper.generateAffixSlots(stack, rand);
        VaultGearModifierHelper.generateBaseAttributes(stack, rand);
        VaultGearModifierHelper.generateImplicits(stack, rand);
        VaultGearModifierHelper.generateModifiers(stack, rand);
        if (GearRollHelper.canGenerateLegendaryModifier(player, data)) {
            VaultGearLegendaryHelper.generateImprovedModifier(stack, 2, rand, List.of(VaultGearModifier.AffixCategory.LEGENDARY));
        }
        if (GearRollHelper.shouldFillAllSlots(player, data)) {
            // empty if block
        }
    }

    private static void initializeUniqueGear(VaultGearData data, ItemStack stack) {
        ResourceLocation uniqueItemKey = data.getFirstValue(ModGearAttributes.UNIQUE_ITEM_KEY).orElse(null);
        if (uniqueItemKey == null) {
            return;
        }
        UniqueGearConfig.Entry entry = ModConfigs.UNIQUE_GEAR.getEntry(uniqueItemKey).orElse(null);
        if (entry == null) {
            return;
        }
        data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_NAME, entry.getName());
        if (entry.getModel() != null) {
            data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_MODEL, entry.getModel());
        }
        data.write(stack);
        VaultGearTierConfig.getConfig(stack).ifPresent(config -> {
            entry.getModifierIdentifiers().forEach((affix, identifiers) -> {
                for (ResourceLocation id : identifiers) {
                    VaultGearModifier<?> modifier = config.generateModifier(id, data.getItemLevel(), rand);
                    if (modifier == null) continue;
                    affix.apply(data, modifier);
                }
            });
            entry.getModifierTags().forEach(tag -> config.getGenericGroupsWithModifierTag((String)tag).forEach(tpl -> GearRollHelper.generateModifiers(data, ((VaultGearTierConfig.ModifierAffixTagGroup)((Object)((Object)((Object)((Object)tpl.m_14418_()))))).getTargetAffixType(), (VaultGearTierConfig.ModifierTierGroup)tpl.m_14419_())));
        });
        data.write(stack);
    }

    private static void generateModifiers(VaultGearData data, VaultGearModifier.AffixType affix, VaultGearTierConfig.ModifierTierGroup group) {
        WeightedList tiers = new WeightedList();
        for (VaultGearTierConfig.ModifierTier<?> tier2 : group.getModifiersForLevel(data.getItemLevel())) {
            tiers.add(tier2, tier2.getWeight());
        }
        tiers.getRandom(randSrc).ifPresent(tier -> data.addModifier(affix, tier.makeModifier(group, rand)));
    }

    private static boolean canGenerateLegendaryModifier(@Nullable Player player, VaultGearData data) {
        Level level;
        if (data.get(ModGearAttributes.IS_LEGENDARY, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) {
            return true;
        }
        float extraLegendaryChance = 0.0f;
        if (player instanceof ServerPlayer && (level = player.f_19853_) instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            ExpertiseTree expertises = PlayerExpertisesData.get(sLevel).getExpertises(player);
            for (LegendaryExpertise expertise : expertises.getAll(LegendaryExpertise.class, Skill::isUnlocked)) {
                extraLegendaryChance += expertise.getExtraLegendaryChance();
            }
        }
        return data.getFirstValue(ModGearAttributes.IS_LOOT).orElse(false) != false && rand.nextFloat() < ModConfigs.VAULT_GEAR_COMMON.getLegendaryModifierChance() + extraLegendaryChance;
    }

    private static boolean shouldFillAllSlots(@Nullable Player player, VaultGearData data) {
        return data.getFirstValue(ModGearAttributes.IS_FULLFILL_ALL).orElse(false);
    }

    public static void tickToll(ItemStack stack, Player player, BiConsumer<ItemStack, Player> onRollTick, Consumer<ItemStack> onFinish) {
        Level world = player.m_183503_();
        CompoundTag rollTag = stack.m_41698_("RollHelper");
        int ticks = rollTag.m_128451_("RollTicks");
        int lastHit = rollTag.m_128451_("LastHit");
        double displacement = GearRollHelper.getDisplacement(ticks);
        if (ticks >= 120) {
            onFinish.accept(stack);
            stack.m_41749_("RollHelper");
            world.m_5594_(null, player.m_142538_(), ModSounds.IDENTIFICATION_SFX, SoundSource.PLAYERS, 0.3f, 1.0f);
            return;
        }
        if ((int)displacement != lastHit || ticks == 0) {
            onRollTick.accept(stack, player);
            rollTag.m_128405_("LastHit", (int)displacement);
            world.m_5594_(null, player.m_142538_(), ModSounds.RAFFLE_SFX, SoundSource.PLAYERS, 0.4f, 1.0f);
        }
        rollTag.m_128405_("RollTicks", ticks + 1);
    }

    private static double getDisplacement(int tick) {
        double c = 7200.0;
        return ((double)(-tick * tick * tick) / 6.0 + c * (double)tick) * 50.0 / (-288000.0 + c * 120.0);
    }
}

