/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear;

import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.GearDataCache;
import iskallia.vault.gear.data.VaultGearData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;

public class GearScoreHelper {
    public static Optional<ItemStack> pickHighestWeight(Collection<ItemStack> stacks) {
        HashMap weights = new HashMap();
        stacks.forEach(stack -> weights.put(stack, GearScoreHelper.getWeight(stack)));
        return weights.entrySet().stream().max(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey);
    }

    public static int getWeight(ItemStack stack) {
        Object attributeData = AttributeGearData.read(stack);
        if (!(attributeData instanceof VaultGearData)) {
            return 0;
        }
        VaultGearData gearData = (VaultGearData)attributeData;
        GearDataCache cache = GearDataCache.of(stack);
        int weight = 0;
        if (cache.hasModifierOfCategory(VaultGearModifier.AffixCategory.LEGENDARY)) {
            weight += 1000000;
        }
        VaultGearRarity rarity = gearData.getRarity();
        weight += rarity.ordinal() * 10000;
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack).orElse(null);
        if (cfg == null) {
            return weight;
        }
        int level = gearData.getItemLevel();
        ArrayList modifiers = new ArrayList();
        modifiers.addAll(gearData.getModifiers(VaultGearModifier.AffixType.PREFIX));
        modifiers.addAll(gearData.getModifiers(VaultGearModifier.AffixType.SUFFIX));
        ArrayList rangePercentage = new ArrayList();
        modifiers.forEach(mod -> {
            VaultGearTierConfig.ModifierConfigRange range = cfg.getTierConfigRange((VaultGearModifier<?>)mod, level);
            ConfigurableAttributeGenerator generator = mod.getAttribute().getGenerator();
            generator.getRollPercentage(mod.getValue(), range.allTierConfigs()).ifPresent(value -> {
                if (value instanceof Float) {
                    Float f = (Float)value;
                    rangePercentage.add(f);
                }
            });
        });
        if (rangePercentage.size() > 0) {
            float avg = (float)rangePercentage.stream().mapToDouble(Float::doubleValue).average().orElse(1.0);
            weight += (int)(avg * 1000.0f);
        }
        return weight;
    }
}

