/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear;

import iskallia.vault.VaultMod;
import iskallia.vault.config.gear.VaultCharmTierConfig;
import iskallia.vault.config.gear.VaultGearCraftingConfig;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.gear.VaultCharmItem;
import iskallia.vault.world.data.PlayerReputationData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GodCharmRollHelper {
    public static final Random rand = new Random();
    public static final RandomSource randSrc = JavaRandom.ofNanoTime();
    private static final int ROLL_TIME = 120;
    private static final int ENTRIES_PER_ROLL = 50;
    private static final VaultGearRarity[] availableRarities = new VaultGearRarity[]{VaultGearRarity.COMMON, VaultGearRarity.RARE, VaultGearRarity.EPIC, VaultGearRarity.OMEGA};

    public static void tickGearRoll(ItemStack stack, @Nullable Player player) {
        VaultGearData data = VaultGearData.read(stack);
        VaultGearRarity rarity = data.getRarity();
        if (data.getState() != VaultGearState.IDENTIFIED) {
            VaultGearRarity finalRolledRarity = rarity = data.getFirstValue(ModGearAttributes.GEAR_ROLL_TYPE).flatMap(rollTypeStr -> ModConfigs.VAULT_GEAR_TYPE_CONFIG.getRollPool((String)rollTypeStr)).orElse(ModConfigs.VAULT_GEAR_TYPE_CONFIG.getDefaultRoll()).getRandom(rand);
            if (Arrays.stream(availableRarities).noneMatch(r -> r == finalRolledRarity)) {
                rarity = availableRarities[rand.nextInt(availableRarities.length)];
            }
            data.setRarity(rarity);
            List<VaultGod> gods = List.of(VaultGod.values());
            int randomIndex = rand.nextInt(gods.size());
            VaultGod selectedGod = gods.get(randomIndex);
            data.createOrReplaceAttributeValue(ModGearAttributes.CHARM_VAULT_GOD, selectedGod);
        }
        if (rarity == VaultGearRarity.SCRAPPY || rarity == VaultGearRarity.UNIQUE) {
            rarity = VaultGearRarity.COMMON;
            data.setRarity(rarity);
        }
        ResourceLocation id = ModDynamicModels.VaultGodCharms.getModel(data.getFirstValue(ModGearAttributes.CHARM_VAULT_GOD).orElse(VaultGod.IDONA), rarity).getId();
        data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_MODEL, id);
        data.write(stack);
    }

    public static void initializeGodCharm(ItemStack stack, @Nullable Player player) {
        Optional<VaultGod> finalGodOpt;
        VaultGearData data = VaultGearData.read(stack);
        data.setState(VaultGearState.IDENTIFIED);
        Optional<VaultGod> godOpt = data.getFirstValue(ModGearAttributes.CHARM_VAULT_GOD);
        if (godOpt.isEmpty()) {
            List<VaultGod> gods = List.of(VaultGod.values());
            VaultGod fallbackGod = gods.get(rand.nextInt(gods.size()));
            data.createOrReplaceAttributeValue(ModGearAttributes.CHARM_VAULT_GOD, fallbackGod);
            ResourceLocation id = ModDynamicModels.VaultGodCharms.getModel(fallbackGod, data.getRarity()).getId();
            data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_MODEL, id);
            VaultMod.LOGGER.warn("Had to generate fallback god for charm during initialization");
        }
        int prefixSlots = GodCharmRollHelper.getPrefixSlotsForRarity(data.getRarity());
        data.createOrReplaceAttributeValue(ModGearAttributes.PREFIXES, prefixSlots);
        data.createOrReplaceAttributeValue(ModGearAttributes.SUFFIXES, 0);
        int godLevel = 0;
        if (player != null && (finalGodOpt = data.getFirstValue(ModGearAttributes.CHARM_VAULT_GOD)).isPresent()) {
            godLevel = PlayerReputationData.getReputation(player.m_142081_(), finalGodOpt.get());
            VaultCharmItem.setGodReputation(stack, godLevel);
        }
        data.write(stack);
        GodCharmRollHelper.generateGodCharmModifiers(stack, player);
        VaultCharmItem.setUses(stack, 30);
    }

    /*
     * WARNING - void declaration
     */
    private static void generateGodCharmModifiers(ItemStack stack, @Nullable Player player) {
        void var11_13;
        VaultGearData data = VaultGearData.read(stack);
        VaultCharmTierConfig cfg = ModConfigs.VAULT_CHARM;
        if (!data.isModifiable()) {
            return;
        }
        Optional<VaultGod> godOpt = data.getFirstValue(ModGearAttributes.CHARM_VAULT_GOD);
        if (godOpt.isEmpty()) {
            VaultMod.LOGGER.warn("Charm missing god attribution during modifier generation");
            return;
        }
        VaultGod god = godOpt.get();
        int itemLevel = data.getItemLevel();
        int godLevel = VaultCharmItem.getGodReputation(stack);
        int prefixSlots = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0);
        ArrayList existingModifiers = new ArrayList(data.getModifiers(VaultGearModifier.AffixType.PREFIX));
        for (VaultGearModifier vaultGearModifier : existingModifiers) {
            data.removeModifier(vaultGearModifier);
        }
        HashSet<String> usedModifierGroups = new HashSet<String>();
        boolean bl = false;
        int attempts = 0;
        int maxAttempts = prefixSlots * 3;
        while (var11_13 < prefixSlots && attempts < maxAttempts) {
            ++attempts;
            Optional<VaultGearModifier<?>> modifierOptional = GodCharmRollHelper.getRandomModifierWithoutGroupCollision(cfg, god, itemLevel, rand, usedModifierGroups);
            if (!modifierOptional.isPresent()) break;
            VaultGearModifier<?> modifier = modifierOptional.get();
            if (modifier.getModifierGroup() != null && !modifier.getModifierGroup().isEmpty()) {
                usedModifierGroups.add(modifier.getModifierGroup());
            }
            VaultGearModifier<?> scaledModifier = modifier.getAttribute().scaleValue(modifier, godLevel + 1);
            scaledModifier.setRolledTier(modifier.getRolledTier());
            scaledModifier.setModifierGroup(modifier.getModifierGroup());
            scaledModifier.setModifierIdentifier(modifier.getModifierIdentifier());
            modifier.getCategories().forEach(scaledModifier::addCategory);
            if (!VaultGearCraftingConfig.ProficiencyStep.isModifierAllowed(stack, scaledModifier.getModifierIdentifier())) continue;
            data.addModifier(VaultGearModifier.AffixType.PREFIX, scaledModifier);
            ++var11_13;
        }
        data.write(stack);
    }

    private static Optional<VaultGearModifier<?>> getRandomModifierWithoutGroupCollision(VaultCharmTierConfig cfg, VaultGod god, int level, Random random, Set<String> excludedGroups) {
        VaultGearTierConfig.AttributeGroup attributePool = cfg.getModifierGroup(god);
        if (attributePool == null || attributePool.isEmpty()) {
            return Optional.empty();
        }
        WeightedList outcomes = new WeightedList();
        attributePool.forEach(group -> {
            if (!group.getModifierGroup().isEmpty() && excludedGroups.contains(group.getModifierGroup())) {
                return;
            }
            group.getModifiersForLevel(level).forEach(tier -> outcomes.add(new VaultGearTierConfig.ModifierOutcome(tier, (VaultGearTierConfig.ModifierTierGroup)group), tier.getWeight()));
        });
        return outcomes.getRandom(random).map(modifierOutcome -> modifierOutcome.makeModifier(random));
    }

    private static int getPrefixSlotsForRarity(VaultGearRarity rarity) {
        return switch (rarity) {
            case VaultGearRarity.COMMON -> 1;
            case VaultGearRarity.RARE -> 2;
            case VaultGearRarity.EPIC -> 3;
            case VaultGearRarity.OMEGA -> 4;
            default -> 1;
        };
    }

    @Deprecated
    public static void tickToll(ItemStack stack, Player player, Consumer<ItemStack> onFinish) {
        Level world = player.m_183503_();
        CompoundTag rollTag = stack.m_41698_("RollHelper");
        int ticks = rollTag.m_128451_("RollTicks");
        int lastHit = rollTag.m_128451_("LastHit");
        double displacement = GodCharmRollHelper.getDisplacement(ticks);
        if (ticks >= 120) {
            onFinish.accept(stack);
            stack.m_41749_("RollHelper");
            world.m_5594_(null, player.m_142538_(), ModSounds.IDENTIFICATION_SFX, SoundSource.PLAYERS, 0.3f, 1.0f);
            return;
        }
        if ((int)displacement != lastHit || ticks == 0) {
            rollTag.m_128405_("LastHit", (int)displacement);
            world.m_5594_(null, player.m_142538_(), ModSounds.RAFFLE_SFX, SoundSource.PLAYERS, 0.4f, 1.0f);
        }
        rollTag.m_128405_("RollTicks", ticks + 1);
    }

    private static double getDisplacement(int tick) {
        double c = 7200.0;
        return ((double)(-tick * tick * tick) / 6.0 + c * (double)tick) * 50.0 / (-288000.0 + c * 120.0);
    }
}

