/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear;

import iskallia.vault.VaultMod;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.util.MiscUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;

public class VaultGearLegendaryHelper {
    public static boolean generateImprovedModifier(ItemStack stack, int tierIncrease, Random random, Collection<VaultGearModifier.AffixCategory> categoriesToAdd) {
        VaultGearData data = VaultGearData.read(stack);
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("Unknown VaultGear: " + String.valueOf(stack));
            return false;
        }
        if (!data.isModifiable()) {
            return false;
        }
        if (VaultGearLegendaryHelper.improveExistingModifier(stack, tierIncrease, random, cfg, data, categoriesToAdd)) {
            return true;
        }
        return VaultGearLegendaryHelper.useOpenSlotToAddImprovedModifier(stack, tierIncrease, random, categoriesToAdd, cfg, data);
    }

    private static boolean useOpenSlotToAddImprovedModifier(ItemStack stack, int tierIncrease, Random random, Collection<VaultGearModifier.AffixCategory> categoriesToAdd, VaultGearTierConfig cfg, VaultGearData data) {
        ArrayList<VaultGearModifier.AffixType> types = new ArrayList<VaultGearModifier.AffixType>();
        types.add(VaultGearModifier.AffixType.PREFIX);
        types.add(VaultGearModifier.AffixType.SUFFIX);
        Collections.shuffle(types, random);
        Set<String> existingGroups = data.getExistingModifierGroups(VaultGearData.Type.EXPLICIT_MODIFIERS);
        for (VaultGearModifier.AffixType type : types) {
            VaultGearModifier generatedModifier;
            VaultGearModifier<?> legendary;
            VaultGearAttribute<Integer> affixTypeAttribute = type == VaultGearModifier.AffixType.PREFIX ? ModGearAttributes.PREFIXES : ModGearAttributes.SUFFIXES;
            VaultGearTierConfig.ModifierAffixTagGroup affixTagGroup = type == VaultGearModifier.AffixType.PREFIX ? VaultGearTierConfig.ModifierAffixTagGroup.PREFIX : VaultGearTierConfig.ModifierAffixTagGroup.SUFFIX;
            int affixSlots = data.getFirstValue(affixTypeAttribute).orElse(0);
            List<VaultGearModifier> affixes = data.getModifiers(type).stream().filter(VaultGearModifier::canBeModified).toList();
            List<ResourceLocation> affixIds = affixes.stream().map(VaultGearModifier::getModifierIdentifier).filter(Objects::nonNull).toList();
            if (affixes.size() >= affixSlots) continue;
            List<Tuple<VaultGearTierConfig.ModifierAffixTagGroup, VaultGearTierConfig.ModifierTierGroup>> availableGroups = cfg.getGenericGroupsFulfilling(group -> !existingGroups.contains(group.getModifierGroup()) && !group.getTags().contains("noLegendary") && !affixIds.contains(group.getIdentifier()));
            WeightedList outcomes = new WeightedList();
            availableGroups.forEach(group -> {
                if (group.m_14418_() != affixTagGroup) {
                    return;
                }
                VaultGearTierConfig.ModifierTier<?> tier = ((VaultGearTierConfig.ModifierTierGroup)group.m_14419_()).getHighestForLevel(data.getItemLevel());
                if (tier != null) {
                    outcomes.add(new VaultGearTierConfig.ModifierOutcome(tier, (VaultGearTierConfig.ModifierTierGroup)group.m_14419_()), tier.getWeight());
                }
            });
            VaultGearTierConfig.ModifierOutcome outcome = outcomes.getRandom(random).orElse(null);
            if (outcome == null || (legendary = cfg.maxAndIncreaseTier(type, generatedModifier = outcome.makeModifier(random), data.getItemLevel(), tierIncrease, random)) == null) continue;
            categoriesToAdd.forEach(legendary::addCategory);
            data.addModifierFirst(type, legendary);
            data.write(stack);
            return true;
        }
        return false;
    }

    public static GearModification.Result improveExistingModifier(ItemStack stack, int amount, Random random, Collection<VaultGearModifier.AffixCategory> categoriesToAdd) {
        VaultGearData data = VaultGearData.read(stack);
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("Unknown VaultGear: " + String.valueOf(stack));
            return GearModification.Result.errorUnmodifiable();
        }
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        if (!VaultGearLegendaryHelper.improveExistingModifier(stack, amount, random, cfg, data, categoriesToAdd)) {
            return GearModification.Result.errorInternal();
        }
        return GearModification.Result.makeSuccess();
    }

    private static boolean improveExistingModifier(ItemStack stack, int amount, Random random, VaultGearTierConfig cfg, VaultGearData data, Collection<VaultGearModifier.AffixCategory> categoriesToAdd) {
        ArrayList<Tuple> modifiers = new ArrayList<Tuple>();
        data.getModifiers(VaultGearModifier.AffixType.PREFIX).forEach(modifier -> modifiers.add(new Tuple((Object)VaultGearModifier.AffixType.PREFIX, modifier)));
        data.getModifiers(VaultGearModifier.AffixType.SUFFIX).forEach(modifier -> modifiers.add(new Tuple((Object)VaultGearModifier.AffixType.SUFFIX, modifier)));
        modifiers.removeIf(tpl -> {
            VaultGearTierConfig.ModifierTierGroup group = cfg.getTierGroup(((VaultGearModifier)tpl.m_14419_()).getModifierIdentifier());
            if (group == null) {
                return false;
            }
            return group.getTags().contains("noLegendary");
        });
        modifiers.removeIf(tpl -> !((VaultGearModifier)tpl.m_14419_()).hasNoCategoryMatching(VaultGearModifier.AffixCategory::cannotBeModifiedByArtisanFoci));
        Tuple randomMod = (Tuple)MiscUtils.getRandomEntry(modifiers, random);
        if (randomMod == null) {
            return false;
        }
        VaultGearModifier<?> newMod = cfg.maxAndIncreaseTier((VaultGearModifier.AffixType)((Object)randomMod.m_14418_()), (VaultGearModifier)randomMod.m_14419_(), data.getItemLevel(), amount, random);
        if (newMod == null) {
            return false;
        }
        categoriesToAdd.forEach(newMod::addCategory);
        if (data.removeModifier((VaultGearModifier)randomMod.m_14419_())) {
            data.addModifierFirst((VaultGearModifier.AffixType)((Object)randomMod.m_14418_()), newMod);
        }
        data.write(stack);
        return true;
    }
}

