/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear;

import iskallia.vault.VaultMod;
import iskallia.vault.config.gear.VaultGearCraftingConfig;
import iskallia.vault.config.gear.VaultGearModificationConfig;
import iskallia.vault.config.gear.VaultGearTagConfig;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.gear.VaultGearClassification;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModGearModifications;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.util.MiscUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class VaultGearModifierHelper {
    public static GearModification.Result reForgeAllModifiers(ItemStack stack, Random random) {
        GearModification.Result result = VaultGearModifierHelper.removeAllModifiers(stack);
        if (!result.success()) {
            return result;
        }
        return VaultGearModifierHelper.generateModifiers(stack, random);
    }

    public static GearModification.Result reForgeAllImplicits(ItemStack stack, Random random) {
        VaultGearData data;
        GearModification.Result result = VaultGearModifierHelper.removeAllModifiersOfType(stack, VaultGearModifier.AffixType.IMPLICIT);
        if (!result.success()) {
            return result;
        }
        GearModification.Result genResult = VaultGearModifierHelper.generateImplicits(stack, random);
        if (genResult.success() && !(data = VaultGearData.read(stack)).has(ModGearAttributes.DURABILITY, VaultGearData.Type.ATTRIBUTES)) {
            VaultGearModifierHelper.generateBaseAttributes(stack, random);
        }
        return genResult;
    }

    public static GearModification.Result reForgeAllWithTag(VaultGearTagConfig.ModTagGroup modGroupTag, ItemStack stack, Random random) {
        ItemStack emptyCopy = stack.m_41777_();
        GearModification.Result result = VaultGearModifierHelper.removeAllModifiers(emptyCopy);
        if (!result.success()) {
            return result;
        }
        if (VaultGearModifierHelper.getAvailableModGroupOutcomes(modGroupTag, emptyCopy).isEmpty()) {
            return GearModification.Result.makeActionError("no_modifiers", modGroupTag.getDisplayComponent());
        }
        result = VaultGearModifierHelper.removeAllModifiers(stack);
        if (!result.success()) {
            return result;
        }
        result = VaultGearModifierHelper.addNewModifierOfGroup(modGroupTag, stack, random);
        if (!result.success()) {
            return result;
        }
        return VaultGearModifierHelper.generateModifiers(stack, random);
    }

    public static GearModification.Result reForgeAllModifiersTagged(ItemStack stack, Random random, String tag) {
        VaultGearData data = VaultGearData.read(stack);
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        if (stack.m_150930_((Item)ModItems.TOOL)) {
            return GearModification.Result.errorUnmodifiable();
        }
        VaultGearTierConfig config = VaultGearTierConfig.getConfig(stack).orElse(null);
        if (config == null) {
            VaultMod.LOGGER.error("[1] Unknown VaultGear: " + String.valueOf(stack));
            return GearModification.Result.errorUnmodifiable();
        }
        JavaRandom src = JavaRandom.ofInternal(random.nextLong());
        List<Tuple<VaultGearTierConfig.ModifierAffixTagGroup, VaultGearTierConfig.ModifierTierGroup>> modifierTagGroups = config.getAnyGroupsFulfilling(tier -> tier.getTags().contains(tag));
        modifierTagGroups.stream().map(Tuple::m_14419_).forEach(group -> {
            VaultGearAttribute<?> attr = VaultGearAttributeRegistry.getAttribute(group.getAttribute());
            if (attr == null) {
                return;
            }
            data.getModifiers(attr, VaultGearData.Type.ALL).stream().filter(VaultGearAttributeInstance::canBeModified).filter(inst -> inst instanceof VaultGearModifier).map(inst -> (VaultGearModifier)inst).filter(mod -> group.getIdentifier().equals((Object)mod.getModifierIdentifier())).forEach(data::removeModifier);
        });
        ItemStack stackCopy = stack.m_41777_();
        data.write(stackCopy);
        Set<String> allGroups = data.getExistingModifierGroups(VaultGearData.Type.ALL);
        modifierTagGroups.removeIf(tpl -> allGroups.contains(((VaultGearTierConfig.ModifierTierGroup)tpl.m_14419_()).getModifierGroup()));
        HashSet modGroups = new HashSet();
        modifierTagGroups.forEach(tpl -> modGroups.add(((VaultGearTierConfig.ModifierTierGroup)tpl.m_14419_()).getModifierGroup()));
        boolean hasValidOutcome = false;
        for (String group2 : modGroups) {
            boolean applied = VaultGearModifierHelper.getAvailableModGroupOutcomes((VaultGearTierConfig.ModifierTierGroup grp) -> group2.equalsIgnoreCase(grp.getModifierGroup()), stackCopy, true).getRandom(src).map(outcome -> outcome.type().addModifier(data, outcome.tier().makeModifier(outcome.tierGroup(), random))).orElse(false);
            if (!applied) continue;
            hasValidOutcome = true;
        }
        if (!hasValidOutcome) {
            return GearModification.Result.makeActionError("no_modifiers", new Component[0]);
        }
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }

    public static GearModification.Result addNewModifierOfGroup(VaultGearTagConfig.ModTagGroup modGroupTag, ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        WeightedList<TierGroupOutcome> outcomes = VaultGearModifierHelper.getAvailableModGroupOutcomes(modGroupTag, stack);
        TierGroupOutcome outcome = outcomes.getRandom(random).orElse(null);
        if (outcome == null) {
            return GearModification.Result.makeActionError("no_modifiers", modGroupTag.getDisplayComponent());
        }
        if (!outcome.type().addModifier(data, outcome.tier().makeModifier(outcome.tierGroup(), random))) {
            return GearModification.Result.errorUnmodifiable();
        }
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }

    public static GearModification.Result reForgeOutcomeOfRandomModifier(ItemStack stack, long worldGameTime, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        List<Tuple<VaultGearModifier<?>, WeightedList<VaultGearTierConfig.ModifierOutcome<?>>>> modifierReplacements = VaultGearModifierHelper.getAvailableModifierConfigurationOutcomes(data, stack, true);
        modifierReplacements.removeIf(tpl -> ((WeightedList)tpl.m_14419_()).size() <= 1);
        if (modifierReplacements.isEmpty()) {
            return GearModification.Result.makeActionError("no_modifiers", new Component[0]);
        }
        Tuple<VaultGearModifier<?>, WeightedList<VaultGearTierConfig.ModifierOutcome<?>>> potentialReplacements = MiscUtils.getRandomEntry(modifierReplacements);
        if (potentialReplacements == null) {
            return GearModification.Result.errorInternal();
        }
        VaultGearTierConfig.ModifierOutcome replacement = ((WeightedList)potentialReplacements.m_14419_()).getRandom(random).orElse(null);
        if (replacement == null) {
            return GearModification.Result.errorInternal();
        }
        VaultGearModifier existing = (VaultGearModifier)potentialReplacements.m_14418_();
        VaultGearModifier newModifier = replacement.makeModifier(random);
        VaultGearAttributeComparator comparator = existing.getAttribute().getAttributeComparator();
        if (comparator != null && comparator.compare(existing.getValue(), newModifier.getValue()) == 0) {
            return VaultGearModifierHelper.reForgeOutcomeOfRandomModifier(stack, worldGameTime, random);
        }
        data.getAllModifierAffixes().forEach(VaultGearModifier::resetGameTimeAdded);
        existing.setValue(newModifier.getValue());
        existing.setRolledTier(newModifier.getRolledTier());
        existing.setGameTimeAdded(worldGameTime);
        existing.clearCategories();
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }

    public static GearModification.Result reforgeModifiersForNewLevel(ItemStack stack, int newLevel, Random random, boolean takeRepairSlot) {
        VaultGearData data = VaultGearData.read(stack);
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        if (data.getUsedRepairSlots() >= data.getRepairSlots() && takeRepairSlot) {
            return GearModification.Result.makeActionError("no_repair_slots", new Component[0]);
        }
        if ((newLevel = Math.min(100, newLevel)) <= data.getItemLevel()) {
            return GearModification.Result.makeActionError("same_level", new Component[0]);
        }
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack).orElse(null);
        if (cfg == null) {
            return GearModification.Result.errorUnmodifiable();
        }
        data.setItemLevel(newLevel);
        if (takeRepairSlot) {
            data.setUsedRepairSlots(data.getUsedRepairSlots() + 1);
        }
        VaultGearModifierHelper.reforgeBaseAttributesForNewLevel(data, cfg, newLevel, random);
        VaultGearModifierHelper.reforgeModifiersOfTypeForNewLevel(data, cfg, VaultGearModifier.AffixType.IMPLICIT, newLevel, random);
        VaultGearModifierHelper.reforgeModifiersOfTypeForNewLevel(data, cfg, VaultGearModifier.AffixType.PREFIX, newLevel, random);
        VaultGearModifierHelper.reforgeModifiersOfTypeForNewLevel(data, cfg, VaultGearModifier.AffixType.SUFFIX, newLevel, random);
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }

    private static void reforgeBaseAttributesForNewLevel(VaultGearData data, VaultGearTierConfig cfg, int newLevel, Random random) {
        ArrayList attributeInstances = new ArrayList();
        VaultGearData.Type.ATTRIBUTES.getAttributeSource(data).forEach(attributeInstances::add);
        for (VaultGearAttributeInstance instance : attributeInstances) {
            VaultGearTierConfig.ModifierOutcome outcome;
            VaultGearTierConfig.ModifierTierGroup tierGroup;
            VaultGearModifier modifier;
            VaultGearAttribute attribute = instance.getAttribute();
            if (attribute == ModGearAttributes.CRAFTING_POTENTIAL || attribute == ModGearAttributes.MAX_CRAFTING_POTENTIAL || !(instance instanceof VaultGearModifier) || (modifier = (VaultGearModifier)instance).hasCategory(VaultGearModifier.AffixCategory.FROZEN) || modifier.hasCategory(VaultGearModifier.AffixCategory.CRAFTED) || (tierGroup = cfg.getTierGroup(modifier.getModifierIdentifier())) == null) continue;
            WeightedList outcomes = new WeightedList();
            tierGroup.getModifiersForLevel(newLevel).forEach(tier -> outcomes.add(new VaultGearTierConfig.ModifierOutcome(tier, tierGroup), tier.getWeight()));
            if (outcomes.isEmpty() || (outcome = (VaultGearTierConfig.ModifierOutcome)outcomes.getRandom(random).orElse(null)) == null) continue;
            VaultGearModifier newModifier = outcome.makeModifier(random);
            VaultGearAttributeComparator comparator = attribute.getAttributeComparator();
            if (comparator == null || comparator.compare(modifier.getValue(), newModifier.getValue()) > 0) continue;
            for (VaultGearModifier.AffixCategory category : modifier.getCategories()) {
                newModifier.addCategory(category);
            }
            data.removeAttribute(modifier.getAttribute());
            data.addAttribute(newModifier);
        }
    }

    private static void reforgeModifiersOfTypeForNewLevel(VaultGearData data, VaultGearTierConfig cfg, VaultGearModifier.AffixType type, int newLevel, Random random) {
        ArrayList modifiers = new ArrayList(data.getModifiers(type));
        for (VaultGearModifier vaultGearModifier : modifiers) {
            if (vaultGearModifier.hasCategory(VaultGearModifier.AffixCategory.FROZEN) || vaultGearModifier.hasCategory(VaultGearModifier.AffixCategory.CRAFTED)) continue;
            if (vaultGearModifier.hasCategory(VaultGearModifier.AffixCategory.LEGENDARY)) {
                VaultGearModifierHelper.reforgeLegendaryModifierForNewLevel(data, cfg, vaultGearModifier, type, newLevel, random);
                continue;
            }
            VaultGearModifierHelper.reforgeModifierForNewLevel(data, cfg, vaultGearModifier, type, newLevel, random);
        }
    }

    private static void reforgeModifierForNewLevel(VaultGearData data, VaultGearTierConfig cfg, VaultGearModifier<?> modifier, VaultGearModifier.AffixType type, int newLevel, Random random) {
        VaultGearTierConfig.ModifierTierGroup tierGroup = cfg.getTierGroup(modifier.getModifierIdentifier());
        if (tierGroup == null) {
            return;
        }
        WeightedList outcomes = new WeightedList();
        tierGroup.getModifiersForLevel(newLevel).forEach(tier -> outcomes.add(new VaultGearTierConfig.ModifierOutcome(tier, tierGroup), tier.getWeight()));
        if (outcomes.isEmpty()) {
            return;
        }
        VaultGearTierConfig.ModifierOutcome outcome = outcomes.getRandom(random).orElse(null);
        if (outcome == null) {
            return;
        }
        VaultGearModifier newModifier = outcome.makeModifier(random);
        VaultGearAttributeComparator comparator = modifier.getAttribute().getAttributeComparator();
        if (comparator == null) {
            return;
        }
        if (comparator.compare(modifier.getValue(), newModifier.getValue()) > 0) {
            return;
        }
        for (VaultGearModifier.AffixCategory category : modifier.getCategories()) {
            newModifier.addCategory(category);
        }
        newModifier.setModifierGroup(modifier.getModifierGroup());
        newModifier.setModifierIdentifier(modifier.getModifierIdentifier());
        data.removeModifier(modifier);
        data.addModifier(type, newModifier);
    }

    private static void reforgeLegendaryModifierForNewLevel(VaultGearData data, VaultGearTierConfig cfg, VaultGearModifier<?> legendary, VaultGearModifier.AffixType type, int newLevel, Random random) {
        VaultGearTierConfig.ModifierTierGroup tierGroup = cfg.getTierGroup(legendary.getModifierIdentifier());
        if (tierGroup == null) {
            return;
        }
        VaultGearTierConfig.ModifierTier<?> maxTier = tierGroup.getHighestForLevel(newLevel);
        if (maxTier == null) {
            return;
        }
        int targetTier = Math.min(maxTier.getModifierTier() + 2, tierGroup.size() - 1);
        VaultGearTierConfig.ModifierTier<?> targetTierModifier = tierGroup.getModifierForTier(targetTier);
        if (targetTierModifier == null) {
            targetTierModifier = maxTier;
        }
        VaultGearModifier newModifier = targetTierModifier.makeModifier(tierGroup, random);
        VaultGearAttributeComparator comparator = legendary.getAttribute().getAttributeComparator();
        if (comparator == null) {
            return;
        }
        if (comparator.compare(legendary.getValue(), newModifier.getValue()) > 0) {
            return;
        }
        for (VaultGearModifier.AffixCategory category : legendary.getCategories()) {
            newModifier.addCategory(category);
        }
        newModifier.setModifierGroup(legendary.getModifierGroup());
        newModifier.setModifierIdentifier(legendary.getModifierIdentifier());
        data.removeModifier(legendary);
        data.addModifier(type, newModifier);
    }

    public static GearModification.Result canImproveRandomModifier(ItemStack stack) {
        VaultGearData data = VaultGearData.read(stack);
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        List<Tuple<VaultGearModifier<?>, WeightedList<VaultGearTierConfig.ModifierOutcome<?>>>> modifierReplacements = VaultGearModifierHelper.getAvailableModifierConfigurationOutcomes(data, stack, true);
        VaultGearModifierHelper.filterImprovableModifiers(modifierReplacements);
        if (modifierReplacements.isEmpty()) {
            return GearModification.Result.makeActionError("all_max", new Component[0]);
        }
        return GearModification.Result.makeSuccess();
    }

    public static GearModification.Result improveRandomModifier(ItemStack stack, long worldGameTime, Random random) {
        GearModification.Result canImprove = VaultGearModifierHelper.canImproveRandomModifier(stack);
        if (!canImprove.success()) {
            return canImprove;
        }
        VaultGearData data = VaultGearData.read(stack);
        List<Tuple<VaultGearModifier<?>, WeightedList<VaultGearTierConfig.ModifierOutcome<?>>>> modifierReplacements = VaultGearModifierHelper.getAvailableModifierConfigurationOutcomes(data, stack, true);
        VaultGearModifierHelper.filterImprovableModifiers(modifierReplacements);
        Tuple<VaultGearModifier<?>, WeightedList<VaultGearTierConfig.ModifierOutcome<?>>> potentialReplacements = MiscUtils.getRandomEntry(modifierReplacements);
        if (potentialReplacements == null) {
            return GearModification.Result.errorInternal();
        }
        VaultGearTierConfig.ModifierOutcome replacement = ((WeightedList)potentialReplacements.m_14419_()).getRandom(random).orElse(null);
        if (replacement == null) {
            return GearModification.Result.errorInternal();
        }
        VaultGearModifier existing = (VaultGearModifier)potentialReplacements.m_14418_();
        ConfigurableAttributeGenerator generator = existing.getAttribute().getGenerator();
        Object tierConfig = replacement.tier().getModifierConfiguration();
        Object maxPossibleValue = generator.getMaximumValue(List.of(tierConfig)).orElse(null);
        VaultGearModificationConfig.OperationConfig improvementConfig = ModConfigs.VAULT_GEAR_MODIFICATION_CONFIG.getOperationConfig(ModGearModifications.IMPROVE_MODIFIER);
        float improvementExponent = improvementConfig != null ? improvementConfig.getImprovementExponent() : 3.0f;
        float minImprovement = improvementConfig != null ? improvementConfig.getMinImprovement() : 1.0f;
        Object improvedValue = VaultGearModifierHelper.calculateImprovedValue(existing.getValue(), maxPossibleValue, random, improvementExponent, minImprovement);
        data.getAllModifierAffixes().forEach(VaultGearModifier::resetGameTimeAdded);
        existing.setValue(improvedValue);
        existing.setRolledTier(replacement.tier().getModifierTier());
        existing.setGameTimeAdded(worldGameTime);
        existing.clearCategories();
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }

    public static GearModification.Result addNewModifier(ItemStack stack, long worldGameTime, Random random) {
        if (stack.m_150930_((Item)ModItems.TOOL)) {
            return GearModification.Result.errorUnmodifiable();
        }
        VaultGearData data = VaultGearData.read(stack);
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("[2] Unknown VaultGear: " + String.valueOf(stack));
            return GearModification.Result.errorUnmodifiable();
        }
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        int itemLevel = data.getItemLevel();
        int prefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0);
        int suffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0);
        if ((prefixes -= data.getModifiers(VaultGearModifier.AffixType.PREFIX).size()) <= 0 && (suffixes -= data.getModifiers(VaultGearModifier.AffixType.SUFFIX).size()) <= 0) {
            return GearModification.Result.makeActionError("full", new Component[0]);
        }
        Set<String> groups = data.getExistingModifierGroups(VaultGearData.Type.EXPLICIT_MODIFIERS);
        ArrayList<VaultGearModifier.AffixType> types = new ArrayList<VaultGearModifier.AffixType>();
        if (prefixes > 0 && cfg.getRandomModifier(VaultGearModifier.AffixType.PREFIX, itemLevel, random, groups).isPresent()) {
            types.add(VaultGearModifier.AffixType.PREFIX);
        }
        if (suffixes > 0 && cfg.getRandomModifier(VaultGearModifier.AffixType.SUFFIX, itemLevel, random, groups).isPresent()) {
            types.add(VaultGearModifier.AffixType.SUFFIX);
        }
        if (types.isEmpty()) {
            return GearModification.Result.makeActionError("no_modifiers", new Component[0]);
        }
        VaultGearModifier.AffixType type = (VaultGearModifier.AffixType)((Object)MiscUtils.getRandomEntry(types, random));
        return cfg.getRandomModifier(type, itemLevel, random, groups).map(modifier -> {
            data.getAllModifierAffixes().forEach(VaultGearModifier::resetGameTimeAdded);
            modifier.setGameTimeAdded(worldGameTime);
            data.addModifier(type, (VaultGearModifier<?>)modifier);
            data.write(stack);
            return GearModification.Result.makeSuccess();
        }).orElse(GearModification.Result.makeActionError("no_modifiers", new Component[0]));
    }

    public static GearModification.Result removeRandomModifier(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        ArrayList<VaultGearModifier> affixes = new ArrayList<VaultGearModifier>();
        affixes.addAll(data.getModifiers(VaultGearModifier.AffixType.PREFIX));
        affixes.addAll(data.getModifiers(VaultGearModifier.AffixType.SUFFIX));
        affixes.removeIf(modifier -> !modifier.hasNoCategoryMatching(VaultGearModifier.AffixCategory::cannotBeModifiedByArtisanFoci));
        if (affixes.isEmpty()) {
            return GearModification.Result.makeActionError("no_modifiers", new Component[0]);
        }
        VaultGearModifier randomMod = (VaultGearModifier)MiscUtils.getRandomEntry(affixes, random);
        data.removeModifier(randomMod);
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }

    public static int getAffixCount(ItemStack stack) {
        Integer data = AttributeGearData.read(stack);
        int prefixes = ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.PREFIXES).orElse(0);
        int suffixes = ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.SUFFIXES).orElse(0);
        return prefixes + suffixes;
    }

    public static boolean hasAnyOpenAffix(ItemStack stack) {
        VaultGearData data = VaultGearData.read(stack);
        int prefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0);
        int suffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0);
        return (prefixes -= data.getModifiers(VaultGearModifier.AffixType.PREFIX).size()) > 0 || (suffixes -= data.getModifiers(VaultGearModifier.AffixType.SUFFIX).size()) > 0;
    }

    public static boolean hasOpenPrefix(ItemStack stack) {
        VaultGearData data = VaultGearData.read(stack);
        int prefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0) - data.getModifiers(VaultGearModifier.AffixType.PREFIX).size();
        return prefixes > 0;
    }

    public static boolean hasOpenSuffix(ItemStack stack) {
        VaultGearData data = VaultGearData.read(stack);
        int suffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0) - data.getModifiers(VaultGearModifier.AffixType.SUFFIX).size();
        return suffixes > 0;
    }

    public static GearModification.Result removeAllModifiers(ItemStack stack) {
        GearModification.Result result = VaultGearModifierHelper.removeAllModifiersOfType(stack, VaultGearModifier.AffixType.PREFIX);
        if (!result.success()) {
            return result;
        }
        return VaultGearModifierHelper.removeAllModifiersOfType(stack, VaultGearModifier.AffixType.SUFFIX);
    }

    public static GearModification.Result removeAllModifiersOfType(ItemStack stack, VaultGearModifier.AffixType type) {
        VaultGearData data = VaultGearData.read(stack);
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        ArrayList modifiers = new ArrayList(data.getModifiers(type));
        for (VaultGearModifier vaultGearModifier : modifiers) {
            if (!vaultGearModifier.hasNoCategoryMatching(VaultGearModifier.AffixCategory::cannotBeModifiedByArtisanFoci)) continue;
            data.removeModifier(vaultGearModifier);
        }
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }

    public static boolean createOrReplaceAbilityEnhancementModifier(ItemStack stack, Random random) {
        if (stack.m_150930_((Item)ModItems.TOOL)) {
            return false;
        }
        VaultGearData data = VaultGearData.read(stack);
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("[3] Unknown VaultGear: " + String.valueOf(stack));
            return false;
        }
        if (!data.isModifiable()) {
            return false;
        }
        Optional<VaultGearModifier<?>> modifierOpt = cfg.getRandomModifier(VaultGearTierConfig.ModifierAffixTagGroup.ABILITY_ENHANCEMENT, data.getItemLevel(), random, Collections.emptySet());
        if (modifierOpt.isEmpty()) {
            return false;
        }
        VaultGearModifier<?> newModifier = modifierOpt.get();
        newModifier.addCategory(VaultGearModifier.AffixCategory.ABILITY_ENHANCEMENT);
        VaultGearModifier.AffixType targetType = VaultGearTierConfig.ModifierAffixTagGroup.ABILITY_ENHANCEMENT.getTargetAffixType();
        if (targetType == null) {
            throw new IllegalStateException("Ability enhancement affix has no valid target type.");
        }
        List<VaultGearModifier<?>> implicits = data.getModifiers(targetType);
        for (VaultGearModifier<?> modifier : new ArrayList(implicits)) {
            if (!modifier.hasCategory(VaultGearModifier.AffixCategory.ABILITY_ENHANCEMENT)) continue;
            data.removeModifier(modifier);
        }
        if (!data.addModifierFirst(VaultGearModifier.AffixType.IMPLICIT, newModifier)) {
            return false;
        }
        data.write(stack);
        return true;
    }

    public static GearModification.Result improveGearRarity(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        VaultGearRarity currentRarity = data.getRarity();
        VaultGearRarity nextRarity = currentRarity.getNextTier();
        if (nextRarity == null) {
            return GearModification.Result.makeActionError("max_rarity", new Component[0]);
        }
        data.setRarity(nextRarity);
        data.write(stack);
        ItemStack copyStack = stack.m_41777_();
        VaultGearModifierHelper.generateAffixSlots(copyStack, random);
        VaultGearData copyData = VaultGearData.read(copyStack);
        int copyAffixes = VaultGearModifierHelper.getAffixSlotCount(copyData);
        int affixes = VaultGearModifierHelper.getAffixSlotCount(data);
        if (copyAffixes > affixes) {
            data.createOrReplaceAttributeValue(ModGearAttributes.PREFIXES, copyData.getFirstValue(ModGearAttributes.PREFIXES).orElse(data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0)));
            data.createOrReplaceAttributeValue(ModGearAttributes.SUFFIXES, copyData.getFirstValue(ModGearAttributes.SUFFIXES).orElse(data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0)));
            data.write(stack);
        }
        return GearModification.Result.makeSuccess();
    }

    public static void generateAffixSlots(ItemStack stack, Random random) {
        if (stack.m_150930_((Item)ModItems.TOOL)) {
            return;
        }
        VaultGearData data = VaultGearData.read(stack);
        VaultGearRarity rarity = data.getRarity();
        boolean shouldFullFillAll = InventoryUtil.isRoyaleItem(stack);
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("[4] Unknown VaultGear: " + String.valueOf(stack));
            return;
        }
        Item item = stack.m_41720_();
        if (item instanceof VaultGearItem) {
            VaultGearModifier modifier;
            VaultGearModifier modifier2;
            VaultGearItem item2 = (VaultGearItem)item;
            VaultGearClassification classification = item2.getClassification(stack);
            int modifierCount = classification.getModifierCount(rarity);
            HashSet<String> prefixModifiers = new HashSet<String>();
            HashSet<String> suffixModifiers = new HashSet<String>();
            int itemLevel = data.getItemLevel();
            while (cfg.getRandomModifier(VaultGearModifier.AffixType.PREFIX, itemLevel, random, prefixModifiers).isPresent() && (modifier2 = (VaultGearModifier)cfg.getRandomModifier(VaultGearModifier.AffixType.PREFIX, itemLevel, random, prefixModifiers).orElse(null)) != null) {
                prefixModifiers.add(modifier2.getModifierGroup());
            }
            int availablePrefixes = prefixModifiers.size();
            while (cfg.getRandomModifier(VaultGearModifier.AffixType.SUFFIX, itemLevel, random, suffixModifiers).isPresent() && (modifier = (VaultGearModifier)cfg.getRandomModifier(VaultGearModifier.AffixType.SUFFIX, itemLevel, random, suffixModifiers).orElse(null)) != null) {
                suffixModifiers.add(modifier.getModifierGroup());
            }
            int availableSuffixes = suffixModifiers.size();
            int prefixes = modifierCount / 2;
            int suffixes = modifierCount / 2;
            if (modifierCount - prefixes - suffixes > 0) {
                if (random.nextBoolean()) {
                    ++prefixes;
                } else {
                    ++suffixes;
                }
            }
            prefixes = Math.min(prefixes, availablePrefixes);
            suffixes = Math.min(suffixes, availableSuffixes);
            if (classification.hasOnlySuffixes()) {
                prefixes = 0;
                suffixes = classification.getModifierCount(rarity);
            }
            data.createOrReplaceAttributeValue(ModGearAttributes.PREFIXES, prefixes);
            data.createOrReplaceAttributeValue(ModGearAttributes.SUFFIXES, suffixes);
            data.write(stack);
            if (shouldFullFillAll) {
                int missingPrefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0);
                int missingSuffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0);
                if ((missingPrefixes -= data.getModifiers(VaultGearModifier.AffixType.PREFIX).size()) > 0 || (missingSuffixes -= data.getModifiers(VaultGearModifier.AffixType.SUFFIX).size()) > 0) {
                    Optional<VaultGearModifier<?>> mod;
                    Set<String> groups = data.getExistingModifierGroups(VaultGearData.Type.EXPLICIT_MODIFIERS);
                    while (missingPrefixes > 0 && !(mod = cfg.getRandomModifier(VaultGearModifier.AffixType.PREFIX, itemLevel, random, groups)).isEmpty()) {
                        data.addModifier(VaultGearModifier.AffixType.PREFIX, mod.get());
                        groups.add(mod.get().getModifierGroup());
                        --missingPrefixes;
                    }
                    while (missingSuffixes > 0 && !(mod = cfg.getRandomModifier(VaultGearModifier.AffixType.SUFFIX, itemLevel, random, groups)).isEmpty()) {
                        data.addModifier(VaultGearModifier.AffixType.SUFFIX, mod.get());
                        groups.add(mod.get().getModifierGroup());
                        --missingSuffixes;
                    }
                    data.write(stack);
                }
            }
        }
    }

    public static GearModification.Result generateBaseAttributes(ItemStack stack, Random random) {
        if (stack.m_150930_((Item)ModItems.TOOL)) {
            return GearModification.Result.errorUnmodifiable();
        }
        VaultGearData data = VaultGearData.read(stack);
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("[5] Unknown VaultGear: " + String.valueOf(stack));
            return GearModification.Result.errorUnmodifiable();
        }
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        int itemLevel = data.getItemLevel();
        List allowedAttributes = cfg.generateBaseAttributes(itemLevel, random).stream().filter(mod -> VaultGearCraftingConfig.ProficiencyStep.isModifierAllowed(stack, mod.getModifierIdentifier())).collect(Collectors.toList());
        allowedAttributes.stream().map(VaultGearModifier::cast).forEach(data::addAttribute);
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }

    public static GearModification.Result generateImplicits(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        if (stack.m_150930_((Item)ModItems.TOOL)) {
            return GearModification.Result.errorUnmodifiable();
        }
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("[6] Unknown VaultGear: " + String.valueOf(stack));
            return GearModification.Result.errorUnmodifiable();
        }
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        int itemLevel = data.getItemLevel();
        List<VaultGearModifier> allowedImplicits = cfg.generateImplicits(itemLevel, random).stream().filter(mod -> VaultGearCraftingConfig.ProficiencyStep.isModifierAllowed(stack, mod.getModifierIdentifier())).toList();
        allowedImplicits.forEach(modifier -> {
            if (!data.hasModifier(modifier.getModifierIdentifier())) {
                data.addModifier(VaultGearModifier.AffixType.IMPLICIT, (VaultGearModifier<?>)modifier);
            }
        });
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }

    public static GearModification.Result generateCorruptedImplicit(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        if (stack.m_150930_((Item)ModItems.TOOL)) {
            return GearModification.Result.errorUnmodifiable();
        }
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("[7] Unknown VaultGear: " + String.valueOf(stack));
            return GearModification.Result.errorUnmodifiable();
        }
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        int itemLevel = data.getItemLevel();
        Set<String> groups = data.getExistingModifierGroups(VaultGearData.Type.IMPLICIT_MODIFIERS);
        return cfg.getRandomModifier(VaultGearTierConfig.ModifierAffixTagGroup.CORRUPTED_IMPLICIT, itemLevel, random, groups).map(modifier -> {
            modifier.addCategory(VaultGearModifier.AffixCategory.CORRUPTED);
            data.addModifierFirst(VaultGearModifier.AffixType.IMPLICIT, (VaultGearModifier<?>)modifier);
            data.write(stack);
            return GearModification.Result.makeSuccess();
        }).orElse(GearModification.Result.makeActionError("no_modifiers", new Component[0]));
    }

    public static GearModification.Result generateRepairSlots(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        int repairs = 1 + random.nextInt(8);
        data.setRepairSlots(repairs);
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }

    public static GearModification.Result setGearCorrupted(ItemStack stack) {
        VaultGearData data = VaultGearData.read(stack);
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        data.createOrReplaceAttributeValue(ModGearAttributes.IS_CORRUPTED, true);
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }

    public static GearModification.Result lockRandomAffix(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        ArrayList affixes = new ArrayList();
        affixes.addAll(data.getModifiers(VaultGearModifier.AffixType.PREFIX));
        affixes.addAll(data.getModifiers(VaultGearModifier.AffixType.SUFFIX));
        if (affixes.stream().anyMatch(modifier -> modifier.hasCategory(VaultGearModifier.AffixCategory.FROZEN))) {
            return GearModification.Result.makeActionError("frozen", new Component[0]);
        }
        VaultGearModifier randomModifier = (VaultGearModifier)MiscUtils.getRandomEntry(affixes, random);
        if (randomModifier == null) {
            return GearModification.Result.errorInternal();
        }
        randomModifier.addCategory(VaultGearModifier.AffixCategory.FROZEN);
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }

    public static GearModification.Result generateModifiersOfAffix(ItemStack stack, VaultGearModifier.AffixType affixType, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        if (stack.m_150930_((Item)ModItems.TOOL)) {
            return GearModification.Result.errorUnmodifiable();
        }
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("[8] Unknown VaultGear: " + String.valueOf(stack));
            return GearModification.Result.errorUnmodifiable();
        }
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        int itemLevel = data.getItemLevel();
        int maxPrefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0);
        int maxSuffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0);
        if (affixType == VaultGearModifier.AffixType.PREFIX && maxPrefixes <= 0) {
            return GearModification.Result.makeActionError("no_prefixes", new Component[0]);
        }
        if (affixType == VaultGearModifier.AffixType.SUFFIX && maxSuffixes <= 0) {
            return GearModification.Result.makeActionError("no_suffixes", new Component[0]);
        }
        int prefixCount = data.getModifiers(VaultGearModifier.AffixType.PREFIX).size();
        int suffixCount = data.getModifiers(VaultGearModifier.AffixType.SUFFIX).size();
        int possibleGenerated = VaultGearModifierHelper.getGeneratedModifierCount(maxPrefixes + maxSuffixes, itemLevel, random);
        int toGenerate = possibleGenerated - Math.min(prefixCount, maxPrefixes) - Math.min(suffixCount, maxSuffixes);
        toGenerate = affixType == VaultGearModifier.AffixType.PREFIX ? Math.min(toGenerate, maxPrefixes - prefixCount) : Math.min(toGenerate, maxSuffixes - suffixCount);
        for (int i = 0; i < toGenerate; ++i) {
            VaultGearModifier modifier = cfg.getRandomModifier(affixType, itemLevel, random, data.getExistingModifierGroups(VaultGearData.Type.EXPLICIT_MODIFIERS)).orElse(null);
            if (modifier == null || !data.addModifier(affixType, modifier)) continue;
            if (affixType == VaultGearModifier.AffixType.PREFIX) {
                ++prefixCount;
                continue;
            }
            ++suffixCount;
        }
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }

    public static GearModification.Result generateModifiers(ItemStack stack, Random random) {
        VaultGearData data = VaultGearData.read(stack);
        if (stack.m_150930_((Item)ModItems.TOOL)) {
            return GearModification.Result.errorUnmodifiable();
        }
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("[9] Unknown VaultGear: " + String.valueOf(stack));
            return GearModification.Result.errorUnmodifiable();
        }
        if (!data.isModifiable()) {
            return GearModification.Result.errorUnmodifiable();
        }
        int itemLevel = data.getItemLevel();
        int maxPrefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0) - data.getModifiers(VaultGearModifier.AffixType.PREFIX).size();
        int maxSuffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0) - data.getModifiers(VaultGearModifier.AffixType.SUFFIX).size();
        if (maxPrefixes <= 0 && maxSuffixes <= 0) {
            return GearModification.Result.makeActionError("no_modifiers", new Component[0]);
        }
        int generatedModifiers = VaultGearModifierHelper.getGeneratedModifierCount(maxPrefixes + maxSuffixes, itemLevel, random);
        int rolledPrefixes = 0;
        int rolledSuffixes = 0;
        if (stack.m_41720_() == ModItems.JEWEL) {
            generatedModifiers = maxPrefixes + maxSuffixes;
        }
        for (int i = 0; i < generatedModifiers; ++i) {
            VaultGearModifier<?> modifier;
            Optional<VaultGearModifier<Object>> modifierOpt;
            VaultGearModifier.AffixType type;
            ArrayList<VaultGearModifier.AffixType> types = new ArrayList<VaultGearModifier.AffixType>();
            if (rolledPrefixes < maxPrefixes) {
                types.add(VaultGearModifier.AffixType.PREFIX);
            }
            if (rolledSuffixes < maxSuffixes) {
                types.add(VaultGearModifier.AffixType.SUFFIX);
            }
            if ((type = (VaultGearModifier.AffixType)((Object)MiscUtils.getRandomEntry(types, random))) == null) continue;
            int attempts = 0;
            int MAX_ATTEMPTS = 10;
            do {
                modifierOpt = cfg.getRandomModifier(type, itemLevel, random, data.getExistingModifierGroups(VaultGearData.Type.EXPLICIT_MODIFIERS));
                ++attempts;
                if (!modifierOpt.isPresent() || VaultGearCraftingConfig.ProficiencyStep.isModifierAllowed(stack, modifierOpt.get().getModifierIdentifier())) continue;
                modifierOpt = Optional.empty();
            } while (modifierOpt.isEmpty() && attempts < 10);
            if (!modifierOpt.isPresent() || !data.addModifier(type, modifier = modifierOpt.get())) continue;
            if (type == VaultGearModifier.AffixType.PREFIX) {
                ++rolledPrefixes;
                continue;
            }
            ++rolledSuffixes;
        }
        data.write(stack);
        return GearModification.Result.makeSuccess();
    }

    private static int getAffixSlotCount(VaultGearData data) {
        return data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0) + data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0);
    }

    private static List<Tuple<VaultGearModifier<?>, WeightedList<VaultGearTierConfig.ModifierOutcome<?>>>> getAvailableModifierConfigurationOutcomes(VaultGearData data, ItemStack stack, boolean includeOnlyModifiableModifiers) {
        ArrayList modifierReplacements = new ArrayList();
        if (!data.isModifiable()) {
            return modifierReplacements;
        }
        if (stack.m_150930_((Item)ModItems.TOOL)) {
            return modifierReplacements;
        }
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack).orElse(null);
        if (cfg == null) {
            VaultMod.LOGGER.error("[10] Unknown VaultGear: " + String.valueOf(stack));
            return modifierReplacements;
        }
        int itemLevel = data.getItemLevel();
        data.getModifiers(VaultGearModifier.AffixType.PREFIX).forEach(modifier -> {
            VaultGearTierConfig.ModifierTierGroup group;
            if (includeOnlyModifiableModifiers) {
                if (!modifier.hasNoCategoryMatching(VaultGearModifier.AffixCategory::cannotBeModifiedByArtisanFoci)) {
                    return;
                }
                if (!modifier.hasNoCategoryMatching(VaultGearModifier.AffixCategory::cannotBeRolledByArtisanFoci)) {
                    return;
                }
            }
            if ((group = cfg.getTierGroup(modifier.getModifierIdentifier())) != null) {
                WeightedList replacementTiers = new WeightedList();
                group.getModifiersForLevel(itemLevel).forEach(tier -> replacementTiers.add(new VaultGearTierConfig.ModifierOutcome(tier, group), tier.getWeight()));
                modifierReplacements.add(new Tuple(modifier, replacementTiers));
            }
        });
        data.getModifiers(VaultGearModifier.AffixType.SUFFIX).forEach(modifier -> {
            VaultGearTierConfig.ModifierTierGroup group;
            if (includeOnlyModifiableModifiers) {
                if (!modifier.hasNoCategoryMatching(VaultGearModifier.AffixCategory::cannotBeModifiedByArtisanFoci)) {
                    return;
                }
                if (!modifier.hasNoCategoryMatching(VaultGearModifier.AffixCategory::cannotBeRolledByArtisanFoci)) {
                    return;
                }
            }
            if ((group = cfg.getTierGroup(modifier.getModifierIdentifier())) != null) {
                WeightedList replacementTiers = new WeightedList();
                group.getModifiersForLevel(itemLevel).forEach(tier -> replacementTiers.add(new VaultGearTierConfig.ModifierOutcome(tier, group), tier.getWeight()));
                modifierReplacements.add(new Tuple(modifier, replacementTiers));
            }
        });
        return modifierReplacements;
    }

    public static WeightedList<TierGroupOutcome> getAvailableModGroupOutcomes(VaultGearTagConfig.ModTagGroup modGroupTag, ItemStack stack) {
        return VaultGearModifierHelper.getAvailableModGroupOutcomes(modGroupTag.getTags(), stack, false);
    }

    private static WeightedList<TierGroupOutcome> getAvailableModGroupOutcomes(List<String> tags, ItemStack stack, boolean anyGroup) {
        return VaultGearModifierHelper.getAvailableModGroupOutcomes((VaultGearTierConfig.ModifierTierGroup group) -> !MiscUtils.intersection(group.getTags(), tags).isEmpty(), stack, anyGroup);
    }

    private static WeightedList<TierGroupOutcome> getAvailableModGroupOutcomes(Predicate<VaultGearTierConfig.ModifierTierGroup> filter, ItemStack stack, boolean anyGroup) {
        WeightedList<TierGroupOutcome> groupOutcomes = new WeightedList<TierGroupOutcome>();
        VaultGearTierConfig cfg = VaultGearTierConfig.getConfig(stack).orElse(null);
        if (cfg == null) {
            return groupOutcomes;
        }
        VaultGearData data = VaultGearData.read(stack);
        int itemLevel = data.getItemLevel();
        Set<String> existingGroups = data.getExistingModifierGroups(VaultGearData.Type.ALL);
        boolean generatePrefixes = data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0) > data.getModifiers(VaultGearModifier.AffixType.PREFIX).size();
        boolean generateSuffixes = data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0) > data.getModifiers(VaultGearModifier.AffixType.SUFFIX).size();
        cfg.getAnyGroupsFulfilling(filter).forEach(tpl -> {
            if (!anyGroup && !((VaultGearTierConfig.ModifierAffixTagGroup)((Object)((Object)tpl.m_14418_()))).isGenericGroup()) {
                return;
            }
            if (existingGroups.contains(((VaultGearTierConfig.ModifierTierGroup)tpl.m_14419_()).getModifierGroup())) {
                return;
            }
            VaultGearModifier.AffixType type = ((VaultGearTierConfig.ModifierAffixTagGroup)((Object)((Object)tpl.m_14418_()))).getTargetAffixType();
            if (type != null) {
                if (type == VaultGearModifier.AffixType.PREFIX && !generatePrefixes) {
                    return;
                }
                if (type == VaultGearModifier.AffixType.SUFFIX && !generateSuffixes) {
                    return;
                }
            }
            ((VaultGearTierConfig.ModifierTierGroup)tpl.m_14419_()).getModifiersForLevel(itemLevel).forEach(tier -> groupOutcomes.add(new TierGroupOutcome((VaultGearTierConfig.ModifierAffixTagGroup)((Object)((Object)((Object)tpl.m_14418_()))), (VaultGearTierConfig.ModifierTierGroup)tpl.m_14419_(), (VaultGearTierConfig.ModifierTier<?>)tier), tier.getWeight()));
        });
        return groupOutcomes;
    }

    private static int getGeneratedModifierCount(int modifierCount, int itemLevel, Random random) {
        if (itemLevel <= 20) {
            return modifierCount;
        }
        return Math.round((float)modifierCount * 0.6f + (float)modifierCount * 0.4f * random.nextFloat());
    }

    private static void filterImprovableModifiers(List<Tuple<VaultGearModifier<?>, WeightedList<VaultGearTierConfig.ModifierOutcome<?>>>> modifierReplacements) {
        modifierReplacements.removeIf(tpl -> {
            VaultGearModifier existing = (VaultGearModifier)tpl.m_14418_();
            VaultGearAttributeComparator comparator = existing.getAttribute().getAttributeComparator();
            if (comparator == null) {
                return true;
            }
            ConfigurableAttributeGenerator generator = existing.getAttribute().getGenerator();
            ((WeightedList)tpl.m_14419_()).entrySet().removeIf(weightedOutcome -> {
                VaultGearTierConfig.ModifierOutcome outcome = (VaultGearTierConfig.ModifierOutcome)weightedOutcome.getKey();
                Object tierConfig = outcome.tier().getModifierConfiguration();
                Object maxValue = generator.getMaximumValue(List.of(tierConfig)).orElse(null);
                if (maxValue == null) {
                    return true;
                }
                int comparison = comparator.compare(maxValue, existing.getValue());
                return comparison <= 0;
            });
            if (((WeightedList)tpl.m_14419_()).isEmpty()) {
                return true;
            }
            return ((WeightedList)tpl.m_14419_()).entrySet().stream().allMatch(weightedOutcome -> {
                VaultGearTierConfig.ModifierOutcome outcome = (VaultGearTierConfig.ModifierOutcome)weightedOutcome.getKey();
                Object tierConfig = outcome.tier().getModifierConfiguration();
                Object minValue = generator.getMinimumValue(List.of(tierConfig)).orElse(null);
                Object maxValue = generator.getMaximumValue(List.of(tierConfig)).orElse(null);
                if (minValue == null || maxValue == null) {
                    return true;
                }
                return comparator.compare(minValue, existing.getValue()) == 0 && comparator.compare(maxValue, existing.getValue()) == 0;
            });
        });
    }

    private static Object calculateImprovedValue(Object currentValue, Object maxPossibleValue, Random random, float improvementExponent, float minImprovement) {
        if (!(currentValue instanceof Number) || !(maxPossibleValue instanceof Number)) {
            return maxPossibleValue;
        }
        float currentVal = ((Number)currentValue).floatValue();
        float maxVal = ((Number)maxPossibleValue).floatValue();
        float randomFactor = 1.0f - (float)Math.pow(random.nextFloat(), improvementExponent);
        float improvement = currentVal + (maxVal - currentVal) * randomFactor;
        if ((improvement = (float)Math.round(improvement * 10.0f) / 10.0f) <= currentVal) {
            improvement = (float)Math.round((currentVal + minImprovement) * 10.0f) / 10.0f;
        }
        improvement = Math.min(improvement, maxVal);
        if (currentValue instanceof Integer) {
            return Math.round(improvement);
        }
        if (currentValue instanceof Float) {
            return Float.valueOf(improvement);
        }
        return (double)improvement;
    }

    public record TierGroupOutcome(VaultGearTierConfig.ModifierAffixTagGroup type, VaultGearTierConfig.ModifierTierGroup tierGroup, VaultGearTierConfig.ModifierTier<?> tier) {
    }
}

