/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.ColorBlindMode;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import org.apache.commons.lang3.StringUtils;

public enum VaultGearRarity {
    SCRAPPY(ChatFormatting.GRAY, 2, 2, 1, 1, 0, 1, 1, 1, 0),
    COMMON(ChatFormatting.AQUA, 3, 3, 2, 2, 1, 2, 2, 2, 0),
    RARE(ChatFormatting.YELLOW, 4, 4, 3, 3, 2, 3, 3, 3, 0),
    EPIC(ChatFormatting.LIGHT_PURPLE, 5, 5, 4, 4, 3, 4, 4, 4, 0),
    OMEGA(ChatFormatting.GREEN, 6, 6, 5, 5, 4, 5, 5, 5, 0),
    UNIQUE(TextColor.m_131266_((int)-1213660), 0, 0, 0, 0, 0, 0, 0, 0, 0),
    SPECIAL(TextColor.m_131266_((int)-749647), 0, 0, 0, 0, 0, 0, 0, 0, 0);

    private final TextColor color;
    private final int armorModifierCount;
    private final int weaponModifierCount;
    private final int idolModifierCount;
    private final int shieldModifierCount;
    private final int jewelModifierCount;
    private final int magnetModifierCount;
    private final int wandModifierCount;
    private final int focusModifierCount;
    private final int voidStoneModifierCount;

    private VaultGearRarity(ChatFormatting color, int armorModifierCount, int weaponModifierCount, int idolModifierCount, int shieldModifierCount, int jewelModifierCount, int magnetModifierCount, int wandModifierCount, int focusModifierCount, int voidStoneModifierCount) {
        this(TextColor.m_131270_((ChatFormatting)color), armorModifierCount, weaponModifierCount, idolModifierCount, shieldModifierCount, jewelModifierCount, magnetModifierCount, wandModifierCount, focusModifierCount, voidStoneModifierCount);
    }

    private VaultGearRarity(TextColor color, int armorModifierCount, int weaponModifierCount, int idolModifierCount, int shieldModifierCount, int jewelModifierCount, int magnetModifierCount, int wandModifierCount, int focusModifierCount, int voidStoneModifierCount) {
        this.color = color;
        this.armorModifierCount = armorModifierCount;
        this.weaponModifierCount = weaponModifierCount;
        this.idolModifierCount = idolModifierCount;
        this.shieldModifierCount = shieldModifierCount;
        this.jewelModifierCount = jewelModifierCount;
        this.magnetModifierCount = magnetModifierCount;
        this.wandModifierCount = wandModifierCount;
        this.focusModifierCount = focusModifierCount;
        this.voidStoneModifierCount = voidStoneModifierCount;
    }

    public TextColor getColor() {
        int rgb;
        try {
            if (ModConfigs.VAULT_GEAR_TYPE_CONFIG != null) {
                String rollType = StringUtils.capitalize((String)this.name().toLowerCase());
                rgb = ModConfigs.VAULT_GEAR_TYPE_CONFIG.getRollPool(rollType).map(pool -> pool.getColor()).orElse(this.color.m_131265_());
            } else {
                rgb = this.color.m_131265_();
            }
        }
        catch (Exception ignored) {
            rgb = this.color.m_131265_();
        }
        return TextColor.m_131266_((int)rgb);
    }

    private static int getAccessibleRarityColor(VaultGearRarity rarity, ColorBlindMode mode, int original) {
        return switch (mode) {
            case ColorBlindMode.DEUTERANOPIA -> {
                switch (rarity) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case SCRAPPY: {
                        yield original;
                    }
                    case COMMON: {
                        yield original;
                    }
                    case RARE: {
                        yield 16766720;
                    }
                    case EPIC: {
                        yield 0xFF66CC;
                    }
                    case OMEGA: {
                        yield original;
                    }
                    case UNIQUE: {
                        yield original;
                    }
                    case SPECIAL: 
                }
                yield original;
            }
            case ColorBlindMode.PROTANOPIA -> {
                switch (rarity) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case SCRAPPY: {
                        yield original;
                    }
                    case COMMON: {
                        yield original;
                    }
                    case RARE: {
                        yield original;
                    }
                    case EPIC: {
                        yield 0x9933FF;
                    }
                    case OMEGA: {
                        yield 52428;
                    }
                    case UNIQUE: {
                        yield original;
                    }
                    case SPECIAL: 
                }
                yield original;
            }
            case ColorBlindMode.TRITANOPIA -> {
                switch (rarity) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case SCRAPPY: {
                        yield original;
                    }
                    case COMMON: {
                        yield 0xFFCC00;
                    }
                    case RARE: {
                        yield original;
                    }
                    case EPIC: {
                        yield 0xCC3333;
                    }
                    case OMEGA: {
                        yield original;
                    }
                    case UNIQUE: {
                        yield original;
                    }
                    case SPECIAL: 
                }
                yield 0x663399;
            }
            default -> original;
        };
    }

    private static int applyColorBlindness(int rgb, ColorBlindMode mode) {
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        float nr = r;
        float ng = g;
        float nb = b;
        switch (mode) {
            case PROTANOPIA: {
                nr = 0.56667f * r + 0.43333f * g;
                ng = 0.55833f * r + 0.44167f * g;
                nb = b;
                break;
            }
            case DEUTERANOPIA: {
                nr = 0.625f * r + 0.375f * g;
                ng = 0.7f * r + 0.3f * g;
                nb = b;
                break;
            }
            case TRITANOPIA: {
                nr = r;
                ng = 0.95f * g + 0.05f * b;
                nb = 0.43333f * g + 0.56667f * b;
                break;
            }
        }
        return (int)(nr * 255.0f) << 16 | (int)(ng * 255.0f) << 8 | (int)(nb * 255.0f);
    }

    public int getArmorModifierCount() {
        return this.armorModifierCount;
    }

    public int getWeaponModifierCount() {
        return this.weaponModifierCount;
    }

    public int getIdolModifierCount() {
        return this.idolModifierCount;
    }

    public int getShieldModifierCount() {
        return this.shieldModifierCount;
    }

    public int getJewelModifierCount() {
        return this.jewelModifierCount;
    }

    public int getMagnetModifierCount() {
        return this.magnetModifierCount;
    }

    public int getWandModifierCount() {
        return this.wandModifierCount;
    }

    public int getFocusModifierCount() {
        return this.focusModifierCount;
    }

    public int getVoidStoneModifierCount() {
        return this.voidStoneModifierCount;
    }

    public Component getDisplayName() {
        Style style = Style.f_131099_.m_131148_(this.getColor());
        String name = StringUtils.capitalize((String)this.name().toLowerCase());
        return new TextComponent(name).m_130948_(style);
    }

    @Nullable
    public VaultGearRarity getNextTier() {
        if (this == OMEGA || this == UNIQUE || this == SPECIAL) {
            return null;
        }
        return VaultGearRarity.values()[this.ordinal() + 1];
    }
}

