/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear;

import iskallia.vault.init.ModItems;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;

public enum VaultGearType {
    SWORD(EquipmentSlot.MAINHAND, (Item)ModItems.SWORD),
    AXE(EquipmentSlot.MAINHAND, (Item)ModItems.AXE),
    HELMET(EquipmentSlot.HEAD, (Item)ModItems.HELMET),
    CHESTPLATE(EquipmentSlot.CHEST, (Item)ModItems.CHESTPLATE),
    LEGGINGS(EquipmentSlot.LEGS, (Item)ModItems.LEGGINGS),
    BOOTS(EquipmentSlot.FEET, (Item)ModItems.BOOTS),
    FOCUS(EquipmentSlot.OFFHAND, ModItems.FOCUS),
    WAND(EquipmentSlot.OFFHAND, ModItems.WAND),
    SHIELD(EquipmentSlot.OFFHAND, (Item)ModItems.SHIELD),
    IDOL(EquipmentSlot.OFFHAND),
    JEWEL(null, ModItems.JEWEL),
    MAGNET(null, ModItems.MAGNET),
    TOOL(EquipmentSlot.MAINHAND, (Item)ModItems.TOOL),
    VOID_STONE(null, ModItems.VOID_STONE),
    NECKLACE(null, ModItems.VAULT_NECKLACE),
    CHARM(null, ModItems.VAULT_GOD_CHARM),
    ETCHING(null, ModItems.ETCHING);

    @Nullable
    private final EquipmentSlot slot;
    @Nullable
    private final Item associatedItem;

    private VaultGearType(EquipmentSlot slot) {
        this.slot = slot;
        this.associatedItem = null;
    }

    private VaultGearType(EquipmentSlot slot, Item associatedItem) {
        this.slot = slot;
        this.associatedItem = associatedItem;
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot() {
        return this.slot;
    }

    public String getDisplayName() {
        return this.name().charAt(0) + this.name().substring(1).toLowerCase().replace("_", " ");
    }

    @Nullable
    public Item getAssociatedItem() {
        return this.associatedItem;
    }
}

