/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute;

import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class VaultGearAttribute<T>
extends ForgeRegistryEntry<VaultGearAttribute<?>> {
    private final VaultGearAttributeType<T> type;
    private final ConfigurableAttributeGenerator<T, ?> generator;
    private final VaultGearModifierReader<T> reader;
    private final VaultGearAttributeComparator<T> attributeComparator;
    private final BiFunction<VaultGearModifier<?>, Float, VaultGearModifier<?>> scalingFunction;

    public VaultGearAttribute(ResourceLocation name, VaultGearAttributeType<T> type, ConfigurableAttributeGenerator<T, ?> generator, VaultGearModifierReader<T> reader, @Nullable VaultGearAttributeComparator<T> attributeComparator, @Nullable BiFunction<VaultGearModifier<?>, Float, VaultGearModifier<?>> scalingFunction) {
        this.setRegistryName(name);
        this.generator = generator;
        this.reader = reader;
        this.type = type;
        this.attributeComparator = attributeComparator;
        this.scalingFunction = scalingFunction != null ? scalingFunction : this::defaultScaling;
    }

    public VaultGearAttribute(ResourceLocation name, VaultGearAttributeType<T> type, ConfigurableAttributeGenerator<T, ?> generator, VaultGearModifierReader<T> reader, @Nullable VaultGearAttributeComparator<T> attributeComparator) {
        this(name, type, generator, reader, attributeComparator, null);
    }

    public VaultGearAttribute(ResourceLocation name, VaultGearAttributeType<T> type, ConfigurableAttributeGenerator<T, ?> generator, VaultGearModifierReader<T> reader) {
        this(name, type, generator, reader, null);
    }

    private VaultGearModifier<?> defaultScaling(VaultGearModifier<?> value, Float scale) {
        Object t = value.getValue();
        if (t instanceof Number) {
            Number number = (Number)t;
            if (number instanceof Integer) {
                return new VaultGearModifier<Integer>(this, (int)((float)number.intValue() * scale.floatValue()));
            }
            if (number instanceof Float) {
                return new VaultGearModifier<Float>(this, Float.valueOf(number.floatValue() * scale.floatValue()));
            }
            if (number instanceof Double) {
                return new VaultGearModifier<Double>(this, number.doubleValue() * (double)scale.floatValue());
            }
        }
        return value;
    }

    public VaultGearAttributeType<T> getType() {
        return this.type;
    }

    public ConfigurableAttributeGenerator<T, ?> getGenerator() {
        return this.generator;
    }

    public VaultGearModifierReader<T> getReader() {
        return this.reader;
    }

    @Nullable
    public VaultGearAttributeComparator<T> getAttributeComparator() {
        return this.attributeComparator;
    }

    public Component getValueDisplay(T value) {
        return this.getReader().getValueDisplay(value);
    }

    public String toString() {
        return this.getRegistryName().toString();
    }

    public VaultGearModifier<?> scaleValue(VaultGearModifier<?> value, float scale) {
        return this.scalingFunction.apply(value, Float.valueOf(scale));
    }
}

