/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute;

import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.GearDataVersion;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;

public class VaultGearAttributeSerializer {
    private static final Map<Integer, AttributeInstanceSerializer<?>> TYPE_SERIALIZERS = new HashMap();
    public static final VaultGearAttributeInstance.Serializer INSTANCE_SERIALIZER = new VaultGearAttributeInstance.Serializer();
    public static final VaultGearModifier.Serializer MODIFIER_SERIALIZER = new VaultGearModifier.Serializer();
    private static final int DEFAULT_SERIALIZER_ID = 0;
    private static final AttributeInstanceSerializer<?> DEFAULT_SERIALIZER = INSTANCE_SERIALIZER;

    public static void register(int id, @Nonnull AttributeInstanceSerializer<?> serializer) {
        TYPE_SERIALIZERS.put(id, serializer);
    }

    @Nonnull
    private static <T extends VaultGearAttributeInstance<?>> Tuple<Integer, AttributeInstanceSerializer<T>> getSerializer(VaultGearAttributeInstance<?> instance) {
        for (Map.Entry<Integer, AttributeInstanceSerializer<?>> entry : TYPE_SERIALIZERS.entrySet()) {
            if (!entry.getValue().accepts(instance)) continue;
            AttributeInstanceSerializer<?> serializer = entry.getValue();
            return new Tuple((Object)entry.getKey(), serializer);
        }
        return new Tuple((Object)0, DEFAULT_SERIALIZER);
    }

    @Nonnull
    private static <T extends VaultGearAttributeInstance<?>> Tuple<Integer, AttributeInstanceSerializer<T>> getSerializer(int id) {
        AttributeInstanceSerializer<?> serializer = TYPE_SERIALIZERS.getOrDefault(id, DEFAULT_SERIALIZER);
        return new Tuple((Object)id, serializer);
    }

    @Nullable
    public static <T extends VaultGearAttributeInstance<?>> T deserializeTag(CompoundTag tag, GearDataVersion version) {
        if (!tag.m_128425_("type", 3)) {
            return null;
        }
        int type = tag.m_128451_("type");
        Tuple<Integer, AttributeInstanceSerializer<T>> serializer = VaultGearAttributeSerializer.getSerializer(type);
        return ((AttributeInstanceSerializer)serializer.m_14419_()).deserialize(tag, version);
    }

    public static <T extends VaultGearAttributeInstance<?>> CompoundTag serializeTag(T instance) {
        Tuple<Integer, AttributeInstanceSerializer<T>> serializer = VaultGearAttributeSerializer.getSerializer(instance);
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("type", ((Integer)serializer.m_14418_()).intValue());
        ((AttributeInstanceSerializer)serializer.m_14419_()).serialize(instance, tag);
        return tag;
    }

    @Nullable
    public static <T extends VaultGearAttributeInstance<?>> T deserialize(BitBuffer buf, GearDataVersion version) {
        int type = buf.readInt();
        Tuple<Integer, AttributeInstanceSerializer<T>> serializer = VaultGearAttributeSerializer.getSerializer(type);
        return ((AttributeInstanceSerializer)serializer.m_14419_()).deserialize(buf, version);
    }

    public static <T extends VaultGearAttributeInstance<?>> void serialize(T instance, BitBuffer buf) {
        Tuple<Integer, AttributeInstanceSerializer<T>> serializer = VaultGearAttributeSerializer.getSerializer(instance);
        buf.writeInt((Integer)serializer.m_14418_());
        ((AttributeInstanceSerializer)serializer.m_14419_()).serialize(instance, buf);
    }

    static {
        VaultGearAttributeSerializer.register(1, MODIFIER_SERIALIZER);
    }

    public static interface AttributeInstanceSerializer<T extends VaultGearAttributeInstance<?>> {
        public boolean accepts(VaultGearAttributeInstance<?> var1);

        @Nullable
        public T deserialize(CompoundTag var1, GearDataVersion var2);

        @Nullable
        public T deserialize(BitBuffer var1, GearDataVersion var2);

        public void serialize(T var1, CompoundTag var2);

        public void serialize(T var1, BitBuffer var2);

        @Nullable
        default public T deserializeInto(CompoundTag tag, GearDataVersion version, Function<VaultGearAttribute<?>, T> constructor) {
            ResourceLocation key = new ResourceLocation(tag.m_128461_("key"));
            VaultGearAttribute<?> attribute = VaultGearAttributeRegistry.getAttribute(key);
            if (attribute == null) {
                throw new IllegalArgumentException("Unknown attribute: " + String.valueOf(key));
            }
            VaultGearAttributeInstance instance = (VaultGearAttributeInstance)constructor.apply(attribute);
            instance.fromNbt(tag, version);
            if (!instance.isValid()) {
                return null;
            }
            return (T)instance;
        }

        @Nullable
        default public T deserializeInto(BitBuffer buf, GearDataVersion version, Function<VaultGearAttribute<?>, T> constructor) {
            ResourceLocation key = buf.readIdentifier();
            VaultGearAttribute<?> attribute = VaultGearAttributeRegistry.getAttribute(key);
            if (attribute == null) {
                throw new IllegalArgumentException("Unknown attribute: " + String.valueOf(key));
            }
            VaultGearAttributeInstance instance = (VaultGearAttributeInstance)constructor.apply(attribute);
            instance.read(buf, version);
            if (!instance.isValid()) {
                return null;
            }
            return (T)instance;
        }

        default public void serializeInto(T instance, CompoundTag tag) {
            tag.m_128359_("key", ((VaultGearAttributeInstance)instance).getAttribute().getRegistryName().toString());
            ((VaultGearAttributeInstance)instance).toNbt(tag);
        }

        default public void serializeInto(T instance, BitBuffer buf) {
            buf.writeIdentifier(((VaultGearAttributeInstance)instance).getAttribute().getRegistryName());
            ((VaultGearAttributeInstance)instance).write(buf);
        }
    }
}

