/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearAttributeSerializer;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.gear.data.GearDataVersion;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.tooltip.ModifierCategoryTooltip;
import iskallia.vault.util.MiscUtils;
import java.util.Comparator;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class VaultGearModifier<T>
extends VaultGearAttributeInstance<T> {
    private int rolledTier = -1;
    private String modifierGroup = "";
    private ResourceLocation modifierIdentifier = null;
    private long gameTimeAdded = Long.MIN_VALUE;
    private AffixCategorySet categories = new AffixCategorySet();

    VaultGearModifier(VaultGearAttribute<T> attribute) {
        super(attribute);
    }

    public VaultGearModifier(VaultGearAttribute<T> attribute, T value) {
        super(attribute, value);
    }

    public static <T> VaultGearModifier<T> cast(VaultGearAttribute<T> attr, Object value) {
        return new VaultGearModifier<T>(attr, attr.getType().cast(value));
    }

    public static <T> VaultGearModifier<T> cast(VaultGearModifier<?> inst) {
        return inst;
    }

    public void setRolledTier(int rolledTier) {
        this.rolledTier = rolledTier;
    }

    public int getRolledTier() {
        return this.rolledTier;
    }

    public boolean addCategory(AffixCategory category) {
        return this.categories.add(category);
    }

    public AffixCategorySet getCategories() {
        return this.categories;
    }

    public boolean removeCategory(AffixCategory category) {
        return this.categories.remove((Object)category);
    }

    public void clearCategories() {
        this.categories.clear();
    }

    public boolean hasCategory(AffixCategory category) {
        return this.categories.contains((Object)category);
    }

    public boolean hasAnyCategoryMatching(Predicate<AffixCategory> categoryCheck) {
        return this.categories.stream().anyMatch(categoryCheck);
    }

    public boolean hasNoCategoryMatching(Predicate<AffixCategory> categoryCheck) {
        return this.categories.stream().noneMatch(categoryCheck);
    }

    public void setModifierGroup(String modifierGroup) {
        this.modifierGroup = modifierGroup;
    }

    public String getModifierGroup() {
        return this.modifierGroup;
    }

    public void setModifierIdentifier(ResourceLocation modifierIdentifier) {
        this.modifierIdentifier = modifierIdentifier;
    }

    public ResourceLocation getModifierIdentifier() {
        return this.modifierIdentifier;
    }

    public void setGameTimeAdded(long gameTimeAdded) {
        this.gameTimeAdded = gameTimeAdded;
    }

    public long getGameTimeAdded() {
        return this.gameTimeAdded;
    }

    public boolean hasGameTimeAdded() {
        return this.getGameTimeAdded() != Long.MIN_VALUE;
    }

    public void resetGameTimeAdded() {
        this.setGameTimeAdded(Long.MIN_VALUE);
    }

    @Override
    public boolean canBeModified() {
        return this.hasNoCategoryMatching(cat -> !cat.canBeModified());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<MutableComponent> getDisplay(VaultGearData data, AffixType type, ItemStack stack, boolean displayDetail) {
        return super.getDisplay(data, type, stack, displayDetail).map(this::modifyDisplayComponentCategoryFormatters).map(this::modifyDisplayComponentRecentlyChanged).map(displayText -> {
            MutableComponent minMaxRangeCmp;
            if (!displayDetail) {
                return displayText;
            }
            Style txtStyle = Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(false)).m_131162_(Boolean.valueOf(false)).m_131136_(Boolean.valueOf(false));
            String categoryInfo = this.getCategories().stream().map(AffixCategory::getTooltipDescriptor).collect(Collectors.joining(" "));
            VaultGearTierConfig.ModifierConfigRange configRange = VaultGearTierConfig.getConfig(stack).map(tierCfg -> tierCfg.getTierConfigRange(this, data.getItemLevel())).orElse(VaultGearTierConfig.ModifierConfigRange.empty());
            ConfigurableAttributeGenerator attributeGenerator = this.getAttribute().getGenerator();
            TextComponent cmpRangeDescriptor = new TextComponent(categoryInfo);
            if (configRange.minAvailableConfig() != null && configRange.maxAvailableConfig() != null && (minMaxRangeCmp = attributeGenerator.getConfigRangeDisplay(this.getAttribute().getReader(), configRange.minAvailableConfig(), configRange.maxAvailableConfig())) != null) {
                if (!cmpRangeDescriptor.getString().isBlank()) {
                    cmpRangeDescriptor.m_130946_(" ");
                }
                cmpRangeDescriptor.m_7220_((Component)minMaxRangeCmp);
                if (Screen.m_96639_()) {
                    cmpRangeDescriptor.m_130946_(",");
                }
            }
            if (Screen.m_96639_()) {
                if (!cmpRangeDescriptor.getString().isBlank()) {
                    cmpRangeDescriptor.m_130946_(" ");
                }
                if (configRange.tierConfig() != null) {
                    MutableComponent rangeCmp = attributeGenerator.getConfigRangeDisplay(this.getAttribute().getReader(), configRange.tierConfig());
                    if (rangeCmp != null) {
                        cmpRangeDescriptor.m_130946_("T%s: ".formatted(this.getRolledTier() + 1));
                        cmpRangeDescriptor.m_7220_((Component)rangeCmp);
                    }
                } else {
                    cmpRangeDescriptor.m_130946_("T%s".formatted(this.getRolledTier() + 1));
                }
            }
            if (!cmpRangeDescriptor.getString().isBlank()) {
                displayText.m_7220_((Component)new TextComponent(" ").m_130948_(txtStyle).m_130946_("(").m_7220_((Component)cmpRangeDescriptor).m_130946_(")"));
            }
            return displayText;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent modifyDisplayComponentCategoryFormatters(MutableComponent displayText) {
        for (AffixCategory cat : this.categories) {
            displayText = cat.getModifierFormatter().apply(displayText);
        }
        return displayText;
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent modifyDisplayComponentRecentlyChanged(MutableComponent displayText) {
        if (!this.hasGameTimeAdded()) {
            return displayText;
        }
        int showDuration = 600;
        long added = this.getGameTimeAdded();
        ClientLevel currentWorld = Minecraft.m_91087_().f_91073_;
        if (currentWorld == null || currentWorld.m_46467_() - added > (long)showDuration) {
            return displayText;
        }
        displayText.m_7220_((Component)new TextComponent(" [new]").m_130940_(ChatFormatting.GOLD));
        return displayText;
    }

    public Optional<MutableComponent> getConfigDisplay(ItemStack stack) {
        return VaultGearTierConfig.getConfig(stack).map(tierCfg -> tierCfg.getTierConfig(this)).map(cfg -> {
            ConfigurableAttributeGenerator configGen = this.getAttribute().getGenerator();
            return configGen.getConfigDisplay(this.getAttribute().getReader(), cfg);
        });
    }

    @Nullable
    public ComparableModifier<T> getComparable() {
        VaultGearAttributeComparator attributeComparator = this.getAttribute().getAttributeComparator();
        if (attributeComparator == null) {
            return null;
        }
        return new ComparableModifier(this, attributeComparator.getComparator());
    }

    @Override
    public void write(BitBuffer buf) {
        super.write(buf);
        buf.writeInt(this.rolledTier);
        this.categories.write(buf);
        buf.writeString(this.modifierGroup);
        buf.writeNullable(this.modifierIdentifier, BitBuffer::writeIdentifier);
        buf.writeLong(this.gameTimeAdded);
    }

    @Override
    public void read(BitBuffer buf, GearDataVersion version) {
        super.read(buf, version);
        this.rolledTier = buf.readInt();
        this.categories = AffixCategorySet.read(buf, version);
        this.modifierGroup = buf.readString();
        this.modifierIdentifier = buf.readNullable(BitBuffer::readIdentifier);
        this.gameTimeAdded = buf.readLong();
    }

    @Override
    public void toNbt(CompoundTag tag) {
        super.toNbt(tag);
        tag.m_128405_("rolledTier", this.rolledTier);
        this.categories.writeNbt(tag);
        tag.m_128359_("modifierGroup", this.modifierGroup);
        if (this.modifierIdentifier != null) {
            tag.m_128359_("modifierIdentifier", this.modifierIdentifier.toString());
        }
        tag.m_128356_("gameTimeAdded", this.gameTimeAdded);
    }

    @Override
    protected void fromNbt(CompoundTag tag, GearDataVersion version) {
        super.fromNbt(tag, version);
        this.rolledTier = tag.m_128451_("rolledTier");
        this.categories = AffixCategorySet.readNbt(tag, version);
        this.modifierGroup = tag.m_128461_("modifierGroup");
        if (tag.m_128425_("modifierIdentifier", 8)) {
            this.modifierIdentifier = new ResourceLocation(tag.m_128461_("modifierIdentifier"));
        }
        this.gameTimeAdded = tag.m_128454_("gameTimeAdded");
    }

    @Override
    public JsonObject serialize(AffixType type) {
        JsonObject obj = super.serialize(type);
        obj.addProperty("legendary", Boolean.valueOf(this.categories.contains((Object)AffixCategory.LEGENDARY)));
        obj.addProperty("category", this.categories.isEmpty() ? AffixCategory.NONE.name() : ((AffixCategory)((Object)this.categories.first())).name());
        JsonArray categories = new JsonArray();
        this.categories.forEach(cat -> categories.add(cat.name()));
        obj.add("categories", (JsonElement)categories);
        return obj;
    }

    public static class AffixCategorySet
    extends TreeSet<AffixCategory> {
        public void write(BitBuffer buf) {
            buf.writeInt(this.size());
            this.forEach(cat -> buf.writeInt(cat.ordinal()));
        }

        public static AffixCategorySet read(BitBuffer buf, GearDataVersion version) {
            AffixCategorySet set = new AffixCategorySet();
            if (GearDataVersion.V0_3.isLaterThan(version)) {
                if (buf.readBoolean()) {
                    set.add(AffixCategory.LEGENDARY);
                }
            } else if (GearDataVersion.V0_5.isLaterThan(version)) {
                AffixCategory cat = MiscUtils.getEnumEntry(AffixCategory.class, buf.readInt());
                set.add(cat);
            } else {
                int size = buf.readInt();
                for (int i = 0; i < size; ++i) {
                    set.add(MiscUtils.getEnumEntry(AffixCategory.class, buf.readInt()));
                }
            }
            return set;
        }

        public void writeNbt(CompoundTag tag) {
            ListTag list = new ListTag();
            this.forEach(cat -> list.add((Object)IntTag.m_128679_((int)cat.ordinal())));
            tag.m_128365_("categories", (Tag)list);
        }

        public static AffixCategorySet readNbt(CompoundTag tag, GearDataVersion version) {
            AffixCategorySet set = new AffixCategorySet();
            if (tag.m_128425_("legendary", 1)) {
                if (tag.m_128471_("legendary")) {
                    set.add(AffixCategory.LEGENDARY);
                }
            } else if (tag.m_128425_("category", 3)) {
                AffixCategory cat = MiscUtils.getEnumEntry(AffixCategory.class, tag.m_128451_("category"));
                set.add(cat);
            } else {
                ListTag list = tag.m_128437_("categories", 3);
                for (int i = 0; i < list.size(); ++i) {
                    set.add(MiscUtils.getEnumEntry(AffixCategory.class, list.m_128763_(i)));
                }
            }
            return set;
        }
    }

    public static enum AffixType {
        IMPLICIT("Implicits", "Implicit", isPositive -> ""),
        PREFIX("Prefixes", "Prefix", isPositive -> isPositive != false ? "+" : ""),
        SUFFIX("Suffixes", "Suffix", isPositive -> isPositive != false ? "+" : "");

        private static final AffixType[] EXPLICITS;
        private final String plural;
        private final String singular;
        private final Function<Boolean, String> affixPrefix;

        private AffixType(String plural, String singular, Function<Boolean, String> affixPrefix) {
            this.plural = plural;
            this.singular = singular;
            this.affixPrefix = affixPrefix;
        }

        public String getPlural() {
            return this.plural;
        }

        public String getSingular() {
            return this.singular;
        }

        public String getAffixPrefix(boolean isPositive) {
            return this.affixPrefix.apply(isPositive);
        }

        public MutableComponent getAffixPrefixComponent(boolean isPositive) {
            return new TextComponent(this.getAffixPrefix(isPositive));
        }

        public static AffixType[] explicits() {
            return EXPLICITS;
        }

        static {
            EXPLICITS = new AffixType[]{PREFIX, SUFFIX};
        }
    }

    public static enum AffixCategory {
        NONE,
        LEGENDARY("Legendary", ModifierCategoryTooltip::modifyLegendaryTooltip, VaultMod.id("textures/item/gear/legendary_overlay.png")),
        ABYSSAL("Abyssal", ModifierCategoryTooltip::modifyAbyssalTooltip),
        ABILITY_ENHANCEMENT("Enhancement", ModifierCategoryTooltip::modifyEnhancementTooltip),
        CRAFTED("Crafted", ModifierCategoryTooltip::modifyCraftedTooltip),
        FROZEN("Frozen", ModifierCategoryTooltip::modifyFrozenTooltip),
        CORRUPTED("Corrupted", ModifierCategoryTooltip::modifyCorruptedTooltip, VaultMod.id("textures/item/gear/corrupted_overlay.png")),
        GREATER("Greater", ModifierCategoryTooltip::modifyGreaterTooltip, VaultMod.id("textures/item/gear/greater_overlay.png"));

        private final String descriptor;
        private final Function<MutableComponent, MutableComponent> modifierFormatter;
        @Nullable
        private final ResourceLocation overlayIcon;

        private AffixCategory() {
            this("");
        }

        private AffixCategory(String descriptor) {
            this(descriptor, Function.identity());
        }

        private AffixCategory(String descriptor, Function<MutableComponent, MutableComponent> modifierFormatter) {
            this(descriptor, modifierFormatter, null);
        }

        private AffixCategory(@Nullable String descriptor, Function<MutableComponent, MutableComponent> modifierFormatter, ResourceLocation overlayIcon) {
            this.descriptor = descriptor;
            this.modifierFormatter = modifierFormatter;
            this.overlayIcon = overlayIcon;
        }

        @Nonnull
        public String getTooltipDescriptor() {
            return this.descriptor;
        }

        public Function<MutableComponent, MutableComponent> getModifierFormatter() {
            return this.modifierFormatter;
        }

        public boolean cannotBeModifiedByArtisanFoci() {
            return this == ABYSSAL || this == ABILITY_ENHANCEMENT || !this.canBeModified();
        }

        public boolean canBeModified() {
            return this != FROZEN;
        }

        public boolean cannotBeRolledByArtisanFoci() {
            return this == CRAFTED;
        }

        public boolean onlyDisplayCurrentTierInformation() {
            return this == LEGENDARY || this == CORRUPTED || this == GREATER;
        }

        @Nullable
        public ResourceLocation getOverlayIcon() {
            return this.overlayIcon;
        }
    }

    public static class ComparableModifier<T>
    implements Comparable<ComparableModifier<T>> {
        private final VaultGearModifier<T> modifier;
        private final Comparator<T> comparator;

        public ComparableModifier(VaultGearModifier<T> modifier, Comparator<T> comparator) {
            this.modifier = modifier;
            this.comparator = comparator;
        }

        public VaultGearModifier<T> getModifier() {
            return this.modifier;
        }

        @Override
        public int compareTo(@Nonnull ComparableModifier<T> o) {
            return this.comparator.compare(this.modifier.getValue(), o.modifier.getValue());
        }
    }

    public static class Serializer
    implements VaultGearAttributeSerializer.AttributeInstanceSerializer<VaultGearModifier<?>> {
        @Override
        public boolean accepts(VaultGearAttributeInstance<?> instance) {
            return instance instanceof VaultGearModifier;
        }

        @Override
        @Nullable
        public VaultGearModifier<?> deserialize(CompoundTag tag, GearDataVersion version) {
            return this.deserializeInto(tag, version, VaultGearModifier::new);
        }

        @Override
        @Nullable
        public VaultGearModifier<?> deserialize(BitBuffer buf, GearDataVersion version) {
            return this.deserializeInto(buf, version, VaultGearModifier::new);
        }

        @Override
        public void serialize(VaultGearModifier<?> instance, CompoundTag tag) {
            this.serializeInto(instance, tag);
        }

        @Override
        public void serialize(VaultGearModifier<?> instance, BitBuffer buf) {
            this.serializeInto(instance, buf);
        }
    }
}

