/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.ability;

import com.google.gson.JsonArray;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.ability.AbilityFloatValueAttribute;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.init.ModConfigs;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public class AbilityAreaOfEffectFlatAttribute
extends AbilityFloatValueAttribute {
    public AbilityAreaOfEffectFlatAttribute(String abilityKey, float amount) {
        super(abilityKey, amount);
    }

    public float adjustAreaOfEffect(@Nullable String ability, float area) {
        if (this.affectsAbility(ability)) {
            return area + this.getAmount();
        }
        return area;
    }

    public String toString() {
        return "AbilityAreaOfEffectFlatAttribute{abilityKey='" + this.abilityKey + "', amount=" + this.amount + "}";
    }

    public static VaultGearAttributeType<AbilityAreaOfEffectFlatAttribute> type() {
        return AbilityFloatValueAttribute.type(AbilityAreaOfEffectFlatAttribute::new);
    }

    public static AbilityFloatValueAttribute.Generator<AbilityAreaOfEffectFlatAttribute, AbilityFloatValueAttribute.Config> generator() {
        return AbilityFloatValueAttribute.generator(AbilityAreaOfEffectFlatAttribute::new, AbilityFloatValueAttribute.Config.class);
    }

    public static Reader reader() {
        return new Reader();
    }

    private static class Reader
    extends AbilityFloatValueAttribute.Reader<AbilityAreaOfEffectFlatAttribute> {
        private Reader() {
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<AbilityAreaOfEffectFlatAttribute> instance, VaultGearModifier.AffixType type) {
            AbilityAreaOfEffectFlatAttribute attribute = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(attribute);
            if (valueDisplay == null) {
                return null;
            }
            MutableComponent areaCmp = new TextComponent("Area Of Effect").m_130948_(Style.f_131099_.m_131148_(ModConfigs.COLORS.getColor("areaOfEffect")));
            return new TextComponent("").m_7220_((Component)type.getAffixPrefixComponent(attribute.getAmount() >= 0.0f).m_130948_(this.getValueStyle())).m_7220_((Component)valueDisplay.m_130948_(this.getValueStyle())).m_130946_(" Blocks ").m_130948_(this.getValueStyle()).m_130946_(" of ").m_7220_((Component)areaCmp).m_130946_(" of ").m_7220_((Component)this.formatAbilityName(attribute.getAbilityKey())).m_6270_(this.getColoredTextStyle());
        }

        @Override
        @Nullable
        public MutableComponent getValueDisplay(AbilityAreaOfEffectFlatAttribute value) {
            return new TextComponent(this.formatValue(value.getAmount()));
        }

        @Override
        protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<AbilityAreaOfEffectFlatAttribute> instance, VaultGearModifier.AffixType type) {
            AbilityAreaOfEffectFlatAttribute attribute = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(attribute);
            if (valueDisplay == null) {
                return;
            }
            out.add(type.getAffixPrefix(attribute.getAmount() >= 0.0f));
            out.add(valueDisplay.getString());
            out.add(" Blocks of Area of Effect of ");
            out.add(this.formatAbilityName(attribute.getAbilityKey()).getString());
        }
    }
}

