/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.ability;

import com.google.gson.Gson;
import com.google.gson.annotations.Expose;
import iskallia.vault.gear.attribute.ability.AbilityGearAttribute;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.NetcodeUtils;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public abstract class AbilityFloatValueAttribute
extends AbilityGearAttribute {
    protected final float amount;

    public AbilityFloatValueAttribute(String abilityKey, float amount) {
        super(abilityKey);
        this.amount = amount;
    }

    public float getAmount() {
        return this.amount;
    }

    public static <T extends AbilityFloatValueAttribute> VaultGearAttributeType<T> type(BiFunction<String, Float, T> ctor) {
        return VaultGearAttributeType.of((buf, attribute) -> {
            buf.writeString(attribute.getAbilityKey());
            buf.writeFloat(attribute.getAmount());
        }, buf -> (AbilityFloatValueAttribute)ctor.apply(buf.readString(), Float.valueOf(buf.readFloat())), (buf, attribute) -> {
            NetcodeUtils.writeString(buf, attribute.getAbilityKey());
            buf.writeFloat(attribute.getAmount());
        }, buf -> {
            String abilityKey = NetcodeUtils.readString(buf);
            float amount = buf.readFloat();
            return (AbilityFloatValueAttribute)ctor.apply(abilityKey, Float.valueOf(amount));
        }, arg_0 -> ((Gson)VaultGearAttributeType.GSON).toJsonTree(arg_0), AbilityFloatValueAttribute.read(ctor), AbilityFloatValueAttribute.write());
    }

    private static <T extends AbilityFloatValueAttribute> Function<Tag, T> read(BiFunction<String, Float, T> ctor) {
        return nbt -> {
            CompoundTag tag = (CompoundTag)nbt;
            String ability = tag.m_128461_("ability");
            float amount = tag.m_128457_("amount");
            return (AbilityFloatValueAttribute)ctor.apply(ability, Float.valueOf(amount));
        };
    }

    private static <T extends AbilityFloatValueAttribute> Function<T, Tag> write() {
        return attribute -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("ability", attribute.getAbilityKey());
            tag.m_128350_("amount", attribute.getAmount());
            return tag;
        };
    }

    public static <T extends AbilityFloatValueAttribute, C extends Config> Generator<T, C> generator(BiFunction<String, Float, T> ctor, Class<C> configClass) {
        return new Generator<T, C>(ctor, configClass);
    }

    public static class Generator<T extends AbilityFloatValueAttribute, C extends Config>
    extends ConfigurableAttributeGenerator<T, C> {
        private final Function<ConfigRoll, T> valueConverter;
        private final Class<C> configClass;

        protected Generator(BiFunction<String, Float, T> valueConverter, Class<C> configClass) {
            this((ConfigRoll cfg) -> (AbilityFloatValueAttribute)valueConverter.apply(cfg.cfg().getAbilityKey(), cfg.value()), configClass);
        }

        protected Generator(Function<ConfigRoll, T> valueConverter, Class<C> configClass) {
            this.valueConverter = valueConverter;
            this.configClass = configClass;
        }

        @Override
        @Nullable
        public Class<C> getConfigurationObjectClass() {
            return this.configClass;
        }

        @Override
        public T generateRandomValue(C object, Random random) {
            return (T)((AbilityFloatValueAttribute)this.valueConverter.apply(new ConfigRoll((Config)object, Float.valueOf(((Config)object).generateValue(random)))));
        }

        @Override
        public Optional<T> getMinimumValue(List<C> configurations) {
            return configurations.stream().map(cfg -> new ConfigRoll((Config)cfg, Float.valueOf(cfg.getMin()))).min(Comparator.comparing(ConfigRoll::value)).map(this.valueConverter);
        }

        @Override
        public Optional<T> getMaximumValue(List<C> configurations) {
            return configurations.stream().map(cfg -> new ConfigRoll((Config)cfg, Float.valueOf(cfg.generateMaximumValue()))).min(Comparator.comparing(ConfigRoll::value)).map(this.valueConverter);
        }

        @Override
        public Optional<Float> getRollPercentage(T value, List<C> configurations) {
            return MiscUtils.getFloatValueRange(((AbilityFloatValueAttribute)value).getAmount(), this.getMinimumValue(configurations), this.getMaximumValue(configurations), AbilityFloatValueAttribute::getAmount);
        }

        @Override
        @Nullable
        public MutableComponent getConfigRangeDisplay(VaultGearModifierReader<T> reader, C min, C max) {
            MutableComponent minDisplay = reader.getValueDisplay((AbilityFloatValueAttribute)this.valueConverter.apply(new ConfigRoll((Config)min, Float.valueOf(((Config)min).getMin()))));
            MutableComponent maxDisplay = reader.getValueDisplay((AbilityFloatValueAttribute)this.valueConverter.apply(new ConfigRoll((Config)min, Float.valueOf(((Config)min).generateMaximumValue()))));
            if (minDisplay == null || maxDisplay == null) {
                return new TextComponent("");
            }
            return minDisplay.m_130946_("-").m_7220_((Component)maxDisplay);
        }
    }

    public static class Config
    extends AbilityGearAttribute.AbilityAttributeConfig {
        @Expose
        private float min;
        @Expose
        private float max;
        @Expose
        private float step;

        public Config(String abilityKey, float min, float max, float step) {
            super(abilityKey);
            this.min = min;
            this.max = max;
            this.step = step;
        }

        public float getMin() {
            return this.min;
        }

        public float generateValue(Random rand) {
            int steps = Math.round(Math.max(this.max - this.min, 0.0f) / this.step) + 1;
            return this.min + (float)rand.nextInt(steps) * this.step;
        }

        public float generateMaximumValue() {
            int steps = Math.round(Math.max(this.max - this.min, 0.0f) / this.step);
            return this.min + (float)steps * this.step;
        }
    }

    protected record ConfigRoll(Config cfg, Float value) {
    }

    public static abstract class Reader<T extends AbilityFloatValueAttribute>
    extends VaultGearModifierReader<T> {
        private static final DecimalFormat FORMAT = new DecimalFormat("0.#");

        protected Reader() {
            this(0xB4B4B4);
        }

        protected Reader(int rgbColor) {
            super("", rgbColor);
        }

        protected Style getAbilityStyle() {
            return Style.f_131099_.m_178520_(14076214);
        }

        protected Style getValueStyle() {
            return Style.f_131099_.m_178520_(6082075);
        }

        protected String formatValue(float value) {
            return FORMAT.format(value);
        }

        protected MutableComponent formatAbilityName(String abilityKey) {
            return ModConfigs.ABILITIES.getAbilityById(abilityKey).filter(skill -> skill.getName() != null).map(skill -> {
                String name = skill.getName();
                if (skill.getParent() instanceof AbilityTree) {
                    name = String.format("all %s skills", name);
                }
                return new TextComponent(name).m_130948_(this.getAbilityStyle());
            }).orElseGet(() -> new TextComponent(abilityKey).m_130948_(this.getAbilityStyle()));
        }
    }
}

