/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.ability;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.annotations.Expose;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.NetcodeUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.NotNull;

public class AbilityLevelAttribute {
    public static final String ALL_ABILITIES = "all_abilities";
    protected final String ability;
    protected final int levelChange;

    public AbilityLevelAttribute(String ability, int levelChange) {
        this.ability = ability;
        this.levelChange = levelChange;
    }

    public String getAbility() {
        return this.ability;
    }

    public int getLevelChange() {
        return this.levelChange;
    }

    public static VaultGearAttributeType<AbilityLevelAttribute> type() {
        return VaultGearAttributeType.of((buf, attribute) -> {
            buf.writeString(attribute.getAbility());
            buf.writeInt(attribute.getLevelChange());
        }, buf -> new AbilityLevelAttribute(buf.readString(), buf.readInt()), (buf, attribute) -> {
            NetcodeUtils.writeString(buf, attribute.getAbility());
            buf.writeInt(attribute.getLevelChange());
        }, buf -> {
            String ability = NetcodeUtils.readString(buf);
            int levelChange = buf.readInt();
            return new AbilityLevelAttribute(ability, levelChange);
        }, arg_0 -> ((Gson)VaultGearAttributeType.GSON).toJsonTree(arg_0), nbt -> {
            CompoundTag tag = (CompoundTag)nbt;
            String ability = tag.m_128461_("ability");
            int levelChange = tag.m_128451_("levelChange");
            return new AbilityLevelAttribute(ability, levelChange);
        }, attribute -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("ability", attribute.getAbility());
            tag.m_128405_("levelChange", attribute.getLevelChange());
            return tag;
        });
    }

    public static ConfigurableAttributeGenerator<AbilityLevelAttribute, Config> generator() {
        return new ConfigurableAttributeGenerator<AbilityLevelAttribute, Config>(){

            @Override
            public Class<Config> getConfigurationObjectClass() {
                return Config.class;
            }

            @Override
            public MutableComponent getConfigRangeDisplay(VaultGearModifierReader<AbilityLevelAttribute> reader, Config min, Config max) {
                return new TextComponent("%s-%s".formatted(min.getLevelChange(), max.getLevelChange()));
            }

            @Override
            public AbilityLevelAttribute generateRandomValue(Config object, Random random) {
                return new AbilityLevelAttribute(object.getAbilityKey(), object.getLevelChange());
            }

            @Override
            public Optional<AbilityLevelAttribute> getMinimumValue(List<Config> configurations) {
                return configurations.stream().min(Comparator.comparingInt(Config::getLevelChange)).map(config -> new AbilityLevelAttribute(config.getAbilityKey(), config.getLevelChange()));
            }

            @Override
            public Optional<AbilityLevelAttribute> getMaximumValue(List<Config> configurations) {
                return configurations.stream().max(Comparator.comparingInt(Config::getLevelChange)).map(config -> new AbilityLevelAttribute(config.getAbilityKey(), config.getLevelChange()));
            }

            @Override
            public Optional<Float> getRollPercentage(AbilityLevelAttribute value, List<Config> configurations) {
                return MiscUtils.getIntValueRange(value.getLevelChange(), this.getMinimumValue(configurations), this.getMaximumValue(configurations), AbilityLevelAttribute::getLevelChange);
            }
        };
    }

    public static VaultGearModifierReader<AbilityLevelAttribute> reader() {
        return new VaultGearModifierReader<AbilityLevelAttribute>("", 15638784){

            @Override
            @Nullable
            public MutableComponent getDisplay(VaultGearAttributeInstance<AbilityLevelAttribute> instance, VaultGearModifier.AffixType type) {
                AbilityLevelAttribute attribute = instance.getValue();
                MutableComponent valueDisplay = this.getValueDisplay(attribute);
                if (attribute.getAbility().equals(AbilityLevelAttribute.ALL_ABILITIES)) {
                    return new TextComponent("").m_7220_((Component)type.getAffixPrefixComponent(attribute.getLevelChange() >= 0).m_130948_(this.getColoredTextStyle())).m_7220_((Component)valueDisplay.m_130948_(this.getColoredTextStyle())).m_130946_(" to level of ").m_7220_((Component)new TextComponent("all Abilities").m_130948_(this.getAbilityStyle())).m_130948_(this.getColoredTextStyle());
                }
                Skill ability = ModConfigs.ABILITIES.getAbilityById(attribute.getAbility()).orElse(null);
                if (ability == null) {
                    return null;
                }
                return new TextComponent("").m_7220_((Component)type.getAffixPrefixComponent(attribute.getLevelChange() >= 0).m_130948_(this.getColoredTextStyle())).m_7220_((Component)valueDisplay.m_130948_(this.getColoredTextStyle())).m_130946_(" to level of ").m_7220_((Component)new TextComponent(ability.getName()).m_130948_(this.getAbilityStyle())).m_130948_(this.getColoredTextStyle());
            }

            private Style getAbilityStyle() {
                return Style.f_131099_.m_178520_(14076214);
            }

            @Override
            public MutableComponent getValueDisplay(AbilityLevelAttribute value) {
                return new TextComponent(String.valueOf(value.getLevelChange()));
            }

            @Override
            protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<AbilityLevelAttribute> instance, VaultGearModifier.AffixType type) {
                AbilityLevelAttribute attribute = instance.getValue();
                MutableComponent valueDisplay = this.getValueDisplay(attribute);
                if (attribute.getAbility().equals(AbilityLevelAttribute.ALL_ABILITIES)) {
                    out.add(type.getAffixPrefix(attribute.getLevelChange() >= 0));
                    out.add(valueDisplay.getString());
                    out.add(" to level of all Abilities");
                    return;
                }
                Skill ability = ModConfigs.ABILITIES.getAbilityById(attribute.getAbility()).orElse(null);
                if (ability == null) {
                    return;
                }
                out.add(type.getAffixPrefix(attribute.getLevelChange() >= 0));
                out.add(valueDisplay.getString());
                out.add(" to level of ");
                out.add(ability.getName());
            }
        };
    }

    public static VaultGearAttributeComparator<AbilityLevelAttribute> comparator() {
        return new VaultGearAttributeComparator<AbilityLevelAttribute>(){

            @Override
            public Optional<AbilityLevelAttribute> merge(AbilityLevelAttribute thisValue, AbilityLevelAttribute thatValue) {
                if (!thisValue.getAbility().equals(thatValue.getAbility())) {
                    return Optional.empty();
                }
                return Optional.of(new AbilityLevelAttribute(thisValue.getAbility(), thisValue.getLevelChange() + thatValue.getLevelChange()));
            }

            @Override
            public Optional<AbilityLevelAttribute> difference(AbilityLevelAttribute thisValue, AbilityLevelAttribute thatValue) {
                return Optional.empty();
            }

            @Override
            @NotNull
            public Comparator<AbilityLevelAttribute> getComparator() {
                return Comparator.comparing(AbilityLevelAttribute::getLevelChange);
            }
        };
    }

    public static class Config {
        @Expose
        private String abilityKey;
        @Expose
        private int levelChange;

        public Config(String abilityKey, int levelChange) {
            this.abilityKey = abilityKey;
            this.levelChange = levelChange;
        }

        public String getAbilityKey() {
            return this.abilityKey;
        }

        public int getLevelChange() {
            return this.levelChange;
        }
    }
}

