/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.ability;

import com.google.gson.JsonArray;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.ability.AbilityFloatValueAttribute;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.init.ModConfigs;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public class AbilityManaCostFlatAttribute
extends AbilityFloatValueAttribute {
    public AbilityManaCostFlatAttribute(String abilityKey, float amount) {
        super(abilityKey, amount);
    }

    public float adjustManaCost(@Nullable String ability, float manaCost) {
        if (this.affectsAbility(ability)) {
            return manaCost + this.getAmount();
        }
        return manaCost;
    }

    public String toString() {
        return "AbilityManaCostFlatAttribute{abilityKey='" + this.abilityKey + "', amount=" + this.amount + "}";
    }

    public static VaultGearAttributeType<AbilityManaCostFlatAttribute> type() {
        return AbilityFloatValueAttribute.type(AbilityManaCostFlatAttribute::new);
    }

    public static AbilityFloatValueAttribute.Generator<AbilityManaCostFlatAttribute, AbilityFloatValueAttribute.Config> generator() {
        return AbilityFloatValueAttribute.generator(AbilityManaCostFlatAttribute::new, AbilityFloatValueAttribute.Config.class);
    }

    public static Reader reader() {
        return new Reader();
    }

    private static class Reader
    extends AbilityFloatValueAttribute.Reader<AbilityManaCostFlatAttribute> {
        private Reader() {
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<AbilityManaCostFlatAttribute> instance, VaultGearModifier.AffixType type) {
            AbilityManaCostFlatAttribute attribute = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(attribute);
            if (valueDisplay == null) {
                return null;
            }
            MutableComponent manaCostCmp = new TextComponent("Mana Cost").m_130948_(Style.f_131099_.m_131148_(ModConfigs.COLORS.getColor("manaCost")));
            return new TextComponent("").m_7220_((Component)type.getAffixPrefixComponent(attribute.getAmount() >= 0.0f).m_130948_(this.getValueStyle())).m_7220_((Component)valueDisplay.m_130948_(this.getValueStyle())).m_130946_(" to ").m_7220_((Component)manaCostCmp).m_130946_(" of ").m_7220_((Component)this.formatAbilityName(attribute.getAbilityKey())).m_6270_(this.getColoredTextStyle());
        }

        @Override
        @Nullable
        public MutableComponent getValueDisplay(AbilityManaCostFlatAttribute value) {
            return new TextComponent(this.formatValue(value.getAmount()));
        }

        @Override
        protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<AbilityManaCostFlatAttribute> instance, VaultGearModifier.AffixType type) {
            AbilityManaCostFlatAttribute attribute = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(attribute);
            if (valueDisplay == null) {
                return;
            }
            out.add(type.getAffixPrefix(attribute.getAmount() >= 0.0f));
            out.add(valueDisplay.getString());
            out.add(" to Mana Cost of ");
            out.add(this.formatAbilityName(attribute.getAbilityKey()).getString());
        }
    }
}

