/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.ability;

import com.google.gson.JsonArray;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.ability.AbilityFloatValueAttribute;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.init.ModConfigs;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public class AbilityManaCostPercentAttribute
extends AbilityFloatValueAttribute {
    public AbilityManaCostPercentAttribute(String abilityKey, float amount) {
        super(abilityKey, amount);
    }

    public float adjustManaCost(@Nullable String ability, float manaCost) {
        if (this.affectsAbility(ability)) {
            return manaCost * Math.max(1.0f + this.getAmount(), 0.0f);
        }
        return manaCost;
    }

    public String toString() {
        return "AbilityManaCostPercentAttribute{abilityKey='" + this.abilityKey + "', amount=" + this.amount + "}";
    }

    public static VaultGearAttributeType<AbilityManaCostPercentAttribute> type() {
        return AbilityFloatValueAttribute.type(AbilityManaCostPercentAttribute::new);
    }

    public static AbilityFloatValueAttribute.Generator<AbilityManaCostPercentAttribute, AbilityFloatValueAttribute.Config> generator() {
        return AbilityFloatValueAttribute.generator(AbilityManaCostPercentAttribute::new, AbilityFloatValueAttribute.Config.class);
    }

    public static Reader reader() {
        return new Reader();
    }

    private static class Reader
    extends AbilityFloatValueAttribute.Reader<AbilityManaCostPercentAttribute> {
        private Reader() {
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<AbilityManaCostPercentAttribute> instance, VaultGearModifier.AffixType type) {
            AbilityManaCostPercentAttribute attribute = instance.getValue();
            TextComponent valueDisplay = this.getValueComponent(Math.abs(attribute.getAmount()));
            boolean positive = attribute.getAmount() >= 0.0f;
            MutableComponent manaCostCmp = new TextComponent("Mana Cost").m_130948_(Style.f_131099_.m_131148_(ModConfigs.COLORS.getColor("manaCost")));
            String cdInfo = positive ? " more " : " less ";
            return new TextComponent("").m_7220_((Component)type.getAffixPrefixComponent(true).m_130948_(this.getValueStyle())).m_7220_((Component)valueDisplay.m_130948_(this.getValueStyle())).m_130946_(cdInfo).m_7220_((Component)manaCostCmp).m_130946_(" of ").m_7220_((Component)this.formatAbilityName(attribute.getAbilityKey())).m_6270_(this.getColoredTextStyle());
        }

        @Override
        @Nullable
        public MutableComponent getValueDisplay(AbilityManaCostPercentAttribute value) {
            return this.getValueComponent(value.getAmount());
        }

        @Override
        protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<AbilityManaCostPercentAttribute> instance, VaultGearModifier.AffixType type) {
            AbilityManaCostPercentAttribute attribute = instance.getValue();
            TextComponent valueDisplay = this.getValueComponent(Math.abs(attribute.getAmount()));
            boolean positive = attribute.getAmount() >= 0.0f;
            String cdInfo = positive ? " more Mana Cost of " : " less Mana Cost of ";
            out.add(type.getAffixPrefix(true));
            out.add(valueDisplay.getString());
            out.add(cdInfo);
            out.add(this.formatAbilityName(attribute.getAbilityKey()).getString());
        }

        private TextComponent getValueComponent(float value) {
            return new TextComponent(this.formatValue(value * 100.0f) + "%");
        }
    }
}

