/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.ability.special.base;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.annotations.Expose;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.ability.AbilityGearAttribute;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityConfig;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityConfigValue;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityModification;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityModificationRegistry;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.NetcodeUtils;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;

public class SpecialAbilityGearAttribute<T extends SpecialAbilityModification<? extends SpecialAbilityConfig<V>, V>, V extends SpecialAbilityConfigValue>
extends AbilityGearAttribute {
    private final T modification;
    private final V value;
    private int textColor = 14076214;
    private int highlightColor = 6082075;

    protected SpecialAbilityGearAttribute(String abilityKey, T modification, V value) {
        super(abilityKey);
        this.modification = modification;
        this.value = value;
    }

    public T getModification() {
        return this.modification;
    }

    public V getValue() {
        return this.value;
    }

    public <M extends SpecialAbilityGearAttribute<?, ?>> M setTextColor(int textColor) {
        this.textColor = textColor;
        return (M)this;
    }

    public <M extends SpecialAbilityGearAttribute<?, ?>> M setHighlightColor(int highlightColor) {
        this.highlightColor = highlightColor;
        return (M)this;
    }

    public Style getTextStyle() {
        return Style.f_131099_.m_131148_(TextColor.m_131266_((int)this.textColor));
    }

    public Style getHighlightStyle() {
        return Style.f_131099_.m_131148_(TextColor.m_131266_((int)this.highlightColor));
    }

    public static VaultGearAttributeType<SpecialAbilityGearAttribute> type() {
        return VaultGearAttributeType.of((buf, attribute) -> {
            buf.writeString(attribute.getAbilityKey());
            buf.writeIdentifier(((SpecialAbilityModification)attribute.getModification()).getKey());
            buf.writeInt(attribute.textColor);
            buf.writeInt(attribute.highlightColor);
            ((SpecialAbilityConfigValue)attribute.getValue()).write((BitBuffer)buf);
        }, buf -> {
            String ability = buf.readString();
            Object modification = SpecialAbilityModificationRegistry.getAbilityModification(buf.readIdentifier());
            int textColor = buf.readInt();
            int highlightColor = buf.readInt();
            SpecialAbilityConfigValue value = (SpecialAbilityConfigValue)((SpecialAbilityModification)modification).readValue().apply((BitBuffer)buf);
            return ((SpecialAbilityGearAttribute)new SpecialAbilityGearAttribute(ability, modification, value).setTextColor(textColor)).setHighlightColor(highlightColor);
        }, (buf, attribute) -> {
            NetcodeUtils.writeString(buf, attribute.getAbilityKey());
            NetcodeUtils.writeIdentifier(buf, ((SpecialAbilityModification)attribute.getModification()).getKey());
            buf.writeInt(attribute.textColor);
            buf.writeInt(attribute.highlightColor);
            ((SpecialAbilityConfigValue)attribute.getValue()).netWrite((ByteBuf)buf);
        }, buf -> {
            String ability = NetcodeUtils.readString(buf);
            Object modification = SpecialAbilityModificationRegistry.getAbilityModification(NetcodeUtils.readIdentifier(buf));
            int textColor = buf.readInt();
            int highlightColor = buf.readInt();
            SpecialAbilityConfigValue value = (SpecialAbilityConfigValue)((SpecialAbilityModification)modification).netReadValue().apply((ByteBuf)buf);
            return ((SpecialAbilityGearAttribute)new SpecialAbilityGearAttribute(ability, modification, value).setTextColor(textColor)).setHighlightColor(highlightColor);
        }, arg_0 -> ((Gson)VaultGearAttributeType.GSON).toJsonTree(arg_0), SpecialAbilityGearAttribute::read, SpecialAbilityGearAttribute::write);
    }

    private static SpecialAbilityGearAttribute read(Tag tag) {
        CompoundTag nbt = (CompoundTag)tag;
        String ability = nbt.m_128461_("ability");
        String modificationKey = nbt.m_128461_("modification");
        int textColor = nbt.m_128451_("textColor");
        int highlightColor = nbt.m_128451_("highlightColor");
        Tag valueTag = nbt.m_128423_("value");
        Object modification = SpecialAbilityModificationRegistry.getAbilityModification(new ResourceLocation(modificationKey));
        SpecialAbilityConfigValue value = (SpecialAbilityConfigValue)((SpecialAbilityModification)modification).nbtReadValue().apply(valueTag);
        return ((SpecialAbilityGearAttribute)new SpecialAbilityGearAttribute(ability, modification, value).setTextColor(textColor)).setHighlightColor(highlightColor);
    }

    private static Tag write(SpecialAbilityGearAttribute attribute) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("ability", attribute.getAbilityKey());
        nbt.m_128359_("modification", ((SpecialAbilityModification)attribute.getModification()).getKey().toString());
        nbt.m_128405_("textColor", attribute.textColor);
        nbt.m_128405_("highlightColor", attribute.highlightColor);
        nbt.m_128365_("value", ((SpecialAbilityConfigValue)attribute.getValue()).nbtWrite());
        return nbt;
    }

    public static Generator<?, ?, ?> generator() {
        return new Generator();
    }

    public static Reader<?, ?, ?> reader() {
        return new Reader();
    }

    public static class Generator<T extends SpecialAbilityModification<C, V>, C extends SpecialAbilityConfig<V>, V extends SpecialAbilityConfigValue>
    extends ConfigurableAttributeGenerator<SpecialAbilityGearAttribute<T, V>, SpecialAbilityTierConfig<T, C, V>> {
        private Generator() {
        }

        @Override
        @Nullable
        public Class<SpecialAbilityTierConfig<T, C, V>> getConfigurationObjectClass() {
            return MiscUtils.cast(SpecialAbilityTierConfig.class);
        }

        @Override
        public SpecialAbilityGearAttribute<T, V> generateRandomValue(SpecialAbilityTierConfig<T, C, V> cfgContainer, Random random) {
            SpecialAbilityConfig config = (SpecialAbilityConfig)Optional.ofNullable(cfgContainer.getConfig()).orElseThrow();
            SpecialAbilityGearAttribute attr = new SpecialAbilityGearAttribute(cfgContainer.getAbilityKey(), cfgContainer.getModification(), config.generateValue(random));
            attr.setTextColor(config.getTextColor());
            attr.setHighlightColor(config.getHighlightColor());
            return attr;
        }

        @Override
        public Optional<SpecialAbilityGearAttribute<T, V>> getMinimumValue(List<SpecialAbilityTierConfig<T, C, V>> configurations) {
            return configurations.stream().findFirst().map(SpecialAbilityTierConfig::getModification).flatMap(mod -> mod.getMinimumValue(configurations));
        }

        @Override
        public Optional<SpecialAbilityGearAttribute<T, V>> getMaximumValue(List<SpecialAbilityTierConfig<T, C, V>> configurations) {
            return configurations.stream().findFirst().map(SpecialAbilityTierConfig::getModification).flatMap(mod -> mod.getMaximumValue(configurations));
        }

        @Override
        public Optional<Float> getRollPercentage(SpecialAbilityGearAttribute<T, V> value, List<SpecialAbilityTierConfig<T, C, V>> configurations) {
            return configurations.stream().findFirst().map(SpecialAbilityTierConfig::getModification).flatMap(mod -> mod.getRollPercentage(value, configurations));
        }

        @Override
        @Nullable
        public MutableComponent getConfigRangeDisplay(VaultGearModifierReader<SpecialAbilityGearAttribute<T, V>> reader, SpecialAbilityTierConfig<T, C, V> min, SpecialAbilityTierConfig<T, C, V> max) {
            if (min.getModification() == null) {
                return null;
            }
            return ((SpecialAbilityModification)min.getModification()).getConfigRangeDisplay(reader, min, max);
        }
    }

    public static class Reader<T extends SpecialAbilityModification<C, V>, C extends SpecialAbilityConfig<V>, V extends SpecialAbilityConfigValue>
    extends VaultGearModifierReader<SpecialAbilityGearAttribute<T, V>> {
        private Reader() {
            super("", 0xB4B4B4);
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<SpecialAbilityGearAttribute<T, V>> instance, VaultGearModifier.AffixType type) {
            SpecialAbilityGearAttribute<T, V> attr = instance.getValue();
            return ((SpecialAbilityModification)attr.getModification()).getDisplay(attr, this.getColoredTextStyle(), type);
        }

        @Override
        @Nullable
        public MutableComponent getValueDisplay(SpecialAbilityGearAttribute<T, V> value) {
            return ((SpecialAbilityModification)value.getModification()).getValueDisplay(value.getValue());
        }

        @Override
        protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<SpecialAbilityGearAttribute<T, V>> instance, VaultGearModifier.AffixType type) {
            SpecialAbilityGearAttribute<T, V> attr = instance.getValue();
            ((SpecialAbilityModification)attr.getModification()).serializeTextElements(out, attr, type);
        }
    }

    public static class SpecialAbilityTierConfig<T extends SpecialAbilityModification<C, V>, C extends SpecialAbilityConfig<V>, V extends SpecialAbilityConfigValue>
    extends AbilityGearAttribute.AbilityAttributeConfig
    implements ConfigurableAttributeGenerator.CustomTierConfig {
        @Expose
        private final ResourceLocation specialModificationKey;
        private C specialConfig;

        public SpecialAbilityTierConfig(String abilityKey, ResourceLocation specialModificationKey, C config) {
            super(abilityKey);
            this.specialModificationKey = specialModificationKey;
            this.specialConfig = config;
        }

        @Nullable
        public C getConfig() {
            return this.specialConfig;
        }

        @Nullable
        public T getModification() {
            return SpecialAbilityModificationRegistry.getAbilityModification(this.specialModificationKey);
        }

        @Override
        public void deserializeAdditional(JsonObject configObject, JsonDeserializationContext ctx) {
            T modification = this.getModification();
            if (modification != null) {
                this.specialConfig = (SpecialAbilityConfig)ctx.deserialize((JsonElement)configObject, ((SpecialAbilityModification)modification).getConfigClass());
            }
        }

        @Override
        public void serializeAdditional(JsonObject configObject, JsonSerializationContext ctx) {
            T modification = this.getModification();
            if (modification != null && this.specialConfig != null) {
                JsonObject obj = ctx.serialize(this.specialConfig, ((SpecialAbilityModification)modification).getConfigClass()).getAsJsonObject();
                for (String key : obj.keySet()) {
                    configObject.add(key, obj.get(key));
                }
            }
        }
    }
}

