/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.ability.special.base.template;

import io.netty.buffer.ByteBuf;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityGearAttribute;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityModification;
import iskallia.vault.gear.attribute.ability.special.base.template.config.FloatRangeConfig;
import iskallia.vault.gear.attribute.ability.special.base.template.value.FloatValue;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.util.MiscUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class FloatRangeModification
extends SpecialAbilityModification<FloatRangeConfig, FloatValue> {
    protected FloatRangeModification(ResourceLocation key) {
        super(key);
    }

    @Override
    public Class<FloatRangeConfig> getConfigClass() {
        return FloatRangeConfig.class;
    }

    @Override
    public Function<BitBuffer, FloatValue> readValue() {
        return FloatValue::new;
    }

    @Override
    public Function<ByteBuf, FloatValue> netReadValue() {
        return FloatValue::new;
    }

    @Override
    public Function<Tag, FloatValue> nbtReadValue() {
        return FloatValue::new;
    }

    @Override
    @Nullable
    public MutableComponent getValueDisplay(FloatValue value) {
        return new TextComponent(String.valueOf(value.getValue()));
    }

    @Override
    @Nullable
    public <T extends SpecialAbilityModification<FloatRangeConfig, FloatValue>> MutableComponent getConfigRangeDisplay(VaultGearModifierReader<SpecialAbilityGearAttribute<T, FloatValue>> reader, SpecialAbilityGearAttribute.SpecialAbilityTierConfig<T, FloatRangeConfig, FloatValue> min, SpecialAbilityGearAttribute.SpecialAbilityTierConfig<T, FloatRangeConfig, FloatValue> max) {
        MutableComponent minDisplay = reader.getValueDisplay(this.of(min.getAbilityKey(), min.getModification(), new FloatValue(min.getConfig().getMin())));
        MutableComponent maxDisplay = reader.getValueDisplay(this.of(min.getAbilityKey(), min.getModification(), new FloatValue(min.getConfig().generateMaximumValue().floatValue())));
        if (minDisplay == null || maxDisplay == null) {
            return new TextComponent("");
        }
        return minDisplay.m_130946_("-").m_7220_((Component)maxDisplay);
    }

    @Override
    public <T extends SpecialAbilityModification<FloatRangeConfig, FloatValue>> Optional<SpecialAbilityGearAttribute<T, FloatValue>> getMinimumValue(List<SpecialAbilityGearAttribute.SpecialAbilityTierConfig<T, FloatRangeConfig, FloatValue>> configurations) {
        return configurations.stream().filter(cfg -> cfg.getModification() != null && cfg.getConfig() != null).map(cfg -> new ComparingConfig(cfg.getAbilityKey(), cfg.getModification(), ((FloatRangeConfig)cfg.getConfig()).getMin())).min(Comparator.comparing(ComparingConfig::value)).map(cfg -> this.of(cfg.abilityKey(), cfg.modification(), new FloatValue(cfg.value())));
    }

    @Override
    public <T extends SpecialAbilityModification<FloatRangeConfig, FloatValue>> Optional<SpecialAbilityGearAttribute<T, FloatValue>> getMaximumValue(List<SpecialAbilityGearAttribute.SpecialAbilityTierConfig<T, FloatRangeConfig, FloatValue>> configurations) {
        return configurations.stream().filter(cfg -> cfg.getModification() != null && cfg.getConfig() != null).map(cfg -> new ComparingConfig(cfg.getAbilityKey(), cfg.getModification(), ((FloatRangeConfig)cfg.getConfig()).generateMaximumValue().floatValue())).max(Comparator.comparing(ComparingConfig::value)).map(cfg -> this.of(cfg.abilityKey(), cfg.modification(), new FloatValue(cfg.value())));
    }

    @Override
    public <T extends SpecialAbilityModification<FloatRangeConfig, FloatValue>> Optional<Float> getRollPercentage(SpecialAbilityGearAttribute<T, FloatValue> value, List<SpecialAbilityGearAttribute.SpecialAbilityTierConfig<T, FloatRangeConfig, FloatValue>> configurations) {
        Optional<SpecialAbilityGearAttribute<SpecialAbilityGearAttribute, FloatValue>> min = this.getMinimumValue(configurations);
        Optional<SpecialAbilityGearAttribute<SpecialAbilityGearAttribute, FloatValue>> max = this.getMaximumValue(configurations);
        return MiscUtils.getFloatValueRange(value.getValue().getValue(), min.map(attr -> Float.valueOf(((FloatValue)attr.getValue()).getValue())), max.map(attr -> Float.valueOf(((FloatValue)attr.getValue()).getValue())), i -> i);
    }

    private record ComparingConfig<T extends SpecialAbilityModification<FloatRangeConfig, FloatValue>>(String abilityKey, T modification, float value) {
    }
}

