/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.ability.special.base.template;

import io.netty.buffer.ByteBuf;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityGearAttribute;
import iskallia.vault.gear.attribute.ability.special.base.SpecialAbilityModification;
import iskallia.vault.gear.attribute.ability.special.base.template.config.IntRangeConfig;
import iskallia.vault.gear.attribute.ability.special.base.template.value.IntValue;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.util.MiscUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class IntRangeModification
extends SpecialAbilityModification<IntRangeConfig, IntValue> {
    protected IntRangeModification(ResourceLocation key) {
        super(key);
    }

    @Override
    public Class<IntRangeConfig> getConfigClass() {
        return IntRangeConfig.class;
    }

    @Override
    public Function<BitBuffer, IntValue> readValue() {
        return IntValue::new;
    }

    @Override
    public Function<ByteBuf, IntValue> netReadValue() {
        return IntValue::new;
    }

    @Override
    public Function<Tag, IntValue> nbtReadValue() {
        return IntValue::new;
    }

    @Override
    @Nullable
    public MutableComponent getValueDisplay(IntValue value) {
        return new TextComponent(String.valueOf(value.getValue()));
    }

    @Override
    @Nullable
    public <T extends SpecialAbilityModification<IntRangeConfig, IntValue>> MutableComponent getConfigRangeDisplay(VaultGearModifierReader<SpecialAbilityGearAttribute<T, IntValue>> reader, SpecialAbilityGearAttribute.SpecialAbilityTierConfig<T, IntRangeConfig, IntValue> min, SpecialAbilityGearAttribute.SpecialAbilityTierConfig<T, IntRangeConfig, IntValue> max) {
        MutableComponent minDisplay = reader.getValueDisplay(this.of(min.getAbilityKey(), min.getModification(), new IntValue(min.getConfig().getMin())));
        MutableComponent maxDisplay = reader.getValueDisplay(this.of(min.getAbilityKey(), min.getModification(), new IntValue(min.getConfig().generateMaximumValue())));
        if (minDisplay == null || maxDisplay == null) {
            return new TextComponent("");
        }
        return minDisplay.m_130946_("-").m_7220_((Component)maxDisplay);
    }

    @Override
    public <T extends SpecialAbilityModification<IntRangeConfig, IntValue>> Optional<SpecialAbilityGearAttribute<T, IntValue>> getMinimumValue(List<SpecialAbilityGearAttribute.SpecialAbilityTierConfig<T, IntRangeConfig, IntValue>> configurations) {
        return configurations.stream().filter(cfg -> cfg.getModification() != null && cfg.getConfig() != null).map(cfg -> new ComparingConfig(cfg.getAbilityKey(), cfg.getModification(), ((IntRangeConfig)cfg.getConfig()).getMin())).min(Comparator.comparing(ComparingConfig::value)).map(cfg -> this.of(cfg.abilityKey(), cfg.modification(), new IntValue(cfg.value())));
    }

    @Override
    public <T extends SpecialAbilityModification<IntRangeConfig, IntValue>> Optional<SpecialAbilityGearAttribute<T, IntValue>> getMaximumValue(List<SpecialAbilityGearAttribute.SpecialAbilityTierConfig<T, IntRangeConfig, IntValue>> configurations) {
        return configurations.stream().filter(cfg -> cfg.getModification() != null && cfg.getConfig() != null).map(cfg -> new ComparingConfig(cfg.getAbilityKey(), cfg.getModification(), ((IntRangeConfig)cfg.getConfig()).generateMaximumValue())).max(Comparator.comparing(ComparingConfig::value)).map(cfg -> this.of(cfg.abilityKey(), cfg.modification(), new IntValue(cfg.value())));
    }

    @Override
    public <T extends SpecialAbilityModification<IntRangeConfig, IntValue>> Optional<Float> getRollPercentage(SpecialAbilityGearAttribute<T, IntValue> value, List<SpecialAbilityGearAttribute.SpecialAbilityTierConfig<T, IntRangeConfig, IntValue>> configurations) {
        Optional<SpecialAbilityGearAttribute<SpecialAbilityGearAttribute, IntValue>> min = this.getMinimumValue(configurations);
        Optional<SpecialAbilityGearAttribute<SpecialAbilityGearAttribute, IntValue>> max = this.getMaximumValue(configurations);
        return MiscUtils.getIntValueRange(value.getValue().getValue(), min.map(attr -> ((IntValue)attr.getValue()).getValue()), max.map(attr -> ((IntValue)attr.getValue()).getValue()), i -> i);
    }

    private record ComparingConfig<T extends SpecialAbilityModification<IntRangeConfig, IntValue>>(String abilityKey, T modification, int value) {
    }
}

