/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.gear.attribute.config.NumberRangeGenerator;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.util.MiscUtils;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;

public class FloatAttributeGenerator
extends NumberRangeGenerator<Float, Range> {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.##");

    @Override
    @Nullable
    public Class<Range> getConfigurationObjectClass() {
        return Range.class;
    }

    @Override
    @Nullable
    public MutableComponent getConfigRangeDisplay(VaultGearModifierReader<Float> reader, Range min, Range max) {
        MutableComponent minDisplay = reader.getValueDisplay(Float.valueOf(min.min));
        MutableComponent maxDisplay = reader.getValueDisplay(Float.valueOf(max.max));
        if (minDisplay == null || maxDisplay == null) {
            return new TextComponent("");
        }
        return minDisplay.m_130946_("-").m_7220_((Component)maxDisplay);
    }

    @Override
    @Nullable
    public MutableComponent getConfigDisplay(VaultGearModifierReader<Float> reader, Range object) {
        MutableComponent range = this.getConfigRangeDisplay(reader, object);
        if (range == null) {
            return null;
        }
        return new TextComponent("").m_130948_(reader.getColoredTextStyle()).m_7220_((Component)range.m_130948_(reader.getColoredTextStyle())).m_130946_(" ").m_7220_((Component)new TextComponent(reader.getModifierName()).m_130948_(reader.getColoredTextStyle()));
    }

    @Override
    public Optional<Float> getMinimumValue(List<Range> configurations) {
        return configurations.stream().map(range -> Float.valueOf(range.min)).min(Double::compare);
    }

    @Override
    public Optional<Float> getMaximumValue(List<Range> configurations) {
        return configurations.stream().map(Range::generateMaximumNumber).min(Double::compare);
    }

    @Override
    public Optional<Float> getRollPercentage(Float value, List<Range> configurations) {
        return MiscUtils.getFloatValueRange(value.floatValue(), this.getMinimumValue(configurations), this.getMaximumValue(configurations), f -> f);
    }

    public static class Range
    extends NumberRangeGenerator.NumberRange<Float> {
        @Expose
        private float min;
        @Expose
        private float max;
        @Expose
        private float step;

        public Range(float min, float max) {
            this(min, max, 0.1f);
        }

        public Range(float min, float max, float step) {
            this.min = min;
            this.max = max;
            this.step = step;
        }

        @Override
        public Float generateNumber(Random random) {
            int steps = Math.round(Math.max(this.max - this.min, 0.0f) / this.step) + 1;
            return Float.valueOf(this.min + (float)random.nextInt(steps) * this.step);
        }

        @Override
        public Float generateMaximumNumber() {
            int steps = Math.round(Math.max(this.max - this.min, 0.0f) / this.step);
            return Float.valueOf(this.min + (float)steps * this.step);
        }
    }
}

