/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.gear.attribute.config.NumberRangeGenerator;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.util.MiscUtils;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;

public class IntegerAttributeGenerator
extends NumberRangeGenerator<Integer, Range> {
    @Override
    @Nullable
    public Class<Range> getConfigurationObjectClass() {
        return Range.class;
    }

    @Override
    @Nullable
    public MutableComponent getConfigRangeDisplay(VaultGearModifierReader<Integer> reader, Range min, Range max) {
        MutableComponent minDisplay = reader.getValueDisplay(min.min);
        MutableComponent maxDisplay = reader.getValueDisplay(max.max);
        if (minDisplay == null || maxDisplay == null) {
            return new TextComponent("");
        }
        return minDisplay.m_130946_("-").m_7220_((Component)maxDisplay);
    }

    @Override
    @Nullable
    public MutableComponent getConfigDisplay(VaultGearModifierReader<Integer> reader, Range object) {
        MutableComponent range = this.getConfigRangeDisplay(reader, object);
        if (range == null) {
            return null;
        }
        return new TextComponent("").m_130948_(reader.getColoredTextStyle()).m_7220_((Component)range.m_130948_(reader.getColoredTextStyle())).m_130946_(" ").m_7220_((Component)new TextComponent(reader.getModifierName()).m_130948_(reader.getColoredTextStyle()));
    }

    @Override
    public Optional<Integer> getMinimumValue(List<Range> configurations) {
        return configurations.stream().map(range -> range.min).min(Double::compare);
    }

    @Override
    public Optional<Integer> getMaximumValue(List<Range> configurations) {
        return configurations.stream().map(Range::generateMaximumNumber).min(Double::compare);
    }

    @Override
    public Optional<Float> getRollPercentage(Integer value, List<Range> configurations) {
        return MiscUtils.getIntValueRange(value, this.getMinimumValue(configurations), this.getMaximumValue(configurations), i -> i);
    }

    public static class Range
    extends NumberRangeGenerator.NumberRange<Integer> {
        @Expose
        public int min;
        @Expose
        public int max;
        @Expose
        public int step;

        public Range(int min, int max, int step) {
            this.min = min;
            this.max = max;
            this.step = step;
        }

        @Override
        public Integer generateNumber(Random random) {
            int steps = Math.max(this.max - this.min, 0) / this.step + 1;
            return this.min + random.nextInt(steps) * this.step;
        }

        @Override
        public Integer generateMaximumNumber() {
            int steps = Math.max(this.max - this.min, 0) / this.step;
            return this.min + steps * this.step;
        }
    }
}

