/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.annotations.Expose;
import com.mojang.datafixers.util.Pair;
import iskallia.vault.VaultMod;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.config.WeightedListAttributeGenerator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class PairAttributeGenerator<F, S, FC, SC>
extends ConfigurableAttributeGenerator<Pair<F, S>, Config<FC, SC>> {
    private final ConfigurableAttributeGenerator<F, FC> firstGenerator;
    private final ConfigurableAttributeGenerator<S, SC> secondGenerator;
    private final String firstKey;
    private final String secondKey;
    private final boolean customKeys;

    public PairAttributeGenerator(ConfigurableAttributeGenerator<F, FC> firstGenerator, ConfigurableAttributeGenerator<S, SC> secondGenerator) {
        this(firstGenerator, secondGenerator, "first", "second");
    }

    public PairAttributeGenerator(ConfigurableAttributeGenerator<F, FC> firstGenerator, ConfigurableAttributeGenerator<S, SC> secondGenerator, String firstKey, String secondKey) {
        this.firstGenerator = firstGenerator;
        this.secondGenerator = secondGenerator;
        this.firstKey = firstKey;
        this.secondKey = secondKey;
        this.customKeys = !"first".equals(firstKey) || !"second".equals(secondKey);
    }

    @Override
    @Nullable
    public Class<Config<FC, SC>> getConfigurationObjectClass() {
        if (this.customKeys) {
            return Config2.class;
        }
        return Config.class;
    }

    @Override
    public Pair<F, S> generateRandomValue(Config<FC, SC> object, Random random) {
        if (object == null) {
            throw new IllegalArgumentException("Configuration object cannot be null");
        }
        if (object.first == null || object.second == null) {
            VaultMod.LOGGER.info(object.second);
            throw new IllegalArgumentException("Configuration object must have non-null first and second values (" + this.firstKey + ", " + this.secondKey + ")");
        }
        F first = this.firstGenerator.generateRandomValue(object.first, random);
        S second = this.secondGenerator.generateRandomValue(object.second, random);
        return Pair.of(first, second);
    }

    @Override
    public Optional<Pair<F, S>> getMinimumValue(List<Config<FC, SC>> configurations) {
        List firstConfigs = configurations.stream().map(cfg -> cfg.first).collect(Collectors.toList());
        List secondConfigs = configurations.stream().map(cfg -> cfg.second).collect(Collectors.toList());
        Optional<F> first = this.firstGenerator.getMinimumValue(firstConfigs);
        Optional<S> second = this.secondGenerator.getMinimumValue(secondConfigs);
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(Pair.of(first.get(), second.get()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Pair<F, S>> getMaximumValue(List<Config<FC, SC>> configurations) {
        List firstConfigs = configurations.stream().map(cfg -> cfg.first).collect(Collectors.toList());
        List secondConfigs = configurations.stream().map(cfg -> cfg.second).collect(Collectors.toList());
        Optional<F> first = this.firstGenerator.getMaximumValue(firstConfigs);
        Optional<S> second = this.secondGenerator.getMaximumValue(secondConfigs);
        if (first.isPresent() && second.isPresent()) {
            return Optional.of(Pair.of(first.get(), second.get()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Float> getRollPercentage(Pair<F, S> value, List<Config<FC, SC>> configurations) {
        List firstConfigs = configurations.stream().map(cfg -> cfg.first).collect(Collectors.toList());
        List secondConfigs = configurations.stream().map(cfg -> cfg.second).collect(Collectors.toList());
        Optional<Float> firstPercent = this.firstGenerator.getRollPercentage(value.getFirst(), firstConfigs);
        Optional<Float> secondPercent = this.secondGenerator.getRollPercentage(value.getSecond(), secondConfigs);
        if (firstPercent.isPresent() && secondPercent.isPresent()) {
            return Optional.of(Float.valueOf(firstPercent.get().floatValue() * secondPercent.get().floatValue()));
        }
        return Optional.empty();
    }

    public static class Config2<FC, SC>
    extends Config<FC, SC>
    implements ConfigurableAttributeGenerator.CustomTierConfig {
        private transient ConfigurableAttributeGenerator<?, FC> firstGenerator;
        private transient ConfigurableAttributeGenerator<?, SC> secondGenerator;
        private transient String firstKey;
        private transient String secondKey;

        public Config2() {
            this(null, null);
        }

        public Config2(FC first, SC second) {
            super(first, second);
        }

        public Config2(FC first, SC second, String firstName, String secondName) {
            super(first, second);
            this.firstKey = firstName;
            this.secondKey = secondName;
        }

        public void init(PairAttributeGenerator<?, ?, ?, ?> generator) {
            this.firstGenerator = generator.firstGenerator;
            this.secondGenerator = generator.secondGenerator;
            this.firstKey = generator.firstKey;
            this.secondKey = generator.secondKey;
        }

        @Override
        public void deserializeAdditional(JsonObject configObject, JsonDeserializationContext ctx) {
            Class<SC> secondClass;
            WeightedList list;
            JsonElement element;
            Class<FC> firstClass;
            if (configObject.has(this.firstKey) && (firstClass = this.firstGenerator.getConfigurationObjectClass()) != null) {
                element = configObject.get(this.firstKey);
                try {
                    this.first = ctx.deserialize(element, firstClass);
                }
                catch (JsonParseException e) {
                    if (firstClass == WeightedListAttributeGenerator.Config.class && element.isJsonArray()) {
                        list = (WeightedList)ctx.deserialize(element, WeightedList.class);
                        this.first = new WeightedListAttributeGenerator.Config(list);
                    }
                    throw e;
                }
            }
            if (configObject.has(this.secondKey) && (secondClass = this.secondGenerator.getConfigurationObjectClass()) != null) {
                element = configObject.get(this.secondKey);
                try {
                    this.second = ctx.deserialize(element, secondClass);
                }
                catch (JsonParseException e) {
                    if (secondClass == WeightedListAttributeGenerator.Config.class && element.isJsonArray()) {
                        list = (WeightedList)ctx.deserialize(element, WeightedList.class);
                        this.second = new WeightedListAttributeGenerator.Config(list);
                    }
                    throw e;
                }
            }
        }

        @Override
        public void serializeAdditional(JsonObject configObject, JsonSerializationContext ctx) {
            configObject.remove("first");
            configObject.remove("second");
            configObject.add(this.firstKey, ctx.serialize(this.first));
            configObject.add(this.secondKey, ctx.serialize(this.second));
        }
    }

    public static class Config<FC, SC> {
        @Expose
        public FC first;
        @Expose
        public SC second;

        public Config(FC first, SC second) {
            this.first = first;
            this.second = second;
        }
    }
}

