/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.annotations.Expose;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.config.WeightedListAttributeGenerator;
import iskallia.vault.util.Throuple;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ThroupleAttributeGenerator<F, S, T, FC, SC, TC>
extends ConfigurableAttributeGenerator<Throuple<F, S, T>, Config> {
    private final ConfigurableAttributeGenerator<F, FC> firstGenerator;
    private final ConfigurableAttributeGenerator<S, SC> secondGenerator;
    private final ConfigurableAttributeGenerator<T, TC> thirdGenerator;
    private final String firstKey;
    private final String secondKey;
    private final String thirdKey;

    public ThroupleAttributeGenerator(ConfigurableAttributeGenerator<F, FC> firstGenerator, ConfigurableAttributeGenerator<S, SC> secondGenerator, ConfigurableAttributeGenerator<T, TC> thirdGenerator) {
        this(firstGenerator, secondGenerator, thirdGenerator, "first", "second", "third");
    }

    public ThroupleAttributeGenerator(ConfigurableAttributeGenerator<F, FC> firstGenerator, ConfigurableAttributeGenerator<S, SC> secondGenerator, ConfigurableAttributeGenerator<T, TC> thirdGenerator, String firstKey, String secondKey, String thirdKey) {
        this.firstGenerator = firstGenerator;
        this.secondGenerator = secondGenerator;
        this.thirdGenerator = thirdGenerator;
        this.firstKey = firstKey;
        this.secondKey = secondKey;
        this.thirdKey = thirdKey;
    }

    @Override
    @Nullable
    public Class<Config> getConfigurationObjectClass() {
        return Config.class;
    }

    @Override
    public Throuple<F, S, T> generateRandomValue(Config object, Random random) {
        F first = this.firstGenerator.generateRandomValue(object.first, random);
        S second = this.secondGenerator.generateRandomValue(object.second, random);
        T third = this.thirdGenerator.generateRandomValue(object.third, random);
        return Throuple.of(first, second, third);
    }

    @Override
    public Optional<Throuple<F, S, T>> getMinimumValue(List<Config> configurations) {
        List firstConfigs = configurations.stream().map(cfg -> cfg.first).collect(Collectors.toList());
        List secondConfigs = configurations.stream().map(cfg -> cfg.second).collect(Collectors.toList());
        List thirdConfigs = configurations.stream().map(cfg -> cfg.third).collect(Collectors.toList());
        Optional<F> first = this.firstGenerator.getMinimumValue(firstConfigs);
        Optional<S> second = this.secondGenerator.getMinimumValue(secondConfigs);
        Optional<T> third = this.thirdGenerator.getMinimumValue(thirdConfigs);
        if (first.isPresent() && second.isPresent() && third.isPresent()) {
            return Optional.of(Throuple.of(first.get(), second.get(), third.get()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Throuple<F, S, T>> getMaximumValue(List<Config> configurations) {
        List firstConfigs = configurations.stream().map(cfg -> cfg.first).collect(Collectors.toList());
        List secondConfigs = configurations.stream().map(cfg -> cfg.second).collect(Collectors.toList());
        List thirdConfigs = configurations.stream().map(cfg -> cfg.third).collect(Collectors.toList());
        Optional<F> first = this.firstGenerator.getMaximumValue(firstConfigs);
        Optional<S> second = this.secondGenerator.getMaximumValue(secondConfigs);
        Optional<T> third = this.thirdGenerator.getMaximumValue(thirdConfigs);
        if (first.isPresent() && second.isPresent() && third.isPresent()) {
            return Optional.of(Throuple.of(first.get(), second.get(), third.get()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Float> getRollPercentage(Throuple<F, S, T> value, List<Config> configurations) {
        List firstConfigs = configurations.stream().map(cfg -> cfg.first).collect(Collectors.toList());
        List secondConfigs = configurations.stream().map(cfg -> cfg.second).collect(Collectors.toList());
        List thirdConfigs = configurations.stream().map(cfg -> cfg.third).collect(Collectors.toList());
        Optional<Float> firstPercent = this.firstGenerator.getRollPercentage(value.getFirst(), firstConfigs);
        Optional<Float> secondPercent = this.secondGenerator.getRollPercentage(value.getSecond(), secondConfigs);
        Optional<Float> thirdPercent = this.thirdGenerator.getRollPercentage(value.getThird(), thirdConfigs);
        if (firstPercent.isPresent() && secondPercent.isPresent() && thirdPercent.isPresent()) {
            return Optional.of(Float.valueOf(firstPercent.get().floatValue() * secondPercent.get().floatValue() * thirdPercent.get().floatValue()));
        }
        return Optional.empty();
    }

    public class Config
    implements ConfigurableAttributeGenerator.CustomTierConfig {
        @Expose
        public FC first;
        @Expose
        public SC second;
        @Expose
        public TC third;
        private transient ConfigurableAttributeGenerator<?, FC> firstGenerator;
        private transient ConfigurableAttributeGenerator<?, SC> secondGenerator;
        private transient ConfigurableAttributeGenerator<?, TC> thirdGenerator;
        private transient String firstKey;
        private transient String secondKey;
        private transient String thirdKey;

        public Config() {
            this(null, null, null);
        }

        public Config(FC first, SC second, TC third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }

        public void init(ThroupleAttributeGenerator<?, ?, ?, ?, ?, ?> generator) {
            this.firstGenerator = generator.firstGenerator;
            this.secondGenerator = generator.secondGenerator;
            this.thirdGenerator = generator.thirdGenerator;
            this.firstKey = generator.firstKey;
            this.secondKey = generator.secondKey;
            this.thirdKey = generator.thirdKey;
        }

        @Override
        public void deserializeAdditional(JsonObject configObject, JsonDeserializationContext ctx) {
            Class thirdClass;
            Class secondClass;
            WeightedList list;
            JsonElement element;
            Class firstClass;
            if (configObject.has(this.firstKey) && (firstClass = this.firstGenerator.getConfigurationObjectClass()) != null) {
                element = configObject.get(this.firstKey);
                try {
                    this.first = ctx.deserialize(element, firstClass);
                }
                catch (JsonParseException e) {
                    if (firstClass == WeightedListAttributeGenerator.Config.class && element.isJsonArray()) {
                        list = (WeightedList)ctx.deserialize(element, WeightedList.class);
                        this.first = new WeightedListAttributeGenerator.Config(list);
                    }
                    throw e;
                }
            }
            if (configObject.has(this.secondKey) && (secondClass = this.secondGenerator.getConfigurationObjectClass()) != null) {
                element = configObject.get(this.secondKey);
                try {
                    this.second = ctx.deserialize(element, secondClass);
                }
                catch (JsonParseException e) {
                    if (secondClass == WeightedListAttributeGenerator.Config.class && element.isJsonArray()) {
                        list = (WeightedList)ctx.deserialize(element, WeightedList.class);
                        this.second = new WeightedListAttributeGenerator.Config(list);
                    }
                    throw e;
                }
            }
            if (configObject.has(this.thirdKey) && (thirdClass = this.thirdGenerator.getConfigurationObjectClass()) != null) {
                element = configObject.get(this.thirdKey);
                try {
                    this.third = ctx.deserialize(element, thirdClass);
                }
                catch (JsonParseException e) {
                    if (thirdClass == WeightedListAttributeGenerator.Config.class && element.isJsonArray()) {
                        list = (WeightedList)ctx.deserialize(element, WeightedList.class);
                        this.third = new WeightedListAttributeGenerator.Config(list);
                    }
                    throw e;
                }
            }
        }

        @Override
        public void serializeAdditional(JsonObject configObject, JsonSerializationContext ctx) {
            configObject.remove("first");
            configObject.remove("second");
            configObject.remove("third");
            configObject.add(this.firstKey, ctx.serialize(this.first));
            configObject.add(this.secondKey, ctx.serialize(this.second));
            configObject.add(this.thirdKey, ctx.serialize(this.third));
        }
    }
}

