/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.config;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;

public class WeightedListAttributeGenerator<T>
extends ConfigurableAttributeGenerator<T, Config<T>> {
    @Override
    @Nullable
    public Class<Config<T>> getConfigurationObjectClass() {
        return Config.class;
    }

    @Override
    public T generateRandomValue(Config<T> object, Random random) {
        return object.strings.getRandom(random).orElseThrow(() -> new IllegalStateException("No string available in the weighted list"));
    }

    @Override
    public Optional<T> getMinimumValue(List<Config<T>> configurations) {
        return configurations.stream().map(range -> range.strings.getRandom()).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Override
    public Optional<T> getMaximumValue(List<Config<T>> configurations) {
        return configurations.stream().map(range -> range.strings.getRandom()).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public static class Config<T> {
        @Expose
        public WeightedList<T> strings;

        public Config(WeightedList<T> strings) {
            this.strings = strings;
        }
    }
}

