/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.custom;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.annotations.Expose;
import iskallia.vault.config.entry.FloatRollRangeEntry;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public class DoubleFloatAttribute {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.##");
    private final float floatA;
    private final float floatB;

    protected DoubleFloatAttribute(float floatA, float healthIncrease) {
        this.floatA = floatA;
        this.floatB = healthIncrease;
    }

    public float getFloatA() {
        return this.floatA;
    }

    public float getFloatB() {
        return this.floatB;
    }

    public static VaultGearAttributeType<DoubleFloatAttribute> type() {
        return VaultGearAttributeType.of((buf, attribute) -> {
            buf.writeFloat(attribute.getFloatA());
            buf.writeFloat(attribute.getFloatB());
        }, buf -> new DoubleFloatAttribute(buf.readFloat(), buf.readFloat()), (buf, attribute) -> {
            buf.writeFloat(attribute.getFloatA());
            buf.writeFloat(attribute.getFloatB());
        }, buf -> new DoubleFloatAttribute(buf.readFloat(), buf.readFloat()), arg_0 -> ((Gson)VaultGearAttributeType.GSON).toJsonTree(arg_0), tag -> {
            CompoundTag compoundTag = (CompoundTag)tag;
            float floatA = compoundTag.m_128457_("floatA");
            float floatB = compoundTag.m_128457_("floatB");
            return new DoubleFloatAttribute(floatA, floatB);
        }, attribute -> {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128350_("floatA", attribute.getFloatA());
            compoundTag.m_128350_("floatB", attribute.getFloatB());
            return compoundTag;
        });
    }

    public static AttributeComparator comparator() {
        return new AttributeComparator();
    }

    public static Generator generator() {
        return new Generator();
    }

    public static Reader reader() {
        return new Reader();
    }

    private static class AttributeComparator
    extends VaultGearAttributeComparator<DoubleFloatAttribute> {
        private AttributeComparator() {
        }

        @Override
        public Optional<DoubleFloatAttribute> merge(DoubleFloatAttribute thisValue, DoubleFloatAttribute thatValue) {
            return Optional.of(new DoubleFloatAttribute(Math.max(thisValue.getFloatA(), thatValue.getFloatA()), Math.max(thisValue.getFloatB(), thatValue.getFloatB())));
        }

        @Override
        public Optional<DoubleFloatAttribute> difference(DoubleFloatAttribute thisValue, DoubleFloatAttribute thatValue) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Comparator<DoubleFloatAttribute> getComparator() {
            return Comparator.comparing(DoubleFloatAttribute::getFloatA).thenComparing(DoubleFloatAttribute::getFloatB);
        }
    }

    public static class Generator
    extends ConfigurableAttributeGenerator<DoubleFloatAttribute, Config> {
        @Override
        @Nullable
        public Class<Config> getConfigurationObjectClass() {
            return Config.class;
        }

        @Override
        @Nullable
        public MutableComponent getConfigRangeDisplay(VaultGearModifierReader<DoubleFloatAttribute> reader, Config min, Config max) {
            return this.getChanceDisplay(min.getFloatA().getMin()).m_130946_("-").m_7220_((Component)this.getChanceDisplay(max.getFloatA().getMax())).m_130946_(", ").m_130946_(String.valueOf(min.getFloatB().getMin())).m_130946_("-").m_130946_(String.valueOf(max.getFloatB().getMax()));
        }

        private MutableComponent getChanceDisplay(float value) {
            return new TextComponent(FORMAT.format(value * 100.0f) + "%");
        }

        @Override
        @Nullable
        public MutableComponent getConfigDisplay(VaultGearModifierReader<DoubleFloatAttribute> reader, Config object) {
            MutableComponent range = this.getConfigRangeDisplay(reader, object);
            if (range == null) {
                return null;
            }
            return new TextComponent("Double Float Attribute: ").m_7220_((Component)range).m_6270_(reader.getColoredTextStyle());
        }

        @Override
        public DoubleFloatAttribute generateRandomValue(Config object, Random random) {
            JavaRandom rand = JavaRandom.ofScrambled(random.nextLong());
            float floatA = object.getFloatA().getRandom(rand);
            float floatB = object.getFloatB().getRandom(rand);
            return new DoubleFloatAttribute(floatA, floatB);
        }

        @Override
        public Optional<DoubleFloatAttribute> getMinimumValue(List<Config> configurations) {
            Comparator<Config> cfgCmp = Comparator.comparing(config -> Float.valueOf(config.getFloatB().getMin()));
            cfgCmp = cfgCmp.thenComparing(config -> Float.valueOf(config.getFloatA().getMin()));
            return configurations.stream().min(cfgCmp).map(config -> new DoubleFloatAttribute(config.getFloatA().getMin(), config.getFloatB().getMin()));
        }

        @Override
        public Optional<DoubleFloatAttribute> getMaximumValue(List<Config> configurations) {
            Comparator<Config> cfgCmp = Comparator.comparing(config -> Float.valueOf(config.getFloatB().getMax()));
            cfgCmp = cfgCmp.thenComparing(config -> Float.valueOf(config.getFloatA().getRolledMaximum()));
            return configurations.stream().max(cfgCmp).map(config -> new DoubleFloatAttribute(config.getFloatA().getRolledMaximum(), config.getFloatB().getRolledMaximum()));
        }
    }

    private static class Reader
    extends VaultGearModifierReader<DoubleFloatAttribute> {
        protected Reader() {
            super("", 15418941);
        }

        private Style getHighlightStyle() {
            return Style.f_131099_.m_178520_(0xFFAA00);
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<DoubleFloatAttribute> instance, VaultGearModifier.AffixType type) {
            DoubleFloatAttribute doubleFloatAttribute = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(doubleFloatAttribute);
            if (valueDisplay == null) {
                return null;
            }
            return new TextComponent("").m_7220_((Component)type.getAffixPrefixComponent(true)).m_7220_((Component)valueDisplay).m_7220_((Component)new TextComponent(" Empty Double Float Attribute Reader")).m_6270_(this.getColoredTextStyle());
        }

        @Override
        @Nullable
        public MutableComponent getValueDisplay(DoubleFloatAttribute value) {
            return new TextComponent(FORMAT.format(value.getFloatA() * 100.0f) + "%");
        }

        @Override
        protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<DoubleFloatAttribute> instance, VaultGearModifier.AffixType type) {
            DoubleFloatAttribute attribute = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(attribute);
            if (valueDisplay == null) {
                return;
            }
            out.add(type.getAffixPrefix(true));
            out.add("Empty Double Float Attribute Reader: ");
            out.add(valueDisplay.m_130948_(this.getHighlightStyle()).getString());
        }
    }

    public static class Config {
        @Expose
        private final FloatRollRangeEntry floatA;
        @Expose
        private final FloatRollRangeEntry floatB;

        public Config(FloatRollRangeEntry floatA, FloatRollRangeEntry floatB) {
            this.floatA = floatA;
            this.floatB = floatB;
        }

        public FloatRollRangeEntry getFloatA() {
            return this.floatA;
        }

        public FloatRollRangeEntry getFloatB() {
            return this.floatB;
        }
    }
}

