/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.custom;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.annotations.Expose;
import iskallia.vault.config.entry.FloatRollRangeEntry;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.world.roll.FloatRoll;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.util.MiscUtils;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public class HitHeartsAttribute {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.##");
    private final float dropChance;
    private final FloatRoll healthIncrease;

    protected HitHeartsAttribute(float dropChance, FloatRoll healthIncrease) {
        this.dropChance = dropChance;
        this.healthIncrease = healthIncrease;
    }

    public float getDropChance() {
        return this.dropChance;
    }

    public FloatRoll getHealthIncrease() {
        return this.healthIncrease;
    }

    public static VaultGearAttributeType<HitHeartsAttribute> type() {
        return VaultGearAttributeType.of((buf, attribute) -> {
            buf.writeFloat(attribute.getDropChance());
            Adapters.FLOAT_ROLL.writeBits(attribute.getHealthIncrease(), (BitBuffer)buf);
        }, buf -> new HitHeartsAttribute(buf.readFloat(), Adapters.FLOAT_ROLL.readBits((BitBuffer)buf).orElse(FloatRoll.ofConstant(0.0f))), (buf, attribute) -> {
            buf.writeFloat(attribute.getDropChance());
            buf.writeFloat(attribute.getHealthIncrease().getMin());
            buf.writeFloat(attribute.getHealthIncrease().getMax());
        }, buf -> new HitHeartsAttribute(buf.readFloat(), FloatRoll.ofUniform(buf.readFloat(), buf.readFloat())), arg_0 -> ((Gson)VaultGearAttributeType.GSON).toJsonTree(arg_0), tag -> {
            CompoundTag compoundTag = (CompoundTag)tag;
            float dropChance = compoundTag.m_128457_("dropChance");
            FloatRoll healthIncrease = Adapters.FLOAT_ROLL.readNbt(compoundTag.m_128423_("healthIncrease")).orElse(FloatRoll.ofConstant(0.0f));
            return new HitHeartsAttribute(dropChance, healthIncrease);
        }, attribute -> {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128350_("dropChance", attribute.getDropChance());
            Adapters.FLOAT_ROLL.writeNbt(attribute.getHealthIncrease()).ifPresent(tag -> compoundTag.m_128365_("healthIncrease", tag));
            return compoundTag;
        });
    }

    public static AttributeComparator comparator() {
        return new AttributeComparator();
    }

    public static Generator generator() {
        return new Generator();
    }

    public static Reader reader() {
        return new Reader();
    }

    private static class AttributeComparator
    extends VaultGearAttributeComparator<HitHeartsAttribute> {
        private AttributeComparator() {
        }

        @Override
        public Optional<HitHeartsAttribute> merge(HitHeartsAttribute thisValue, HitHeartsAttribute thatValue) {
            return Optional.of(new HitHeartsAttribute(Math.max(thisValue.getDropChance(), thatValue.getDropChance()), FloatRoll.ofUniform(Math.max(thisValue.getHealthIncrease().getMin(), thatValue.getHealthIncrease().getMin()), Math.max(thisValue.getHealthIncrease().getMax(), thatValue.getHealthIncrease().getMax()))));
        }

        @Override
        public Optional<HitHeartsAttribute> difference(HitHeartsAttribute thisValue, HitHeartsAttribute thatValue) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Comparator<HitHeartsAttribute> getComparator() {
            return Comparator.comparing(HitHeartsAttribute::getDropChance).thenComparing(HitHeartsAttribute::getHealthIncrease, (a, b) -> {
                if (a.getMin() == b.getMin()) {
                    return Float.compare(a.getMax(), b.getMax());
                }
                return Float.compare(a.getMin(), b.getMin());
            });
        }
    }

    public static class Generator
    extends ConfigurableAttributeGenerator<HitHeartsAttribute, Config> {
        @Override
        @Nullable
        public Class<Config> getConfigurationObjectClass() {
            return Config.class;
        }

        @Override
        @Nullable
        public MutableComponent getConfigRangeDisplay(VaultGearModifierReader<HitHeartsAttribute> reader, Config min, Config max) {
            return this.getChanceDisplay(min.getDropChance().getMin()).m_130946_("-").m_7220_((Component)this.getChanceDisplay(max.getDropChance().getMax())).m_130946_(", ").m_130946_(String.valueOf(min.getHealthIncrease().getMin())).m_130946_("-").m_130946_(String.valueOf(max.getHealthIncrease().getMax()));
        }

        private MutableComponent getChanceDisplay(float value) {
            return new TextComponent(FORMAT.format(value * 100.0f) + "%");
        }

        @Override
        @Nullable
        public MutableComponent getConfigDisplay(VaultGearModifierReader<HitHeartsAttribute> reader, Config object) {
            MutableComponent range = this.getConfigRangeDisplay(reader, object);
            if (range == null) {
                return null;
            }
            return new TextComponent("").m_130948_(reader.getColoredTextStyle()).m_130946_("Killing a mob has a ").m_7220_((Component)range.m_130948_(reader.getColoredTextStyle())).m_130946_(" chance to drop a heart fragment, increasing your health by ").m_130946_(object.getHealthIncrease().getMin() * 100.0f + "%").m_130946_("-").m_130946_(object.getHealthIncrease().getMax() * 100.0f + "%");
        }

        @Override
        public HitHeartsAttribute generateRandomValue(Config object, Random random) {
            JavaRandom rand = JavaRandom.ofScrambled(random.nextLong());
            float dropChange = object.getDropChance().getRandom(rand);
            return new HitHeartsAttribute(dropChange, object.getHealthIncrease());
        }

        @Override
        public Optional<HitHeartsAttribute> getMinimumValue(List<Config> configurations) {
            Comparator<Config> cfgCmp = Comparator.comparing(config -> Float.valueOf(config.getHealthIncrease().getMin()));
            cfgCmp = cfgCmp.thenComparing(config -> Float.valueOf(config.getDropChance().getMin()));
            return configurations.stream().min(cfgCmp).map(config -> new HitHeartsAttribute(config.getDropChance().getMin(), config.getHealthIncrease()));
        }

        @Override
        public Optional<HitHeartsAttribute> getMaximumValue(List<Config> configurations) {
            Comparator<Config> cfgCmp = Comparator.comparing(config -> Float.valueOf(config.getHealthIncrease().getMax()));
            cfgCmp = cfgCmp.thenComparing(config -> Float.valueOf(config.getDropChance().getRolledMaximum()));
            return configurations.stream().max(cfgCmp).map(config -> new HitHeartsAttribute(config.getDropChance().getRolledMaximum(), config.getHealthIncrease()));
        }

        @Override
        public Optional<Float> getRollPercentage(HitHeartsAttribute value, List<Config> configurations) {
            return MiscUtils.getFloatValueRange(value.getDropChance(), this.getMinimumValue(configurations), this.getMaximumValue(configurations), HitHeartsAttribute::getDropChance);
        }
    }

    private static class Reader
    extends VaultGearModifierReader<HitHeartsAttribute> {
        protected Reader() {
            super("", 15418941);
        }

        private Style getHighlightStyle() {
            return Style.f_131099_.m_178520_(0xFFAA00);
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<HitHeartsAttribute> instance, VaultGearModifier.AffixType type) {
            HitHeartsAttribute hitHeartsAttribute = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(hitHeartsAttribute);
            if (valueDisplay == null) {
                return null;
            }
            MutableComponent rangeDisplay = new TextComponent(FORMAT.format(hitHeartsAttribute.getHealthIncrease().getMin() * 100.0f) + "% - " + FORMAT.format(hitHeartsAttribute.getHealthIncrease().getMax() * 100.0f) + "%").m_130948_(this.getHighlightStyle());
            return new TextComponent("").m_7220_((Component)type.getAffixPrefixComponent(true)).m_7220_((Component)valueDisplay).m_7220_((Component)new TextComponent(" Heart Fragments")).m_6270_(this.getColoredTextStyle());
        }

        @Override
        @Nullable
        public MutableComponent getValueDisplay(HitHeartsAttribute value) {
            return new TextComponent(FORMAT.format(value.getDropChance() * 100.0f) + "%");
        }

        @Override
        protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<HitHeartsAttribute> instance, VaultGearModifier.AffixType type) {
            HitHeartsAttribute attribute = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(attribute);
            if (valueDisplay == null) {
                return;
            }
            out.add(type.getAffixPrefix(true));
            out.add("Killing a mob has a ");
            out.add(valueDisplay.getString());
            out.add(" chance to drop a heart fragment, increasing your health by ");
            out.add(FORMAT.format(attribute.getHealthIncrease().getMin() * 100.0f) + "% - " + FORMAT.format(attribute.getHealthIncrease().getMax() * 100.0f) + "%");
        }
    }

    public static class Config {
        @Expose
        private final FloatRollRangeEntry dropChance;
        @Expose
        private final FloatRoll healthIncrease;

        public Config(FloatRollRangeEntry dropChance, FloatRoll healthIncrease) {
            this.dropChance = dropChance;
            this.healthIncrease = healthIncrease;
        }

        public FloatRollRangeEntry getDropChance() {
            return this.dropChance;
        }

        public FloatRoll getHealthIncrease() {
            return this.healthIncrease;
        }
    }
}

