/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.custom;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.annotations.Expose;
import iskallia.vault.config.entry.IntRollRangeEntry;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.NetcodeUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class RandomGodVaultModifierAttribute {
    protected final ResourceLocation modifier;
    protected final int count;
    protected final int time;
    protected final VaultGod vaultGod;

    public RandomGodVaultModifierAttribute(ResourceLocation modifier, int count, int time, VaultGod vaultGod) {
        this.modifier = modifier;
        this.count = count;
        this.time = time;
        this.vaultGod = vaultGod;
    }

    public ResourceLocation getModifier() {
        return this.modifier;
    }

    public int getCount() {
        return this.count;
    }

    public int getTime() {
        return this.time;
    }

    public VaultGod getVaultGod() {
        return this.vaultGod;
    }

    public static VaultGearAttributeType<RandomGodVaultModifierAttribute> type() {
        return VaultGearAttributeType.of((buf, attribute) -> {
            buf.writeIdentifier(attribute.getModifier());
            buf.writeInt(attribute.getCount());
            buf.writeInt(attribute.getTime());
            buf.writeString(attribute.getVaultGod().m_7912_());
        }, buf -> new RandomGodVaultModifierAttribute(buf.readIdentifier(), buf.readInt(), buf.readInt(), VaultGod.fromName(buf.readString())), (buf, attribute) -> {
            NetcodeUtils.writeIdentifier(buf, attribute.getModifier());
            buf.writeInt(attribute.getCount());
            buf.writeInt(attribute.getTime());
            NetcodeUtils.writeString(buf, attribute.getVaultGod().m_7912_());
        }, buf -> {
            ResourceLocation modifier = NetcodeUtils.readIdentifier(buf);
            int count = buf.readInt();
            int time = buf.readInt();
            return new RandomGodVaultModifierAttribute(modifier, count, time, VaultGod.fromName(NetcodeUtils.readString(buf)));
        }, arg_0 -> ((Gson)VaultGearAttributeType.GSON).toJsonTree(arg_0), nbt -> {
            CompoundTag tag = (CompoundTag)nbt;
            ResourceLocation modifier = ResourceLocation.m_135820_((String)tag.m_128461_("modifier"));
            int count = tag.m_128451_("count");
            int time = tag.m_128451_("time");
            return new RandomGodVaultModifierAttribute(modifier, count, time, VaultGod.fromName(tag.m_128461_("vault_god")));
        }, attribute -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("modifier", attribute.getModifier().toString());
            tag.m_128405_("count", attribute.getCount());
            tag.m_128405_("time", attribute.getTime());
            tag.m_128359_("vault_god", attribute.getVaultGod().m_7912_());
            return tag;
        });
    }

    public static BiFunction<VaultGearModifier<?>, Float, VaultGearModifier<?>> scalingFunction() {
        return (value, scale) -> {
            Object patt4312$temp = value.getValue();
            if (patt4312$temp instanceof RandomGodVaultModifierAttribute) {
                RandomGodVaultModifierAttribute attribute = (RandomGodVaultModifierAttribute)patt4312$temp;
                RandomGodVaultModifierAttribute newAttribute = new RandomGodVaultModifierAttribute(attribute.getModifier(), attribute.getCount(), (int)((float)attribute.getTime() * scale.floatValue()), attribute.getVaultGod());
                return new VaultGearModifier<RandomGodVaultModifierAttribute>(value.getAttribute(), newAttribute);
            }
            return value;
        };
    }

    public static ConfigurableAttributeGenerator<RandomGodVaultModifierAttribute, Config> generator() {
        return new ConfigurableAttributeGenerator<RandomGodVaultModifierAttribute, Config>(){

            @Override
            public Class<Config> getConfigurationObjectClass() {
                return Config.class;
            }

            @Override
            public MutableComponent getConfigRangeDisplay(VaultGearModifierReader<RandomGodVaultModifierAttribute> reader, Config min, Config max) {
                return new TextComponent("%s-%s".formatted(min.getTime().getMin() / 20, max.getTime().getMax() / 20));
            }

            @Override
            public RandomGodVaultModifierAttribute generateRandomValue(Config object, Random random) {
                JavaRandom rand = JavaRandom.ofScrambled(random.nextLong());
                return new RandomGodVaultModifierAttribute(object.getModifier(), object.getCount(), object.getTime().getRandom(rand), object.getVaultGod());
            }

            @Override
            public Optional<RandomGodVaultModifierAttribute> getMinimumValue(List<Config> configurations) {
                return configurations.stream().min(Comparator.comparingInt(Config::getCount)).map(config -> new RandomGodVaultModifierAttribute(config.getModifier(), config.getCount(), config.getTime().getMin(), config.getVaultGod()));
            }

            @Override
            public Optional<RandomGodVaultModifierAttribute> getMaximumValue(List<Config> configurations) {
                return configurations.stream().max(Comparator.comparingInt(Config::getCount)).map(config -> new RandomGodVaultModifierAttribute(config.getModifier(), config.getCount(), config.getTime().getMax(), config.getVaultGod()));
            }

            @Override
            public Optional<Float> getRollPercentage(RandomGodVaultModifierAttribute value, List<Config> configurations) {
                return MiscUtils.getIntValueRange(value.getTime(), this.getMinimumValue(configurations), this.getMaximumValue(configurations), RandomGodVaultModifierAttribute::getTime);
            }
        };
    }

    public static VaultGearModifierReader<RandomGodVaultModifierAttribute> reader() {
        return new VaultGearModifierReader<RandomGodVaultModifierAttribute>("", 15638784){

            @Override
            @Nullable
            public MutableComponent getDisplay(VaultGearAttributeInstance<RandomGodVaultModifierAttribute> instance, VaultGearModifier.AffixType type) {
                RandomGodVaultModifierAttribute attribute = instance.getValue();
                MutableComponent valueDisplay = this.getValueDisplay(attribute);
                VaultModifier modifier = VaultModifierRegistry.getOpt(attribute.getModifier()).orElse(null);
                if (modifier == null) {
                    return null;
                }
                return new TextComponent("").m_7220_((Component)type.getAffixPrefixComponent(attribute.getCount() >= 0).m_130948_(this.getColoredTextStyle())).m_7220_((Component)valueDisplay.m_130948_(this.getColoredTextStyle())).m_130946_(" of ").m_130946_((String)(attribute.getCount() > 1 ? attribute.getCount() + "x " : "")).m_7220_(modifier.getNameComponentFormatted(attribute.getCount())).m_130948_(this.getColoredTextStyle());
            }

            @Override
            public MutableComponent getValueDisplay(RandomGodVaultModifierAttribute value) {
                return new TextComponent(value.getTime() / 20 + " seconds");
            }

            @Override
            protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<RandomGodVaultModifierAttribute> instance, VaultGearModifier.AffixType type) {
                RandomGodVaultModifierAttribute attribute = instance.getValue();
                MutableComponent valueDisplay = this.getValueDisplay(attribute);
                VaultModifier modifier = VaultModifierRegistry.getOpt(attribute.getModifier()).orElse(null);
                if (modifier == null) {
                    return;
                }
                out.add(type.getAffixPrefix(attribute.getCount() >= 0));
                out.add(valueDisplay.getString());
                out.add(" of ");
                out.add(attribute.getCount() + "x ");
                out.add(modifier.getNameComponentFormatted(attribute.getCount()).getString());
            }
        };
    }

    public static VaultGearAttributeComparator<RandomGodVaultModifierAttribute> comparator() {
        return new VaultGearAttributeComparator<RandomGodVaultModifierAttribute>(){

            @Override
            public Optional<RandomGodVaultModifierAttribute> merge(RandomGodVaultModifierAttribute thisValue, RandomGodVaultModifierAttribute thatValue) {
                if (!thisValue.getModifier().equals((Object)thatValue.getModifier()) || thisValue.getCount() != thatValue.getCount()) {
                    return Optional.empty();
                }
                return Optional.of(new RandomGodVaultModifierAttribute(thisValue.getModifier(), thisValue.getCount(), thisValue.getTime() + thatValue.getTime(), thisValue.getVaultGod()));
            }

            @Override
            public Optional<RandomGodVaultModifierAttribute> difference(RandomGodVaultModifierAttribute thisValue, RandomGodVaultModifierAttribute thatValue) {
                return Optional.empty();
            }

            @Override
            @NotNull
            public Comparator<RandomGodVaultModifierAttribute> getComparator() {
                return Comparator.comparing(RandomGodVaultModifierAttribute::getTime);
            }
        };
    }

    public static class Config {
        @Expose
        private ResourceLocation modifier;
        @Expose
        private int count;
        @Expose
        private IntRollRangeEntry time;
        @Expose
        private VaultGod vaultGod;

        public Config(ResourceLocation modifier, int count, IntRollRangeEntry time, VaultGod god) {
            this.modifier = modifier;
            this.count = count;
            this.time = time;
            this.vaultGod = god;
        }

        public ResourceLocation getModifier() {
            return this.modifier;
        }

        public int getCount() {
            return this.count;
        }

        public IntRollRangeEntry getTime() {
            return this.time;
        }

        public VaultGod getVaultGod() {
            return this.vaultGod;
        }
    }
}

