/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.custom;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.annotations.Expose;
import iskallia.vault.config.entry.FloatRollRangeEntry;
import iskallia.vault.config.entry.IntRollRangeEntry;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.util.MiscUtils;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;

public class RelentlessStrikeAttribute {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.##");
    private final float attackDamageIncrease;
    private final int maxStackSize;

    protected RelentlessStrikeAttribute(float attackDamageIncrease, int maxStackSize) {
        this.attackDamageIncrease = attackDamageIncrease;
        this.maxStackSize = maxStackSize;
    }

    public float getAttackDamageIncrease() {
        return this.attackDamageIncrease;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public static VaultGearAttributeType<RelentlessStrikeAttribute> type() {
        return VaultGearAttributeType.of((buf, attribute) -> {
            buf.writeFloat(attribute.getAttackDamageIncrease());
            buf.writeInt(attribute.getMaxStackSize());
        }, buf -> new RelentlessStrikeAttribute(buf.readFloat(), buf.readInt()), (buf, attribute) -> {
            buf.writeFloat(attribute.getAttackDamageIncrease());
            buf.writeInt(attribute.getMaxStackSize());
        }, buf -> new RelentlessStrikeAttribute(buf.readFloat(), buf.readInt()), arg_0 -> ((Gson)VaultGearAttributeType.GSON).toJsonTree(arg_0), tag -> {
            CompoundTag compoundTag = (CompoundTag)tag;
            float attackDamageIncrease = compoundTag.m_128457_("attackDamageIncrease");
            int maxStackSize = compoundTag.m_128451_("maxStackSize");
            return new RelentlessStrikeAttribute(attackDamageIncrease, maxStackSize);
        }, attribute -> {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128350_("attackDamageIncrease", attribute.getAttackDamageIncrease());
            compoundTag.m_128405_("maxStackSize", attribute.getMaxStackSize());
            return compoundTag;
        });
    }

    public static AttributeComparator comparator() {
        return new AttributeComparator();
    }

    public static Generator generator() {
        return new Generator();
    }

    public static Reader reader() {
        return new Reader();
    }

    private static class AttributeComparator
    extends VaultGearAttributeComparator<RelentlessStrikeAttribute> {
        private AttributeComparator() {
        }

        @Override
        public Optional<RelentlessStrikeAttribute> merge(RelentlessStrikeAttribute thisValue, RelentlessStrikeAttribute thatValue) {
            return Optional.of(new RelentlessStrikeAttribute(Math.max(thisValue.getAttackDamageIncrease(), thatValue.getAttackDamageIncrease()), Math.max(thisValue.getMaxStackSize(), thatValue.getMaxStackSize())));
        }

        @Override
        public Optional<RelentlessStrikeAttribute> difference(RelentlessStrikeAttribute thisValue, RelentlessStrikeAttribute thatValue) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Comparator<RelentlessStrikeAttribute> getComparator() {
            return Comparator.comparing(RelentlessStrikeAttribute::getAttackDamageIncrease).thenComparing(RelentlessStrikeAttribute::getMaxStackSize);
        }
    }

    public static class Generator
    extends ConfigurableAttributeGenerator<RelentlessStrikeAttribute, Config> {
        @Override
        @Nullable
        public Class<Config> getConfigurationObjectClass() {
            return Config.class;
        }

        @Override
        @Nullable
        public MutableComponent getConfigRangeDisplay(VaultGearModifierReader<RelentlessStrikeAttribute> reader, Config min, Config max) {
            return this.getChanceDisplay(min.getAttackDamageIncrease().getMin()).m_130946_("-").m_7220_((Component)this.getChanceDisplay(max.getAttackDamageIncrease().getMax())).m_130946_(", ").m_130946_(String.valueOf(min.getMaxStackSize().getMin())).m_130946_("-").m_130946_(String.valueOf(max.getMaxStackSize().getMax()));
        }

        private MutableComponent getChanceDisplay(float value) {
            return new TextComponent(FORMAT.format(value * 100.0f) + "%");
        }

        @Override
        @Nullable
        public MutableComponent getConfigDisplay(VaultGearModifierReader<RelentlessStrikeAttribute> reader, Config object) {
            MutableComponent range = this.getConfigRangeDisplay(reader, object);
            if (range == null) {
                return null;
            }
            return new TextComponent("").m_130948_(reader.getColoredTextStyle()).m_130946_("Attacking a mob increases your attack damage by ").m_7220_((Component)range.m_130948_(reader.getColoredTextStyle())).m_130946_(", this effect can stack up to ").m_130946_(String.valueOf(object.getMaxStackSize().getMin())).m_130946_(" times and lasts for ").m_130946_("8 seconds");
        }

        @Override
        public RelentlessStrikeAttribute generateRandomValue(Config object, Random random) {
            JavaRandom rand = JavaRandom.ofScrambled(random.nextLong());
            float attackDamage = object.getAttackDamageIncrease().getRandom(rand);
            int stackSize = object.getMaxStackSize().getRandom(rand);
            return new RelentlessStrikeAttribute(attackDamage, stackSize);
        }

        @Override
        public Optional<RelentlessStrikeAttribute> getMinimumValue(List<Config> configurations) {
            Comparator<Config> cfgCmp = Comparator.comparing(config -> config.getMaxStackSize().getMin());
            cfgCmp = cfgCmp.thenComparing(config -> Float.valueOf(config.getAttackDamageIncrease().getMin()));
            return configurations.stream().min(cfgCmp).map(config -> new RelentlessStrikeAttribute(config.getAttackDamageIncrease().getMin(), config.getMaxStackSize().getMin()));
        }

        @Override
        public Optional<RelentlessStrikeAttribute> getMaximumValue(List<Config> configurations) {
            Comparator<Config> cfgCmp = Comparator.comparing(config -> config.getMaxStackSize().getRolledMaximum());
            cfgCmp = cfgCmp.thenComparing(config -> Float.valueOf(config.getAttackDamageIncrease().getRolledMaximum()));
            return configurations.stream().max(cfgCmp).map(config -> new RelentlessStrikeAttribute(config.getAttackDamageIncrease().getRolledMaximum(), config.getMaxStackSize().getRolledMaximum()));
        }

        @Override
        public Optional<Float> getRollPercentage(RelentlessStrikeAttribute value, List<Config> configurations) {
            return MiscUtils.getFloatValueRange(value.getAttackDamageIncrease(), this.getMinimumValue(configurations), this.getMaximumValue(configurations), RelentlessStrikeAttribute::getAttackDamageIncrease);
        }
    }

    private static class Reader
    extends VaultGearModifierReader<RelentlessStrikeAttribute> {
        protected Reader() {
            super("", 14901010);
        }

        private Style getHighlightStyle() {
            return Style.f_131099_.m_178520_(0xFFAA00);
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<RelentlessStrikeAttribute> instance, VaultGearModifier.AffixType type) {
            RelentlessStrikeAttribute abilityTriggerData = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(abilityTriggerData);
            if (valueDisplay == null) {
                return null;
            }
            TextComponent maxStackSizeDisplay = new TextComponent(String.valueOf(abilityTriggerData.getMaxStackSize()));
            return new TextComponent("").m_7220_((Component)type.getAffixPrefixComponent(true)).m_7220_((Component)new TextComponent("Attacking a mob increases your attack damage by ")).m_7220_((Component)valueDisplay.m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFAA00)))).m_7220_((Component)new TextComponent(", this effect can stack up to ")).m_7220_((Component)maxStackSizeDisplay.m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFAA00)))).m_7220_((Component)new TextComponent(" times and lasts for ")).m_7220_((Component)new TextComponent("8 seconds").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFAA00)))).m_6270_(this.getColoredTextStyle());
        }

        @Override
        @Nullable
        public MutableComponent getValueDisplay(RelentlessStrikeAttribute value) {
            return new TextComponent(FORMAT.format(value.getAttackDamageIncrease() * 100.0f) + "%");
        }

        @Override
        protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<RelentlessStrikeAttribute> instance, VaultGearModifier.AffixType type) {
            RelentlessStrikeAttribute attribute = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(attribute);
            if (valueDisplay == null) {
                return;
            }
            out.add(type.getAffixPrefix(attribute.getAttackDamageIncrease() >= 0.0f));
            out.add("Attacking a mob increases your attack damage by ");
            out.add(valueDisplay.getString());
            out.add(", this effect can stack up to ");
            out.add(String.valueOf(attribute.getMaxStackSize()));
            out.add(" times and lasts for ");
            out.add("8 seconds");
        }
    }

    public static class Config {
        @Expose
        private final FloatRollRangeEntry attackDamageIncrease;
        @Expose
        private final IntRollRangeEntry maxStackSize;

        public Config(FloatRollRangeEntry chance, IntRollRangeEntry level) {
            this.attackDamageIncrease = chance;
            this.maxStackSize = level;
        }

        public FloatRollRangeEntry getAttackDamageIncrease() {
            return this.attackDamageIncrease;
        }

        public IntRollRangeEntry getMaxStackSize() {
            return this.maxStackSize;
        }
    }
}

