/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.custom;

import com.google.gson.Gson;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.util.NetcodeUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class StringListGearAttribute {
    private final List<String> strings;

    public StringListGearAttribute(List<String> strings) {
        this.strings = strings;
    }

    public String toString() {
        return "StringListGearAttribute{string=" + String.valueOf(this.strings) + "}";
    }

    public static VaultGearAttributeType<StringListGearAttribute> type() {
        return VaultGearAttributeType.of(StringListGearAttribute::write, StringListGearAttribute::read, StringListGearAttribute::write, StringListGearAttribute::read, arg_0 -> ((Gson)VaultGearAttributeType.GSON).toJsonTree(arg_0), StringListGearAttribute::read, StringListGearAttribute::write);
    }

    private static StringListGearAttribute read(ByteBuf buf) {
        int size = buf.readInt();
        ArrayList<String> strings = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            try {
                strings.add(NetcodeUtils.readString(buf));
                continue;
            }
            catch (IllegalArgumentException e) {
                strings.add(null);
            }
        }
        strings.removeIf(Objects::isNull);
        return new StringListGearAttribute(strings);
    }

    private static void write(ByteBuf buf, StringListGearAttribute attribute) {
        buf.writeInt(attribute.strings.size());
        for (String string : attribute.strings) {
            NetcodeUtils.writeString(buf, string);
        }
    }

    private static StringListGearAttribute read(BitBuffer buf) {
        int size = buf.readInt();
        ArrayList<String> string = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            string.add(buf.readString());
        }
        string.removeIf(Objects::isNull);
        return new StringListGearAttribute(string);
    }

    private static void write(BitBuffer buf, StringListGearAttribute attribute) {
        buf.writeInt(attribute.strings.size());
        for (String string : attribute.strings) {
            buf.writeString(string);
        }
    }

    private static StringListGearAttribute read(Tag nbt) {
        CompoundTag tag = (CompoundTag)nbt;
        ArrayList<String> strings = new ArrayList<String>();
        ListTag stringList = tag.m_128437_("strings", 8);
        for (Tag stringTag : stringList) {
            strings.add(stringTag.m_7916_());
        }
        return new StringListGearAttribute(strings);
    }

    private static Tag write(StringListGearAttribute attribute) {
        CompoundTag tag = new CompoundTag();
        ListTag stringList = new ListTag();
        for (String string : attribute.strings) {
            stringList.add((Object)StringTag.m_129297_((String)string));
        }
        tag.m_128365_("strings", (Tag)stringList);
        return tag;
    }

    public static AttributeComparator comparator() {
        return new AttributeComparator();
    }

    public List<String> getStrings() {
        return this.strings;
    }

    public boolean addString(String string) {
        return this.strings.add(string);
    }

    private static class AttributeComparator
    extends VaultGearAttributeComparator<StringListGearAttribute> {
        private AttributeComparator() {
        }

        @Override
        public Optional<StringListGearAttribute> merge(StringListGearAttribute thisValue, StringListGearAttribute thatValue) {
            HashSet<String> thatSet;
            HashSet<String> thisSet = new HashSet<String>(thisValue.getStrings());
            if (!thisSet.containsAll(thatSet = new HashSet<String>(thatValue.getStrings())) && !thatSet.containsAll(thisSet)) {
                return Optional.empty();
            }
            return Optional.of(new StringListGearAttribute(thisValue.getStrings()));
        }

        @Override
        @Deprecated
        public Optional<StringListGearAttribute> difference(StringListGearAttribute thisValue, StringListGearAttribute thatValue) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Comparator<StringListGearAttribute> getComparator() {
            return Comparator.comparing(thisValue -> thisValue.getStrings().toString());
        }
    }
}

