/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.custom;

import com.google.gson.Gson;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.util.NetcodeUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class UUIDListGearAttribute {
    private final List<UUID> uuids;

    public UUIDListGearAttribute(List<UUID> uuids) {
        this.uuids = uuids;
    }

    public String toString() {
        return "UUIDListGearAttribute{uuids=" + String.valueOf(this.uuids) + "}";
    }

    public static VaultGearAttributeType<UUIDListGearAttribute> type() {
        return VaultGearAttributeType.of(UUIDListGearAttribute::write, UUIDListGearAttribute::read, UUIDListGearAttribute::write, UUIDListGearAttribute::read, arg_0 -> ((Gson)VaultGearAttributeType.GSON).toJsonTree(arg_0), UUIDListGearAttribute::read, UUIDListGearAttribute::write);
    }

    private static UUIDListGearAttribute read(ByteBuf buf) {
        int size = buf.readInt();
        ArrayList<UUID> uuids = new ArrayList<UUID>(size);
        for (int i = 0; i < size; ++i) {
            try {
                uuids.add(UUID.fromString(NetcodeUtils.readString(buf)));
                continue;
            }
            catch (IllegalArgumentException e) {
                uuids.add(null);
            }
        }
        uuids.removeIf(Objects::isNull);
        return new UUIDListGearAttribute(uuids);
    }

    private static void write(ByteBuf buf, UUIDListGearAttribute attribute) {
        buf.writeInt(attribute.uuids.size());
        for (UUID uuid : attribute.uuids) {
            NetcodeUtils.writeString(buf, uuid.toString());
        }
    }

    private static UUIDListGearAttribute read(BitBuffer buf) {
        int size = buf.readInt();
        ArrayList<UUID> uuids = new ArrayList<UUID>(size);
        for (int i = 0; i < size; ++i) {
            uuids.add(buf.readUUID());
        }
        uuids.removeIf(Objects::isNull);
        return new UUIDListGearAttribute(uuids);
    }

    private static void write(BitBuffer buf, UUIDListGearAttribute attribute) {
        buf.writeInt(attribute.uuids.size());
        for (UUID effect : attribute.uuids) {
            buf.writeUUID(effect);
        }
    }

    private static UUIDListGearAttribute read(Tag nbt) {
        CompoundTag tag = (CompoundTag)nbt;
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        ListTag uuidList = tag.m_128437_("uuids", 8);
        for (Tag uuidTag : uuidList) {
            uuids.add(UUID.fromString(uuidTag.m_7916_()));
        }
        return new UUIDListGearAttribute(uuids);
    }

    private static Tag write(UUIDListGearAttribute attribute) {
        CompoundTag tag = new CompoundTag();
        ListTag uuidList = new ListTag();
        for (UUID uuid : attribute.uuids) {
            uuidList.add((Object)StringTag.m_129297_((String)uuid.toString()));
        }
        tag.m_128365_("uuids", (Tag)uuidList);
        return tag;
    }

    public static AttributeComparator comparator() {
        return new AttributeComparator();
    }

    public List<UUID> getUuids() {
        return this.uuids;
    }

    public boolean addUuid(UUID uuid) {
        return this.uuids.add(uuid);
    }

    private static class AttributeComparator
    extends VaultGearAttributeComparator<UUIDListGearAttribute> {
        private AttributeComparator() {
        }

        @Override
        public Optional<UUIDListGearAttribute> merge(UUIDListGearAttribute thisValue, UUIDListGearAttribute thatValue) {
            HashSet<UUID> thatSet;
            HashSet<UUID> thisSet = new HashSet<UUID>(thisValue.getUuids());
            if (!thisSet.containsAll(thatSet = new HashSet<UUID>(thatValue.getUuids())) && !thatSet.containsAll(thisSet)) {
                return Optional.empty();
            }
            return Optional.of(new UUIDListGearAttribute(thisValue.getUuids()));
        }

        @Override
        @Deprecated
        public Optional<UUIDListGearAttribute> difference(UUIDListGearAttribute thisValue, UUIDListGearAttribute thatValue) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Comparator<UUIDListGearAttribute> getComparator() {
            return Comparator.comparing(thisValue -> thisValue.getUuids().toString());
        }
    }
}

