/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.custom.ability;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.annotations.Expose;
import iskallia.vault.config.entry.FloatRollRangeEntry;
import iskallia.vault.config.entry.IntRollRangeEntry;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.mana.FullManaPlayer;
import iskallia.vault.skill.ability.effect.spi.core.InstantAbility;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.SpecializedSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.source.SkillSource;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.NetcodeUtils;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class AbilityTriggerOnDamageAttribute {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.##");
    private final String abilityId;
    private final float chance;
    private final int level;

    protected AbilityTriggerOnDamageAttribute(String abilityId, float chance, int level) {
        this.abilityId = abilityId;
        this.chance = chance;
        this.level = level;
    }

    public String getAbilityId() {
        return this.abilityId;
    }

    public float getChance() {
        return this.chance;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean shouldTrigger(ServerPlayer player) {
        return !((float)player.m_183503_().m_5822_().nextInt(100) >= this.chance * 100.0f);
    }

    public void trigger(ServerPlayer player, RandomSource random) {
        if (!this.shouldTrigger(player)) {
            return;
        }
        AbilityTree tree = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
        this.resolve(tree).ifPresent(ability -> ability.onAction(SkillContext.of(player, SkillSource.of((Entity)player).setPos(player.m_20182_()).setMana(FullManaPlayer.INSTANCE))));
    }

    private Optional<InstantAbility> resolve(AbilityTree tree) {
        return tree.getForId(this.abilityId).map(skill -> {
            Skill skill2;
            if (skill instanceof SpecializedSkill) {
                SpecializedSkill specialized = (SpecializedSkill)skill;
                v0 = specialized.getSpecialization();
            } else {
                v0 = skill = skill;
            }
            if (skill instanceof TieredSkill) {
                TieredSkill tiered = (TieredSkill)skill;
                skill2 = tiered.getChild();
            } else {
                skill2 = skill;
            }
            skill = skill2;
            return (InstantAbility)(skill instanceof InstantAbility ? skill : null);
        });
    }

    public static VaultGearAttributeType<AbilityTriggerOnDamageAttribute> type() {
        return VaultGearAttributeType.of((buf, attribute) -> {
            buf.writeString(attribute.getAbilityId());
            buf.writeFloat(attribute.getChance());
            buf.writeInt(attribute.getLevel());
        }, buf -> new AbilityTriggerOnDamageAttribute(buf.readString(), buf.readFloat(), buf.readInt()), (buf, attribute) -> {
            NetcodeUtils.writeString(buf, attribute.getAbilityId());
            buf.writeFloat(attribute.getChance());
            buf.writeInt(attribute.getLevel());
        }, buf -> new AbilityTriggerOnDamageAttribute(NetcodeUtils.readString(buf), buf.readFloat(), buf.readInt()), arg_0 -> ((Gson)VaultGearAttributeType.GSON).toJsonTree(arg_0), tag -> {
            CompoundTag compoundTag = (CompoundTag)tag;
            String abilityId = compoundTag.m_128461_("abilityId");
            float chance = compoundTag.m_128457_("chance");
            int level = compoundTag.m_128451_("level");
            return new AbilityTriggerOnDamageAttribute(abilityId, chance, level);
        }, attribute -> {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("abilityId", attribute.getAbilityId());
            compoundTag.m_128350_("chance", attribute.getChance());
            compoundTag.m_128405_("level", attribute.getLevel());
            return compoundTag;
        });
    }

    public static AttributeComparator comparator() {
        return new AttributeComparator();
    }

    public static Generator generator() {
        return new Generator();
    }

    public static Reader reader() {
        return new Reader();
    }

    private static class AttributeComparator
    extends VaultGearAttributeComparator<AbilityTriggerOnDamageAttribute> {
        private AttributeComparator() {
        }

        @Override
        public Optional<AbilityTriggerOnDamageAttribute> merge(AbilityTriggerOnDamageAttribute thisValue, AbilityTriggerOnDamageAttribute thatValue) {
            if (!Objects.equals(thisValue.getAbilityId(), thatValue.getAbilityId())) {
                return Optional.empty();
            }
            return Optional.of(new AbilityTriggerOnDamageAttribute(thisValue.getAbilityId(), Math.max(thisValue.getChance(), thatValue.getChance()), Math.max(thisValue.getLevel(), thatValue.getLevel())));
        }

        @Override
        public Optional<AbilityTriggerOnDamageAttribute> difference(AbilityTriggerOnDamageAttribute thisValue, AbilityTriggerOnDamageAttribute thatValue) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Comparator<AbilityTriggerOnDamageAttribute> getComparator() {
            return Comparator.comparing(AbilityTriggerOnDamageAttribute::getAbilityId).thenComparing(AbilityTriggerOnDamageAttribute::getChance).thenComparing(AbilityTriggerOnDamageAttribute::getLevel);
        }
    }

    public static class Generator
    extends ConfigurableAttributeGenerator<AbilityTriggerOnDamageAttribute, Config> {
        @Override
        @Nullable
        public Class<Config> getConfigurationObjectClass() {
            return Config.class;
        }

        @Override
        @Nullable
        public MutableComponent getConfigRangeDisplay(VaultGearModifierReader<AbilityTriggerOnDamageAttribute> reader, Config min, Config max) {
            return this.getChanceDisplay(min.getChance().getMin()).m_130946_("-").m_7220_((Component)this.getChanceDisplay(max.getChance().getMax())).m_130946_(", ").m_130946_(String.valueOf(min.getLevel().getMin())).m_130946_("-").m_130946_(String.valueOf(max.getLevel().getMax()));
        }

        private MutableComponent getChanceDisplay(float value) {
            return new TextComponent(FORMAT.format(value * 100.0f) + "%");
        }

        @Override
        @Nullable
        public MutableComponent getConfigDisplay(VaultGearModifierReader<AbilityTriggerOnDamageAttribute> reader, Config object) {
            MutableComponent range = this.getConfigRangeDisplay(reader, object);
            TextComponent abilityName = new TextComponent(ModConfigs.ABILITIES.getAbilityById(object.getAbilityId()).map(Skill::getName).orElse(""));
            if (range == null) {
                return null;
            }
            return new TextComponent("").m_130948_(reader.getColoredTextStyle()).m_130946_("Every hit you take has a ").m_7220_((Component)range.m_130948_(reader.getColoredTextStyle())).m_130946_(" chance to cast a level ").m_130946_(String.valueOf(object.getLevel().getMin())).m_130946_(" ").m_7220_((Component)abilityName.m_130948_(reader.getColoredTextStyle()));
        }

        @Override
        public AbilityTriggerOnDamageAttribute generateRandomValue(Config object, Random random) {
            JavaRandom rand = JavaRandom.ofScrambled(random.nextLong());
            float genChance = object.getChance().getRandom(rand);
            int genAmount = object.getLevel().getRandom(rand);
            return new AbilityTriggerOnDamageAttribute(object.getAbilityId(), genChance, genAmount);
        }

        @Override
        public Optional<AbilityTriggerOnDamageAttribute> getMinimumValue(List<Config> configurations) {
            Comparator<Config> cfgCmp = Comparator.comparing(config -> config.getLevel().getMin());
            cfgCmp = cfgCmp.thenComparing(config -> Float.valueOf(config.getChance().getMin()));
            return configurations.stream().min(cfgCmp).map(config -> new AbilityTriggerOnDamageAttribute(config.getAbilityId(), config.getChance().getMin(), config.getLevel().getMin()));
        }

        @Override
        public Optional<AbilityTriggerOnDamageAttribute> getMaximumValue(List<Config> configurations) {
            Comparator<Config> cfgCmp = Comparator.comparing(config -> config.getLevel().getRolledMaximum());
            cfgCmp = cfgCmp.thenComparing(config -> Float.valueOf(config.getChance().getRolledMaximum()));
            return configurations.stream().max(cfgCmp).map(config -> new AbilityTriggerOnDamageAttribute(config.getAbilityId(), config.getChance().getRolledMaximum(), config.getLevel().getRolledMaximum()));
        }

        @Override
        public Optional<Float> getRollPercentage(AbilityTriggerOnDamageAttribute value, List<Config> configurations) {
            return MiscUtils.getFloatValueRange(value.getChance(), this.getMinimumValue(configurations), this.getMaximumValue(configurations), AbilityTriggerOnDamageAttribute::getChance);
        }
    }

    private static class Reader
    extends VaultGearModifierReader<AbilityTriggerOnDamageAttribute> {
        protected Reader() {
            super("", 14901010);
        }

        private Style getHighlightStyle() {
            return Style.f_131099_.m_178520_(0xFFAA00);
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<AbilityTriggerOnDamageAttribute> instance, VaultGearModifier.AffixType type) {
            AbilityTriggerOnDamageAttribute abilityTriggerData = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(abilityTriggerData);
            if (valueDisplay == null) {
                return null;
            }
            TextComponent levelDisplay = new TextComponent(String.valueOf(abilityTriggerData.getLevel()));
            String abilityName = ModConfigs.ABILITIES.getAbilityById(abilityTriggerData.abilityId).map(Skill::getName).orElse("");
            if (abilityName.isEmpty()) {
                return null;
            }
            return new TextComponent(type.getAffixPrefix(abilityTriggerData.getChance() >= 0.0f)).m_130948_(this.getColoredTextStyle()).m_7220_((Component)new TextComponent("Every hit you take has a ").m_130948_(this.getColoredTextStyle())).m_7220_((Component)valueDisplay.m_130948_(this.getHighlightStyle())).m_7220_((Component)new TextComponent(" chance to cast a level ").m_130948_(this.getColoredTextStyle())).m_7220_((Component)levelDisplay.m_130948_(this.getHighlightStyle())).m_7220_((Component)new TextComponent(" " + abilityName).m_130948_(this.getColoredTextStyle()));
        }

        @Override
        @Nullable
        public MutableComponent getValueDisplay(AbilityTriggerOnDamageAttribute value) {
            return new TextComponent(FORMAT.format(value.getChance() * 100.0f) + "%");
        }

        @Override
        protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<AbilityTriggerOnDamageAttribute> instance, VaultGearModifier.AffixType type) {
            AbilityTriggerOnDamageAttribute attribute = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(attribute);
            if (valueDisplay == null) {
                return;
            }
            out.add(type.getAffixPrefix(attribute.getChance() >= 0.0f));
            out.add("Every hit you take has a ");
            out.add(valueDisplay.getString());
            out.add(" chance to cast a level ");
            out.add(String.valueOf(attribute.getLevel()));
            out.add(" " + ModConfigs.ABILITIES.getAbilityById(attribute.abilityId).map(Skill::getName).orElse(""));
        }
    }

    public static class Config {
        @Expose
        private final String abilityId;
        @Expose
        private final FloatRollRangeEntry chance;
        @Expose
        private final IntRollRangeEntry level;

        public Config(String abilityId, FloatRollRangeEntry chance, IntRollRangeEntry level) {
            this.abilityId = abilityId;
            this.chance = chance;
            this.level = level;
        }

        public String getAbilityId() {
            return this.abilityId;
        }

        public FloatRollRangeEntry getChance() {
            return this.chance;
        }

        public IntRollRangeEntry getLevel() {
            return this.level;
        }
    }
}

