/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.custom.effect;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.annotations.Expose;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.custom.effect.IEffectAvoidanceChanceAttribute;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.NetcodeUtils;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.registries.ForgeRegistries;

public class EffectAvoidanceGearAttribute
implements IEffectAvoidanceChanceAttribute {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.##");
    private final MobEffect effect;
    private final float chance;

    public EffectAvoidanceGearAttribute(MobEffect effect, float chance) {
        this.effect = effect;
        this.chance = chance;
    }

    @Override
    public List<MobEffect> getEffects() {
        return Collections.singletonList(this.effect);
    }

    public MobEffect getEffect() {
        return this.effect;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    public String toString() {
        return "EffectAvoidanceGearAttribute{effect=" + (this.effect == null ? "null" : this.effect.getRegistryName().toString()) + ", chance=" + this.chance + "}";
    }

    public static VaultGearAttributeType<EffectAvoidanceGearAttribute> type() {
        return VaultGearAttributeType.of((buf, attribute) -> {
            buf.writeIdentifier(attribute.getEffect().getRegistryName());
            buf.writeFloat(attribute.getChance());
        }, buf -> {
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(buf.readIdentifier());
            return new EffectAvoidanceGearAttribute(effect, buf.readFloat());
        }, (buf, attribute) -> {
            NetcodeUtils.writeIdentifier(buf, attribute.getEffect().getRegistryName());
            buf.writeFloat(attribute.getChance());
        }, buf -> {
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(NetcodeUtils.readIdentifier(buf));
            return new EffectAvoidanceGearAttribute(effect, buf.readFloat());
        }, arg_0 -> ((Gson)VaultGearAttributeType.GSON).toJsonTree(arg_0), EffectAvoidanceGearAttribute::read, EffectAvoidanceGearAttribute::write);
    }

    public static BiFunction<VaultGearModifier<?>, Float, VaultGearModifier<?>> scalingFunction() {
        return (value, scale) -> {
            Object patt3208$temp = value.getValue();
            if (patt3208$temp instanceof EffectAvoidanceGearAttribute) {
                EffectAvoidanceGearAttribute attribute = (EffectAvoidanceGearAttribute)patt3208$temp;
                EffectAvoidanceGearAttribute newAttribute = new EffectAvoidanceGearAttribute(attribute.getEffect(), attribute.getChance() * scale.floatValue());
                return new VaultGearModifier<EffectAvoidanceGearAttribute>(value.getAttribute(), newAttribute);
            }
            return value;
        };
    }

    private static EffectAvoidanceGearAttribute read(Tag nbt) {
        CompoundTag tag = (CompoundTag)nbt;
        MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(tag.m_128461_("effect")));
        float chance = tag.m_128457_("chance");
        return new EffectAvoidanceGearAttribute(effect, chance);
    }

    private static Tag write(EffectAvoidanceGearAttribute attribute) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("effect", attribute.getEffect().getRegistryName().toString());
        tag.m_128350_("chance", attribute.getChance());
        return tag;
    }

    public static AttributeComparator comparator() {
        return new AttributeComparator();
    }

    public static Generator generator() {
        return new Generator();
    }

    public static Reader reader() {
        return new Reader();
    }

    private static class AttributeComparator
    extends VaultGearAttributeComparator<EffectAvoidanceGearAttribute> {
        private AttributeComparator() {
        }

        @Override
        public Optional<EffectAvoidanceGearAttribute> merge(EffectAvoidanceGearAttribute thisValue, EffectAvoidanceGearAttribute thatValue) {
            if (thisValue.getEffect() != thatValue.getEffect()) {
                return Optional.empty();
            }
            return Optional.of(new EffectAvoidanceGearAttribute(thisValue.getEffect(), thisValue.getChance() + thatValue.getChance()));
        }

        @Override
        @Deprecated
        public Optional<EffectAvoidanceGearAttribute> difference(EffectAvoidanceGearAttribute thisValue, EffectAvoidanceGearAttribute thatValue) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Comparator<EffectAvoidanceGearAttribute> getComparator() {
            return Comparator.comparing(EffectAvoidanceGearAttribute::getChance);
        }
    }

    private static class Generator
    extends ConfigurableAttributeGenerator<EffectAvoidanceGearAttribute, Config> {
        private Generator() {
        }

        @Override
        @Nullable
        public Class<Config> getConfigurationObjectClass() {
            return Config.class;
        }

        @Override
        @Nullable
        public MutableComponent getConfigRangeDisplay(VaultGearModifierReader<EffectAvoidanceGearAttribute> reader, Config min, Config max) {
            return this.getChanceDisplay(min.minChance).m_130946_("-").m_7220_((Component)this.getChanceDisplay(max.maxChance));
        }

        private MutableComponent getChanceDisplay(float value) {
            return new TextComponent(FORMAT.format(value * 100.0f) + "%");
        }

        @Override
        @Nullable
        public MutableComponent getConfigDisplay(VaultGearModifierReader<EffectAvoidanceGearAttribute> reader, Config object) {
            MutableComponent range = this.getConfigRangeDisplay(reader, object);
            MobEffect effect = object.getEffect();
            return new TextComponent("").m_130948_(reader.getColoredTextStyle()).m_7220_((Component)range.m_130948_(reader.getColoredTextStyle())).m_130946_(" ").m_7220_(effect.m_19482_()).m_7220_((Component)new TextComponent(" Avoidance"));
        }

        @Override
        public EffectAvoidanceGearAttribute generateRandomValue(Config config, Random random) {
            int steps = Math.round(Math.max(config.maxChance - config.minChance, 0.0f) / config.step) + 1;
            return new EffectAvoidanceGearAttribute(config.getEffect(), config.minChance + (float)random.nextInt(steps) * config.step);
        }

        @Override
        public Optional<EffectAvoidanceGearAttribute> getMinimumValue(List<Config> configurations) {
            return configurations.stream().min(Comparator.comparing(config -> Float.valueOf(config.minChance))).map(config -> new EffectAvoidanceGearAttribute(config.getEffect(), config.minChance));
        }

        private float getMaximumChance(Config config) {
            int steps = Math.round(Math.max(config.maxChance - config.minChance, 0.0f) / config.step);
            return config.minChance + (float)steps * config.step;
        }

        @Override
        public Optional<EffectAvoidanceGearAttribute> getMaximumValue(List<Config> configurations) {
            return configurations.stream().max(Comparator.comparing(this::getMaximumChance)).map(config -> new EffectAvoidanceGearAttribute(config.getEffect(), config.maxChance));
        }

        @Override
        public Optional<Float> getRollPercentage(EffectAvoidanceGearAttribute value, List<Config> configurations) {
            return MiscUtils.getFloatValueRange(value.getChance(), this.getMinimumValue(configurations), this.getMaximumValue(configurations), EffectAvoidanceGearAttribute::getChance);
        }
    }

    private static class Reader
    extends VaultGearModifierReader<EffectAvoidanceGearAttribute> {
        protected Reader() {
            super("", 9561049);
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<EffectAvoidanceGearAttribute> instance, VaultGearModifier.AffixType type) {
            EffectAvoidanceGearAttribute effectAvoidance = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(effectAvoidance);
            if (valueDisplay == null) {
                return null;
            }
            return new TextComponent(type.getAffixPrefix(effectAvoidance.getChance() >= 0.0f)).m_7220_((Component)valueDisplay).m_130946_(" ").m_7220_((Component)new TranslatableComponent("the_vault.gear_attribute.effect_avoidance.avoidance", new Object[]{effectAvoidance.getEffect().m_19482_()})).m_6270_(this.getColoredTextStyle());
        }

        @Override
        @Nullable
        public MutableComponent getValueDisplay(EffectAvoidanceGearAttribute value) {
            return new TextComponent(FORMAT.format(value.getChance() * 100.0f) + "%");
        }

        @Override
        protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<EffectAvoidanceGearAttribute> instance, VaultGearModifier.AffixType type) {
            EffectAvoidanceGearAttribute effectAvoidance = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(effectAvoidance);
            if (valueDisplay == null) {
                return;
            }
            out.add(type.getAffixPrefix(effectAvoidance.getChance() >= 0.0f));
            out.add(valueDisplay.getString());
            out.add(" ");
            out.add(effectAvoidance.getEffect().m_19481_());
            out.add(" Avoidance");
        }
    }

    public static class Config {
        @Expose
        private final ResourceLocation effectKey;
        @Expose
        private final float minChance;
        @Expose
        private final float maxChance;
        @Expose
        private final float step;

        public Config(MobEffect effect, float minChance, float maxChance) {
            this(effect.getRegistryName(), minChance, maxChance, 0.05f);
        }

        public Config(ResourceLocation effectKey, float minChance, float maxChance, float step) {
            this.effectKey = effectKey;
            this.minChance = minChance;
            this.maxChance = maxChance;
            this.step = step;
        }

        private MobEffect getEffect() {
            return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(this.effectKey);
        }
    }
}

