/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.custom.effect;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.annotations.Expose;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.custom.effect.IEffectAvoidanceChanceAttribute;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.NetcodeUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;

public class EffectAvoidanceListGearAttribute
implements IEffectAvoidanceChanceAttribute {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.##");
    private final List<MobEffect> effects;
    private final String name;
    private final float chance;

    public EffectAvoidanceListGearAttribute(List<MobEffect> effects, String name, float chance) {
        this.effects = effects;
        this.name = name;
        this.chance = chance;
    }

    @Override
    public List<MobEffect> getEffects() {
        return Collections.unmodifiableList(this.effects);
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    public String toString() {
        return "EffectAvoidanceListGearAttribute{effects=" + String.valueOf(this.effects) + ", name='" + this.name + "', chance=" + this.chance + "}";
    }

    public static VaultGearAttributeType<EffectAvoidanceListGearAttribute> type() {
        return VaultGearAttributeType.of(EffectAvoidanceListGearAttribute::write, EffectAvoidanceListGearAttribute::read, EffectAvoidanceListGearAttribute::write, EffectAvoidanceListGearAttribute::read, arg_0 -> ((Gson)VaultGearAttributeType.GSON).toJsonTree(arg_0), EffectAvoidanceListGearAttribute::read, EffectAvoidanceListGearAttribute::write);
    }

    public static BiFunction<VaultGearModifier<?>, Float, VaultGearModifier<?>> scalingFunction() {
        return (value, scale) -> {
            Object patt2984$temp = value.getValue();
            if (patt2984$temp instanceof EffectAvoidanceListGearAttribute) {
                EffectAvoidanceListGearAttribute attribute = (EffectAvoidanceListGearAttribute)patt2984$temp;
                EffectAvoidanceListGearAttribute newAttribute = new EffectAvoidanceListGearAttribute(attribute.getEffects(), attribute.name, attribute.getChance() * scale.floatValue());
                return new VaultGearModifier<EffectAvoidanceListGearAttribute>(value.getAttribute(), newAttribute);
            }
            return value;
        };
    }

    private static EffectAvoidanceListGearAttribute read(ByteBuf buf) {
        int size = buf.readInt();
        ArrayList<MobEffect> effects = new ArrayList<MobEffect>(size);
        for (int i = 0; i < size; ++i) {
            effects.add((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(NetcodeUtils.readIdentifier(buf)));
        }
        effects.removeIf(Objects::isNull);
        String name = NetcodeUtils.readString(buf);
        float chance = buf.readFloat();
        return new EffectAvoidanceListGearAttribute(effects, name, chance);
    }

    private static void write(ByteBuf buf, EffectAvoidanceListGearAttribute attribute) {
        buf.writeInt(attribute.effects.size());
        for (MobEffect effect : attribute.effects) {
            NetcodeUtils.writeIdentifier(buf, effect.getRegistryName());
        }
        NetcodeUtils.writeString(buf, attribute.name);
        buf.writeFloat(attribute.chance);
    }

    private static EffectAvoidanceListGearAttribute read(BitBuffer buf) {
        int size = buf.readInt();
        ArrayList<MobEffect> effects = new ArrayList<MobEffect>(size);
        for (int i = 0; i < size; ++i) {
            effects.add((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(buf.readString())));
        }
        effects.removeIf(Objects::isNull);
        String name = buf.readString();
        float chance = buf.readFloat();
        return new EffectAvoidanceListGearAttribute(effects, name, chance);
    }

    private static void write(BitBuffer buf, EffectAvoidanceListGearAttribute attribute) {
        buf.writeInt(attribute.effects.size());
        for (MobEffect effect : attribute.effects) {
            buf.writeString(effect.getRegistryName().toString());
        }
        buf.writeString(attribute.name);
        buf.writeFloat(attribute.chance);
    }

    private static EffectAvoidanceListGearAttribute read(Tag nbt) {
        CompoundTag tag = (CompoundTag)nbt;
        ArrayList<MobEffect> effects = new ArrayList<MobEffect>();
        ListTag effectList = tag.m_128437_("effects", 8);
        for (Tag effectTag : effectList) {
            effects.add((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectTag.m_7916_())));
        }
        String name = tag.m_128461_("name");
        float chance = tag.m_128457_("chance");
        return new EffectAvoidanceListGearAttribute(effects, name, chance);
    }

    private static Tag write(EffectAvoidanceListGearAttribute attribute) {
        CompoundTag tag = new CompoundTag();
        ListTag effectList = new ListTag();
        for (MobEffect effect : attribute.getEffects()) {
            effectList.add((Object)StringTag.m_129297_((String)effect.getRegistryName().toString()));
        }
        tag.m_128365_("effects", (Tag)effectList);
        tag.m_128359_("name", attribute.name);
        tag.m_128350_("chance", attribute.getChance());
        return tag;
    }

    public static AttributeComparator comparator() {
        return new AttributeComparator();
    }

    public static Generator generator() {
        return new Generator();
    }

    public static Reader reader() {
        return new Reader();
    }

    private static class AttributeComparator
    extends VaultGearAttributeComparator<EffectAvoidanceListGearAttribute> {
        private AttributeComparator() {
        }

        @Override
        public Optional<EffectAvoidanceListGearAttribute> merge(EffectAvoidanceListGearAttribute thisValue, EffectAvoidanceListGearAttribute thatValue) {
            HashSet<MobEffect> thatSet;
            HashSet<MobEffect> thisSet = new HashSet<MobEffect>(thisValue.getEffects());
            if (!thisSet.containsAll(thatSet = new HashSet<MobEffect>(thatValue.getEffects())) && !thatSet.containsAll(thisSet)) {
                return Optional.empty();
            }
            if (!thisValue.name.equals(thatValue.name)) {
                return Optional.empty();
            }
            return Optional.of(new EffectAvoidanceListGearAttribute(thisValue.getEffects(), thisValue.name, thisValue.getChance() + thatValue.getChance()));
        }

        @Override
        @Deprecated
        public Optional<EffectAvoidanceListGearAttribute> difference(EffectAvoidanceListGearAttribute thisValue, EffectAvoidanceListGearAttribute thatValue) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Comparator<EffectAvoidanceListGearAttribute> getComparator() {
            return Comparator.comparing(EffectAvoidanceListGearAttribute::getChance);
        }
    }

    private static class Generator
    extends ConfigurableAttributeGenerator<EffectAvoidanceListGearAttribute, Config> {
        private Generator() {
        }

        @Override
        @Nullable
        public Class<Config> getConfigurationObjectClass() {
            return Config.class;
        }

        @Override
        @Nullable
        public MutableComponent getConfigRangeDisplay(VaultGearModifierReader<EffectAvoidanceListGearAttribute> reader, Config min, Config max) {
            return this.getChanceDisplay(min.minChance).m_130946_("-").m_7220_((Component)this.getChanceDisplay(max.maxChance));
        }

        private MutableComponent getChanceDisplay(float value) {
            return new TextComponent(FORMAT.format(value * 100.0f) + "%");
        }

        @Override
        @Nullable
        public MutableComponent getConfigDisplay(VaultGearModifierReader<EffectAvoidanceListGearAttribute> reader, Config object) {
            MutableComponent range = this.getConfigRangeDisplay(reader, object);
            return new TextComponent("").m_130948_(reader.getColoredTextStyle()).m_7220_((Component)range.m_130948_(reader.getColoredTextStyle())).m_130946_(" ").m_7220_((Component)new TranslatableComponent("the_vault.gear_attribute.effect_avoidance.avoidance", new Object[]{new TranslatableComponent(object.name)}));
        }

        @Override
        public EffectAvoidanceListGearAttribute generateRandomValue(Config config, Random random) {
            int steps = Math.round(Math.max(config.maxChance - config.minChance, 0.0f) / config.step) + 1;
            return new EffectAvoidanceListGearAttribute(config.getEffects(), config.name, config.minChance + (float)random.nextInt(steps) * config.step);
        }

        @Override
        public Optional<EffectAvoidanceListGearAttribute> getMinimumValue(List<Config> configurations) {
            return configurations.stream().min(Comparator.comparing(config -> Float.valueOf(config.minChance))).map(config -> new EffectAvoidanceListGearAttribute(config.getEffects(), config.name, config.minChance));
        }

        private float getMaximumChance(Config config) {
            int steps = Math.round(Math.max(config.maxChance - config.minChance, 0.0f) / config.step);
            return config.minChance + (float)steps * config.step;
        }

        @Override
        public Optional<EffectAvoidanceListGearAttribute> getMaximumValue(List<Config> configurations) {
            return configurations.stream().max(Comparator.comparing(this::getMaximumChance)).map(config -> new EffectAvoidanceListGearAttribute(config.getEffects(), config.name, config.maxChance));
        }

        @Override
        public Optional<Float> getRollPercentage(EffectAvoidanceListGearAttribute value, List<Config> configurations) {
            return MiscUtils.getFloatValueRange(value.getChance(), this.getMinimumValue(configurations), this.getMaximumValue(configurations), EffectAvoidanceListGearAttribute::getChance);
        }
    }

    private static class Reader
    extends VaultGearModifierReader<EffectAvoidanceListGearAttribute> {
        protected Reader() {
            super("", 9561049);
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<EffectAvoidanceListGearAttribute> instance, VaultGearModifier.AffixType type) {
            EffectAvoidanceListGearAttribute effectAvoidance = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(effectAvoidance);
            if (valueDisplay == null) {
                return null;
            }
            return new TextComponent(type.getAffixPrefix(effectAvoidance.getChance() >= 0.0f)).m_7220_((Component)valueDisplay).m_130946_(" ").m_7220_((Component)new TranslatableComponent("the_vault.gear_attribute.effect_avoidance.avoidance", new Object[]{new TranslatableComponent(effectAvoidance.name)})).m_6270_(this.getColoredTextStyle());
        }

        @Override
        @Nullable
        public MutableComponent getValueDisplay(EffectAvoidanceListGearAttribute value) {
            return new TextComponent(FORMAT.format(value.getChance() * 100.0f) + "%");
        }

        @Override
        protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<EffectAvoidanceListGearAttribute> instance, VaultGearModifier.AffixType type) {
            EffectAvoidanceListGearAttribute effectAvoidance = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(effectAvoidance);
            if (valueDisplay == null) {
                return;
            }
            out.add(type.getAffixPrefix(effectAvoidance.getChance() >= 0.0f));
            out.add(valueDisplay.getString());
            out.add(" ");
            out.add(effectAvoidance.name);
            out.add(" Avoidance");
        }
    }

    public static class Config {
        @Expose
        private final List<ResourceLocation> effectKeys;
        @Expose
        private final String name;
        @Expose
        private final float minChance;
        @Expose
        private final float maxChance;
        @Expose
        private final float step;

        public Config(List<MobEffect> effects, String name, float minChance, float maxChance) {
            this(Config.keys(effects), name, minChance, maxChance, 0.05f);
        }

        public Config(List<ResourceLocation> effectKeys, String name, float minChance, float maxChance, float step) {
            this.effectKeys = effectKeys;
            this.name = name;
            this.minChance = minChance;
            this.maxChance = maxChance;
            this.step = step;
        }

        private static List<ResourceLocation> keys(List<MobEffect> effects) {
            return effects.stream().map(ForgeRegistryEntry::getRegistryName).collect(Collectors.toList());
        }

        private List<MobEffect> getEffects() {
            return this.effectKeys.stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.MOB_EFFECTS).getValue(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }
}

