/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.custom.effect;

import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.annotations.Expose;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.entity.entity.EffectCloudEntity;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.NetcodeUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;

public class EffectCloudAttribute {
    private final EffectCloud effectCloud;

    public EffectCloudAttribute(EffectCloud effectCloud) {
        this.effectCloud = effectCloud;
    }

    public void apply(EffectCloudEntity entity) {
        this.effectCloud.apply(entity);
    }

    public float getTriggerChance() {
        return this.effectCloud.getTriggerChance();
    }

    @Nullable
    public MobEffect getPrimaryEffect() {
        AdditionalCloudEffect first = (AdditionalCloudEffect)Iterables.getFirst(this.effectCloud.additionalEffects, null);
        if (first == null) {
            return null;
        }
        return first.effect;
    }

    public static VaultGearAttributeType<EffectCloudAttribute> type() {
        return VaultGearAttributeType.of((buf, effect) -> effect.effectCloud.write((BitBuffer)buf), buf -> new EffectCloudAttribute(EffectCloud.read(buf)), (buf, effect) -> effect.effectCloud.netWrite((ByteBuf)buf), buf -> new EffectCloudAttribute(EffectCloud.netRead(buf)), arg_0 -> ((Gson)VaultGearAttributeType.GSON).toJsonTree(arg_0), EffectCloudAttribute::read, EffectCloudAttribute::write);
    }

    public static BiFunction<VaultGearModifier<?>, Float, VaultGearModifier<?>> scalingFunction() {
        return (value, scale) -> {
            Object patt2723$temp = value.getValue();
            if (patt2723$temp instanceof EffectCloudAttribute) {
                EffectCloudAttribute attribute = (EffectCloudAttribute)patt2723$temp;
                EffectCloud cloud = attribute.effectCloud;
                EffectCloud newCloud = new EffectCloud(cloud.tooltip, (int)((float)cloud.duration * scale.floatValue()), cloud.radius * scale.floatValue(), cloud.color, cloud.affectsOwner, cloud.triggerChance * scale.floatValue());
                for (AdditionalCloudEffect effect : cloud.additionalEffects) {
                    newCloud.addEffect(new AdditionalCloudEffect(effect.effect, (int)((float)effect.duration * scale.floatValue()), effect.amplifier));
                }
                EffectCloudAttribute newAttribute = new EffectCloudAttribute(newCloud);
                return new VaultGearModifier<EffectCloudAttribute>(value.getAttribute(), newAttribute);
            }
            return value;
        };
    }

    private static EffectCloudAttribute read(Tag nbt) {
        CompoundTag tag = (CompoundTag)nbt;
        EffectCloud cloud = new EffectCloud();
        cloud.tooltip = tag.m_128461_("tooltip");
        cloud.duration = tag.m_128451_("duration");
        cloud.radius = tag.m_128457_("radius");
        cloud.color = new Color(tag.m_128451_("color"), true);
        cloud.affectsOwner = tag.m_128471_("affectsOwner");
        cloud.triggerChance = tag.m_128457_("triggerChance");
        ListTag effects = tag.m_128437_("effects", 10);
        for (int i = 0; i < effects.size(); ++i) {
            CompoundTag effectTag = effects.m_128728_(i);
            AdditionalCloudEffect effect = new AdditionalCloudEffect();
            effect.effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectTag.m_128461_("effect")));
            effect.amplifier = effectTag.m_128451_("amplifier");
            effect.duration = effectTag.m_128451_("duration");
            cloud.additionalEffects.add(effect);
        }
        return new EffectCloudAttribute(cloud);
    }

    private static Tag write(EffectCloudAttribute attribute) {
        EffectCloud cloud = attribute.effectCloud;
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("tooltip", cloud.tooltip);
        tag.m_128405_("duration", cloud.duration);
        tag.m_128350_("radius", cloud.radius);
        tag.m_128405_("color", cloud.color.getRGB());
        tag.m_128379_("affectsOwner", cloud.affectsOwner);
        tag.m_128350_("triggerChance", cloud.triggerChance);
        ListTag effects = new ListTag();
        cloud.additionalEffects.forEach(effect -> {
            CompoundTag effectTag = new CompoundTag();
            effectTag.m_128359_("effect", effect.effect.getRegistryName().toString());
            effectTag.m_128405_("amplifier", effect.amplifier);
            effectTag.m_128405_("duration", effect.duration);
            effects.add((Object)effectTag);
        });
        tag.m_128365_("effects", (Tag)effects);
        return tag;
    }

    public static Generator generator() {
        return new Generator();
    }

    public static Reader reader(boolean whenHit) {
        return new Reader(whenHit);
    }

    public static AttributeComparator comparator() {
        return new AttributeComparator();
    }

    public static class EffectCloud {
        private String tooltip;
        private List<AdditionalCloudEffect> additionalEffects = new ArrayList<AdditionalCloudEffect>();
        private int duration;
        private float radius;
        private Color color;
        private boolean affectsOwner;
        private float triggerChance;

        private EffectCloud() {
        }

        public EffectCloud(String tooltip, int duration, float radius, Color color, boolean affectsOwner, float triggerChance) {
            this.tooltip = tooltip;
            this.duration = duration;
            this.radius = radius;
            this.color = color;
            this.affectsOwner = affectsOwner;
            this.triggerChance = triggerChance;
        }

        public static EffectCloud fromConfig(CloudConfig config) {
            EffectCloud cloud = new EffectCloud(config.tooltipDisplayName, config.duration, config.radius, new Color(config.color, true), config.affectsOwner, config.triggerChance);
            for (CloudEffectConfig effectConfig : config.additionalEffects) {
                cloud.addEffect(AdditionalCloudEffect.fromConfig(effectConfig));
            }
            return cloud;
        }

        public EffectCloud addEffect(AdditionalCloudEffect additionalEffect) {
            this.additionalEffects.add(additionalEffect);
            return this;
        }

        public float getTriggerChance() {
            return this.triggerChance;
        }

        public void apply(EffectCloudEntity entity) {
            entity.setDuration(this.duration);
            entity.setRadius(this.radius);
            entity.setColor(this.color.getRGB());
            entity.setAffectsOwner(this.affectsOwner);
            this.additionalEffects.forEach(additionalCloudEffect -> entity.addEffect(additionalCloudEffect.makeEffect()));
        }

        private void write(BitBuffer buffer) {
            buffer.writeString(this.tooltip);
            buffer.writeInt(this.duration);
            buffer.writeFloat(this.radius);
            buffer.writeInt(this.color.getRGB());
            buffer.writeBoolean(this.affectsOwner);
            buffer.writeFloat(this.triggerChance);
            buffer.writeCollection(this.additionalEffects, AdditionalCloudEffect::write);
        }

        private static EffectCloud read(BitBuffer buffer) {
            EffectCloud cloud = new EffectCloud();
            cloud.tooltip = buffer.readString();
            cloud.duration = buffer.readInt();
            cloud.radius = buffer.readFloat();
            cloud.color = new Color(buffer.readInt(), true);
            cloud.affectsOwner = buffer.readBoolean();
            cloud.triggerChance = buffer.readFloat();
            cloud.additionalEffects = buffer.readCollection(ArrayList::new, AdditionalCloudEffect::read);
            return cloud;
        }

        private void netWrite(ByteBuf buffer) {
            NetcodeUtils.writeString(buffer, this.tooltip);
            buffer.writeInt(this.duration);
            buffer.writeFloat(this.radius);
            buffer.writeInt(this.color.getRGB());
            buffer.writeBoolean(this.affectsOwner);
            buffer.writeFloat(this.triggerChance);
            NetcodeUtils.writeCollection(buffer, this.additionalEffects, AdditionalCloudEffect::netWrite);
        }

        private static EffectCloud netRead(ByteBuf buffer) {
            EffectCloud cloud = new EffectCloud();
            cloud.tooltip = NetcodeUtils.readString(buffer);
            cloud.duration = buffer.readInt();
            cloud.radius = buffer.readFloat();
            cloud.color = new Color(buffer.readInt(), true);
            cloud.affectsOwner = buffer.readBoolean();
            cloud.triggerChance = buffer.readFloat();
            cloud.additionalEffects = NetcodeUtils.readCollection(buffer, ArrayList::new, AdditionalCloudEffect::netRead);
            return cloud;
        }
    }

    public static class AdditionalCloudEffect {
        private MobEffect effect;
        private int duration;
        private int amplifier;

        private AdditionalCloudEffect() {
        }

        public AdditionalCloudEffect(MobEffect effect, int duration, int amplifier) {
            this.effect = effect;
            this.duration = duration;
            this.amplifier = amplifier;
        }

        private static AdditionalCloudEffect fromConfig(CloudEffectConfig config) {
            return new AdditionalCloudEffect((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(config.effect), config.duration, config.amplifier);
        }

        public MobEffectInstance makeEffect() {
            return new MobEffectInstance(this.effect, this.duration, this.amplifier, false, false, true);
        }

        public void write(BitBuffer buffer) {
            buffer.writeIdentifier(this.effect.getRegistryName());
            buffer.writeInt(this.duration);
            buffer.writeInt(this.amplifier);
        }

        private static AdditionalCloudEffect read(BitBuffer buffer) {
            AdditionalCloudEffect effect = new AdditionalCloudEffect();
            effect.effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(buffer.readIdentifier());
            effect.duration = buffer.readInt();
            effect.amplifier = buffer.readInt();
            return effect;
        }

        public void netWrite(ByteBuf buffer) {
            NetcodeUtils.writeIdentifier(buffer, this.effect.getRegistryName());
            buffer.writeInt(this.duration);
            buffer.writeInt(this.amplifier);
        }

        private static AdditionalCloudEffect netRead(ByteBuf buffer) {
            AdditionalCloudEffect effect = new AdditionalCloudEffect();
            effect.effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(NetcodeUtils.readIdentifier(buffer));
            effect.duration = buffer.readInt();
            effect.amplifier = buffer.readInt();
            return effect;
        }
    }

    private static class Generator
    extends ConfigurableAttributeGenerator<EffectCloudAttribute, CloudConfig> {
        private Generator() {
        }

        @Override
        @Nullable
        public Class<CloudConfig> getConfigurationObjectClass() {
            return CloudConfig.class;
        }

        @Override
        public EffectCloudAttribute generateRandomValue(CloudConfig object, Random random) {
            return new EffectCloudAttribute(EffectCloud.fromConfig(object));
        }

        @Override
        @Nullable
        public MutableComponent getConfigDisplay(VaultGearModifierReader<EffectCloudAttribute> reader, CloudConfig object) {
            return reader.getValueDisplay(new EffectCloudAttribute(EffectCloud.fromConfig(object)));
        }

        @Override
        public Optional<EffectCloudAttribute> getMinimumValue(List<CloudConfig> configurations) {
            return configurations.stream().min(Comparator.comparing(config -> config.additionalEffects.stream().mapToInt(effect -> effect.amplifier).sum())).map(EffectCloud::fromConfig).map(EffectCloudAttribute::new);
        }

        @Override
        public Optional<EffectCloudAttribute> getMaximumValue(List<CloudConfig> configurations) {
            return configurations.stream().max(Comparator.comparing(config -> config.additionalEffects.stream().mapToInt(effect -> effect.amplifier).sum())).map(EffectCloud::fromConfig).map(EffectCloudAttribute::new);
        }

        @Override
        public Optional<Float> getRollPercentage(EffectCloudAttribute value, List<CloudConfig> configurations) {
            return MiscUtils.getIntValueRange(this.getAmplifierSum(value), this.getMinimumValue(configurations), this.getMaximumValue(configurations), this::getAmplifierSum);
        }

        private int getAmplifierSum(EffectCloudAttribute attribute) {
            return attribute.effectCloud.additionalEffects.stream().mapToInt(effect -> effect.amplifier).sum();
        }
    }

    private static class Reader
    extends VaultGearModifierReader<EffectCloudAttribute> {
        private final boolean isWhenHit;

        protected Reader(boolean isWhenHit) {
            super(isWhenHit ? "Effect Cloud when Hit" : "Effect Cloud", 15007916);
            this.isWhenHit = isWhenHit;
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<EffectCloudAttribute> instance, VaultGearModifier.AffixType type) {
            MutableComponent valueDisplay = this.getValueDisplay(instance.getValue());
            if (valueDisplay == null) {
                return null;
            }
            return new TextComponent(type.getAffixPrefix(true)).m_7220_((Component)valueDisplay).m_6270_(this.getColoredTextStyle());
        }

        @Override
        @Nullable
        public MutableComponent getValueDisplay(EffectCloudAttribute value) {
            return new TextComponent(value.effectCloud.tooltip + " Cloud" + (this.isWhenHit ? " when Hit" : ""));
        }

        @Override
        protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<EffectCloudAttribute> instance, VaultGearModifier.AffixType type) {
            MutableComponent valueDisplay = this.getValueDisplay(instance.getValue());
            if (valueDisplay == null) {
                return;
            }
            out.add(type.getAffixPrefix(true));
            out.add(valueDisplay.getString());
        }
    }

    private static class AttributeComparator
    extends VaultGearAttributeComparator<EffectCloudAttribute> {
        private AttributeComparator() {
        }

        @Override
        public Optional<EffectCloudAttribute> merge(EffectCloudAttribute thisValue, EffectCloudAttribute thatValue) {
            return Optional.empty();
        }

        @Override
        @Deprecated
        public Optional<EffectCloudAttribute> difference(EffectCloudAttribute thisValue, EffectCloudAttribute thatValue) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Comparator<EffectCloudAttribute> getComparator() {
            return Comparator.comparing(attribute -> attribute.effectCloud.additionalEffects.stream().mapToInt(effect -> effect.amplifier).sum()).thenComparing(attribute -> Float.valueOf(attribute.effectCloud.triggerChance)).thenComparing(attribute -> attribute.effectCloud.duration);
        }
    }

    public static class CloudEffectConfig {
        @Expose
        private ResourceLocation effect;
        @Expose
        private int duration;
        @Expose
        private int amplifier;

        public CloudEffectConfig(ResourceLocation effect, int duration, int amplifier) {
            this.effect = effect;
            this.duration = duration;
            this.amplifier = amplifier;
        }
    }

    public static class CloudConfig {
        @Expose
        private String tooltipDisplayName;
        @Expose
        private ResourceLocation potion;
        @Expose
        private List<CloudEffectConfig> additionalEffects = new ArrayList<CloudEffectConfig>();
        @Expose
        private int duration;
        @Expose
        private float radius;
        @Expose
        private int color;
        @Expose
        private boolean affectsOwner;
        @Expose
        private float triggerChance;

        public CloudConfig(String tooltipDisplayName, ResourceLocation potion, int duration, float radius, int color, boolean affectsOwner, float triggerChance) {
            this.tooltipDisplayName = tooltipDisplayName;
            this.potion = potion;
            this.duration = duration;
            this.radius = radius;
            this.color = color;
            this.affectsOwner = affectsOwner;
            this.triggerChance = triggerChance;
        }

        public void setAdditionalEffect(CloudEffectConfig config) {
            this.additionalEffects.add(config);
        }
    }
}

