/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.custom.effect;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.annotations.Expose;
import iskallia.vault.config.entry.IntRollRangeEntry;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.entity.entity.EffectCloudEntity;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModParticles;
import iskallia.vault.util.NetcodeUtils;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class EffectTrialAttribute {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.##");
    private final ResourceLocation effectId;
    private final int durationTicks;

    protected EffectTrialAttribute(ResourceLocation effectId, int durationTicks) {
        this.effectId = effectId;
        this.durationTicks = durationTicks;
    }

    public ResourceLocation getEffectId() {
        return this.effectId;
    }

    public int getDurationTicks() {
        return this.durationTicks;
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.f_19853_.f_46443_ || !(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (serverPlayer.m_21255_()) {
            return;
        }
        if (!serverPlayer.m_20096_()) {
            return;
        }
        NonNullList armorSlots = serverPlayer.m_150109_().f_35975_;
        int duration = 0;
        for (ItemStack stack : armorSlots) {
            Optional<EffectTrialAttribute> instance;
            VaultGearData data;
            if (!(stack.m_41720_() instanceof VaultGearItem) || !(data = VaultGearData.read(stack)).hasAttribute(ModGearAttributes.EFFECT_TRAIL) || !(instance = data.getFirstValue(ModGearAttributes.EFFECT_TRAIL)).isPresent()) continue;
            duration = Math.max(duration, instance.get().getDurationTicks());
        }
        if (duration > 0) {
            BlockPos pos = event.player.m_142538_();
            EffectCloudEntity entity = new EffectCloudEntity(event.player.f_19853_, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            entity.addEffect(new MobEffectInstance(ModEffects.CHILLED, duration));
            entity.setRadius(0.5f);
            entity.setRadiusOnUse(-0.5f);
            entity.setDuration(duration);
            entity.setParticleData((ParticleOptions)ModParticles.CLOUD_EFFECT.get());
            entity.setOwner((LivingEntity)serverPlayer);
            entity.setAffectsOwner(false);
            event.player.f_19853_.m_7967_((Entity)entity);
        }
    }

    public static VaultGearAttributeType<EffectTrialAttribute> type() {
        return VaultGearAttributeType.of((buf, attribute) -> {
            buf.writeIdentifier(attribute.getEffectId());
            buf.writeInt(attribute.getDurationTicks());
        }, buf -> new EffectTrialAttribute(buf.readIdentifier(), buf.readInt()), (buf, attribute) -> {
            NetcodeUtils.writeIdentifier(buf, attribute.getEffectId());
            buf.writeInt(attribute.getDurationTicks());
        }, buf -> new EffectTrialAttribute(NetcodeUtils.readIdentifier(buf), buf.readInt()), arg_0 -> ((Gson)VaultGearAttributeType.GSON).toJsonTree(arg_0), tag -> {
            CompoundTag ctag = new CompoundTag();
            ResourceLocation effectId = new ResourceLocation(ctag.m_128461_("effectId"));
            int durationTicks = ctag.m_128451_("durationTicks");
            return new EffectTrialAttribute(effectId, durationTicks);
        }, attribute -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("effectId", attribute.getEffectId().toString());
            tag.m_128405_("durationTicks", attribute.getDurationTicks());
            return tag;
        });
    }

    public static AttributeComparator comparator() {
        return new AttributeComparator();
    }

    public static Generator generator() {
        return new Generator();
    }

    public static Reader reader() {
        return new Reader();
    }

    private static class AttributeComparator
    extends VaultGearAttributeComparator<EffectTrialAttribute> {
        private AttributeComparator() {
        }

        @Override
        public Optional<EffectTrialAttribute> merge(EffectTrialAttribute a, EffectTrialAttribute b) {
            return Optional.of(new EffectTrialAttribute(b.getEffectId(), Math.max(a.getDurationTicks(), b.getDurationTicks())));
        }

        @Override
        public Optional<EffectTrialAttribute> difference(EffectTrialAttribute a, EffectTrialAttribute b) {
            return Optional.empty();
        }

        @Override
        public Comparator<EffectTrialAttribute> getComparator() {
            return Comparator.comparingInt(EffectTrialAttribute::getDurationTicks);
        }
    }

    public static class Generator
    extends ConfigurableAttributeGenerator<EffectTrialAttribute, Config> {
        @Override
        @Nullable
        public Class<Config> getConfigurationObjectClass() {
            return Config.class;
        }

        @Override
        @Nullable
        public MutableComponent getConfigRangeDisplay(VaultGearModifierReader<EffectTrialAttribute> reader, Config min, Config max) {
            return new TextComponent((double)min.getDurationTicks().getMin() / 20.0 + "-" + (double)max.getDurationTicks().getMax() / 20.0 + "s");
        }

        @Override
        @Nullable
        public MutableComponent getConfigDisplay(VaultGearModifierReader<EffectTrialAttribute> reader, Config object) {
            return this.getConfigRangeDisplay(reader, object, object);
        }

        @Override
        public EffectTrialAttribute generateRandomValue(Config object, Random random) {
            JavaRandom rand = JavaRandom.ofScrambled(random.nextLong());
            int duration = object.getDurationTicks().getRandom(rand);
            return new EffectTrialAttribute(object.getEffectId(), duration);
        }

        @Override
        public Optional<EffectTrialAttribute> getMinimumValue(List<Config> configurations) {
            return configurations.stream().min(Comparator.comparingInt(cfg -> cfg.getDurationTicks().getMin())).map(cfg -> new EffectTrialAttribute(cfg.getEffectId(), cfg.getDurationTicks().getMin()));
        }

        @Override
        public Optional<EffectTrialAttribute> getMaximumValue(List<Config> configurations) {
            return configurations.stream().max(Comparator.comparingInt(cfg -> cfg.getDurationTicks().getMax())).map(cfg -> new EffectTrialAttribute(cfg.getEffectId(), cfg.getDurationTicks().getMax()));
        }
    }

    private static class Reader
    extends VaultGearModifierReader<EffectTrialAttribute> {
        protected Reader() {
            super("", 14901010);
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<EffectTrialAttribute> instance, VaultGearModifier.AffixType type) {
            EffectTrialAttribute value = instance.getValue();
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(value.getEffectId());
            if (effect == null) {
                return null;
            }
            return type.getAffixPrefixComponent(true).m_7220_((Component)new TextComponent("Leaves a trail of ")).m_7220_((Component)new TranslatableComponent(effect.m_19481_()).m_130948_(Style.f_131099_.m_178520_(0xFFAA00))).m_7220_((Component)new TextComponent(" for ")).m_7220_((Component)new TextComponent(FORMAT.format((double)value.getDurationTicks() / 20.0) + "s").m_130948_(Style.f_131099_.m_178520_(0xFFAA00))).m_6270_(this.getColoredTextStyle());
        }

        @Override
        @Nullable
        public MutableComponent getValueDisplay(EffectTrialAttribute value) {
            return new TextComponent(FORMAT.format((double)value.getDurationTicks() / 20.0) + "s");
        }

        @Override
        protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<EffectTrialAttribute> instance, VaultGearModifier.AffixType type) {
            EffectTrialAttribute value = instance.getValue();
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(value.getEffectId());
            if (effect == null) {
                return;
            }
            out.add(type.getAffixPrefix(true));
            out.add("Leaves a trail of ");
            out.add(effect.m_19482_().getString());
            out.add(" for ");
            out.add(FORMAT.format((double)instance.getValue().getDurationTicks() / 20.0) + "s");
        }
    }

    public static class Config {
        @Expose
        private final IntRollRangeEntry durationTicks;
        @Expose
        private final ResourceLocation effectId;

        public Config(ResourceLocation effectId, IntRollRangeEntry durationTicks) {
            this.durationTicks = durationTicks;
            this.effectId = effectId;
        }

        public IntRollRangeEntry getDurationTicks() {
            return this.durationTicks;
        }

        public ResourceLocation getEffectId() {
            return this.effectId;
        }
    }
}

