/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.custom.loot;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.annotations.Expose;
import iskallia.vault.config.entry.FloatRollRangeEntry;
import iskallia.vault.config.entry.IntRollRangeEntry;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.custom.loot.LootTriggerAttribute;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.mana.Mana;
import iskallia.vault.mana.ManaAction;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.NetcodeUtils;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ManaPerLootAttribute
extends LootTriggerAttribute {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.##");
    private final float manaGenerationChance;
    private final int manaGenerated;

    public ManaPerLootAttribute(ResourceLocation tileGroupId, String displayName, float manaGenerationChance, int manaGenerated) {
        super(tileGroupId, displayName);
        this.manaGenerationChance = manaGenerationChance;
        this.manaGenerated = manaGenerated;
    }

    public float getManaGenerationChance() {
        return this.manaGenerationChance;
    }

    public int getManaGenerated() {
        return this.manaGenerated;
    }

    @Override
    public void trigger(BlockEntity tile, RandomSource random, ServerPlayer player) {
        if (random.nextFloat() < this.getManaGenerationChance()) {
            Mana.increase((Player)player, ManaAction.PLAYER_ACTION, this.getManaGenerated());
        }
    }

    public String toString() {
        return "ManaPerLootAttribute{tileGroupId=" + String.valueOf(this.getTileGroupId()) + ", displayName='" + this.getDisplayName() + "', manaGenerationChance=" + this.manaGenerationChance + ", manaGenerated=" + this.manaGenerated + "}";
    }

    public static VaultGearAttributeType<ManaPerLootAttribute> type() {
        return VaultGearAttributeType.of((buf, attribute) -> {
            buf.writeIdentifier(attribute.getTileGroupId());
            buf.writeString(attribute.getDisplayName());
            buf.writeFloat(attribute.getManaGenerationChance());
            buf.writeInt(attribute.getManaGenerated());
        }, buf -> new ManaPerLootAttribute(buf.readIdentifier(), buf.readString(), buf.readFloat(), buf.readInt()), (buf, attribute) -> {
            NetcodeUtils.writeIdentifier(buf, attribute.getTileGroupId());
            NetcodeUtils.writeString(buf, attribute.getDisplayName());
            buf.writeFloat(attribute.getManaGenerationChance());
            buf.writeInt(attribute.getManaGenerated());
        }, buf -> new ManaPerLootAttribute(NetcodeUtils.readIdentifier(buf), NetcodeUtils.readString(buf), buf.readFloat(), buf.readInt()), arg_0 -> ((Gson)VaultGearAttributeType.GSON).toJsonTree(arg_0), tag -> {
            CompoundTag compoundTag = (CompoundTag)tag;
            ResourceLocation tileGroupId = new ResourceLocation(compoundTag.m_128461_("tileGroupId"));
            String displayName = compoundTag.m_128461_("displayName");
            float manaGenerationChance = compoundTag.m_128457_("manaGenerationChance");
            int manaGenerated = compoundTag.m_128451_("manaGenerated");
            return new ManaPerLootAttribute(tileGroupId, displayName, manaGenerationChance, manaGenerated);
        }, attribute -> {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("tileGroupId", attribute.getTileGroupId().toString());
            compoundTag.m_128359_("displayName", attribute.getDisplayName());
            compoundTag.m_128350_("manaGenerationChance", attribute.getManaGenerationChance());
            compoundTag.m_128405_("manaGenerated", attribute.getManaGenerated());
            return compoundTag;
        });
    }

    public static AttributeComparator comparator() {
        return new AttributeComparator();
    }

    public static Generator generator() {
        return new Generator();
    }

    public static Reader reader() {
        return new Reader();
    }

    private static class AttributeComparator
    extends VaultGearAttributeComparator<ManaPerLootAttribute> {
        private AttributeComparator() {
        }

        @Override
        public Optional<ManaPerLootAttribute> merge(ManaPerLootAttribute thisValue, ManaPerLootAttribute thatValue) {
            if (!Objects.equals(thisValue.getTileGroupId(), thatValue.getTileGroupId())) {
                return Optional.empty();
            }
            if (thisValue.getManaGenerated() != thatValue.getManaGenerated()) {
                return Optional.empty();
            }
            return Optional.of(new ManaPerLootAttribute(thisValue.getTileGroupId(), thisValue.getDisplayName(), thisValue.getManaGenerationChance() + thatValue.getManaGenerationChance(), thisValue.getManaGenerated()));
        }

        @Override
        public Optional<ManaPerLootAttribute> difference(ManaPerLootAttribute thisValue, ManaPerLootAttribute thatValue) {
            return Optional.empty();
        }

        @Override
        @Nonnull
        public Comparator<ManaPerLootAttribute> getComparator() {
            return Comparator.comparing(ManaPerLootAttribute::getManaGenerated).thenComparing(ManaPerLootAttribute::getManaGenerationChance);
        }
    }

    public static class Generator
    extends ConfigurableAttributeGenerator<ManaPerLootAttribute, Config> {
        @Override
        @Nullable
        public Class<Config> getConfigurationObjectClass() {
            return Config.class;
        }

        @Override
        @Nullable
        public MutableComponent getConfigRangeDisplay(VaultGearModifierReader<ManaPerLootAttribute> reader, Config min, Config max) {
            return this.getChanceDisplay(min.getManaGenerationChance().getMin()).m_130946_("-").m_7220_((Component)this.getChanceDisplay(max.getManaGenerationChance().getMax())).m_130946_(", ").m_130946_(String.valueOf(min.getManaGenerated().getMin())).m_130946_("-").m_130946_(String.valueOf(max.getManaGenerated().getMax()));
        }

        private MutableComponent getChanceDisplay(float value) {
            return new TextComponent(FORMAT.format(value * 100.0f) + "%");
        }

        @Override
        @Nullable
        public MutableComponent getConfigDisplay(VaultGearModifierReader<ManaPerLootAttribute> reader, Config object) {
            MutableComponent range = this.getConfigRangeDisplay(reader, object);
            TextComponent display = new TextComponent(object.getDisplayName());
            return new TextComponent("").m_130948_(reader.getColoredTextStyle()).m_7220_((Component)range.m_130948_(reader.getColoredTextStyle())).m_130946_(" Mana per ").m_7220_((Component)display).m_130946_(" looted");
        }

        @Override
        public ManaPerLootAttribute generateRandomValue(Config object, Random random) {
            JavaRandom rand = JavaRandom.ofScrambled(random.nextLong());
            float genChance = object.getManaGenerationChance().getRandom(rand);
            int genAmount = object.getManaGenerated().getRandom(rand);
            return new ManaPerLootAttribute(object.getTileEntityGroupId(), object.getDisplayName(), genChance, genAmount);
        }

        @Override
        public Optional<ManaPerLootAttribute> getMinimumValue(List<Config> configurations) {
            Comparator<Config> cfgCmp = Comparator.comparing(config -> config.getManaGenerated().getMin());
            cfgCmp = cfgCmp.thenComparing(config -> Float.valueOf(config.getManaGenerationChance().getMin()));
            return configurations.stream().min(cfgCmp).map(config -> new ManaPerLootAttribute(config.getTileEntityGroupId(), config.getDisplayName(), config.getManaGenerationChance().getMin(), config.getManaGenerated().getMin()));
        }

        @Override
        public Optional<ManaPerLootAttribute> getMaximumValue(List<Config> configurations) {
            Comparator<Config> cfgCmp = Comparator.comparing(config -> config.getManaGenerated().getRolledMaximum());
            cfgCmp = cfgCmp.thenComparing(config -> Float.valueOf(config.getManaGenerationChance().getRolledMaximum()));
            return configurations.stream().max(cfgCmp).map(config -> new ManaPerLootAttribute(config.getTileEntityGroupId(), config.getDisplayName(), config.getManaGenerationChance().getRolledMaximum(), config.getManaGenerated().getRolledMaximum()));
        }

        @Override
        public Optional<Float> getRollPercentage(ManaPerLootAttribute value, List<Config> configurations) {
            return MiscUtils.getFloatValueRange(value.getManaGenerationChance(), this.getMinimumValue(configurations), this.getMaximumValue(configurations), ManaPerLootAttribute::getManaGenerationChance);
        }
    }

    private static class Reader
    extends VaultGearModifierReader<ManaPerLootAttribute> {
        protected Reader() {
            super("", 65535);
        }

        private Style getHighlightStyle() {
            return Style.f_131099_.m_178520_(20479);
        }

        @Override
        @Nullable
        public MutableComponent getDisplay(VaultGearAttributeInstance<ManaPerLootAttribute> instance, VaultGearModifier.AffixType type) {
            ManaPerLootAttribute manaLootAttr = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(manaLootAttr);
            if (valueDisplay == null) {
                return null;
            }
            TextComponent manaGenerated = new TextComponent(String.valueOf(manaLootAttr.getManaGenerated()));
            return new TextComponent(type.getAffixPrefix(manaLootAttr.getManaGenerationChance() >= 0.0f)).m_130948_(this.getColoredTextStyle()).m_7220_((Component)valueDisplay.m_130948_(this.getHighlightStyle())).m_7220_((Component)new TextComponent(" chance to generate ").m_130948_(this.getColoredTextStyle())).m_7220_((Component)manaGenerated.m_130948_(this.getHighlightStyle())).m_7220_((Component)new TextComponent(" Mana per ").m_130948_(this.getColoredTextStyle())).m_7220_((Component)new TextComponent(manaLootAttr.getDisplayName()).m_130948_(this.getHighlightStyle())).m_7220_((Component)new TextComponent(" looted").m_130948_(this.getColoredTextStyle()));
        }

        @Override
        @Nullable
        public MutableComponent getValueDisplay(ManaPerLootAttribute value) {
            return new TextComponent(FORMAT.format(value.getManaGenerationChance() * 100.0f) + "%");
        }

        @Override
        protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<ManaPerLootAttribute> instance, VaultGearModifier.AffixType type) {
            ManaPerLootAttribute manaLootAttr = instance.getValue();
            MutableComponent valueDisplay = this.getValueDisplay(manaLootAttr);
            if (valueDisplay == null) {
                return;
            }
            out.add(type.getAffixPrefix(manaLootAttr.getManaGenerationChance() >= 0.0f));
            out.add(valueDisplay.getString());
            out.add(" chance to generate ");
            out.add(String.valueOf(manaLootAttr.getManaGenerated()));
            out.add(" Mana per ");
            out.add(manaLootAttr.getDisplayName());
            out.add(" looted");
        }
    }

    public static class Config
    extends LootTriggerAttribute.Config {
        @Expose
        private final FloatRollRangeEntry manaGenerationChance;
        @Expose
        private final IntRollRangeEntry manaGenerated;

        public Config(ResourceLocation tileEntityGroupId, String displayName, FloatRollRangeEntry manaGenerationChance, IntRollRangeEntry manaGenerated) {
            super(tileEntityGroupId, displayName);
            this.manaGenerationChance = manaGenerationChance;
            this.manaGenerated = manaGenerated;
        }

        public FloatRollRangeEntry getManaGenerationChance() {
            return this.manaGenerationChance;
        }

        public IntRollRangeEntry getManaGenerated() {
            return this.manaGenerated;
        }
    }
}

