/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.talent;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.annotations.Expose;
import iskallia.vault.config.entry.IntRollRangeEntry;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.NetcodeUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class RandomVaultModifierAttribute {
    protected final ResourceLocation modifier;
    protected final int count;
    protected final int time;

    public RandomVaultModifierAttribute(ResourceLocation modifier, int count, int time) {
        this.modifier = modifier;
        this.count = count;
        this.time = time;
    }

    public ResourceLocation getModifier() {
        return this.modifier;
    }

    public int getCount() {
        return this.count;
    }

    public int getTime() {
        return this.time;
    }

    public static VaultGearAttributeType<RandomVaultModifierAttribute> type() {
        return VaultGearAttributeType.of((buf, attribute) -> {
            buf.writeIdentifier(attribute.getModifier());
            buf.writeInt(attribute.getCount());
            buf.writeInt(attribute.getTime());
        }, buf -> new RandomVaultModifierAttribute(buf.readIdentifier(), buf.readInt(), buf.readInt()), (buf, attribute) -> {
            NetcodeUtils.writeIdentifier(buf, attribute.getModifier());
            buf.writeInt(attribute.getCount());
            buf.writeInt(attribute.getTime());
        }, buf -> {
            ResourceLocation modifier = NetcodeUtils.readIdentifier(buf);
            int count = buf.readInt();
            int time = buf.readInt();
            return new RandomVaultModifierAttribute(modifier, count, time);
        }, arg_0 -> ((Gson)VaultGearAttributeType.GSON).toJsonTree(arg_0), nbt -> {
            CompoundTag tag = (CompoundTag)nbt;
            ResourceLocation modifier = ResourceLocation.m_135820_((String)tag.m_128461_("modifier"));
            int count = tag.m_128451_("count");
            int time = tag.m_128451_("time");
            return new RandomVaultModifierAttribute(modifier, count, time);
        }, attribute -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("modifier", attribute.getModifier().toString());
            tag.m_128405_("count", attribute.getCount());
            tag.m_128405_("time", attribute.getTime());
            return tag;
        });
    }

    public static BiFunction<VaultGearModifier<?>, Float, VaultGearModifier<?>> scalingFunction() {
        return (value, scale) -> {
            Object patt3525$temp = value.getValue();
            if (patt3525$temp instanceof RandomVaultModifierAttribute) {
                RandomVaultModifierAttribute attribute = (RandomVaultModifierAttribute)patt3525$temp;
                RandomVaultModifierAttribute newAttribute = new RandomVaultModifierAttribute(attribute.getModifier(), attribute.getCount(), (int)((float)attribute.getTime() * scale.floatValue()));
                return new VaultGearModifier<RandomVaultModifierAttribute>(value.getAttribute(), newAttribute);
            }
            return value;
        };
    }

    public static ConfigurableAttributeGenerator<RandomVaultModifierAttribute, Config> generator() {
        return new ConfigurableAttributeGenerator<RandomVaultModifierAttribute, Config>(){

            @Override
            public Class<Config> getConfigurationObjectClass() {
                return Config.class;
            }

            @Override
            public MutableComponent getConfigRangeDisplay(VaultGearModifierReader<RandomVaultModifierAttribute> reader, Config min, Config max) {
                return new TextComponent("%s-%s".formatted(min.getTime().getMin() / 20, max.getTime().getMax() / 20));
            }

            @Override
            public RandomVaultModifierAttribute generateRandomValue(Config object, Random random) {
                JavaRandom rand = JavaRandom.ofScrambled(random.nextLong());
                return new RandomVaultModifierAttribute(object.getModifier(), object.getCount(), object.getTime().getRandom(rand));
            }

            @Override
            public Optional<RandomVaultModifierAttribute> getMinimumValue(List<Config> configurations) {
                return configurations.stream().min(Comparator.comparingInt(Config::getCount)).map(config -> new RandomVaultModifierAttribute(config.getModifier(), config.getCount(), config.getTime().getMin()));
            }

            @Override
            public Optional<RandomVaultModifierAttribute> getMaximumValue(List<Config> configurations) {
                return configurations.stream().max(Comparator.comparingInt(Config::getCount)).map(config -> new RandomVaultModifierAttribute(config.getModifier(), config.getCount(), config.getTime().getRandom()));
            }

            @Override
            public Optional<Float> getRollPercentage(RandomVaultModifierAttribute value, List<Config> configurations) {
                return MiscUtils.getIntValueRange(value.getTime(), this.getMinimumValue(configurations), this.getMaximumValue(configurations), RandomVaultModifierAttribute::getTime);
            }
        };
    }

    public static VaultGearModifierReader<RandomVaultModifierAttribute> reader() {
        return new VaultGearModifierReader<RandomVaultModifierAttribute>("", 15638784){

            @Override
            @Nullable
            public MutableComponent getDisplay(VaultGearAttributeInstance<RandomVaultModifierAttribute> instance, VaultGearModifier.AffixType type) {
                RandomVaultModifierAttribute attribute = instance.getValue();
                MutableComponent valueDisplay = this.getValueDisplay(attribute);
                VaultModifier modifier = VaultModifierRegistry.getOpt(attribute.getModifier()).orElse(null);
                if (modifier == null) {
                    return null;
                }
                return new TextComponent("").m_7220_((Component)type.getAffixPrefixComponent(attribute.getCount() >= 0).m_130948_(this.getColoredTextStyle())).m_7220_((Component)valueDisplay.m_130948_(this.getColoredTextStyle())).m_130946_(" of ").m_130946_((String)(attribute.getCount() > 1 ? attribute.getCount() + "x " : "")).m_7220_(modifier.getNameComponentFormatted(attribute.getCount())).m_130948_(this.getColoredTextStyle());
            }

            @Override
            public MutableComponent getValueDisplay(RandomVaultModifierAttribute value) {
                return new TextComponent(value.getTime() / 20 + " seconds");
            }

            @Override
            protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<RandomVaultModifierAttribute> instance, VaultGearModifier.AffixType type) {
                RandomVaultModifierAttribute attribute = instance.getValue();
                MutableComponent valueDisplay = this.getValueDisplay(attribute);
                VaultModifier modifier = VaultModifierRegistry.getOpt(attribute.getModifier()).orElse(null);
                if (modifier == null) {
                    return;
                }
                out.add(type.getAffixPrefix(attribute.getCount() >= 0));
                out.add(valueDisplay.getString());
                out.add(" of ");
                out.add(attribute.getCount() + "x ");
                out.add(modifier.getNameComponentFormatted(attribute.getCount()).getString());
            }
        };
    }

    public static VaultGearAttributeComparator<RandomVaultModifierAttribute> comparator() {
        return new VaultGearAttributeComparator<RandomVaultModifierAttribute>(){

            @Override
            public Optional<RandomVaultModifierAttribute> merge(RandomVaultModifierAttribute thisValue, RandomVaultModifierAttribute thatValue) {
                if (!thisValue.getModifier().equals((Object)thatValue.getModifier()) || thisValue.getCount() != thatValue.getCount()) {
                    return Optional.empty();
                }
                return Optional.of(new RandomVaultModifierAttribute(thisValue.getModifier(), thisValue.getCount(), thisValue.getTime() + thatValue.getTime()));
            }

            @Override
            public Optional<RandomVaultModifierAttribute> difference(RandomVaultModifierAttribute thisValue, RandomVaultModifierAttribute thatValue) {
                return Optional.empty();
            }

            @Override
            @NotNull
            public Comparator<RandomVaultModifierAttribute> getComparator() {
                return Comparator.comparing(RandomVaultModifierAttribute::getTime);
            }
        };
    }

    public static class Config {
        @Expose
        private ResourceLocation modifier;
        @Expose
        private int count;
        @Expose
        private IntRollRangeEntry time;

        public Config(ResourceLocation modifier, int count, IntRollRangeEntry time) {
            this.modifier = modifier;
            this.count = count;
            this.time = time;
        }

        public ResourceLocation getModifier() {
            return this.modifier;
        }

        public int getCount() {
            return this.count;
        }

        public IntRollRangeEntry getTime() {
            return this.time;
        }
    }
}

