/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.talent;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.annotations.Expose;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.comparator.VaultGearAttributeComparator;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.NetcodeUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.NotNull;

public class TalentLevelAttribute {
    public static final String ALL_TALENTS = "all_talents";
    protected final String talent;
    protected final int levelChange;

    public TalentLevelAttribute(String talent, int levelChange) {
        this.talent = talent;
        this.levelChange = levelChange;
    }

    public String getTalent() {
        return this.talent;
    }

    public int getLevelChange() {
        return this.levelChange;
    }

    public static VaultGearAttributeType<TalentLevelAttribute> type() {
        return VaultGearAttributeType.of((buf, attribute) -> {
            buf.writeString(attribute.getTalent());
            buf.writeInt(attribute.getLevelChange());
        }, buf -> new TalentLevelAttribute(buf.readString(), buf.readInt()), (buf, attribute) -> {
            NetcodeUtils.writeString(buf, attribute.getTalent());
            buf.writeInt(attribute.getLevelChange());
        }, buf -> {
            String talent = NetcodeUtils.readString(buf);
            int levelChange = buf.readInt();
            return new TalentLevelAttribute(talent, levelChange);
        }, arg_0 -> ((Gson)VaultGearAttributeType.GSON).toJsonTree(arg_0), nbt -> {
            CompoundTag tag = (CompoundTag)nbt;
            String talent = tag.m_128461_("talent");
            int levelChange = tag.m_128451_("levelChange");
            return new TalentLevelAttribute(talent, levelChange);
        }, attribute -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("talent", attribute.getTalent());
            tag.m_128405_("levelChange", attribute.getLevelChange());
            return tag;
        });
    }

    public static ConfigurableAttributeGenerator<TalentLevelAttribute, Config> generator() {
        return new ConfigurableAttributeGenerator<TalentLevelAttribute, Config>(){

            @Override
            public Class<Config> getConfigurationObjectClass() {
                return Config.class;
            }

            @Override
            public MutableComponent getConfigRangeDisplay(VaultGearModifierReader<TalentLevelAttribute> reader, Config min, Config max) {
                return new TextComponent("%s-%s".formatted(min.getLevelChange(), max.getLevelChange()));
            }

            @Override
            public TalentLevelAttribute generateRandomValue(Config object, Random random) {
                return new TalentLevelAttribute(object.getTalent(), object.getLevelChange());
            }

            @Override
            public Optional<TalentLevelAttribute> getMinimumValue(List<Config> configurations) {
                return configurations.stream().min(Comparator.comparingInt(Config::getLevelChange)).map(config -> new TalentLevelAttribute(config.getTalent(), config.getLevelChange()));
            }

            @Override
            public Optional<TalentLevelAttribute> getMaximumValue(List<Config> configurations) {
                return configurations.stream().max(Comparator.comparingInt(Config::getLevelChange)).map(config -> new TalentLevelAttribute(config.getTalent(), config.getLevelChange()));
            }

            @Override
            public Optional<Float> getRollPercentage(TalentLevelAttribute value, List<Config> configurations) {
                return MiscUtils.getIntValueRange(value.getLevelChange(), this.getMinimumValue(configurations), this.getMaximumValue(configurations), TalentLevelAttribute::getLevelChange);
            }
        };
    }

    public static VaultGearModifierReader<TalentLevelAttribute> reader() {
        return new VaultGearModifierReader<TalentLevelAttribute>("", 15638784){

            @Override
            @Nullable
            public MutableComponent getDisplay(VaultGearAttributeInstance<TalentLevelAttribute> instance, VaultGearModifier.AffixType type) {
                TalentLevelAttribute attribute = instance.getValue();
                MutableComponent valueDisplay = this.getValueDisplay(attribute);
                if (attribute.getTalent().equals(TalentLevelAttribute.ALL_TALENTS)) {
                    return new TextComponent("").m_7220_((Component)type.getAffixPrefixComponent(attribute.getLevelChange() >= 0).m_130948_(this.getColoredTextStyle())).m_7220_((Component)valueDisplay.m_130948_(this.getColoredTextStyle())).m_130946_(" to level of ").m_7220_((Component)new TextComponent("all Talents").m_130948_(this.getAbilityStyle())).m_130948_(this.getColoredTextStyle());
                }
                Skill talent = ModConfigs.TALENTS.getTalentById(attribute.getTalent()).orElse(null);
                if (talent == null) {
                    return null;
                }
                return new TextComponent("").m_7220_((Component)type.getAffixPrefixComponent(attribute.getLevelChange() >= 0).m_130948_(this.getColoredTextStyle())).m_7220_((Component)valueDisplay.m_130948_(this.getColoredTextStyle())).m_130946_(" to level of ").m_7220_((Component)new TextComponent(talent.getName()).m_130948_(this.getAbilityStyle())).m_130948_(this.getColoredTextStyle());
            }

            private Style getAbilityStyle() {
                return Style.f_131099_.m_178520_(14076214);
            }

            @Override
            public MutableComponent getValueDisplay(TalentLevelAttribute value) {
                return new TextComponent(String.valueOf(value.getLevelChange()));
            }

            @Override
            protected void serializeTextElements(JsonArray out, VaultGearAttributeInstance<TalentLevelAttribute> instance, VaultGearModifier.AffixType type) {
                TalentLevelAttribute attribute = instance.getValue();
                MutableComponent valueDisplay = this.getValueDisplay(attribute);
                if (attribute.getTalent().equals(TalentLevelAttribute.ALL_TALENTS)) {
                    out.add(type.getAffixPrefix(attribute.getLevelChange() >= 0));
                    out.add(valueDisplay.getString());
                    out.add(" to level of all Talents");
                    return;
                }
                Skill talent = ModConfigs.TALENTS.getTalentById(attribute.getTalent()).orElse(null);
                if (talent == null) {
                    return;
                }
                out.add(type.getAffixPrefix(attribute.getLevelChange() >= 0));
                out.add(valueDisplay.getString());
                out.add(" to level of ");
                out.add(talent.getName());
            }
        };
    }

    public static VaultGearAttributeComparator<TalentLevelAttribute> comparator() {
        return new VaultGearAttributeComparator<TalentLevelAttribute>(){

            @Override
            public Optional<TalentLevelAttribute> merge(TalentLevelAttribute thisValue, TalentLevelAttribute thatValue) {
                if (!thisValue.getTalent().equals(thatValue.getTalent())) {
                    return Optional.empty();
                }
                return Optional.of(new TalentLevelAttribute(thisValue.getTalent(), thisValue.getLevelChange() + thatValue.getLevelChange()));
            }

            @Override
            public Optional<TalentLevelAttribute> difference(TalentLevelAttribute thisValue, TalentLevelAttribute thatValue) {
                return Optional.empty();
            }

            @Override
            @NotNull
            public Comparator<TalentLevelAttribute> getComparator() {
                return Comparator.comparing(TalentLevelAttribute::getLevelChange);
            }
        };
    }

    public static class Config {
        @Expose
        private String talentKey;
        @Expose
        private int levelChange;

        public Config(String talentKey, int levelChange) {
            this.talentKey = talentKey;
            this.levelChange = levelChange;
        }

        public String getTalent() {
            return this.talentKey;
        }

        public int getLevelChange() {
            return this.levelChange;
        }
    }
}

