/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.attribute.type;

import iskallia.vault.gear.attribute.custom.effect.IEffectAvoidanceChanceAttribute;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.effect.MobEffect;

public class EffectAvoidanceCombinedMerger<T extends IEffectAvoidanceChanceAttribute>
extends VaultGearAttributeTypeMerger<T, Avoidances> {
    private EffectAvoidanceCombinedMerger() {
    }

    public static <T extends IEffectAvoidanceChanceAttribute> EffectAvoidanceCombinedMerger<T> of() {
        return new EffectAvoidanceCombinedMerger<T>();
    }

    @Override
    public Avoidances merge(Avoidances merged, IEffectAvoidanceChanceAttribute other) {
        if (other.getChance() <= 0.0f) {
            return merged;
        }
        other.getEffects().forEach(effect -> {
            float chance = merged.avoidanceChances.getOrDefault(effect, Float.valueOf(0.0f)).floatValue();
            merged.avoidanceChances.put((MobEffect)effect, Float.valueOf(chance + other.getChance()));
        });
        return merged;
    }

    @Override
    public Avoidances getBaseValue() {
        return new Avoidances();
    }

    public static class Avoidances {
        private final Map<MobEffect, Float> avoidanceChances = new HashMap<MobEffect, Float>();

        public static Avoidances empty() {
            return new Avoidances();
        }

        public void merge(Avoidances other) {
            other.avoidanceChances.forEach((effect, chance) -> {
                float currentChance = this.avoidanceChances.getOrDefault(effect, Float.valueOf(0.0f)).floatValue();
                this.avoidanceChances.put((MobEffect)effect, Float.valueOf(currentChance + chance.floatValue()));
            });
        }

        public Map<MobEffect, Float> getAvoidanceChances() {
            return Collections.unmodifiableMap(this.avoidanceChances);
        }
    }
}

