/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.charm;

import iskallia.vault.gear.charm.CharmEffect;
import iskallia.vault.integration.IntegrationCurios;
import iskallia.vault.item.gear.CharmItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CharmHelper {
    public static List<CharmStack<CharmEffect<?>>> getCharms(LivingEntity entity) {
        return CharmHelper.getCharms(IntegrationCurios.getCuriosItemStacks(entity), CharmEffect.class);
    }

    public static <T extends CharmEffect<?>> List<CharmStack<T>> getCharms(LivingEntity entity, Class<T> charmClass) {
        return CharmHelper.getCharms(IntegrationCurios.getCuriosItemStacks(entity), charmClass);
    }

    public static <T extends CharmEffect<?>> List<CharmStack<T>> getCharms(Map<String, List<Tuple<ItemStack, Integer>>> slotCurios, Class<? super T> charmClass) {
        ArrayList charms = new ArrayList();
        slotCurios.values().forEach(curios -> curios.forEach(curioTpl -> {
            ItemStack curioStack = (ItemStack)curioTpl.m_14418_();
            if (!(curioStack.m_41720_() instanceof CharmItem)) {
                return;
            }
            CharmItem.getCharm(curioStack).ifPresent(charm -> {
                if (charmClass.isInstance(charm)) {
                    charms.add(new CharmStack<CharmEffect>(curioStack, (CharmEffect)((Object)((Object)((Object)charm)))));
                }
            });
        }));
        return charms;
    }

    public record CharmStack<T extends CharmEffect<?>>(ItemStack stack, T charm) {
        public boolean isUsable(Player player) {
            return ((CharmEffect)((Object)this.charm())).isUsable(this.stack(), player);
        }
    }
}

