/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.crafting.recipe;

import iskallia.vault.config.recipe.ForgeRecipeType;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.InfusedCatalystItem;
import iskallia.vault.util.LootInitialization;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CatalystForgeRecipe
extends VaultForgeRecipe {
    public CatalystForgeRecipe(ResourceLocation id, ItemStack output) {
        super(ForgeRecipeType.CATALYST, id, output);
    }

    public CatalystForgeRecipe(ResourceLocation id, ItemStack output, List<ItemStack> inputs) {
        super(ForgeRecipeType.CATALYST, id, output, inputs);
    }

    @Override
    public ItemStack createOutput(List<OverSizedItemStack> consumed, ServerPlayer crafter, int vaultLevel) {
        ItemStack stack = super.createOutput(consumed, crafter, vaultLevel);
        if (stack.m_150930_((Item)ModItems.VAULT_CATALYST_INFUSED)) {
            stack.m_41749_("display");
            stack.m_41749_("size");
            stack.m_41749_("modifiers");
            stack = LootInitialization.initializeVaultLoot(stack, vaultLevel);
        }
        return stack;
    }

    @Override
    public void addCraftingDisplayTooltip(ItemStack result, List<Component> out) {
        CollectionTag collection;
        Tag size;
        List<ResourceLocation> modifiers = InfusedCatalystItem.getModifiers(result);
        Tag tag = size = result.m_41783_() == null ? null : result.m_41784_().m_128423_("size");
        if (size instanceof NumericTag) {
            NumericTag numeric = (NumericTag)size;
            out.add((Component)new TextComponent("Size: ").m_7220_((Component)new TextComponent(String.valueOf(numeric.m_7047_())).m_130948_(Style.f_131099_.m_178520_(0xDDDDDD))));
        } else if (size instanceof CollectionTag && (collection = (CollectionTag)size).size() == 2) {
            Tag e1 = (Tag)collection.get(0);
            Tag e2 = (Tag)collection.get(1);
            if (e1 instanceof NumericTag) {
                NumericTag n1 = (NumericTag)e1;
                if (e2 instanceof NumericTag) {
                    NumericTag n2 = (NumericTag)e2;
                    out.add((Component)new TextComponent("Size: ").m_7220_((Component)new TextComponent(String.valueOf(n1.m_7047_())).m_130948_(Style.f_131099_.m_178520_(0xDDDDDD))).m_7220_((Component)new TextComponent(" - ")).m_7220_((Component)new TextComponent(String.valueOf(n2.m_7047_())).m_130948_(Style.f_131099_.m_178520_(0xDDDDDD))));
                }
            }
        } else {
            out.add((Component)new TextComponent("Size: ???").m_130940_(ChatFormatting.GRAY));
        }
        for (ResourceLocation modifier : modifiers) {
            VaultModifierRegistry.getOpt(modifier).ifPresent(vaultModifier -> {
                out.add((Component)new TextComponent(" \u2022 " + vaultModifier.getDisplayName()).m_130948_(Style.f_131099_.m_131148_(vaultModifier.getDisplayTextColor())));
                if (Screen.m_96638_()) {
                    out.add((Component)new TextComponent("    " + vaultModifier.getDisplayDescription()).m_130940_(ChatFormatting.DARK_GRAY));
                }
            });
        }
        out.add(TextComponent.f_131282_);
    }
}

