/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.crafting.recipe;

import iskallia.vault.client.gui.overlay.VaultBarOverlay;
import iskallia.vault.config.recipe.ForgeRecipeType;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import iskallia.vault.item.tool.ToolItem;
import iskallia.vault.item.tool.ToolMaterial;
import iskallia.vault.item.tool.ToolType;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ToolForgeRecipe
extends VaultForgeRecipe {
    protected ToolType toolType = ToolType.PICK;
    protected ToolMaterial toolMaterial = ToolMaterial.CHROMATIC_IRON_INGOT;

    public ToolForgeRecipe(ResourceLocation id, ItemStack output) {
        super(ForgeRecipeType.TOOL, id, output);
    }

    public ToolForgeRecipe(ResourceLocation id, ItemStack output, List<ItemStack> inputs, ToolType toolType, ToolMaterial toolMaterial) {
        super(ForgeRecipeType.TOOL, id, output, inputs);
        this.toolType = toolType;
        this.toolMaterial = toolMaterial;
    }

    @Override
    public List<Component> getDisabledText() {
        return List.of(new TextComponent("Requires Level " + this.toolMaterial.getLevel()).m_130940_(ChatFormatting.ITALIC));
    }

    @Override
    protected void readAdditional(FriendlyByteBuf buf) {
        super.readAdditional(buf);
        this.toolType = (ToolType)buf.m_130066_(ToolType.class);
        this.toolMaterial = (ToolMaterial)buf.m_130066_(ToolMaterial.class);
    }

    @Override
    protected void writeAdditional(FriendlyByteBuf buf) {
        super.writeAdditional(buf);
        buf.m_130068_((Enum)this.toolType);
        buf.m_130068_((Enum)this.toolMaterial);
    }

    @Override
    public ItemStack getDisplayOutput(int vaultLevel) {
        return ToolItem.create(this.toolMaterial, this.toolType);
    }

    @Override
    public ItemStack createOutput(List<OverSizedItemStack> consumed, ServerPlayer crafter, int vaultLevel) {
        return ToolItem.create(this.toolMaterial, this.toolType);
    }

    @Override
    public boolean canCraft(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerVaultStatsData data = PlayerVaultStatsData.get(serverPlayer.f_8924_);
            int vaultLevel = data.getVaultStats((Player)serverPlayer).getVaultLevel();
            return vaultLevel >= this.toolMaterial.getLevel();
        }
        return VaultBarOverlay.vaultLevel >= this.toolMaterial.getLevel();
    }
}

