/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.crafting.recipe;

import iskallia.vault.client.ClientDiscoveredEntriesData;
import iskallia.vault.config.TrinketConfig;
import iskallia.vault.config.recipe.ForgeRecipeType;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.world.data.DiscoveredTrinketsData;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class TrinketForgeRecipe
extends VaultForgeRecipe {
    private TrinketEffect<?> effect;

    public TrinketForgeRecipe(ResourceLocation id, ItemStack output) {
        super(ForgeRecipeType.TRINKET, id, output);
    }

    public TrinketForgeRecipe(ResourceLocation id, ItemStack output, List<ItemStack> inputs, TrinketEffect<?> effect) {
        super(ForgeRecipeType.TRINKET, id, output, inputs);
        this.effect = effect;
    }

    @Override
    protected void readAdditional(FriendlyByteBuf buf) {
        super.readAdditional(buf);
        this.effect = (TrinketEffect)buf.readRegistryId();
    }

    @Override
    protected void writeAdditional(FriendlyByteBuf buf) {
        super.writeAdditional(buf);
        buf.writeRegistryId(this.effect);
    }

    @Override
    public ItemStack getDisplayOutput(int vaultLevel) {
        return TrinketItem.createBaseTrinket(this.effect);
    }

    @Override
    public List<Component> getDisabledText() {
        TrinketConfig.Trinket trinket = ModConfigs.TRINKET.getTrinketConfig(this.effect);
        if (trinket == null) {
            return List.of(new TextComponent("Disabled Recipe"));
        }
        return List.of(new TextComponent(trinket.getName()).m_130948_(Style.f_131099_.m_131148_(trinket.getComponentColor())), new TextComponent("Undiscovered").m_130948_(Style.f_131099_.m_178524_(Boolean.valueOf(true)).m_131148_(trinket.getComponentColor())));
    }

    @Override
    public ItemStack createOutput(List<OverSizedItemStack> consumed, ServerPlayer crafter, int vaultLevel) {
        ItemStack trinket = TrinketItem.createRandomTrinket(this.effect);
        TrinketItem.setUses(trinket, this.effect.getTrinketConfig().getRandomCraftedUses());
        String data = AttributeGearData.read(trinket);
        ((AttributeGearData)((Object)data)).createOrReplaceAttributeValue(ModGearAttributes.CRAFTED_BY, (String)crafter.m_7755_().m_6111_());
        ((AttributeGearData)((Object)data)).write(trinket);
        return trinket;
    }

    @Override
    public boolean canCraft(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            DiscoveredTrinketsData trinketsData = DiscoveredTrinketsData.get(sPlayer.m_183503_());
            return trinketsData.hasDiscovered((Player)sPlayer, this.effect);
        }
        return ClientDiscoveredEntriesData.Trinkets.getDiscoveredTrinkets().contains(this.effect.getRegistryName());
    }
}

