/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearAttributeSerializer;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.CardDeckGearData;
import iskallia.vault.gear.data.GearDataCache;
import iskallia.vault.gear.data.GearDataVersion;
import iskallia.vault.gear.data.JewelGearData;
import iskallia.vault.gear.data.ToolGearData;
import iskallia.vault.gear.data.UsesGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.CardDeckItem;
import iskallia.vault.item.MagnetItem;
import iskallia.vault.item.gear.VaultNecklaceItem;
import iskallia.vault.item.gear.VoidStoneItem;
import iskallia.vault.item.tool.JewelItem;
import iskallia.vault.item.tool.ToolItem;
import iskallia.vault.item.tool.ToolMaterial;
import iskallia.vault.util.data.BitSerializers;
import iskallia.vault.util.data.LazyHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class AttributeGearData {
    public static final String TAG_KEY = "vaultGearData";
    protected GearDataVersion version = GearDataVersion.current();
    private final LazyHolder<UUID> identifier = new LazyHolder<UUID>(UUID::randomUUID, BitSerializers.UUID);
    List<VaultGearAttributeInstance<?>> attributes = new ArrayList();

    protected AttributeGearData() {
    }

    protected AttributeGearData(BitBuffer buf) {
        this.read(buf);
    }

    protected AttributeGearData(CompoundTag tag) {
        GearDataVersion version = GearDataVersion.values()[tag.m_128451_("version")];
        this.fromNbt(tag, version);
    }

    public List<VaultGearAttributeInstance<?>> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public static boolean hasData(ItemStack stack) {
        if (stack.m_41720_() instanceof CardDeckItem && !CardDeckItem.hasCardDeck(stack)) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128425_(TAG_KEY, 12);
    }

    @Nonnull
    protected static <T extends AttributeGearData> T read(ItemStack stack, Function<BitBuffer, T> bufferCtor, Supplier<T> ctor) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128425_(TAG_KEY, 12)) {
            return (T)((AttributeGearData)ctor.get());
        }
        return (T)((AttributeGearData)bufferCtor.apply(ArrayBitBuffer.backing(tag.m_128467_(TAG_KEY), 0)));
    }

    public static AttributeGearData empty() {
        return new AttributeGearData();
    }

    @Nonnull
    public static <T extends AttributeGearData> T read(ItemStack stack) {
        if (stack.m_41720_() == ModItems.MAGNET && MagnetItem.isLegacy(stack)) {
            return (T)new VaultGearData();
        }
        if (stack.m_41720_() instanceof JewelItem) {
            return (T)AttributeGearData.read(stack, JewelGearData::new, JewelGearData::new);
        }
        if (stack.m_41720_() instanceof ToolItem) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128441_("version")) {
                tag.m_128473_("version");
                ToolMaterial material = ToolItem.getMaterial(stack);
                int amount = material == ToolMaterial.ECHOING_INGOT ? -50 : (material == ToolMaterial.OMEGA_POG ? -200 : 0);
                ToolItem.addCapacity(stack, amount);
            }
            return (T)AttributeGearData.read(stack, ToolGearData::new, ToolGearData::new);
        }
        if (stack.m_41720_() instanceof VoidStoneItem || stack.m_41720_() instanceof VaultNecklaceItem) {
            return (T)AttributeGearData.read(stack, UsesGearData::new, UsesGearData::new);
        }
        if (stack.m_41720_() instanceof VaultGearItem) {
            return (T)AttributeGearData.read(stack, VaultGearData::new, VaultGearData::new);
        }
        if (stack.m_41720_() instanceof CardDeckItem) {
            return (T)AttributeGearData.read(stack, CardDeckGearData::new, () -> CardDeckGearData.newDeck(stack));
        }
        return (T)AttributeGearData.read(stack, AttributeGearData::new, AttributeGearData::new);
    }

    public static Optional<UUID> readUUID(ItemStack stack) {
        if (!AttributeGearData.hasData(stack)) {
            return Optional.empty();
        }
        ArrayBitBuffer buf = ArrayBitBuffer.backing(stack.m_41784_().m_128467_(TAG_KEY), 0);
        buf.readEnum(GearDataVersion.class);
        return Optional.of(buf.readUUID());
    }

    @Nonnull
    public static <T extends AttributeGearData> T fromNbt(ItemStack stack, CompoundTag tag) {
        if (stack.m_41720_() instanceof VaultGearItem) {
            return (T)new VaultGearData(tag);
        }
        return (T)new AttributeGearData(tag);
    }

    public void write(ItemStack stack) {
        this.markChanged(stack);
        this.writeUnchanged(stack);
    }

    @Deprecated
    public void writeUnchanged(ItemStack stack) {
        ArrayBitBuffer buffer = ArrayBitBuffer.empty();
        this.write(buffer);
        stack.m_41784_().m_128388_(TAG_KEY, buffer.toLongArray());
        if (!stack.m_41619_()) {
            GearDataCache.removeCache(stack);
            GearDataCache.createCache(stack);
        }
    }

    protected void markChanged(ItemStack stack) {
        this.identifier.refresh();
    }

    @Nonnull
    public UUID getIdentifier() {
        return this.identifier.get();
    }

    public void setIdentifier(UUID uuid) {
        this.identifier.set(uuid);
    }

    public <T> Optional<T> getFirstValue(VaultGearAttribute<T> attribute) {
        return Optional.ofNullable(this.get(attribute, VaultGearAttributeTypeMerger.firstNonNull()));
    }

    public <T, V> V get(VaultGearAttribute<T> attribute, VaultGearAttributeTypeMerger<T, V> merger) {
        V merged = merger.getBaseValue();
        for (VaultGearAttributeInstance<?> instance : this.attributes) {
            if (!((Object)instance.getAttribute()).equals(attribute)) continue;
            merged = merger.merge(merged, instance.getValue());
        }
        return merged;
    }

    public <T> Stream<VaultGearAttributeInstance<T>> getAttributes(VaultGearAttribute<T> attribute) {
        return this.attributes.stream().filter(instance -> ((Object)((Object)instance.getAttribute())).equals((Object)attribute)).map(VaultGearAttributeInstance::cast);
    }

    public boolean hasAttribute(VaultGearAttribute<?> attribute) {
        for (VaultGearAttributeInstance<?> instance : this.attributes) {
            if (!((Object)instance.getAttribute()).equals(attribute)) continue;
            return true;
        }
        return false;
    }

    public VaultGearAttributeInstance<?> removeAttribute(VaultGearAttribute<?> attribute) {
        Iterator<VaultGearAttributeInstance<?>> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            VaultGearAttributeInstance<?> instance = iterator.next();
            if (!((Object)instance.getAttribute()).equals(attribute)) continue;
            iterator.remove();
            return instance;
        }
        return null;
    }

    @Nullable
    public <T> T createOrReplaceAttributeValue(VaultGearAttribute<T> attribute, @Nonnull T value) {
        if (!this.isModifiable()) {
            return null;
        }
        Iterator<VaultGearAttributeInstance<?>> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            VaultGearAttributeInstance<?> instance = iterator.next();
            if (!((Object)instance.getAttribute()).equals(attribute)) continue;
            Object prevValue = instance.setValue(value);
            if (!instance.isValid()) {
                iterator.remove();
                return (T)prevValue;
            }
            return (T)prevValue;
        }
        if (attribute.getType().isValid(value)) {
            this.attributes.add(new VaultGearAttributeInstance<T>(attribute, value));
        }
        return null;
    }

    public <T> T createOrReplaceAttribute(VaultGearAttributeInstance<?> instance) {
        if (!this.isModifiable()) {
            return null;
        }
        T prevValue = null;
        Iterator<VaultGearAttributeInstance<?>> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            VaultGearAttributeInstance<?> existing = iterator.next();
            if (!((Object)existing.getAttribute()).equals(instance.getAttribute())) continue;
            prevValue = (T)existing.getValue();
            iterator.remove();
            break;
        }
        this.addAttribute(instance);
        return prevValue;
    }

    public boolean addAttribute(VaultGearAttributeInstance<?> instance) {
        if (!this.isModifiable()) {
            return false;
        }
        return this.attributes.add(instance);
    }

    public boolean isModifiable() {
        return this.get(ModGearAttributes.IS_CORRUPTED, VaultGearAttributeTypeMerger.anyTrue()) == false;
    }

    public void clear() {
        this.attributes.clear();
    }

    protected void write(BitBuffer buf) {
        buf.writeEnum(GearDataVersion.current());
        this.identifier.write(buf);
        buf.writeCollection(this.attributes, VaultGearAttributeSerializer::serialize);
    }

    protected void read(BitBuffer buf) {
        this.version = buf.readEnum(GearDataVersion.class);
        this.identifier.read(buf);
        this.attributes = buf.readCollection(ArrayList::new, this.readVersionedAttribute(VaultGearAttributeSerializer::deserialize));
        this.attributes.removeIf(Objects::isNull);
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("version", this.version.ordinal());
        ListTag attributes = new ListTag();
        this.attributes.stream().map(VaultGearAttributeSerializer::serializeTag).forEach(arg_0 -> attributes.add(arg_0));
        tag.m_128365_("attributes", (Tag)attributes);
        return tag;
    }

    protected void fromNbt(CompoundTag tag, GearDataVersion version) {
        this.clear();
        this.version = GearDataVersion.current();
        ListTag attributes = tag.m_128437_("attributes", 10);
        for (int i = 0; i < attributes.size(); ++i) {
            Object inst;
            CompoundTag attrData = attributes.m_128728_(i);
            if (GearDataVersion.V0_6.isLaterThan(version)) {
                attrData.m_128405_("type", 0);
            }
            if ((inst = VaultGearAttributeSerializer.deserializeTag(attrData, version)) == null) continue;
            this.attributes.add((VaultGearAttributeInstance<?>)inst);
        }
        this.markChanged(ItemStack.f_41583_);
    }

    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("id", this.getIdentifier().toString());
        JsonArray attributes = new JsonArray();
        this.attributes.forEach(attr -> attributes.add((JsonElement)attr.serialize(VaultGearModifier.AffixType.IMPLICIT)));
        obj.add("attributes", (JsonElement)attributes);
        return obj;
    }

    protected <T> Function<BitBuffer, T> readVersionedAttribute(BiFunction<BitBuffer, GearDataVersion, T> fn) {
        if (GearDataVersion.V0_6.isLaterThan(this.version)) {
            return buf -> VaultGearAttributeSerializer.INSTANCE_SERIALIZER.deserialize((BitBuffer)buf, this.version);
        }
        return this.versioned(fn);
    }

    protected <T> Function<BitBuffer, T> readVersionedModifier(BiFunction<BitBuffer, GearDataVersion, T> fn) {
        if (GearDataVersion.V0_6.isLaterThan(this.version)) {
            return buf -> VaultGearAttributeSerializer.MODIFIER_SERIALIZER.deserialize((BitBuffer)buf, this.version);
        }
        return this.versioned(fn);
    }

    protected <T> Function<BitBuffer, T> versioned(BiFunction<BitBuffer, GearDataVersion, T> fn) {
        return buf -> fn.apply((BitBuffer)buf, this.version);
    }
}

