/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.data;

import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.data.VaultGearData;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class UsesGearData
extends VaultGearData {
    private int vaultUses = 0;
    private List<UUID> usedVaults = new LinkedList<UUID>();
    private List<UUID> freeVaultUses = new LinkedList<UUID>();

    public UsesGearData() {
    }

    public UsesGearData(BitBuffer buf) {
        this.read(buf);
    }

    @Override
    protected void read(BitBuffer buf) {
        super.read(buf);
        this.vaultUses = buf.readInt();
        this.usedVaults = buf.readCollection(i -> new LinkedList(), BitBuffer::readUUID);
        this.freeVaultUses = buf.readCollection(i -> new ArrayList(), BitBuffer::readUUID);
    }

    @Override
    protected void write(BitBuffer buf) {
        super.write(buf);
        buf.writeInt(this.vaultUses);
        buf.writeCollection(this.usedVaults, (uuid, bitBuffer) -> bitBuffer.writeUUID((UUID)uuid));
        buf.writeCollection(this.freeVaultUses, (uuid, bitBuffer) -> bitBuffer.writeUUID((UUID)uuid));
    }

    public int getVaultUses() {
        return this.vaultUses;
    }

    public void setVaultUses(int vaultUses) {
        this.vaultUses = vaultUses;
    }

    public List<UUID> getFreeVaultUses() {
        return this.freeVaultUses;
    }

    public List<UUID> getUsedVaults() {
        return this.usedVaults;
    }

    public void setFreeVaultUses(List<UUID> freeVaultUses) {
        this.freeVaultUses = freeVaultUses;
    }

    public void setUsedVaults(List<UUID> usedVaults) {
        this.usedVaults = usedVaults;
    }
}

