/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.etching;

import com.mojang.datafixers.util.Pair;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.util.Throuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class EtchingHelper {
    public static List<VaultGearAttributeInstance<?>> getEtchings(LivingEntity entity) {
        ArrayList etchings = new ArrayList();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            Object data;
            Optional<ResourceLocation> etchingDataOpt;
            ItemStack stack = entity.m_6844_(slot);
            if (stack.m_41619_() || !AttributeGearData.hasData(stack) || (etchingDataOpt = ((AttributeGearData)(data = AttributeGearData.read(stack))).getFirstValue(ModGearAttributes.ETCHING)).isEmpty()) continue;
            ResourceLocation etchingId = etchingDataOpt.get();
            etchings.addAll(((AttributeGearData)data).getAttributes(VaultGearAttributeRegistry.getAttribute(etchingId)).toList());
        }
        return etchings;
    }

    public static <T> List<VaultGearAttributeInstance<T>> getEtchings(LivingEntity entity, VaultGearAttribute<T> attribute) {
        ArrayList<VaultGearAttributeInstance<T>> etchings = new ArrayList<VaultGearAttributeInstance<T>>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            VaultGearData gearData;
            Object data;
            ItemStack stack = entity.m_6844_(slot);
            if (stack.m_41619_() || !VaultGearData.hasData(stack) || !((data = AttributeGearData.read(stack)) instanceof VaultGearData) || !(gearData = (VaultGearData)data).getAttributes(attribute).findAny().isPresent()) continue;
            etchings.addAll(gearData.getModifiers(attribute, VaultGearData.Type.ALL));
        }
        return etchings;
    }

    public static String formatDescription(String description, Optional<?> value) {
        if (value.isEmpty()) {
            return description;
        }
        Object val = value.get();
        if (val instanceof Pair) {
            Pair pair = (Pair)val;
            description = EtchingHelper.formatDescription(description, Map.of("valueA", pair.getFirst(), "valueB", pair.getSecond()));
        } else if (val instanceof Throuple) {
            Throuple thr = (Throuple)val;
            description = EtchingHelper.formatDescription(description, Map.of("valueA", thr.getFirst(), "valueB", thr.getSecond(), "valueC", thr.getThird()));
        } else {
            description = EtchingHelper.formatDescription(description, Map.of("value", val));
        }
        return description;
    }

    private static String formatDescription(String description, Map<String, ?> values) {
        StringBuilder result = new StringBuilder();
        int index = 0;
        while (index < description.length()) {
            String key;
            Object obj;
            int start = description.indexOf(37, index);
            if (start == -1 || start + 1 >= description.length()) {
                result.append(description.substring(index));
                break;
            }
            result.append(description, index, start);
            char nextChar = description.charAt(start + 1);
            if (nextChar == 'd') {
                String key2 = EtchingHelper.extractKey(description, start + 2);
                Object obj2 = values.get(key2);
                if (obj2 instanceof Number) {
                    Number number = (Number)obj2;
                    result.append(number);
                    index = start + 2 + key2.length();
                    continue;
                }
            } else if (nextChar == 's') {
                Object obj3;
                String fullKey = EtchingHelper.extractKeyWithCase(description, start + 2);
                String caseKey = "";
                String key3 = fullKey;
                int slashIndex = fullKey.indexOf(47);
                if (slashIndex != -1) {
                    caseKey = fullKey.substring(slashIndex + 1);
                    key3 = fullKey.substring(0, slashIndex);
                }
                if ((obj3 = values.get(key3)) != null) {
                    String stringValue = obj3.toString();
                    if ("ability".equals(caseKey)) {
                        stringValue = ModConfigs.ABILITIES.getAbilityById(stringValue).map(Skill::getName).orElse(stringValue);
                    } else if ("effect".equals(caseKey)) {
                        stringValue = I18n.m_118938_((String)((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ResourceLocation.m_135820_((String)stringValue))).m_19481_(), (Object[])new Object[0]);
                    }
                    result.append(stringValue);
                    index = start + 2 + fullKey.length();
                    continue;
                }
            } else if (nextChar == '.') {
                boolean isFloat;
                int end;
                for (end = start + 2; end < description.length() && Character.isDigit(description.charAt(end)); ++end) {
                }
                boolean isPercentage = description.startsWith("fp", end);
                boolean bl = isFloat = description.charAt(end) == 'f';
                if (isFloat || isPercentage) {
                    int decimals = Integer.parseInt(description.substring(start + 2, end));
                    int keyStart = end + (isPercentage ? 2 : 1);
                    String key4 = EtchingHelper.extractKey(description, keyStart);
                    Object obj4 = values.get(key4);
                    if (obj4 instanceof Number) {
                        double numberValue;
                        Number number = (Number)obj4;
                        double d = numberValue = isFloat ? (double)number.floatValue() : number.doubleValue();
                        if (isPercentage) {
                            numberValue *= 100.0;
                        }
                        result.append(String.format("%." + decimals + "f", numberValue));
                        index = keyStart + key4.length();
                        continue;
                    }
                }
            } else if (nextChar == 't' && (obj = values.get(key = EtchingHelper.extractKey(description, start + 2))) instanceof Number) {
                Number number = (Number)obj;
                result.append(number.intValue() / 20);
                index = start + 2 + key.length();
                continue;
            }
            result.append('%');
            index = start + 1;
        }
        return result.toString();
    }

    private static String extractKey(String str, int start) {
        int end;
        for (end = start; end < str.length() && Character.isJavaIdentifierPart(str.charAt(end)); ++end) {
        }
        return str.substring(start, end);
    }

    private static String extractKeyWithCase(String str, int start) {
        int end;
        for (end = start; end < str.length() && (Character.isJavaIdentifierPart(str.charAt(end)) || str.charAt(end) == '/'); ++end) {
        }
        return str.substring(start, end);
    }

    public static boolean hasEtching(LivingEntity player, VaultGearAttribute<?> etching) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            Object data;
            ItemStack stack = player.m_6844_(slot);
            if (stack.m_41619_() || !AttributeGearData.hasData(stack) || ((AttributeGearData)(data = AttributeGearData.read(stack))).getAttributes(etching).findAny().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static Optional<?> getEtching(ItemStack stack) {
        VaultGearData data = VaultGearData.read(stack);
        ResourceLocation etchingId = data.getAttributes(ModGearAttributes.ETCHING).findFirst().map(VaultGearAttributeInstance::getValue).orElse(null);
        if (etchingId == null) {
            return Optional.empty();
        }
        VaultGearAttribute<?> attribute = VaultGearAttributeRegistry.getAttribute(etchingId);
        return data.getFirstValue(attribute);
    }
}

