/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.item;

import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import iskallia.vault.config.VaultRecyclerConfig;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.dynamodel.DynamicModel;
import iskallia.vault.dynamodel.DynamicModelItem;
import iskallia.vault.gear.GearRollHelper;
import iskallia.vault.gear.VaultGearClassification;
import iskallia.vault.gear.VaultGearHelper;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.VaultGearType;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.GearDataCache;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.IdentifiableItem;
import iskallia.vault.gear.tooltip.VaultGearTooltipItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.IAnvilPreventCombination;
import iskallia.vault.item.IConditionalDamageable;
import iskallia.vault.item.core.DataTransferItem;
import iskallia.vault.item.core.VaultLevelItem;
import iskallia.vault.item.gear.RecyclableItem;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.util.VHSmpUtil;
import iskallia.vault.world.data.DiscoveredModelsData;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.extensions.IForgeItem;
import org.apache.commons.lang3.ObjectUtils;

public interface VaultGearItem
extends IForgeItem,
VaultGearTooltipItem,
DataTransferItem,
VaultLevelItem,
RecyclableItem,
DynamicModelItem,
IConditionalDamageable,
IAnvilPreventCombination,
IdentifiableItem {
    public static final JavaRandom random = JavaRandom.ofNanoTime();
    public static final int BROKEN_DAMAGE_VALUE = -1;

    default public Item getItem() {
        return (Item)this;
    }

    public static boolean matches(ItemStack stack) {
        return stack.m_41720_() instanceof VaultGearItem;
    }

    public static <T extends VaultGearItem> T of(ItemStack stack) {
        if (!VaultGearItem.matches(stack)) {
            throw new IllegalArgumentException("Item is not VaultGear: %s".formatted(stack));
        }
        return (T)((VaultGearItem)stack.m_41720_());
    }

    public static JsonObject serializeGearData(ItemStack stack) {
        return ((AttributeGearData)AttributeGearData.read(stack)).serialize();
    }

    default public ItemStack defaultItem() {
        ItemStack stack = new ItemStack((ItemLike)this.getItem());
        VaultGearData.read(stack).write(stack);
        return stack;
    }

    @Override
    default public boolean shouldPreventAnvilCombination(ItemStack other) {
        return other.m_41720_() instanceof VaultGearItem;
    }

    @Override
    default public boolean isImmuneToDamage(ItemStack stack, @Nullable Player player) {
        if (player == null) {
            return false;
        }
        if (VaultUtils.getVault(player.m_183503_()).map(vault -> VaultUtils.isRaidVault(vault) || VaultUtils.isTrialVault(vault)).orElse(false).booleanValue()) {
            return true;
        }
        return !VaultUtils.isVaultLevel(player.m_183503_()) && !VHSmpUtil.isArenaWorld((Entity)player);
    }

    @Override
    @Nullable
    default public Optional<ResourceLocation> getDynamicModelId(ItemStack itemStack) {
        GearDataCache cache = GearDataCache.of(itemStack);
        VaultGearState state = (VaultGearState)((Object)ObjectUtils.firstNonNull((Object[])new VaultGearState[]{cache.getState(), VaultGearState.UNIDENTIFIED}));
        if (state == VaultGearState.UNIDENTIFIED) {
            return Optional.empty();
        }
        return cache.getGearModel();
    }

    default public Optional<? extends DynamicModel<?>> resolveDynamicModel(ItemStack stack, ResourceLocation key) {
        return Optional.empty();
    }

    @Override
    default public void initializeVaultLoot(int vaultLevel, ItemStack stack, @Nullable BlockPos pos, @Nullable Vault vault) {
        VaultGearData data = VaultGearData.read(stack);
        data.setItemLevel(vaultLevel);
        data.createOrReplaceAttributeValue(ModGearAttributes.IS_LOOT, vault != null);
        data.write(stack);
    }

    @Override
    default public ItemStack convertStack(ItemStack stack, RandomSource random) {
        String modelStr;
        String modelAttrKey;
        CompoundTag tag;
        EquipmentSlot slot = this.getGearType(stack).getEquipmentSlot();
        if (stack.m_41782_() && slot != null && (tag = stack.m_41784_()).m_128425_(modelAttrKey = ModGearAttributes.GEAR_MODEL.getRegistryName().toString(), 8) && (modelStr = tag.m_128461_(modelAttrKey)).equalsIgnoreCase("random")) {
            DynamicModel randomModel;
            HashSet models = new HashSet();
            ModConfigs.GEAR_MODEL_ROLL_RARITIES.getRolls(stack).forEach((rarity, modelList) -> {
                if (rarity.equals(VaultGearRarity.UNIQUE.name()) || rarity.equals(VaultGearRarity.SPECIAL.name())) {
                    return;
                }
                models.addAll(modelList);
            });
            List<DynamicModel> armorModelSet = models.stream().map(ResourceLocation::new).map(key -> this.resolveDynamicModel(stack, (ResourceLocation)key)).filter(Optional::isPresent).map(Optional::get).toList();
            DynamicModel dynamicModel = randomModel = armorModelSet.isEmpty() ? null : armorModelSet.get(random.nextInt(armorModelSet.size()));
            if (randomModel != null) {
                VaultGearData data = VaultGearData.read(stack);
                data.createOrReplaceAttributeValue(ModGearAttributes.GEAR_MODEL, randomModel.getId());
                data.write(stack);
            }
            tag.m_128473_(modelAttrKey);
        }
        ItemStack result = DataTransferItem.super.convertStack(stack, random);
        VaultGearHelper.initializeGearRollType(result, VaultGearData.read(result).getItemLevel(), random);
        return result;
    }

    @Override
    default public Optional<UUID> getUuid(ItemStack stack) {
        return AttributeGearData.readUUID(stack);
    }

    default public boolean shouldCauseEquipmentCooldown(ServerPlayer sPlayer, ItemStack stack, EquipmentSlot slot) {
        return !sPlayer.m_7500_() && VaultUtils.getVault((Level)sPlayer.m_183503_()).map(VaultUtils::isRoyaleVault).orElse(false) == false;
    }

    @Override
    default public boolean isValidInput(ItemStack input) {
        return !input.m_41619_() && AttributeGearData.hasData(input);
    }

    @Override
    default public VaultRecyclerConfig.RecyclerOutput getOutput(ItemStack input) {
        return ModConfigs.VAULT_RECYCLER.getRecyclingOutput(VaultMod.id("gear")).orElse(ModConfigs.VAULT_RECYCLER.getDefaultRecyclingOutput());
    }

    @Override
    default public float getResultPercentage(ItemStack input) {
        if (input.m_41619_()) {
            return 0.0f;
        }
        if (VaultGearData.read(input).getState() != VaultGearState.IDENTIFIED) {
            return 1.0f;
        }
        if (!input.m_41763_()) {
            return 1.0f;
        }
        return 1.0f - (float)input.m_41773_() / (float)input.m_41776_();
    }

    default public void setItemLevel(ItemStack stack, Player player) {
        this.setItemLevel(stack, SidedHelper.getVaultLevel(player));
    }

    default public void setItemLevel(ItemStack stack, int level) {
        VaultGearData data = VaultGearData.read(stack);
        data.setItemLevel(level);
        data.write(stack);
    }

    @Nonnull
    public VaultGearClassification getClassification(ItemStack var1);

    @Nonnull
    public VaultGearType getGearType(ItemStack var1);

    @Nullable
    public ResourceLocation getRandomModel(ItemStack var1, Random var2, @Nullable Player var3, @Nullable DiscoveredModelsData var4);

    default public int getRandomColor(ItemStack stack, Random random) {
        List<Integer> colors = Arrays.stream(DyeColor.values()).filter(color -> color != DyeColor.BLACK && color != DyeColor.GRAY && color != DyeColor.LIGHT_GRAY).map(DyeColor::m_41071_).toList();
        return colors.get(random.nextInt(colors.size()));
    }

    default public boolean isIntendedForSlot(ItemStack stack, EquipmentSlot slotType) {
        return this.getGearType(stack).getEquipmentSlot() == slotType;
    }

    default public void setDamage(ItemStack stack, int newDamage) {
        int maxDamage = stack.m_41776_();
        if (stack.m_41773_() == newDamage) {
            return;
        }
        if (stack.m_41773_() == -1 && newDamage < maxDamage) {
            stack.m_41784_().m_128405_("Damage", newDamage);
            VaultGearData.read(stack).write(stack);
            return;
        }
        if (newDamage == -1 || newDamage >= maxDamage) {
            stack.m_41784_().m_128405_("Damage", -1);
            VaultGearData.read(stack).write(stack);
            return;
        }
        super.setDamage(stack, newDamage);
    }

    default public boolean isBroken(ItemStack stack) {
        return stack.m_41773_() == -1;
    }

    default public void vaultGearTick(ItemStack stack, ServerPlayer player) {
        VaultGearHelper.initializeGearRollType(stack, player);
        this.inventoryIdentificationTick((Player)player, stack);
    }

    @Override
    default public void tickRoll(ItemStack stack, @Nullable Player player) {
        GearRollHelper.tickGearRoll(stack, player);
    }

    @Override
    default public void tickFinishRoll(ItemStack stack, @Nullable Player player, boolean identify) {
        if (identify) {
            GearRollHelper.initializeAndDiscoverGear(stack, player);
        } else {
            GearRollHelper.initializeGear(stack, player);
        }
    }

    default public boolean canStoreRepairSlots(ItemStack stack) {
        return true;
    }
}

