/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.model.armor.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.dynamodel.model.armor.ArmorLayers;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.gear.data.GearDataCache;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModParticles;
import iskallia.vault.util.ModelPartHelper;
import java.util.HashSet;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ChampionArmorLayers
extends ArmorLayers {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Supplier<LayerDefinition> getGeometrySupplier(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.LEGS ? LeggingsLayer::createBodyLayer : MainLayer::createBodyLayer;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ArmorLayers.VaultArmorLayerSupplier<? extends ArmorLayers.BaseLayer> getLayerSupplier(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.LEGS ? LeggingsLayer::new : MainLayer::new;
    }

    @SubscribeEvent
    public static void shiningParticles(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!entity.f_19853_.m_5776_()) {
            return;
        }
        Level world = entity.f_19853_;
        HashSet<EquipmentSlot> slots = new HashSet<EquipmentSlot>();
        for (ItemStack itemStack : entity.m_6168_()) {
            ArmorPieceModel armorPieceModel;
            GearDataCache vaultGearData;
            ResourceLocation modelId;
            if (!(itemStack.m_41720_() instanceof VaultGearItem) || (modelId = (ResourceLocation)(vaultGearData = GearDataCache.of(itemStack)).getGearModel().orElse(null)) == null || (armorPieceModel = (ArmorPieceModel)ModDynamicModels.Armor.PIECE_REGISTRY.get(modelId).orElse(null)) == null || ModDynamicModels.Armor.CHAMPION != armorPieceModel.getArmorModel()) continue;
            slots.add(armorPieceModel.getEquipmentSlot());
        }
        if (slots.contains(EquipmentSlot.FEET)) {
            ChampionArmorLayers.addTrailingParticle(entity);
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (entity == minecraft.f_91074_ && minecraft.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            return;
        }
        if (slots.contains(EquipmentSlot.HEAD)) {
            ChampionArmorLayers.addShiningParticle(entity, world, 1.75f);
        }
        if (slots.contains(EquipmentSlot.CHEST)) {
            ChampionArmorLayers.addShiningParticle(entity, world, 1.1f);
        }
        if (slots.contains(EquipmentSlot.LEGS)) {
            ChampionArmorLayers.addShiningParticle(entity, world, 0.8f);
        }
        if (slots.contains(EquipmentSlot.FEET)) {
            ChampionArmorLayers.addShiningParticle(entity, world, 0.1f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void addShiningParticle(LivingEntity entity, Level world, float yOffset) {
        Particle particle;
        Minecraft minecraft = Minecraft.m_91087_();
        if (entity.f_19797_ % 2 == 0 && world.f_46441_.nextBoolean() && (particle = minecraft.f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_175831_, entity.m_20185_() + (double)(world.f_46441_.nextFloat() - 0.5f), entity.m_20186_() + (double)(world.f_46441_.nextFloat() - 0.5f) + (double)yOffset, entity.m_20189_() + (double)(world.f_46441_.nextFloat() - 0.5f), 0.0, 0.0, 0.0)) != null) {
            int index = world.f_46441_.nextInt(4);
            int color = index == 0 ? 7798486 : (index == 1 ? 5307221 : (index == 2 ? 16113515 : 0xFF6F6F));
            particle.m_107253_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        }
    }

    private static void addTrailingParticle(LivingEntity entity) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (entity.f_19797_ % 2 == 0 && entity.m_20096_()) {
            Particle particle;
            Vec3 velocity = entity.m_20184_();
            if (velocity.f_82479_ != 0.0 && velocity.f_82480_ != 0.0 && velocity.f_82481_ != 0.0 && (particle = minecraft.f_91061_.m_107370_((ParticleOptions)ModParticles.NOVA_CLOUD.get(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0.0, 0.0, 0.0)) != null) {
                int color = 14676375;
                particle.m_107253_((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LeggingsLayer
    extends ArmorLayers.LeggingsLayer {
        public LeggingsLayer(ArmorPieceModel definition, ModelPart root) {
            super(definition, root);
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = LeggingsLayer.createBaseLayer();
            PartDefinition partdefinition = meshdefinition.m_171576_();
            PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.51f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r1 = body.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(10, 32).m_171488_(-0.5f, 1.0f, -0.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(31, 31).m_171488_(-1.0f, -5.0f, -0.5f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.2655f, (float)15.9141f, (float)2.7325f, (float)2.8424f, (float)-0.8559f, (float)3.0531f));
            PartDefinition cube_r2 = body.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-1.0f, -3.75f, -1.0f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(28, 14).m_171488_(-0.5f, 2.25f, -1.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)15.0f, (float)-3.5f, (float)-0.3232f, (float)-0.4934f, (float)-0.1154f));
            PartDefinition cube_r3 = body.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(12, 16).m_171488_(-2.0f, 0.5f, -0.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(24, 7).m_171488_(-2.5f, -5.5f, -0.5f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.2221f, (float)16.2544f, (float)3.243f, (float)2.7323f, (float)1.0029f, (float)3.1031f));
            PartDefinition cube_r4 = body.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(28, 17).m_171488_(-0.7f, 1.7f, -0.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171488_(-1.2f, -4.3f, -0.5f, 4.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)15.0f, (float)-3.5f, (float)-0.3142f, (float)0.4887f, (float)0.1222f));
            PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
            PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
            return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MainLayer
    extends ArmorLayers.MainLayer {
        protected ModelPart leftWing;
        protected ModelPart rightWing;

        public MainLayer(ArmorPieceModel definition, ModelPart root) {
            super(definition, root);
            ModelPart body = root.m_171324_("body");
            this.leftWing = body.m_171324_("left_wing");
            this.rightWing = body.m_171324_("right_wing");
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = MainLayer.createBaseLayer();
            PartDefinition partdefinition = meshdefinition.m_171576_();
            PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.0f)).m_171514_(76, 94).m_171488_(-6.0f, -8.0f, 0.0f, 1.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 90).m_171488_(-6.0f, -2.0f, -5.0f, 1.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(87, 76).m_171488_(5.0f, -2.0f, -5.0f, 1.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(70, 94).m_171488_(5.0f, -8.0f, 0.0f, 1.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(78, 47).m_171488_(-3.0f, -11.0f, -8.0f, 6.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(66, 36).m_171488_(-4.0f, -12.0f, -4.0f, 8.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(16, 65).m_171488_(-4.0f, -12.0f, 3.0f, 8.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171488_(-5.0f, -13.0f, 0.0f, 10.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(80, 25).m_171488_(-9.0f, -10.0f, -1.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(70, 78).m_171488_(5.0f, -10.0f, -1.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r1 = head.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(64, 51).m_171488_(-5.0f, -4.5f, -5.5f, 3.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.21f, (float)-7.8551f, (float)8.2645f, (float)0.3927f, (float)-0.5672f, (float)0.0f));
            PartDefinition cube_r2 = head.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(49, 16).m_171488_(-4.0f, -1.5f, 0.5f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.1329f, (float)-9.8257f, (float)5.597f, (float)0.5256f, (float)0.1268f, (float)0.144f));
            PartDefinition cube_r3 = head.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(83, 11).m_171488_(-1.9f, -2.0f, -1.5f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)10.6812f, (float)-11.0286f, (float)7.5001f, (float)0.5256f, (float)-0.1268f, (float)-0.144f));
            PartDefinition cube_r4 = head.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(66, 25).m_171488_(-2.0f, -3.0f, -3.0f, 3.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)9.0f, (float)-8.0f, (float)3.0f, (float)0.3927f, (float)0.5672f, (float)0.0f));
            PartDefinition cube_r5 = head.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(85, 18).m_171488_(1.0f, -8.5f, 1.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(46, 8).m_171488_(1.0f, -2.5f, 1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(64, 47).m_171488_(-1.0f, -1.5f, 2.0f, 6.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.4462f, (float)-0.5f, (float)-9.0f, (float)0.0f, (float)-0.5236f, (float)0.0f));
            PartDefinition cube_r6 = head.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(42, 41).m_171488_(-3.0f, -1.5f, 0.0f, 6.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(85, 5).m_171488_(0.0f, -8.5f, -1.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 0).m_171488_(0.0f, -2.5f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0179f, (float)-0.5f, (float)-6.2679f, (float)0.0f, (float)0.5236f, (float)0.0f));
            PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(42, 59).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(1.01f)).m_171514_(32, 75).m_171488_(-4.0f, 0.0f, 3.0f, 8.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r7 = body.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(42, 25).m_171488_(-0.8097f, 6.0f, -2.9567f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(58, 31).m_171488_(-2.8097f, 4.0f, -2.9567f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(82, 62).m_171488_(-4.8097f, 0.0f, -1.9567f, 6.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.4518f, (float)-1.0f, (float)-7.0f, (float)0.4215f, (float)0.3614f, (float)0.1572f));
            PartDefinition cube_r8 = body.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(58, 25).m_171488_(1.8097f, 4.0f, -2.9567f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171488_(-0.1903f, 6.0f, -2.9567f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(69, 16).m_171488_(-1.1903f, 0.0f, -1.9567f, 6.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.25f, (float)-1.0f, (float)-7.0f, (float)0.4215f, (float)-0.3614f, (float)-0.1572f));
            PartDefinition cube_r9 = body.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.1903f, -2.0f, -1.9567f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.25f, (float)9.0f, (float)-5.0f, (float)-0.4215f, (float)-0.3614f, (float)0.1572f));
            PartDefinition cube_r10 = body.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(58, 16).m_171488_(3.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.2645f, (float)2.777f, (float)-6.709f, (float)-0.2898f, (float)-0.015f, (float)0.27f));
            PartDefinition cube_r11 = body.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(20, 16).m_171488_(-0.5f, -4.0f, -1.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0817f, (float)4.9613f, (float)-6.2673f, (float)-0.2633f, (float)-0.1235f, (float)-0.1085f));
            PartDefinition cube_r12 = body.m_171599_("cube_r12", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(9.0f, -2.0f, -1.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.8324f, (float)5.4909f, (float)-5.6323f, (float)-0.2633f, (float)-0.1235f, (float)-0.1085f));
            PartDefinition cube_r13 = body.m_171599_("cube_r13", CubeListBuilder.m_171558_().m_171514_(57, 40).m_171488_(-1.0f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.8324f, (float)5.4909f, (float)-5.6323f, (float)-0.2898f, (float)-0.015f, (float)0.27f));
            PartDefinition cube_r14 = body.m_171599_("cube_r14", CubeListBuilder.m_171558_().m_171514_(85, 0).m_171488_(-4.8097f, -2.0f, -1.9567f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.4518f, (float)9.0f, (float)-5.0f, (float)-0.4215f, (float)0.3614f, (float)-0.1572f));
            PartDefinition left_wing = body.m_171599_("left_wing", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)3.0f, (float)2.0f, (float)3.5f, (float)0.0f, (float)-0.0436f, (float)0.0f));
            PartDefinition cube_r15 = left_wing.m_171599_("cube_r15", CubeListBuilder.m_171558_().m_171514_(0, 65).m_171488_(2.0f, -2.0f, 16.5f, 2.0f, 23.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(46, 8).m_171488_(1.0f, -6.0f, 15.5f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(42, 25).m_171488_(2.0f, -5.0f, -4.5f, 2.0f, 2.0f, 20.0f, new CubeDeformation(0.0f)).m_171514_(0, 22).m_171488_(2.75f, -3.0f, -4.5f, 0.0f, 22.0f, 21.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)7.0f, (float)0.7316f, (float)0.443f, (float)0.0211f));
            PartDefinition right_wing = body.m_171599_("right_wing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)2.0f, (float)3.5f));
            PartDefinition cube_r16 = right_wing.m_171599_("cube_r16", CubeListBuilder.m_171558_().m_171514_(8, 65).m_171488_(-1.0f, -11.5f, -1.0f, 2.0f, 23.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(0.0f, -12.5f, -22.0f, 0.0f, 22.0f, 21.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-11.5571f, (float)-5.76f, (float)24.4215f, (float)0.7156f, (float)-0.4363f, (float)-0.0209f));
            PartDefinition cube_r17 = right_wing.m_171599_("cube_r17", CubeListBuilder.m_171558_().m_171514_(54, 75).m_171488_(-5.0f, -6.5f, 17.5f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(42, 0).m_171488_(-4.0f, -5.5f, -5.5f, 2.0f, 2.0f, 23.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)7.0f, (float)0.7156f, (float)-0.4363f, (float)-0.0209f));
            PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(16, 74).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)).m_171514_(72, 86).m_171488_(-6.0f, 4.0f, -2.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
            PartDefinition cube_r18 = right_arm.m_171599_("cube_r18", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171488_(-0.5f, 2.5f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(94, 84).m_171488_(-1.0f, -1.5f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.0f, (float)9.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
            PartDefinition cube_r19 = right_arm.m_171599_("cube_r19", CubeListBuilder.m_171558_().m_171514_(91, 92).m_171488_(-2.5f, -4.5f, -1.5f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.0f, (float)9.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
            PartDefinition cube_r20 = right_arm.m_171599_("cube_r20", CubeListBuilder.m_171558_().m_171514_(94, 69).m_171488_(1.5f, -1.5f, 3.375f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(32, 84).m_171488_(-4.5f, -5.5f, 2.375f, 3.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(42, 84).m_171488_(-4.5f, -5.5f, -0.375f, 3.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(84, 84).m_171488_(-4.5f, -4.5f, -2.875f, 3.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(22, 90).m_171488_(-4.5f, -2.5f, -5.375f, 3.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(42, 47).m_171488_(-1.5f, 0.5f, -4.625f, 7.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.5f, (float)-3.5f, (float)0.625f, (float)0.0f, (float)0.0f, (float)-0.3927f));
            PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(69, 0).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
            PartDefinition cube_r21 = left_arm.m_171599_("cube_r21", CubeListBuilder.m_171558_().m_171514_(62, 84).m_171488_(1.5f, -4.5f, -2.875f, 3.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(52, 83).m_171488_(1.5f, -5.5f, -0.375f, 3.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(82, 69).m_171488_(1.5f, -5.5f, 2.375f, 3.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(94, 41).m_171488_(-4.5f, -1.5f, 3.375f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(24, 8).m_171488_(-5.5f, 0.5f, -4.625f, 7.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(12, 90).m_171488_(1.5f, -2.5f, -5.375f, 3.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.5f, (float)-3.5f, (float)0.625f, (float)0.0f, (float)0.0f, (float)0.3927f));
            PartDefinition cube_r22 = left_arm.m_171599_("cube_r22", CubeListBuilder.m_171558_().m_171514_(94, 56).m_171488_(-1.0f, -1.5f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(42, 20).m_171488_(-0.5f, 2.5f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)7.0f, (float)9.5f, (float)0.0f, (float)-3.1416f, (float)0.0f, (float)-2.7489f));
            PartDefinition cube_r23 = left_arm.m_171599_("cube_r23", CubeListBuilder.m_171558_().m_171514_(92, 18).m_171488_(-2.5f, -4.5f, -1.5f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)7.0f, (float)9.5f, (float)0.0f, (float)-3.1416f, (float)0.0f, (float)2.3562f));
            PartDefinition cube_r24 = left_arm.m_171599_("cube_r24", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171488_(7.0f, 4.0f, -2.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)13.0f, (float)0.0f, (float)0.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
            PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(66, 62).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
            PartDefinition cube_r25 = right_leg.m_171599_("cube_r25", CubeListBuilder.m_171558_().m_171514_(66, 25).m_171488_(0.0f, -4.5f, -1.75f, 1.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)9.0671f, (float)-5.4526f, (float)0.5672f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r26 = right_leg.m_171599_("cube_r26", CubeListBuilder.m_171558_().m_171514_(86, 56).m_171488_(-1.0f, -1.5f, -2.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(92, 5).m_171488_(-2.0f, -3.5f, -0.5f, 4.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)9.5f, (float)-3.5f, (float)-0.2182f, (float)0.0f, (float)0.0f));
            PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(42, 25).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
            PartDefinition cube_r27 = left_leg.m_171599_("cube_r27", CubeListBuilder.m_171558_().m_171514_(90, 33).m_171488_(-2.0f, -3.5f, -0.5f, 4.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(42, 47).m_171488_(-1.0f, -1.5f, -2.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.2f, (float)9.5f, (float)-3.5f, (float)-0.2182f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r28 = left_leg.m_171599_("cube_r28", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -4.5f, -1.75f, 1.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.3f, (float)9.0671f, (float)-5.4526f, (float)0.5672f, (float)0.0f, (float)0.0f));
            return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
        }

        @Override
        public void m_7695_(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            ModelPartHelper.runPreservingTransforms(() -> {
                this.animateParts();
                super.m_7695_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            }, this.rightWing, this.leftWing);
        }

        private void animateParts() {
            this.leftWing.f_104203_ = Mth.m_184637_((float)((float)Math.sin((double)System.currentTimeMillis() / 1000.0)), (float)-1.0f, (float)1.0f, (float)0.0f, (float)0.17453294f);
            this.leftWing.f_104204_ = Mth.m_184637_((float)((float)Math.sin((double)System.currentTimeMillis() / 500.0)), (float)-1.0f, (float)1.0f, (float)0.0f, (float)0.5235988f);
            this.rightWing.f_104203_ = this.leftWing.f_104203_;
            this.rightWing.f_104204_ = -this.leftWing.f_104204_;
        }
    }
}

