/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.model.armor.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.dynamodel.model.armor.ArmorLayers;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.util.ModelPartHelper;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Companion10ArmorLayers
extends ArmorLayers {
    @Override
    public Supplier<LayerDefinition> getGeometrySupplier(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.LEGS ? LeggingsLayer::createBodyLayer : MainLayer::createBodyLayer;
    }

    @Override
    public ArmorLayers.VaultArmorLayerSupplier<? extends ArmorLayers.BaseLayer> getLayerSupplier(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.LEGS ? LeggingsLayer::new : MainLayer::new;
    }

    public static class LeggingsLayer
    extends ArmorLayers.LeggingsLayer {
        private final ModelPart rl;
        private final ModelPart ll;

        public LeggingsLayer(ArmorPieceModel definition, ModelPart root) {
            super(definition, root);
            ModelPart rightLeg2 = root.m_171324_("right_leg");
            this.rl = rightLeg2.m_171324_("rl");
            ModelPart leftLeg2 = root.m_171324_("left_leg");
            this.ll = leftLeg2.m_171324_("ll");
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = LeggingsLayer.createBaseLayer();
            PartDefinition partdefinition = meshdefinition.m_171576_();
            PartDefinition RightLeg2 = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(16, 60).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.3f)).m_171555_(false).m_171514_(13, 69).m_171480_().m_171488_(-2.0f, 2.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.2f)).m_171555_(false).m_171514_(0, 60).m_171480_().m_171488_(-2.0f, 5.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.3f)).m_171555_(false), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
            PartDefinition rl = RightLeg2.m_171599_("rl", CubeListBuilder.m_171558_().m_171514_(0, 69).m_171480_().m_171488_(0.0f, 1.5f, -1.5f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 69).m_171480_().m_171488_(0.0f, -1.5f, -2.5f, 0.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 67).m_171480_().m_171488_(0.0f, -2.5f, -1.5f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.8f, (float)2.5f, (float)0.0f));
            PartDefinition LeftLeg2 = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(16, 60).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.3f)).m_171514_(13, 69).m_171488_(-2.0f, 2.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.2f)).m_171514_(0, 60).m_171488_(-2.0f, 5.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.3f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
            PartDefinition ll = LeftLeg2.m_171599_("ll", CubeListBuilder.m_171558_().m_171514_(0, 69).m_171488_(0.0f, 1.5f, -1.5f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 69).m_171488_(0.0f, -1.5f, -2.5f, 0.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 67).m_171488_(0.0f, -2.5f, -1.5f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.8f, (float)2.5f, (float)0.0f));
            return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
        }

        @Override
        public void m_7695_(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            ModelPartHelper.runPreservingTransforms(() -> {
                this.animateParts();
                super.m_7695_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            }, this.rl, this.ll);
        }

        private void animateParts() {
            this.rl.f_104203_ = (float)Math.toRadians((double)(System.currentTimeMillis() % 10000L) / 10000.0 * 360.0);
            this.ll.f_104203_ = (float)Math.toRadians((double)(System.currentTimeMillis() % 10000L) / 10000.0 * -360.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MainLayer
    extends ArmorLayers.MainLayer {
        private final ModelPart crystalBone;

        public MainLayer(ArmorPieceModel definition, ModelPart root) {
            super(definition, root);
            ModelPart body = root.m_171324_("body");
            this.crystalBone = body.m_171324_("bone");
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = MainLayer.createBaseLayer();
            PartDefinition partdefinition = meshdefinition.m_171576_();
            PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(101, 0).m_171488_(-4.0f, 0.0f, -2.5f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(101, 8).m_171488_(2.0f, 0.0f, -2.5f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(101, 24).m_171488_(-4.0f, 10.0f, -2.5f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(101, 16).m_171488_(2.0f, 10.0f, -2.5f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(103, 44).m_171488_(-2.0f, 5.0f, 2.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r1 = body.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(103, 38).m_171488_(-1.0f, -3.0f, -0.15f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(109, 38).m_171488_(-1.0f, -3.0f, -5.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)9.0f, (float)2.6f, (float)0.0f, (float)0.0f, (float)-0.5236f));
            PartDefinition cube_r2 = body.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(109, 38).m_171488_(-1.0f, -3.0f, -0.15f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(103, 38).m_171488_(-1.0f, -3.0f, -5.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)9.0f, (float)2.6f, (float)0.0f, (float)0.0f, (float)0.5236f));
            PartDefinition cube_r3 = body.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(103, 32).m_171488_(-1.0f, -2.0f, -0.15f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(109, 32).m_171488_(-1.0f, -2.0f, -5.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)3.0f, (float)2.6f, (float)0.0f, (float)0.0f, (float)0.5236f));
            PartDefinition cube_r4 = body.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(109, 32).m_171488_(-1.0f, -2.0f, -0.15f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(103, 32).m_171488_(-1.0f, -2.0f, -5.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)3.0f, (float)2.6f, (float)0.0f, (float)0.0f, (float)-0.5236f));
            PartDefinition bone = body.m_171599_("bone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)5.5f, (float)-2.4f));
            PartDefinition cube_r5 = bone.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(116, 38).m_171488_(-1.5f, -5.5f, -1.5f, 3.0f, 9.0f, 3.0f, new CubeDeformation(-1.0f)).m_171514_(116, 17).m_171488_(-1.5f, -4.5f, -1.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(-0.5f)).m_171514_(116, 0).m_171488_(-1.5f, -3.5f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
            PartDefinition bone3 = body.m_171599_("bone3", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.2506f, (float)2.0268f, (float)2.563f));
            PartDefinition cube_r6 = bone3.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(72, 27).m_171488_(-5.4745f, -6.7427f, 0.0295f, 1.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(77, 27).m_171488_(-6.4746f, -7.7427f, 0.0295f, 1.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(75, 27).m_171488_(-7.4746f, -9.7427f, 0.0295f, 1.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(88, 27).m_171488_(-9.4746f, -11.7427f, 0.0295f, 2.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(85, 27).m_171488_(-10.4746f, -12.7427f, 0.0295f, 1.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(83, 27).m_171488_(-11.4746f, -13.7427f, 0.0295f, 1.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.3441f, (float)6.7427f, (float)-1.9731f, (float)0.0f, (float)0.7199f, (float)0.0f));
            PartDefinition cube_r7 = bone3.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(81, 27).m_171488_(-12.3724f, -14.7427f, 1.527f, 1.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(93, 27).m_171488_(-15.3724f, -15.7427f, 1.527f, 3.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(81, 11).m_171488_(-24.3724f, -16.7427f, 1.527f, 9.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.3441f, (float)6.7427f, (float)-1.9731f, (float)0.0f, (float)0.589f, (float)0.0f));
            PartDefinition cube_r8 = bone3.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(85, 0).m_171488_(9.8373f, -23.2875f, -5.3433f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.3441f, (float)6.7427f, (float)-1.9731f, (float)-0.5909f, (float)-0.3272f, (float)-1.0211f));
            PartDefinition cube_r9 = bone3.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(90, 0).m_171488_(2.6218f, -19.8235f, -2.278f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.3441f, (float)6.7427f, (float)-1.9731f, (float)-0.5005f, (float)-0.1127f, (float)-0.6804f));
            PartDefinition cube_r10 = bone3.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(95, 0).m_171488_(-1.0f, -9.0f, 0.0f, 1.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.2974f, (float)3.1079f, (float)-0.143f, (float)-0.3054f, (float)0.0f, (float)-0.3927f));
            PartDefinition bone4 = body.m_171599_("bone4", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.2506f, (float)2.0268f, (float)2.563f));
            PartDefinition cube_r11 = bone4.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(72, 27).m_171480_().m_171488_(4.4745f, -6.7427f, 0.0295f, 1.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(77, 27).m_171480_().m_171488_(5.4745f, -7.7427f, 0.0295f, 1.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(75, 27).m_171480_().m_171488_(6.4746f, -9.7427f, 0.0295f, 1.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(88, 27).m_171480_().m_171488_(7.4746f, -11.7427f, 0.0295f, 2.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(85, 27).m_171480_().m_171488_(9.4746f, -12.7427f, 0.0295f, 1.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(83, 27).m_171480_().m_171488_(10.4746f, -13.7427f, 0.0295f, 1.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.3441f, (float)6.7427f, (float)-1.9731f, (float)0.0f, (float)-0.7199f, (float)0.0f));
            PartDefinition cube_r12 = bone4.m_171599_("cube_r12", CubeListBuilder.m_171558_().m_171514_(81, 27).m_171480_().m_171488_(11.3724f, -14.7427f, 1.527f, 1.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(93, 27).m_171480_().m_171488_(12.3724f, -15.7427f, 1.527f, 3.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(81, 11).m_171480_().m_171488_(15.3724f, -16.7427f, 1.527f, 9.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.3441f, (float)6.7427f, (float)-1.9731f, (float)0.0f, (float)-0.589f, (float)0.0f));
            PartDefinition cube_r13 = bone4.m_171599_("cube_r13", CubeListBuilder.m_171558_().m_171514_(85, 0).m_171480_().m_171488_(-10.8373f, -23.2875f, -5.3433f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.3441f, (float)6.7427f, (float)-1.9731f, (float)-0.5909f, (float)0.3272f, (float)1.0211f));
            PartDefinition cube_r14 = bone4.m_171599_("cube_r14", CubeListBuilder.m_171558_().m_171514_(90, 0).m_171480_().m_171488_(-3.6218f, -19.8235f, -2.278f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.3441f, (float)6.7427f, (float)-1.9731f, (float)-0.5005f, (float)0.1127f, (float)0.6804f));
            PartDefinition cube_r15 = bone4.m_171599_("cube_r15", CubeListBuilder.m_171558_().m_171514_(95, 0).m_171480_().m_171488_(0.0f, -9.0f, 0.0f, 1.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.2974f, (float)3.1079f, (float)-0.143f, (float)-0.3054f, (float)0.0f, (float)0.3927f));
            PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-3.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.15f)).m_171514_(17, 28).m_171488_(-4.0f, -6.0f, -2.0f, 5.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(37, 32).m_171488_(-3.5f, 6.0f, -2.5f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(58, 38).m_171488_(-4.0f, -1.0f, -3.0f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(58, 35).m_171488_(0.0f, -2.0f, -3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(27, 45).m_171488_(-4.0f, -2.0f, -3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(53, 32).m_171488_(-4.0f, -3.0f, -3.0f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(22, 45).m_171488_(0.0f, -4.0f, -3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(17, 45).m_171488_(-4.0f, -4.0f, -3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(24, 42).m_171488_(-1.0f, -5.0f, -3.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(17, 42).m_171488_(-4.0f, -5.0f, -3.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(17, 39).m_171488_(-4.0f, -6.0f, -3.0f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
            PartDefinition cube_r16 = right_arm.m_171599_("cube_r16", CubeListBuilder.m_171558_().m_171514_(31, 0).m_171488_(0.3664f, -1.4429f, -4.9044f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(56, 5).m_171488_(-0.1561f, 0.4487f, -5.4325f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.5097f, (float)-8.3227f, (float)4.0237f, (float)-0.448f, (float)0.6845f, (float)-1.3928f));
            PartDefinition cube_r17 = right_arm.m_171599_("cube_r17", CubeListBuilder.m_171558_().m_171514_(62, 1).m_171488_(0.3893f, -2.0811f, -3.434f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(32, 4).m_171488_(-0.1333f, 0.8105f, -3.9622f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.5097f, (float)-8.3227f, (float)4.0237f, (float)-0.4738f, (float)0.3367f, (float)-0.7516f));
            PartDefinition cube_r18 = right_arm.m_171599_("cube_r18", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-1.9283f, -1.0466f, -4.2052f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(64, 5).m_171488_(-2.4057f, 0.8449f, -4.7334f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.5097f, (float)-8.3227f, (float)3.7737f, (float)-0.448f, (float)-0.6845f, (float)0.0838f));
            PartDefinition cube_r19 = right_arm.m_171599_("cube_r19", CubeListBuilder.m_171558_().m_171514_(54, 1).m_171488_(-0.8264f, -4.3858f, 1.5951f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(24, 2).m_171488_(-1.2894f, -2.103f, 1.0885f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.5097f, (float)-8.3227f, (float)4.0237f, (float)-1.1772f, (float)0.3975f, (float)-0.8421f));
            PartDefinition cube_r20 = right_arm.m_171599_("cube_r20", CubeListBuilder.m_171558_().m_171514_(38, 1).m_171488_(1.7216f, -0.949f, 2.1152f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(40, 5).m_171488_(1.3489f, 0.9093f, 1.6428f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.5097f, (float)-8.3227f, (float)3.0237f, (float)-1.0919f, (float)0.8235f, (float)-0.9105f));
            PartDefinition cube_r21 = right_arm.m_171599_("cube_r21", CubeListBuilder.m_171558_().m_171514_(46, 1).m_171488_(-2.184f, -6.3128f, -0.5787f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 5).m_171488_(-2.6865f, -4.0206f, -1.2183f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-3.5097f, -0.6716f, -1.6423f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(12, 3).m_171488_(-2.4424f, 0.6226f, -2.0735f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.5097f, (float)-8.3227f, (float)4.0237f, (float)-0.8164f, (float)0.0317f, (float)-0.9895f));
            PartDefinition cube_r22 = right_arm.m_171599_("cube_r22", CubeListBuilder.m_171558_().m_171514_(54, 45).m_171488_(-2.5f, -2.0f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(42, 45).m_171488_(-2.5f, -1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(47, 45).m_171488_(0.5f, -2.0f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(61, 45).m_171488_(-2.5f, -3.0f, -0.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(51, 42).m_171488_(-2.5f, 1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 45).m_171488_(1.5f, -1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(57, 42).m_171488_(-2.5f, 0.0f, -0.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(63, 35).m_171488_(1.5f, 1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(37, 42).m_171488_(-2.5f, 2.0f, -0.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)-3.0f, (float)2.5f, (float)0.0f, (float)0.0f, (float)-3.1416f));
            PartDefinition bone2 = right_arm.m_171599_("bone2", CubeListBuilder.m_171558_().m_171514_(-8, 39).m_171488_(-4.0f, 0.0f, -4.0f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)3.0f, (float)0.0f));
            PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171480_().m_171488_(-1.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.15f)).m_171555_(false).m_171514_(17, 28).m_171480_().m_171488_(-1.0f, -6.0f, -2.0f, 5.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(37, 32).m_171480_().m_171488_(-1.5f, 6.0f, -2.5f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
            PartDefinition cube_r23 = left_arm.m_171599_("cube_r23", CubeListBuilder.m_171558_().m_171514_(54, 45).m_171480_().m_171488_(0.5f, -2.0f, 2.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(42, 45).m_171480_().m_171488_(1.5f, -1.0f, 2.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(47, 45).m_171480_().m_171488_(-2.5f, -2.0f, 2.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(61, 45).m_171480_().m_171488_(-2.5f, -3.0f, 2.0f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(51, 42).m_171480_().m_171488_(1.5f, 1.0f, 2.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(37, 45).m_171480_().m_171488_(-2.5f, -1.0f, 2.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(57, 42).m_171480_().m_171488_(-2.5f, 0.0f, 2.0f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(63, 35).m_171480_().m_171488_(-2.5f, 1.0f, 2.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(37, 42).m_171480_().m_171488_(-2.5f, 2.0f, 2.0f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.5f, (float)-3.0f, (float)0.0f, (float)-3.1416f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r24 = left_arm.m_171599_("cube_r24", CubeListBuilder.m_171558_().m_171514_(17, 39).m_171480_().m_171488_(-2.5f, -3.0f, -3.0f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(17, 42).m_171480_().m_171488_(0.5f, -2.0f, -3.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(24, 42).m_171480_().m_171488_(-2.5f, -2.0f, -3.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(17, 45).m_171480_().m_171488_(1.5f, -1.0f, -3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(22, 45).m_171480_().m_171488_(-2.5f, -1.0f, -3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(53, 32).m_171480_().m_171488_(-2.5f, 0.0f, -3.0f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(27, 45).m_171480_().m_171488_(1.5f, 1.0f, -3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(58, 35).m_171480_().m_171488_(-2.5f, 1.0f, -3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(58, 38).m_171480_().m_171488_(-2.5f, 2.0f, -3.0f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.5f, (float)-3.0f, (float)0.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
            PartDefinition cube_r25 = left_arm.m_171599_("cube_r25", CubeListBuilder.m_171558_().m_171514_(35, 16).m_171488_(-1.6027f, -2.9966f, -0.2928f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.3884f, (float)-8.3559f, (float)0.6787f, (float)-2.6092f, (float)0.153f, (float)-2.6737f));
            PartDefinition cube_r26 = left_arm.m_171599_("cube_r26", CubeListBuilder.m_171558_().m_171514_(43, 17).m_171488_(-0.2684f, -2.53f, -0.9673f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.3884f, (float)-8.3559f, (float)0.6787f, (float)-2.8093f, (float)0.2406f, (float)-3.0753f));
            PartDefinition cube_r27 = left_arm.m_171599_("cube_r27", CubeListBuilder.m_171558_().m_171514_(26, 15).m_171488_(-1.3424f, -3.799f, -2.3101f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.3884f, (float)-8.3559f, (float)0.6787f, (float)-2.1443f, (float)0.3159f, (float)-2.5224f));
            PartDefinition cube_r28 = left_arm.m_171599_("cube_r28", CubeListBuilder.m_171558_().m_171514_(15, 13).m_171488_(-0.2854f, -6.2157f, 0.2834f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(59, 12).m_171488_(-0.7829f, -3.9235f, -0.3562f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 16).m_171488_(-0.9597f, -0.5745f, -0.7802f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(13, 18).m_171488_(-2.027f, 0.7197f, -1.2114f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.9059f, (float)-8.463f, (float)1.5509f, (float)-2.512f, (float)-0.9658f, (float)-3.0826f));
            PartDefinition cube_r29 = left_arm.m_171599_("cube_r29", CubeListBuilder.m_171558_().m_171514_(20, 13).m_171488_(-1.9145f, -0.7996f, -3.422f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(59, 19).m_171488_(-2.392f, 1.092f, -3.9501f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.9059f, (float)-8.463f, (float)1.5509f, (float)-2.4364f, (float)-0.398f, (float)-2.4204f));
            PartDefinition cube_r30 = left_arm.m_171599_("cube_r30", CubeListBuilder.m_171558_().m_171514_(10, 13).m_171488_(-2.7499f, -2.2376f, -2.4162f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(51, 18).m_171488_(-3.2274f, 0.654f, -2.9443f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.9059f, (float)-8.463f, (float)1.5509f, (float)-2.8251f, (float)-1.049f, (float)-2.3685f));
            PartDefinition bone5 = left_arm.m_171599_("bone5", CubeListBuilder.m_171558_().m_171514_(-8, 39).m_171480_().m_171488_(-4.0f, 0.0f, -4.0f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.0f, (float)3.0f, (float)0.0f));
            PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 108).m_171480_().m_171488_(-2.75f, 9.25f, -2.5f, 5.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 101).m_171480_().m_171488_(-2.75f, 8.25f, -0.5f, 5.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
            PartDefinition cube_r31 = right_leg.m_171599_("cube_r31", CubeListBuilder.m_171558_().m_171514_(0, 119).m_171480_().m_171488_(-1.4848f, -2.67f, -2.0338f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 113).m_171480_().m_171488_(-2.0073f, -0.7784f, -2.5619f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.1f, (float)9.0675f, (float)2.3367f, (float)-0.8197f, (float)0.5245f, (float)-2.2662f));
            PartDefinition cube_r32 = right_leg.m_171599_("cube_r32", CubeListBuilder.m_171558_().m_171514_(4, 119).m_171480_().m_171488_(-0.5113f, -2.4458f, -0.4859f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(8, 119).m_171480_().m_171488_(-0.9887f, -0.5542f, -1.0141f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.9258f, (float)8.4894f, (float)3.6344f, (float)-1.1767f, (float)-0.151f, (float)-0.0704f));
            PartDefinition cube_r33 = right_leg.m_171599_("cube_r33", CubeListBuilder.m_171558_().m_171514_(8, 124).m_171480_().m_171488_(0.4848f, -2.67f, -2.0338f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 123).m_171480_().m_171488_(0.0073f, -0.7784f, -2.5619f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.1f, (float)9.0675f, (float)2.3367f, (float)-0.6106f, (float)-0.37f, (float)-0.493f));
            PartDefinition cube_r34 = right_leg.m_171599_("cube_r34", CubeListBuilder.m_171558_().m_171514_(17, 113).m_171480_().m_171488_(-0.6887f, -3.8914f, -0.3672f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(9, 113).m_171480_().m_171488_(-1.1662f, -0.9998f, -0.8954f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.1f, (float)9.0675f, (float)2.3367f, (float)-0.7845f, (float)-0.169f, (float)-1.1386f));
            PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 108).m_171488_(-2.25f, 9.25f, -2.5f, 5.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 101).m_171488_(-2.25f, 8.25f, -0.5f, 5.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
            PartDefinition cube_r35 = left_leg.m_171599_("cube_r35", CubeListBuilder.m_171558_().m_171514_(0, 119).m_171488_(0.4848f, -2.67f, -2.0338f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 113).m_171488_(0.0073f, -0.7784f, -2.5619f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.1f, (float)9.0675f, (float)2.3367f, (float)-0.8197f, (float)-0.5245f, (float)2.2662f));
            PartDefinition cube_r36 = left_leg.m_171599_("cube_r36", CubeListBuilder.m_171558_().m_171514_(4, 119).m_171488_(-0.4887f, -2.4458f, -0.4859f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(8, 119).m_171488_(-1.0113f, -0.5542f, -1.0141f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.9258f, (float)8.4894f, (float)3.6344f, (float)-1.1767f, (float)0.151f, (float)0.0704f));
            PartDefinition cube_r37 = left_leg.m_171599_("cube_r37", CubeListBuilder.m_171558_().m_171514_(8, 124).m_171488_(-1.4848f, -2.67f, -2.0338f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 123).m_171488_(-2.0073f, -0.7784f, -2.5619f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.1f, (float)9.0675f, (float)2.3367f, (float)-0.6106f, (float)0.37f, (float)0.493f));
            PartDefinition cube_r38 = left_leg.m_171599_("cube_r38", CubeListBuilder.m_171558_().m_171514_(17, 113).m_171488_(-0.3113f, -3.8914f, -0.3672f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(9, 113).m_171488_(-0.8338f, -0.9998f, -0.8954f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.1f, (float)9.0675f, (float)2.3367f, (float)-0.7845f, (float)0.169f, (float)1.1386f));
            PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(98, 117).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 1.0f, 1.7f, new CubeDeformation(0.3f)).m_171514_(98, 118).m_171488_(-4.0f, -8.0f, -1.7f, 8.0f, 2.0f, 3.4f, new CubeDeformation(0.3f)).m_171514_(98, 119).m_171488_(-4.0f, -8.0f, 2.3f, 8.0f, 3.0f, 1.7f, new CubeDeformation(0.3f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r39 = head.m_171599_("cube_r39", CubeListBuilder.m_171558_().m_171514_(78, 100).m_171488_(0.4848f, -2.67f, -2.0338f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(96, 86).m_171488_(0.0073f, -0.7784f, -2.5619f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-7.9325f, (float)5.3367f, (float)-1.0733f, (float)-0.4349f, (float)1.1917f));
            PartDefinition cube_r40 = head.m_171599_("cube_r40", CubeListBuilder.m_171558_().m_171514_(82, 100).m_171488_(-1.4848f, -2.67f, -2.0338f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(104, 86).m_171488_(-2.0073f, -0.7784f, -2.5619f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-7.9325f, (float)5.3367f, (float)-0.6385f, (float)0.1296f, (float)-0.7062f));
            PartDefinition cube_r41 = head.m_171599_("cube_r41", CubeListBuilder.m_171558_().m_171514_(91, 100).m_171488_(-0.3113f, -3.8914f, -0.3672f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(112, 86).m_171488_(-0.8338f, -0.9998f, -0.8954f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-7.9325f, (float)5.3367f, (float)-0.9505f, (float)-0.0077f, (float)-0.0671f));
            PartDefinition cube_r42 = head.m_171599_("cube_r42", CubeListBuilder.m_171558_().m_171514_(100, 101).m_171488_(-0.5113f, -2.4458f, -0.4859f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(88, 86).m_171488_(-0.9887f, -0.5542f, -1.0141f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.7649f, (float)-9.3654f, (float)-2.7019f, (float)0.4544f, (float)-0.9598f, (float)0.0501f));
            PartDefinition cube_r43 = head.m_171599_("cube_r43", CubeListBuilder.m_171558_().m_171514_(96, 101).m_171488_(-0.4887f, -2.4458f, -0.4859f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(80, 86).m_171488_(-1.0113f, -0.5542f, -1.0141f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.7649f, (float)-9.3654f, (float)-2.7019f, (float)0.4544f, (float)0.9598f, (float)-0.0501f));
            PartDefinition cube_r44 = head.m_171599_("cube_r44", CubeListBuilder.m_171558_().m_171514_(110, 101).m_171488_(0.0f, -5.0f, -1.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.15f, (float)-9.0f, (float)-1.75f, (float)0.2195f, (float)0.3234f, (float)0.136f));
            PartDefinition cube_r45 = head.m_171599_("cube_r45", CubeListBuilder.m_171558_().m_171514_(72, 86).m_171488_(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-7.0f, (float)-2.0f, (float)0.2195f, (float)0.3234f, (float)0.136f));
            PartDefinition cube_r46 = head.m_171599_("cube_r46", CubeListBuilder.m_171558_().m_171514_(86, 100).m_171488_(0.0f, -2.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.25f, (float)-10.0f, (float)0.25f, (float)-0.1475f, (float)0.757f, (float)0.4405f));
            PartDefinition cube_r47 = head.m_171599_("cube_r47", CubeListBuilder.m_171558_().m_171514_(64, 99).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-8.0f, (float)0.0f, (float)-0.1475f, (float)0.757f, (float)0.4405f));
            PartDefinition cube_r48 = head.m_171599_("cube_r48", CubeListBuilder.m_171558_().m_171514_(76, 106).m_171488_(-2.0717f, 1.3992f, -2.6739f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(74, 104).m_171488_(-1.8133f, -5.5361f, -1.1791f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(64, 86).m_171488_(-2.3158f, -3.244f, -1.8187f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(88, 106).m_171488_(-3.139f, 0.1051f, -2.2427f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.8614f, (float)-11.9065f, (float)3.8215f, (float)-1.9238f, (float)0.5837f, (float)-2.0923f));
            PartDefinition cube_r49 = head.m_171599_("cube_r49", CubeListBuilder.m_171558_().m_171514_(74, 100).m_171488_(-0.1214f, -3.6524f, 1.3376f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(96, 92).m_171488_(-0.5844f, -1.3697f, 0.831f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.8614f, (float)-11.9065f, (float)3.8215f, (float)-2.581f, (float)0.8386f, (float)-2.4912f));
            PartDefinition cube_r50 = head.m_171599_("cube_r50", CubeListBuilder.m_171558_().m_171514_(64, 106).m_171488_(-2.0717f, 1.3992f, -2.6739f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(105, 101).m_171488_(-1.8133f, -5.5361f, -1.1791f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(120, 86).m_171488_(-2.3158f, -3.244f, -1.8187f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(100, 105).m_171488_(-3.139f, 0.1051f, -2.2427f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.1386f, (float)-12.9065f, (float)0.8216f, (float)-0.1853f, (float)0.2272f, (float)-0.2503f));
            PartDefinition cube_r51 = head.m_171599_("cube_r51", CubeListBuilder.m_171558_().m_171514_(86, 104).m_171488_(-0.1214f, -3.6524f, 1.3376f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(120, 92).m_171488_(-0.5844f, -1.3697f, 0.831f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.1386f, (float)-12.9065f, (float)0.8216f, (float)-0.4613f, (float)0.4244f, (float)0.1091f));
            PartDefinition cube_r52 = head.m_171599_("cube_r52", CubeListBuilder.m_171558_().m_171514_(64, 92).m_171488_(-0.5903f, -3.3718f, -0.7399f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.4805f, (float)-8.7112f, (float)3.9651f, (float)-1.6826f, (float)1.1311f, (float)-0.714f));
            PartDefinition cube_r53 = head.m_171599_("cube_r53", CubeListBuilder.m_171558_().m_171514_(112, 92).m_171488_(-1.6277f, -3.6095f, -2.0591f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.4805f, (float)-8.7112f, (float)3.9651f, (float)-0.7608f, (float)0.6509f, (float)-0.3098f));
            PartDefinition cube_r54 = head.m_171599_("cube_r54", CubeListBuilder.m_171558_().m_171514_(80, 92).m_171488_(-1.9504f, -3.0036f, -0.049f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.4805f, (float)-8.7112f, (float)3.9651f, (float)-1.4622f, (float)0.5625f, (float)-0.5988f));
            PartDefinition cube_r55 = head.m_171599_("cube_r55", CubeListBuilder.m_171558_().m_171514_(88, 92).m_171488_(-0.5903f, -3.3718f, -0.7399f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.5195f, (float)-9.7112f, (float)-1.0349f, (float)-0.3706f, (float)0.4881f, (float)-0.2066f));
            PartDefinition cube_r56 = head.m_171599_("cube_r56", CubeListBuilder.m_171558_().m_171514_(104, 92).m_171488_(-1.6277f, -3.6095f, -2.0591f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0195f, (float)-9.7112f, (float)-1.0349f, (float)0.1401f, (float)0.0447f, (float)-0.5226f));
            PartDefinition cube_r57 = head.m_171599_("cube_r57", CubeListBuilder.m_171558_().m_171514_(72, 92).m_171488_(-1.9504f, -3.0036f, -0.049f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.5195f, (float)-9.7112f, (float)-1.0349f, (float)-0.4203f, (float)0.1917f, (float)-0.7301f));
            PartDefinition cube_r58 = head.m_171599_("cube_r58", CubeListBuilder.m_171558_().m_171514_(64, 116).m_171488_(-5.0f, -1.0f, -5.0f, 10.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
            return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
        }

        @Override
        public void m_7695_(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            ModelPartHelper.runPreservingTransforms(() -> {
                this.animateParts();
                super.m_7695_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            }, this.crystalBone);
        }

        private void animateParts() {
            this.crystalBone.f_104204_ = (float)Math.toRadians((double)(System.currentTimeMillis() % 10000L) / 10000.0 * 360.0);
            this.f_102811_.m_171324_((String)"bone2").f_104204_ = (float)Math.toRadians((double)(System.currentTimeMillis() % 20000L) / 20000.0 * 360.0);
            this.f_102812_.m_171324_((String)"bone5").f_104204_ = (float)Math.toRadians((double)(System.currentTimeMillis() % 20000L) / 20000.0 * -360.0);
            long currentTime = System.currentTimeMillis() % 4000L;
            float progress = currentTime < 2000L ? (float)currentTime / 2000.0f : (float)(4000L - currentTime) / 2000.0f;
            float easedProgress = (float)(0.5 * (1.0 - Math.cos(Math.PI * (double)progress)));
            this.f_102810_.m_171324_((String)"bone3").f_104203_ = (float)Math.toRadians((double)easedProgress * 13.8);
            this.f_102810_.m_171324_((String)"bone3").f_104204_ = (float)Math.toRadians((double)easedProgress * 14.9);
            this.f_102810_.m_171324_((String)"bone3").f_104205_ = (float)Math.toRadians((double)easedProgress * 5.17);
            this.f_102810_.m_171324_((String)"bone4").f_104203_ = (float)Math.toRadians((double)easedProgress * 13.8);
            this.f_102810_.m_171324_((String)"bone4").f_104204_ = (float)Math.toRadians((double)easedProgress * -14.9);
            this.f_102810_.m_171324_((String)"bone4").f_104205_ = (float)Math.toRadians((double)easedProgress * -5.17);
        }
    }
}

