/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.gear.model.armor.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.dynamodel.model.armor.ArmorLayers;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.util.ModelPartHelper;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DylansSuitArmorLayers
extends ArmorLayers {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Supplier<LayerDefinition> getGeometrySupplier(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.LEGS ? LeggingsLayer::createBodyLayer : MainLayer::createBodyLayer;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ArmorLayers.VaultArmorLayerSupplier<? extends ArmorLayers.BaseLayer> getLayerSupplier(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.LEGS ? LeggingsLayer::new : MainLayer::new;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LeggingsLayer
    extends ArmorLayers.LeggingsLayer {
        public LeggingsLayer(ArmorPieceModel definition, ModelPart root) {
            super(definition, root);
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = LeggingsLayer.createBaseLayer();
            PartDefinition partdefinition = meshdefinition.m_171576_();
            PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition HeartFront = body.m_171599_("HeartFront", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)10.3271f, (float)-2.9068f, (float)-0.3491f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r1 = HeartFront.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(31, 24).m_171488_(0.0f, -2.0f, -1.251f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(24, 31).m_171488_(-1.0f, -2.0f, -1.251f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.7071f, (float)0.7507f, (float)0.0f, (float)0.0f, (float)-0.7854f));
            PartDefinition cube_r2 = HeartFront.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(31, 28).m_171488_(-1.0f, -2.0f, -1.251f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(19, 31).m_171488_(0.0f, -2.0f, -1.25f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.7071f, (float)0.7507f, (float)0.0f, (float)0.0f, (float)0.7854f));
            PartDefinition HeartBack = body.m_171599_("HeartBack", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)10.3271f, (float)2.9068f, (float)0.3491f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r3 = HeartBack.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(31, 24).m_171488_(0.0f, -2.0f, 0.251f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(24, 31).m_171488_(-1.0f, -2.0f, 0.251f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.7071f, (float)-0.7507f, (float)0.0f, (float)0.0f, (float)-0.7854f));
            PartDefinition cube_r4 = HeartBack.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(31, 28).m_171488_(-1.0f, -2.0f, 0.251f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(19, 31).m_171488_(0.0f, -2.0f, 0.25f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.7071f, (float)-0.7507f, (float)0.0f, (float)0.0f, (float)0.7854f));
            PartDefinition ClothFront = body.m_171599_("ClothFront", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)16.9987f, (float)-3.3785f));
            PartDefinition cube_r5 = ClothFront.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171488_(-2.0f, -0.0219f, 0.0f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0785f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r6 = ClothFront.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(22, 24).m_171488_(-2.0f, -5.0f, -0.2f, 4.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.9987f, (float)0.2785f, (float)-0.0785f, (float)0.0f, (float)0.0f));
            PartDefinition ClothBack = body.m_171599_("ClothBack", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)16.9987f, (float)3.3785f));
            PartDefinition cube_r7 = ClothBack.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171488_(-2.0f, -0.0219f, 0.0f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0785f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r8 = ClothBack.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(22, 24).m_171488_(-2.0f, -5.0f, 0.2f, 4.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.9987f, (float)-0.2785f, (float)0.0785f, (float)0.0f, (float)0.0f));
            PartDefinition Belt = body.m_171599_("Belt", CubeListBuilder.m_171558_().m_171514_(21, 16).m_171488_(-5.0f, 10.0f, 1.99f, 10.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 22).m_171488_(-5.0f, 10.0f, -2.01f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(11, 24).m_171488_(4.0f, 10.0f, -2.01f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(21, 20).m_171488_(-5.0f, 10.0f, -3.01f, 10.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition SupportsFront = body.m_171599_("SupportsFront", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.5f, (float)13.0f, (float)-2.6f));
            PartDefinition cube_r9 = SupportsFront.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(14, 31).m_171488_(-0.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6545f));
            PartDefinition cube_r10 = SupportsFront.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(9, 31).m_171488_(-0.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6545f));
            PartDefinition SupportsBack = body.m_171599_("SupportsBack", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.5f, (float)13.0f, (float)2.6f));
            PartDefinition cube_r11 = SupportsBack.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(14, 31).m_171488_(-0.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6545f));
            PartDefinition cube_r12 = SupportsBack.m_171599_("cube_r12", CubeListBuilder.m_171558_().m_171514_(9, 31).m_171488_(-0.5f, -3.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6545f));
            PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
            PartDefinition cube_r13 = right_leg.m_171599_("cube_r13", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(-1.5f, -1.5f, -3.0f, 4.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.55f, (float)1.3f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
            PartDefinition cube_r14 = right_leg.m_171599_("cube_r14", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-2.5f, -0.5f, -3.0f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.45f, (float)5.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
            PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
            PartDefinition cube_r15 = left_leg.m_171599_("cube_r15", CubeListBuilder.m_171558_().m_171514_(21, 8).m_171488_(-2.5f, -0.5f, -3.0f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.45f, (float)5.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
            PartDefinition cube_r16 = left_leg.m_171599_("cube_r16", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -1.5f, -3.0f, 4.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.55f, (float)1.3f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
            return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MainLayer
    extends ArmorLayers.MainLayer {
        protected ModelPart leftWing;
        protected ModelPart rightWing;

        public MainLayer(ArmorPieceModel definition, ModelPart root) {
            super(definition, root);
            ModelPart body = root.m_171324_("body");
            this.leftWing = body.m_171324_("WingLeft");
            this.rightWing = body.m_171324_("WingRight");
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = MainLayer.createBaseLayer();
            PartDefinition partdefinition = meshdefinition.m_171576_();
            PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            PartDefinition Helmet = head.m_171599_("Helmet", CubeListBuilder.m_171558_().m_171514_(89, 0).m_171488_(-10.5f, -2.0f, -5.0f, 11.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(100, 88).m_171488_(-9.5f, -4.0f, -4.0f, 9.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)-8.0f, (float)0.0f));
            PartDefinition cube_r1 = Helmet.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(125, 78).m_171488_(-5.5f, -0.15f, -0.5f, 11.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)1.15f, (float)4.5f, (float)0.3054f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r2 = Helmet.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(27, 119).m_171488_(-1.5f, -1.0f, -5.0f, 3.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-12.9546f, (float)-1.3155f, (float)-0.7324f, (float)1.1714f, (float)-0.1209f, (float)-1.1751f));
            PartDefinition cube_r3 = Helmet.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(96, 117).m_171488_(-1.5f, -1.0f, -5.0f, 3.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.9546f, (float)-1.3155f, (float)-0.7324f, (float)1.1714f, (float)0.1209f, (float)1.1751f));
            PartDefinition cube_r4 = Helmet.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(75, 102).m_171488_(-0.5f, 0.0f, -5.0f, 1.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f));
            PartDefinition cube_r5 = Helmet.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(54, 102).m_171488_(-0.5f, 0.0f, -5.0f, 1.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3054f));
            PartDefinition FancyHeart = head.m_171599_("FancyHeart", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-5.5f, (float)-12.6f, (float)-0.3f));
            PartDefinition cube_r6 = FancyHeart.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(96, 129).m_171488_(-1.5f, -1.0f, -4.0f, 3.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.478f, (float)-0.0924f, (float)-0.7811f));
            PartDefinition cube_r7 = FancyHeart.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(130, 14).m_171488_(-1.5f, -2.0f, -4.0f, 3.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.9399f, (float)-4.8513f, (float)0.6422f, (float)1.8425f, (float)-0.05f, (float)0.6575f));
            PartDefinition cube_r8 = FancyHeart.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(132, 0).m_171488_(15.0f, -6.5f, -58.0f, 2.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)46.7095f, (float)30.0342f, (float)-0.3199f, (float)0.05f, (float)1.8425f, (float)0.6575f));
            PartDefinition cube_r9 = FancyHeart.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(132, 25).m_171488_(-17.0f, -6.5f, -58.0f, 2.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-35.7095f, (float)30.0342f, (float)-0.3199f, (float)0.05f, (float)-1.8425f, (float)-0.6575f));
            PartDefinition cube_r10 = FancyHeart.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(119, 131).m_171488_(-1.5f, -2.0f, -4.0f, 3.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)11.9399f, (float)-4.8513f, (float)0.6422f, (float)1.8425f, (float)0.05f, (float)-0.6575f));
            PartDefinition cube_r11 = FancyHeart.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(23, 131).m_171488_(-1.5f, -1.0f, -4.0f, 3.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)11.0f, (float)0.0f, (float)0.0f, (float)1.478f, (float)0.0924f, (float)0.7811f));
            PartDefinition CenterHeart = head.m_171599_("CenterHeart", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)-6.0f));
            PartDefinition Heart8 = CenterHeart.m_171599_("Heart8", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.65f, (float)1.0f, (float)-1.0f));
            PartDefinition cube_r12 = Heart8.m_171599_("cube_r12", CubeListBuilder.m_171558_().m_171514_(148, 72).m_171488_(-1.7f, -2.1f, -1.1f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.2642f, (float)-2.7165f, (float)2.051f, (float)0.0f, (float)0.0f, (float)-0.7854f));
            PartDefinition cube_r13 = Heart8.m_171599_("cube_r13", CubeListBuilder.m_171558_().m_171514_(149, 57).m_171488_(-0.3f, 0.014f, -0.498f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(148, 104).m_171488_(3.7f, 0.014f, -0.498f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0149f, (float)-5.464f, (float)1.55f, (float)0.0f, (float)0.0f, (float)0.7854f));
            PartDefinition cube_r14 = Heart8.m_171599_("cube_r14", CubeListBuilder.m_171558_().m_171514_(148, 145).m_171488_(-5.7f, 0.014f, -0.499f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(148, 138).m_171488_(-1.7f, 0.014f, -0.499f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.2649f, (float)-5.464f, (float)1.55f, (float)0.0f, (float)0.0f, (float)-0.7854f));
            PartDefinition cube_r15 = Heart8.m_171599_("cube_r15", CubeListBuilder.m_171558_().m_171514_(67, 149).m_171488_(-0.6f, -2.0f, -1.1f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.1642f, (float)-2.7165f, (float)2.051f, (float)0.0f, (float)0.0f, (float)0.7854f));
            PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
            PartDefinition Chestplate = body.m_171599_("Chestplate", CubeListBuilder.m_171558_().m_171514_(27, 82).m_171488_(-6.0f, -10.0f, -9.0f, 12.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(89, 14).m_171488_(-5.0f, -12.0f, -9.0f, 10.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)4.0f));
            PartDefinition cube_r16 = Chestplate.m_171599_("cube_r16", CubeListBuilder.m_171558_().m_171514_(67, 142).m_171488_(-3.0f, -2.0f, -2.25f, 6.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r17 = Chestplate.m_171599_("cube_r17", CubeListBuilder.m_171558_().m_171514_(132, 57).m_171488_(-3.0f, -2.0f, 0.25f, 6.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-8.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r18 = Chestplate.m_171599_("cube_r18", CubeListBuilder.m_171558_().m_171514_(22, 142).m_171488_(-2.5f, -3.0f, -0.5f, 6.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.8512f, (float)-8.0f, (float)-10.5f, (float)0.4565f, (float)-0.5194f, (float)-0.2391f));
            PartDefinition cube_r19 = Chestplate.m_171599_("cube_r19", CubeListBuilder.m_171558_().m_171514_(135, 87).m_171488_(-3.5f, -3.0f, -0.5f, 6.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.8284f, (float)-8.0f, (float)-10.5f, (float)0.4565f, (float)0.5194f, (float)0.2391f));
            PartDefinition Heart2 = body.m_171599_("Heart2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)25.0f, (float)0.0f));
            PartDefinition SmolHeart = Heart2.m_171599_("SmolHeart", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.1f, (float)-22.0f, (float)6.5f));
            PartDefinition Heart = SmolHeart.m_171599_("Heart", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)8.1f, (float)-13.0f, (float)-8.5f));
            PartDefinition Heart7 = SmolHeart.m_171599_("Heart7", CubeListBuilder.m_171558_().m_171514_(132, 149).m_171488_(-6.2f, 11.086f, 6.9f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(139, 149).m_171488_(-10.8f, 11.086f, 6.9f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.1f, (float)-13.0f, (float)-8.5f));
            PartDefinition cube_r20 = Heart7.m_171599_("cube_r20", CubeListBuilder.m_171558_().m_171514_(76, 149).m_171488_(-0.2f, -3.5f, -1.998f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-8.2f, (float)15.0f, (float)8.9f, (float)0.0f, (float)0.0f, (float)0.7854f));
            PartDefinition cube_r21 = Heart7.m_171599_("cube_r21", CubeListBuilder.m_171558_().m_171514_(44, 150).m_171488_(-0.1449f, 2.614f, -1.499f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-8.1351f, (float)8.636f, (float)8.4f, (float)0.0f, (float)0.0f, (float)0.7854f));
            PartDefinition cube_r22 = Heart7.m_171599_("cube_r22", CubeListBuilder.m_171558_().m_171514_(125, 149).m_171488_(-0.255f, -2.09f, -1.4998f, 1.0f, 2.8f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-8.481f, (float)11.72f, (float)8.4f, (float)0.0f, (float)0.0f, (float)-0.7854f));
            PartDefinition cube_r23 = Heart7.m_171599_("cube_r23", CubeListBuilder.m_171558_().m_171514_(118, 149).m_171488_(-0.745f, -2.09f, -1.4998f, 1.0f, 2.8f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.519f, (float)11.72f, (float)8.4f, (float)0.0f, (float)0.0f, (float)0.7854f));
            PartDefinition cube_r24 = Heart7.m_171599_("cube_r24", CubeListBuilder.m_171558_().m_171514_(37, 150).m_171488_(-0.8551f, 2.614f, -1.499f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-7.8649f, (float)8.636f, (float)8.4f, (float)0.0f, (float)0.0f, (float)-0.7854f));
            PartDefinition cube_r25 = Heart7.m_171599_("cube_r25", CubeListBuilder.m_171558_().m_171514_(67, 133).m_171488_(-0.5f, -3.2f, -1.999f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-8.2f, (float)15.0f, (float)8.9f, (float)0.0f, (float)0.0f, (float)-0.7854f));
            PartDefinition SmolHeartInner = Heart2.m_171599_("SmolHeartInner", CubeListBuilder.m_171558_().m_171514_(122, 27).m_171488_(-10.0f, 10.5f, 8.4f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)-35.0f, (float)-2.0f));
            PartDefinition WingRight = body.m_171599_("WingRight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.3917f, (float)1.75f, (float)6.3108f));
            PartDefinition cube_r26 = WingRight.m_171599_("cube_r26", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-21.75f, -12.0f, -1.875f, 36.0f, 24.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-9.9125f, (float)-0.375f, (float)8.7587f, (float)0.0f, (float)0.5236f, (float)0.0f));
            PartDefinition cube_r27 = WingRight.m_171599_("cube_r27", CubeListBuilder.m_171558_().m_171514_(73, 32).m_171488_(-14.25f, 9.4548f, -7.6238f, 28.5f, 15.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-9.9125f, (float)-0.375f, (float)8.7587f, (float)0.5236f, (float)0.5236f, (float)0.0f));
            PartDefinition bone3 = WingRight.m_171599_("bone3", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-12.1118f, (float)-12.5702f, (float)7.2325f));
            PartDefinition cube_r28 = bone3.m_171599_("cube_r28", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-21.75f, -7.5f, 0.0f, 43.5f, 15.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.3584f, (float)-6.3f, (float)6.9f, (float)-0.5236f, (float)0.5236f, (float)0.0f));
            PartDefinition WingLeft = body.m_171599_("WingLeft", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.7833f, (float)1.75f, (float)6.3108f));
            PartDefinition cube_r29 = WingLeft.m_171599_("cube_r29", CubeListBuilder.m_171558_().m_171514_(0, 57).m_171488_(-14.25f, -12.0f, -1.875f, 36.0f, 24.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)9.9125f, (float)-0.375f, (float)8.7587f, (float)0.0f, (float)-0.5236f, (float)0.0f));
            PartDefinition cube_r30 = WingLeft.m_171599_("cube_r30", CubeListBuilder.m_171558_().m_171514_(73, 48).m_171488_(-14.25f, 9.4548f, -7.6238f, 28.5f, 15.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)9.9125f, (float)-0.375f, (float)8.7587f, (float)0.5236f, (float)-0.5236f, (float)0.0f));
            PartDefinition bone2 = WingLeft.m_171599_("bone2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)11.7201f, (float)-12.5701f, (float)7.2325f));
            PartDefinition cube_r31 = bone2.m_171599_("cube_r31", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-21.75f, -7.5f, 0.0f, 43.5f, 15.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.735f, (float)-6.2683f, (float)6.8619f, (float)-0.5236f, (float)-0.5236f, (float)0.0f));
            PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(127, 99).m_171488_(-5.25f, 6.0f, -3.0f, 4.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
            PartDefinition cube_r32 = right_arm.m_171599_("cube_r32", CubeListBuilder.m_171558_().m_171514_(0, 82).m_171488_(0.0f, -2.0f, -8.5f, 0.0f, 24.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)0.0f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.6109f));
            PartDefinition BigHeart = right_arm.m_171599_("BigHeart", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-6.8124f, (float)2.1319f, (float)0.2176f, (float)0.0f, (float)0.0f, (float)0.7854f));
            PartDefinition BigHeartInner4 = BigHeart.m_171599_("BigHeartInner4", CubeListBuilder.m_171558_().m_171514_(100, 64).m_171488_(-2.25f, -5.65f, -6.1f, 0.0f, 11.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.1f, (float)-2.8f, (float)-0.2f));
            PartDefinition BigHeart5 = BigHeart.m_171599_("BigHeart5", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)12.0f, (float)54.0f, (float)-2.2f));
            PartDefinition Heart10 = BigHeart5.m_171599_("Heart10", CubeListBuilder.m_171558_().m_171514_(84, 142).m_171488_(-0.4f, -6.9281f, 7.6f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(142, 131).m_171488_(-0.4f, -8.3381f, 4.1055f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(133, 142).m_171488_(-0.4f, -8.3f, -4.2945f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(144, 119).m_171488_(-0.4002f, -6.9281f, -5.6702f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-12.5f, (float)-56.0f, (float)0.0f));
            PartDefinition cube_r33 = Heart10.m_171599_("cube_r33", CubeListBuilder.m_171558_().m_171514_(96, 140).m_171488_(-1.0004f, -10.0f, -1.598f, 3.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.6f, (float)4.8f, (float)2.4f, (float)0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r34 = Heart10.m_171599_("cube_r34", CubeListBuilder.m_171558_().m_171514_(100, 27).m_171488_(-1.998f, -0.0459f, -0.9948f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.6f, (float)-7.5541f, (float)-3.6052f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r35 = Heart10.m_171599_("cube_r35", CubeListBuilder.m_171558_().m_171514_(118, 142).m_171488_(-1.998f, 0.0f, -0.6f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.6f, (float)-7.9281f, (float)0.1298f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r36 = Heart10.m_171599_("cube_r36", CubeListBuilder.m_171558_().m_171514_(148, 64).m_171488_(-1.996f, 0.1281f, -0.6f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.6f, (float)-7.9281f, (float)4.5298f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r37 = Heart10.m_171599_("cube_r37", CubeListBuilder.m_171558_().m_171514_(89, 27).m_171488_(-1.998f, 0.0f, -0.6f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.6f, (float)-7.9281f, (float)8.5298f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r38 = Heart10.m_171599_("cube_r38", CubeListBuilder.m_171558_().m_171514_(0, 134).m_171488_(-1.002f, -9.4f, -1.0f, 3.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.6f, (float)4.8f, (float)2.4f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition Heart11 = BigHeart5.m_171599_("Heart11", CubeListBuilder.m_171558_().m_171514_(0, 148).m_171488_(-2.402f, -6.9281f, 7.6f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(52, 143).m_171488_(-2.4f, -8.3381f, 4.1055f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(144, 112).m_171488_(-2.4f, -8.3f, -4.2945f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(11, 148).m_171488_(-2.402f, -6.9281f, -5.6702f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-13.5f, (float)-56.0f, (float)0.0f));
            PartDefinition cube_r39 = Heart11.m_171599_("cube_r39", CubeListBuilder.m_171558_().m_171514_(107, 140).m_171488_(-1.0002f, -10.0f, -1.598f, 3.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.4f, (float)4.8f, (float)2.4f, (float)0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r40 = Heart11.m_171599_("cube_r40", CubeListBuilder.m_171558_().m_171514_(127, 112).m_171488_(-2.004f, -0.0459f, -0.9948f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.4f, (float)-7.5541f, (float)-3.6052f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r41 = Heart11.m_171599_("cube_r41", CubeListBuilder.m_171558_().m_171514_(37, 143).m_171488_(-2.004f, 0.0f, -0.6f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.4f, (float)-7.9281f, (float)0.1298f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r42 = Heart11.m_171599_("cube_r42", CubeListBuilder.m_171558_().m_171514_(148, 96).m_171488_(-2.002f, 0.1281f, -0.6f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.4f, (float)-7.9281f, (float)4.5298f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r43 = Heart11.m_171599_("cube_r43", CubeListBuilder.m_171558_().m_171514_(111, 27).m_171488_(-2.004f, 0.0f, -0.6f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.4f, (float)-7.9281f, (float)8.5298f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r44 = Heart11.m_171599_("cube_r44", CubeListBuilder.m_171558_().m_171514_(11, 134).m_171488_(-1.0004f, -9.4f, -1.0f, 3.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.4f, (float)4.8f, (float)2.4f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(75, 119).m_171488_(1.25f, 6.0f, -3.0f, 4.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
            PartDefinition cube_r45 = left_arm.m_171599_("cube_r45", CubeListBuilder.m_171558_().m_171514_(73, 64).m_171488_(0.0f, -2.0f, -8.5f, 0.0f, 24.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)0.0f, (float)1.5f, (float)0.0f, (float)0.0f, (float)-0.6109f));
            PartDefinition bone6 = left_arm.m_171599_("bone6", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)6.8124f, (float)2.1319f, (float)0.2176f, (float)0.0f, (float)0.0f, (float)-0.7854f));
            PartDefinition BigHeartInner2 = bone6.m_171599_("BigHeartInner2", CubeListBuilder.m_171558_().m_171514_(100, 64).m_171480_().m_171488_(2.25f, -5.65f, -6.1f, 0.0f, 11.0f, 12.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-0.1f, (float)-2.8f, (float)-0.2f));
            PartDefinition BigHeart2 = bone6.m_171599_("BigHeart2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-12.0f, (float)54.0f, (float)-2.2f));
            PartDefinition Heart3 = BigHeart2.m_171599_("Heart3", CubeListBuilder.m_171558_().m_171514_(84, 142).m_171480_().m_171488_(-2.6f, -6.9281f, 7.6f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(142, 131).m_171480_().m_171488_(-2.6f, -8.3381f, 4.1055f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(133, 142).m_171480_().m_171488_(-2.6f, -8.3f, -4.2945f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(144, 119).m_171480_().m_171488_(-2.5998f, -6.9281f, -5.6702f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)12.5f, (float)-56.0f, (float)0.0f));
            PartDefinition cube_r46 = Heart3.m_171599_("cube_r46", CubeListBuilder.m_171558_().m_171514_(96, 140).m_171480_().m_171488_(-1.9996f, -10.0f, -1.598f, 3.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-0.6f, (float)4.8f, (float)2.4f, (float)0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r47 = Heart3.m_171599_("cube_r47", CubeListBuilder.m_171558_().m_171514_(100, 27).m_171480_().m_171488_(-1.002f, -0.0459f, -0.9948f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.6f, (float)-7.5541f, (float)-3.6052f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r48 = Heart3.m_171599_("cube_r48", CubeListBuilder.m_171558_().m_171514_(118, 142).m_171480_().m_171488_(-1.002f, 0.0f, -0.6f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.6f, (float)-7.9281f, (float)0.1298f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r49 = Heart3.m_171599_("cube_r49", CubeListBuilder.m_171558_().m_171514_(148, 64).m_171480_().m_171488_(-1.004f, 0.1281f, -0.6f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.6f, (float)-7.9281f, (float)4.5298f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r50 = Heart3.m_171599_("cube_r50", CubeListBuilder.m_171558_().m_171514_(89, 27).m_171480_().m_171488_(-1.002f, 0.0f, -0.6f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.6f, (float)-7.9281f, (float)8.5298f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r51 = Heart3.m_171599_("cube_r51", CubeListBuilder.m_171558_().m_171514_(0, 134).m_171480_().m_171488_(-1.998f, -9.4f, -1.0f, 3.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-0.6f, (float)4.8f, (float)2.4f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition Heart4 = BigHeart2.m_171599_("Heart4", CubeListBuilder.m_171558_().m_171514_(0, 148).m_171480_().m_171488_(-0.598f, -6.9281f, 7.6f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(52, 143).m_171480_().m_171488_(-0.6f, -8.3381f, 4.1055f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(144, 112).m_171480_().m_171488_(-0.6f, -8.3f, -4.2945f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(11, 148).m_171480_().m_171488_(-0.598f, -6.9281f, -5.6702f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)13.5f, (float)-56.0f, (float)0.0f));
            PartDefinition cube_r52 = Heart4.m_171599_("cube_r52", CubeListBuilder.m_171558_().m_171514_(107, 140).m_171480_().m_171488_(-1.9998f, -10.0f, -1.598f, 3.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.4f, (float)4.8f, (float)2.4f, (float)0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r53 = Heart4.m_171599_("cube_r53", CubeListBuilder.m_171558_().m_171514_(127, 112).m_171480_().m_171488_(-0.996f, -0.0459f, -0.9948f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.4f, (float)-7.5541f, (float)-3.6052f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r54 = Heart4.m_171599_("cube_r54", CubeListBuilder.m_171558_().m_171514_(37, 143).m_171480_().m_171488_(-0.996f, 0.0f, -0.6f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.4f, (float)-7.9281f, (float)0.1298f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r55 = Heart4.m_171599_("cube_r55", CubeListBuilder.m_171558_().m_171514_(148, 96).m_171480_().m_171488_(-0.998f, 0.1281f, -0.6f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.4f, (float)-7.9281f, (float)4.5298f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r56 = Heart4.m_171599_("cube_r56", CubeListBuilder.m_171558_().m_171514_(111, 27).m_171480_().m_171488_(-0.996f, 0.0f, -0.6f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.4f, (float)-7.9281f, (float)8.5298f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r57 = Heart4.m_171599_("cube_r57", CubeListBuilder.m_171558_().m_171514_(11, 134).m_171480_().m_171488_(-1.9996f, -9.4f, -1.0f, 3.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.4f, (float)4.8f, (float)2.4f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
            PartDefinition bone4 = right_leg.m_171599_("bone4", CubeListBuilder.m_171558_().m_171514_(100, 99).m_171488_(0.6f, -3.7429f, -5.43f, 6.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.09f, (float)6.7929f, (float)2.05f));
            PartDefinition cube_r58 = bone4.m_171599_("cube_r58", CubeListBuilder.m_171558_().m_171514_(0, 120).m_171488_(-2.5f, -4.0f, -3.25f, 6.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.09f, (float)0.8571f, (float)2.85f, (float)0.3927f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r59 = bone4.m_171599_("cube_r59", CubeListBuilder.m_171558_().m_171514_(52, 119).m_171488_(-2.5f, -4.4f, -0.7995f, 6.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.09f, (float)0.9634f, (float)-8.0305f, (float)-0.3927f, (float)0.0f, (float)0.0f));
            PartDefinition bone7 = right_leg.m_171599_("bone7", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.09f, (float)6.7929f, (float)2.05f));
            PartDefinition cube_r60 = bone7.m_171599_("cube_r60", CubeListBuilder.m_171558_().m_171514_(132, 47).m_171488_(-1.0f, -1.5f, -4.5f, 4.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r61 = bone7.m_171599_("cube_r61", CubeListBuilder.m_171558_().m_171514_(132, 37).m_171488_(-1.03f, -1.5f, -1.5f, 4.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-4.2f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
            PartDefinition bone5 = left_leg.m_171599_("bone5", CubeListBuilder.m_171558_().m_171514_(27, 101).m_171488_(-6.6f, -3.7429f, -5.43f, 6.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.09f, (float)6.7929f, (float)2.05f));
            PartDefinition cube_r62 = bone5.m_171599_("cube_r62", CubeListBuilder.m_171558_().m_171514_(121, 117).m_171488_(-3.5f, -4.0f, -3.25f, 6.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.09f, (float)0.8571f, (float)2.85f, (float)0.3927f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r63 = bone5.m_171599_("cube_r63", CubeListBuilder.m_171558_().m_171514_(125, 64).m_171488_(-3.5f, -4.4f, -0.7995f, 6.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.09f, (float)0.9634f, (float)-8.0305f, (float)-0.3927f, (float)0.0f, (float)0.0f));
            PartDefinition bone9 = left_leg.m_171599_("bone9", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.09f, (float)6.7929f, (float)2.05f));
            PartDefinition cube_r64 = bone9.m_171599_("cube_r64", CubeListBuilder.m_171558_().m_171514_(46, 133).m_171488_(-3.0f, -1.5f, -4.5f, 4.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
            PartDefinition cube_r65 = bone9.m_171599_("cube_r65", CubeListBuilder.m_171558_().m_171514_(75, 132).m_171488_(-2.97f, -1.5f, -1.5f, 4.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-4.2f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
        }

        @Override
        public boolean isIgnoredFirstPerson(EquipmentSlot slot) {
            return slot == EquipmentSlot.CHEST;
        }

        @Override
        public void m_7695_(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            ModelPartHelper.runPreservingTransforms(() -> {
                this.leftWing.f_104203_ = Mth.m_184637_((float)((float)Math.sin((double)System.currentTimeMillis() / 1000.0)), (float)-1.0f, (float)1.0f, (float)0.0f, (float)0.17453294f);
                this.leftWing.f_104204_ = Mth.m_184637_((float)((float)Math.sin((double)System.currentTimeMillis() / 500.0)), (float)-1.0f, (float)1.0f, (float)0.0f, (float)0.5235988f);
                this.rightWing.f_104203_ = this.leftWing.f_104203_;
                this.rightWing.f_104204_ = -this.leftWing.f_104204_;
                super.m_7695_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            }, this.rightWing, this.leftWing);
        }
    }
}

